#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include "cmd.h"
#include "wshare.h"
#include "baseGraph.h"
#include "axis.h"
#include "frame.h"

extern XtAppContext  app;
extern Widget top,command_w,text_w,main_w;
extern int flag;
void draw2d(int*,int*);

fastout::fastout()
{
  cout<<"this is a fast constructor"<<endl;
  return;
}

void axis_param::make_wind()
  {   
  static ActionAreaItem act2[]={
     {"Ok",change_axis, (XtPointer) this , 1},
     {"10%",ten_percent ,(XtPointer) this, 1},
     {"Redraw", re_draw,(XtPointer) this, 1},
     {"Area Redraw",old_val,(XtPointer) this, 1},
     {"Dismiss",axis_down,(XtPointer) this, 1},
     };


   if (!alog) 
     {
       alog = XtVaCreatePopupShell("test",
				topLevelShellWidgetClass,command_w,
			        XtNtitle, "Axis Coordinates",
			        NULL);

       Widget pane=
	 XtVaCreateWidget("pane",xmPanedWindowWidgetClass,alog,
                          XmNsashWidth,1,
                          XmNsashHeight,1,
                          NULL);
                                          
       Widget rowtwo=
	 XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,pane,
			  XmNpacking,XmPACK_COLUMN,
			  XmNisAligned, True,
			  XmNnumColumns,1,
			  XmNentryVerticalAlignment,XmALIGNMENT_END,
			  XmNorientation, XmVERTICAL,
			  NULL);
                           
       char l_str[9]="X range:";

       Widget rowcol,label[2],button,log_label;
       XmString str;
       int i;

       if (tpmenu)
	 delete [] tpmenu;
       tpmenu=new axis_menu[16];
       
       for(int ii=0;ii<16;ii++)
	 {
	   tpmenu[ii].THIS= this;
	   tpmenu[ii].count=ii;
	 }


       men_item xlog_plot[]= {
	 { "Standard",&xmPushButtonGadgetClass, 'S', NULL, NULL,
	   axis_log_handler, (XtPointer) (tpmenu), (men_item*) NULL },
	 { "Logoritmic",&xmPushButtonGadgetClass, 'L', NULL, NULL,
	   axis_log_handler, (XtPointer) (tpmenu+1), (men_item*) NULL },
	 {0,}
       };
       
       men_item ylog_plot[]= {
	 { "Standard",&xmPushButtonGadgetClass, 'S', NULL, NULL,
	   axis_log_handler, (XtPointer) (tpmenu+2), (men_item*) NULL },
	 { "Logoritmic",&xmPushButtonGadgetClass, 'L', NULL, NULL,
	   axis_log_handler, (XtPointer) (tpmenu+3), (men_item*) NULL },
	 {0,}
       };
       
       for (i=0;i<2;i++)   //Start of parameter table
	 {
	   rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
				   XmNpacking,XmPACK_TIGHT,
				   XmNisAligned, True,
				   XmNnumColumns,4,
				   XmNentryVerticalAlignment,XmALIGNMENT_END,
				   XmNorientation, XmHORIZONTAL,
				   NULL); 
                                
	   str=XmStringCreateLocalized(l_str);
	   label[i]=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
					    XmNlabelString, str,  
					    XmNmarginHeight,(Dimension) 0,    
					    NULL);
       text[2*i]=
	 XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				 XmNvalue, "0.0",
				 XmNmarginHeight,(Dimension) 0,
				 XmNcolumns,10,
				 NULL);
                             
       XmStringFree(str);                             
       button=
	 XtVaCreateManagedWidget("",xmToggleButtonWidgetClass,rowcol,
				 XmNset,True,
				 XmNindicatorSize,(Dimension) 8,
				 XmNmarginWidth,(Dimension) 0,
				 XmNmarginHeight,(Dimension) 0,
                                 NULL);
       text[2*i+1]=
	 XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				 XmNvalue, "1.0",
				 XmNmarginHeight,(Dimension) 0,
				 XmNcolumns,10,
				 NULL);
       
       if (!i)
	 log_label=BuildOptionMenu(rowcol,"",'L',0,xlog_plot,0); 
       else
	 log_label=BuildOptionMenu(rowcol,"",'L',0,ylog_plot,0); 

       XtManageChild(log_label);
       XtManageChild(rowcol);
       XtAddCallback(button,XmNvalueChangedCallback,flg_change,&cflag[i]);
       XtAddCallback(text[2*i],XmNactivateCallback,axis_entry,
		     (XtPointer) this); 
       XtAddCallback(text[2*i+1],XmNactivateCallback,axis_entry,
                     (XtPointer) this); 
       l_str[0]='Y';    
     }   

   char l2_str[9]="View x :";

   
   for(i=0;i<2;i++)
     {
   
       rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
			       XmNpacking,XmPACK_TIGHT,
			       XmNisAligned, True,
			       XmNnumColumns,5,
			       XmNentryVerticalAlignment,XmALIGNMENT_END,
			       XmNorientation, XmHORIZONTAL,
			       NULL); 
       
       str=XmStringCreateLocalized(l2_str);
       label[i]=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
					XmNlabelString, str,  
					XmNmarginHeight,(Dimension) 0,    
					NULL);
       XmStringFree(str); 
       
       vport[2*i]=
	 XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				 XmNvalue, "1",
				 XmNmaxLength,5,
				 XmNcolumns,5,
				 XmNmarginHeight,(Dimension) 0,
				 NULL);     
       
       vport[2*i+1]=
	 XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				 XmNvalue, "1",
				 XmNmaxLength,5,
				 XmNcolumns,5,
				 XmNmarginHeight,(Dimension) 0,
				 NULL);
                                
       char l3_str[11]="Num. Size:";
       str=XmStringCreateLocalized(l3_str);
       label[i]=XtVaCreateManagedWidget("name",xmLabelWidgetClass,rowcol,
				     XmNlabelString, str,  
				     XmNmarginHeight,(Dimension) 0,    
				     NULL);
       XmStringFree(str); 
       button=
	 XtVaCreateManagedWidget("",xmToggleButtonWidgetClass,rowcol,
				 XmNset,True,
				 XmNindicatorSize,(Dimension) 8,
				 XmNmarginWidth,(Dimension) 0,
				 XmNmarginHeight,(Dimension) 0,
                                 NULL);

       axsize[i]=  
	 XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				 XmNvalue, "1.0",
				 XmNmaxLength,5,
				 XmNcolumns,5,
				 XmNmarginHeight,(Dimension) 0,
				 XmNheight,(Dimension) 0,
				 NULL);     
     
       
       XtManageChild(rowcol);

       XtAddCallback(vport[2*i+1],XmNactivateCallback,view_entry,  
		     (XtPointer) this); 
       XtAddCallback(vport[2*i],XmNactivateCallback,view_entry,  
		     (XtPointer) this); 
       XtAddCallback(axsize[i],XmNactivateCallback,view_entry,  
		     (XtPointer) this); 
       XtAddCallback(button,XmNvalueChangedCallback,Num_off,&aflag[i]);
       
       l2_str[5]='y';
       }  
          

    
   
   char oline[]="x Axis Line:";

   men_item xline_menu[]= {
     { "Both",&xmPushButtonGadgetClass, 'T', NULL, NULL,
       axis_option_handler, (XtPointer) tpmenu, (men_item*) NULL },
     { "Lower",&xmPushButtonGadgetClass, 'L', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+1), (men_item*) NULL },
     { "Top ",&xmPushButtonGadgetClass, 'B', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+2), (men_item*) NULL },
     { "None",&xmPushButtonGadgetClass, 'N', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+3), (men_item*) NULL },

     {0,}
   };

       
   men_item yline_menu[]= {
     { "Both ",&xmPushButtonGadgetClass, 'T', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+4), (men_item*) NULL },
     { "Left",&xmPushButtonGadgetClass, 'L', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+5), (men_item*) NULL },
     { "Right",&xmPushButtonGadgetClass, 'B', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+6), (men_item*) NULL },
     { "None ",&xmPushButtonGadgetClass, 'N', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+7), (men_item*) NULL },
     {0,}
   };


   men_item xtick_menu[]= {
     { "Full",&xmPushButtonGadgetClass, 'F', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+8), (men_item*) NULL },
     { "Major",&xmPushButtonGadgetClass, 'M', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+9), (men_item*) NULL },
     { "No Tick",&xmPushButtonGadgetClass, 'N', NULL, NULL,
	   axis_option_handler, (XtPointer) (tpmenu+10), (men_item*) NULL },
     { "Grid",&xmPushButtonGadgetClass, 'G', NULL, NULL,
	   axis_option_handler, (XtPointer) (tpmenu+11), (men_item*) NULL },
     {0,}
   };

   men_item ytick_menu[]= {
     { "Full",&xmPushButtonGadgetClass, 'F', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+12), (men_item*) NULL },
     { "Major",&xmPushButtonGadgetClass, 'M', NULL, NULL,
       axis_option_handler, (XtPointer) (tpmenu+13), (men_item*) NULL },
     { "No Tick",&xmPushButtonGadgetClass, 'N', NULL, NULL,
	   axis_option_handler, (XtPointer) (tpmenu+14), (men_item*) NULL },
     { "Grid",&xmPushButtonGadgetClass, 'G', NULL, NULL,
	   axis_option_handler, (XtPointer) (tpmenu+15), (men_item*) NULL },
     {0,}
   };
     
   for(i=0;i<2;i++)
     {
   
       rowcol=XtVaCreateWidget("rowcolumn",xmRowColumnWidgetClass,rowtwo,
			       XmNpacking,XmPACK_TIGHT,
			       XmNisAligned, True,
			       XmNnumColumns,4,
			       XmNentryVerticalAlignment,XmALIGNMENT_END,
                               XmNheight, (Dimension) 0,
                               XmNmarginHeight, (Dimension) 0,
			       XmNorientation, XmHORIZONTAL,
			       NULL); 
                                 
       if (i==0)
	 {
	   label[0]=BuildOptionMenu(rowcol,oline,'L',0,xline_menu,0);
	   label[1]=BuildOptionMenu(rowcol,"",'T',0,xtick_menu,0);
	 }
       else
	 {
	   label[0]=BuildOptionMenu(rowcol,oline,'l',0,yline_menu,0);
	   label[1]=BuildOptionMenu(rowcol,"",'t',0,ytick_menu,0);
	 }

       ticks[2*i]=
	 XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				 XmNvalue, "4",
				 XmNmaxLength,5,
				 XmNcolumns,5,
				 XmNmarginHeight,(Dimension) 1,
				 XmNheight,(Dimension) 1,
				 NULL);     
       
       ticks[2*i+1]=
	 XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				 XmNvalue, "4",
				 XmNmaxLength,5,
				 XmNcolumns,5,
				 XmNmarginHeight,(Dimension) 1,
				 XmNheight,(Dimension) 1,
				 NULL);
      
       /*       axsize[i]=  
	 XtVaCreateManagedWidget("text",xmTextFieldWidgetClass,rowcol,
				 XmNvalue, "1.0",
				 XmNmaxLength,5,
				 XmNcolumns,5,
				 XmNmarginHeight,(Dimension) 0,
				 XmNheight,(Dimension) 0,
				 NULL);     
       */
       XtManageChild(label[0]);
       XtManageChild(label[1]);


       XtManageChild(rowcol);

       XtAddCallback(ticks[2*i+1],XmNactivateCallback,line_entry,  
		     (XtPointer) this); 
       XtAddCallback(ticks[2*i],XmNactivateCallback,line_entry,  
		     (XtPointer) this); 

       oline[0]='y';
       } 

     XtManageChild(rowtwo);   //End of parameter table          
     CreateActionArea(pane,act2,5);

     XtManageChild(pane);
     XtAddCallback(alog,XmNdestroyCallback,remove_axis,
                   (XtPointer) this);
     XtPopup(alog,XtGrabNone);   
     //     old_val(vport[0],(XtPointer) this,NULL);
     set_axis_wind();   //nwin
     }
   else
     {
       XtPopup(alog,XtGrabNone);   
     }
  }   

void 
axis_param::view_entry(Widget w,XtPointer client_data,XtPointer call_data)
{
    
  axis_param* THIS= (axis_param*) client_data; 
  char out[255];
  double temp,temp2;
  int k;
  for(int i=0;i<4;i+=2)
    { 
      strcpy(out,XmTextFieldGetString(THIS->vport[i]));     
      temp=atof(out);
      strcpy(out,XmTextFieldGetString(THIS->vport[i+1]));     
      temp2=atof(out);
      temp=((temp<0.0 || temp>1.0) ? THIS->bord[i] : temp);
      temp2=((temp2<0.0 || temp2>1.0) ? THIS->bord[i+1] : temp2);
      if (temp2<temp)
	{
	  THIS->bord[i]=temp2;
	  THIS->bord[i+1]=temp;
	}
      else
	{
	  THIS->bord[i]=temp;
	  THIS->bord[i+1]=temp2;
	}
      sprintf(out,"%20g",THIS->bord[i]);    
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(THIS->vport[i],out+k);
      XmTextFieldSetInsertionPosition(THIS->vport[i],5);
      sprintf(out,"%20g",THIS->bord[i+1]);    
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(THIS->vport[i+1],out+k);
      XmTextFieldSetInsertionPosition(THIS->vport[i+1],5);
      
      strcpy(out,XmTextFieldGetString(THIS->axsize[i/2]));
      temp=atof(out);
      THIS->num_size[i/2]=
	((temp<0.5 || temp>5.0) ? THIS->num_size[i/2] : temp);
      sprintf(out,"%20g",THIS->num_size[i/2]);    
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(THIS->axsize[i/2],out+k);
      XmTextFieldSetInsertionPosition(THIS->axsize[i/2],5);    
      
    }
  XmTextFieldSetInsertionPosition(w,5);   
  return;
}
   
void 
axis_param::line_entry(Widget w,XtPointer client_data,XtPointer call_data)
  /* called when the input data from the fields about axis need 
     updating either from a return or an update call */
{
  axis_param* THIS= (axis_param*) client_data; 
  char out[255];
  int temp,temp2;
  int k;
  for(int i=0;i<4;i+=2)
    { 
      strcpy(out,XmTextFieldGetString(THIS->ticks[i]));     
      temp=(int) atof(out);
      strcpy(out,XmTextFieldGetString(THIS->ticks[i+1]));     
      temp2=(int) atof(out);
      if (temp<0) temp=4;
      if (temp2<0) temp2=4;
      
      THIS->atick[i]=temp;
      THIS->atick[i+1]=temp2;
      
      sprintf(out,"%5d",THIS->atick[i]);    
      for(k=0;k<25 && out[k]==' ';k++);       
      XmTextSetString(THIS->ticks[i],out+k);
      sprintf(out,"%5d",THIS->atick[i+1]);    
      for(k=0;k<25 && out[k]==' ';k++);       
      XmTextSetString(THIS->ticks[i+1],out+k);
    }
  XmTextFieldSetInsertionPosition(w,20);
  return;
}   


void 
axis_param::axis_make_box(const float xmin,const float xmax,
			       const float ymin,const float ymax) 
  //ONLY FOR TWO_GRAPHIC CALL!!!!

  /* Job is to  sort out the box drawing for the plotspecg 
     if box then for the 2d plot */
{
  float y1,y2;

  int xc(0),yc(0);
  int pt=1;
  char inschar[]="ABC STVN";
  char xch[12];
  cpgsci(1);
  cpgsls(2);
  cpgslw(1);
  cpgsch(1);
  for(int i=0;i<8;i++)
    {
      if (aflag[0] & pt) 
	{
	  xch[xc]=inschar[i];
	  xc++;
	}
      pt*=2;
    }

  xch[xc]=0;
  if (atick[0]<=0) 
    y1=0.0;
  else 
    y1= (float) ((xmax-xmin) / atick[0]);

  if (atick[2]<=0) 
    y2=0.0;
  else
    y2= (float) ((ymax-ymin) / atick[2]);


  if (8 & aflag[0])
    {
      cpgsls(2);
      cpgbox("G",y1,atick[1],"",y2,atick[3]);
    }
  cpgsls(1);
  float f1=(float) num_size[0];
  cpgsch(f1);

  cpgbox(xch,y1,atick[1],"",y2,atick[3]);


  pt=1;
  for(int i=0;i<8;i++)
    {
     if (aflag[1] & pt) 
	{
	  xch[yc]=inschar[i];
	  yc++;
	}
      pt*=2;
    }


  xch[yc]=0;
  if (8 & aflag[1])
    {
      cpgsls(2);
      cpgbox("",y1,atick[1],"G",y2,atick[3]);
    }
  cpgsls(1);
  f1=(float) num_size[1];
  cpgsch(f1);

  cpgbox("",y1,atick[1],xch,y2,atick[3]);

  return;

}

void axis_param::Num_off(Widget w,XtPointer client_data,XtPointer call_data)
{
  // Deals with the removal of the number bit. 
  int *tggl = (int *) client_data;
  if (*tggl & 128) 
    *tggl -= 128;
  else
    *tggl += 128;
  return;
} 

void axis_param::axis_log_handler
        (Widget w,XtPointer client_data,XtPointer call_data)
{
 
  axis_menu *AM = (axis_menu*) client_data;
  axis_param *THIS= AM->THIS;
  int type = AM->count;
  int pt=2 * (type/2);

  axis_entry(THIS->text[0],(XtPointer) THIS,(XtPointer) 0);
  if (THIS->log_flag[type/2]!=type % 2)
    {
      if (type % 2)
	{
	  THIS->aval[pt]=log10(fabs(THIS->aval[pt]));
	  THIS->aval[pt+1]=log10(fabs(THIS->aval[pt+1]));
	}
      else
	{
	  if (fabs(THIS->aval[pt])<200.0)
	    THIS->aval[pt]=pow(10,THIS->aval[pt]);
	  if (fabs(THIS->aval[pt+1])<200.0)
	    THIS->aval[pt+1]=pow(10,THIS->aval[pt+1]);
	}
      if (THIS->aval[pt]>THIS->aval[pt+1])
	{
          double temp=THIS->aval[pt];
	  THIS->aval[pt]=THIS->aval[pt+1];
	  THIS->aval[pt+1]=temp;
	}
      THIS->log_flag[type/2]=type % 2;
      THIS->set_axis_wind();
    }
  return;
} 

void axis_param::axis_option_handler
        (Widget w,XtPointer client_data,XtPointer call_data)
{
  /* This to set up a switch table for pgbox 
     A=1,B=2,C=4,G=8,S=16,T=32,V=64 N=128*/
 
  axis_menu *AM = (axis_menu*) client_data;
  axis_param *THIS= AM->THIS;
  int type = AM->count;    
  switch(type)
    {
    case 0 :          //xline_menu
      THIS->aflag[0]&=248;
      THIS->aflag[0]|=6;
      break;
    case 1 :
      THIS->aflag[0]&=248;
      THIS->aflag[0]|=2;
      break;
    case 2 :
      THIS->aflag[0]&=248;
      THIS->aflag[0]|=4;
      break;
    case 3 :
      THIS->aflag[0]&=248;
      break;
    case 4 :          //yline_menu
      THIS->aflag[1]&=248;
      THIS->aflag[1]|=6;
      break;
    case 5 :
      THIS->aflag[1]&=248;
      THIS->aflag[1]|=2;
      break;
    case 6 :
      THIS->aflag[1]&=248;
      THIS->aflag[1]|=4;
      break;
    case 7 :
      THIS->aflag[1]&=248;
      break;

    case 8 :          //xtick_menu
      THIS->aflag[0]&=199;
      THIS->aflag[0]|=48;
      break;
    case 9 :
      THIS->aflag[0]&=199;
      THIS->aflag[0]|=32;
      break;
    case 10 :
      THIS->aflag[0]&=199;
      break;
    case 11:
      THIS->aflag[0]&=199;
      THIS->aflag[0]|=56;
      break;

    case 12 :          //ytick_menu
      THIS->aflag[1]&=199;
      THIS->aflag[1]|=48;
      break;
    case 13 :
      THIS->aflag[1]&=199;
      THIS->aflag[1]|=32;
      break;
    case 14 :
      THIS->aflag[1]&=199;
      break;
    case 15:
      THIS->aflag[1]&=199;
      THIS->aflag[1]|=56;
      break;
    }
  return;
} 

void 
axis_param::num_entry(const double x,const double y)
  /* Sets the size of the number to be printed */
{
  if (x>0.2 && x<5.0) 
      num_size[0]=x;
  if (y>0.2 && y<5.0) 
    num_size[1]=y;
  set_axis_wind();
  return;
}

void 
axis_param::axis_entry(Widget w,XtPointer client_data,XtPointer call_data)
{
    
  axis_param* THIS= (axis_param*) client_data; 
  char out[255];
  double temp,temp2;
  int k;
  for(int i=0;i<4;i+=2)
    { 
      strcpy(out,XmTextFieldGetString(THIS->text[i]));     
      temp=atof(out);
      strcpy(out,XmTextFieldGetString(THIS->text[i+1]));     
      temp2=atof(out);
      if (temp2<temp)
	{
	  THIS->aval[i]=temp2;
	  THIS->aval[i+1]=temp;
	}
      else
	{
	  THIS->aval[i]=temp;
	  THIS->aval[i+1]=temp2;
	}
      sprintf(out,"%20g",THIS->aval[i]);    
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(THIS->text[i],out+k);
      sprintf(out,"%20g",THIS->aval[i+1]);    
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(THIS->text[i+1],out+k);
    }
  XmTextFieldSetInsertionPosition(w,20);
  
  return;
}   
  


void 
axis_param::axis_down(Widget w,XtPointer client_data,XtPointer call_data) 
{
  axis_param* THIS= (axis_param*) client_data; 
  XtPopdown(THIS->alog);
  return;
}
  
void 
axis_param::remove_axis(Widget w,XtPointer client_data,XtPointer call_data) 
{
  axis_param* THIS= (axis_param*) client_data; 
  XtDestroyWidget(THIS->alog);
  THIS->alog=0;
  return;
}
    
void axis_param::change_axis(Widget w,XtPointer client_data,XtPointer call_data)  
  {   //ok button is hit!
  
  axis_param* THIS= (axis_param*) client_data; 
  
  axis_entry(THIS->text[0],client_data,call_data);
  view_entry(THIS->vport[0],client_data,call_data);
  line_entry(THIS->ticks[0],client_data,call_data);
 
  return;
  } 
    
axis_param::axis_param() : alog(0),tpmenu(0)
{
//#pragma extern_model common_block  
  cflag[0]=cflag[1]=1;    //Allowed to change x and y
}
  
axis_param::~axis_param()
  {
  delete [] tpmenu;
  if (alog)
    XtDestroyWidget(alog);
  alog=0;
  }
  
void axis_param::old_val(Widget w,XtPointer client_data,XtPointer call_data)
{
   int a=0;
   int b=0;
   change_axis(w,client_data,call_data);
   draw2d(&a,&b);
   return;
}


void 
axis_param::set_axis_wind()    
{
  if (!alog) return;
  
  int k;    
  char out[255];
  for(int i=0;i<4;i++)
    {
      sprintf(out,"%20g",aval[i]);    
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(text[i],out+k);
      sprintf(out,"%20g",bord[i]);
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(vport[i],out+k);
      sprintf(out,"%5d",atick[i]);
      for(k=0;k<25 && out[k]==' ';k++);       
      XmTextSetString(ticks[i],out+k);
    }
  for(int i=0;i<2;i++)
    {
      sprintf(out,"%20g",num_size[i]);
      for(k=0;k<250 && out[k]==' ';k++);       
      XmTextSetString(axsize[i],out+k);
    }
  return;
}
  

void axis_param::re_draw(Widget w,XtPointer client_data,XtPointer call_data)
{
  axis_param* ap = (axis_param*) client_data;
  Frame* fm = dynamic_cast<Frame*>(ap);
  change_axis(w,client_data,call_data);
  fm->redraw();
  return;
}
  
void 
axis_param::ten_percent(Widget w,XtPointer client_data,XtPointer call_data)
  /* Adds 10% to the axis if they are allows to change */
{
  axis_param* THIS= (axis_param*) client_data; 

  change_axis(w,client_data,call_data);
  double diff;
  char out[255];
  for(int i=0;i<2;i++)
    if (THIS->cflag[i]) 
      {
      diff=THIS->aval[2*i+1]-THIS->aval[2*i];
      THIS->aval[2*i]-=0.05*diff;
      THIS->aval[2*i+1]+=0.05*diff;  
      }  
  int k;
  for(int i=0;i<4;i++)
    {
    sprintf(out,"%20g",THIS->aval[i]);    
    for(k=0;k<250 && out[k]==' ';k++);       
    XmTextSetString(THIS->text[i],out+k);
    } 
      
  return;
  }
  
void axis_param::flg_change(Widget w,XtPointer client_data,XtPointer call_data)
{
  int* cd = (int*) client_data;
  *cd=1- *cd; 
  return;
}  


