#ifndef areaInt_h
#define areaInt_h


struct Point
{
  double x;
  double y;
  

  Point(const double xx,const double yy) : x(xx),y(yy) {};
  Point() : x(0.0),y(0.0) {};
  Point(const Point&); //copy constructor
  Point& operator=(const Point&);
  Point operator+(const Point&) const;
  Point& operator+=(const Point&);
  Point operator-(const Point&) const;
  Point& operator-=(const Point&);
  double dist(const Point&) const;
  double dist() const;      //dist from origin
  double Flat_angle(const Point&) const;   //find angle A-O-This
  double c_angle(const Point&) const;   //find angle A-O-This
  double c_angle(Point,Point) const;    //find angle A-T-B 
  double Tri(Point,Point) const;        //Find area of Triangle TAB
  void boundary(const double,const double,Point&,Point&) const;
  Point arcPoint(Point&,double= -2.0,double= -2.0,double= -2.0) const;
  ~Point() {};
};

class AreaInt
{
 private:

  float **V;  //area of data
  Point cent; //Centre being used for integration
  double TArea;
  int n_hp,n_vp; //vertical / horrizotal pointt
  double ArcA(Point,Point,Point,const double R);
  int find_line(std::vector<Point>&,const Point&,const Point& );


 public:
  
  AreaInt();
  ~AreaInt();
  void Initialise(float**,const int,const int);
  int EvalArcUnit(double&,const double,const double,const double,
		 const double);
  void Set_centre(const double,const double);
  
};

#endif

