#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "datain.h"
#include "fglo.h"


void
resize(const int N)
  /* Resize arrays */
{
  if (N!=Npts && N>0)
    {
      delete [] Angle;
      delete [] Yval;
      delete [] Err;
      Angle = new double[N];
      Yval = new double[N];
      Err = new double[N];
    }
  return;
}


int 
datain::read(const char* Fn)
  /* 
     job is to read in the experimental EXAFS file 
     File format is   
        title line
	X , Y    newline
   */
{
  ifstream ipf;
  ipf.open(Fn);
  if (!ipf) 
    return 1;
  ipf.getline(ss,255,'\n'); //number of point
  if (!cmdnumber(ss,npts))
    {
      cerr<<"No point to read"<<endl;
      return -1;
    }
  int cnt=0;
  resize(npts);
  double xv,yv,zv;

  while(cnt<npts && ipf)
    {
      ipf.getline(ss,255,'\n');
      if (!cmdnumber(ss,xv) || !cmdnumber(ss,yv)
	  || !cmdnumber(ss,zv))
        {
	  cerr<<"Error with file"<<endl;
	  return -2;
	}
      Angle[cnt]=xv;
      Yval[cnt]=yv;
      Err[cnt]=ev;
      while(cmdnumber(ss,xv) && cmdnumber(ss,yv) && cmdnumber(ss,ev))
	{
	  Angle[cnt]=xv;
	  Yval[cnt]=yv;
	  Err[cnt]=ev;
	}
    }
  return;
}


