#ifndef svd_h
#define svd_h

void svdpoly();  //global for dxops.
double polyvalues(const double,const int,const double*,double*);


class svd 
{
private:

  int m;     
  int n;
  double** A;  // input m*n matrix
  double*  W;     //n length
  double** U;    //m*n matrix
  double** V;    //n*n matrix
  
  double pythag(const double,const double) const;
    
protected:
  
  double** getA() const { return A; }  

public:

  int checkA() const;         //check that A=UWV^t
  void setA(const int,const int,const double ** =0); //set up variables
  void svdbksb(const double*,double*) const;
  int svdcmp();
  double getWeight(const int) const;
  int removeSingular(const double);

  svd();
  virtual ~svd();
};

class decompose : public svd
{
 private:
  
  int ngrp;   //number of grps ( -- n in svd)
  int xlen;   //lenght of x ( -- m in svd)
  double* xpts;  //m length
  int outgrp;
  int maxout;

  int getactive(const char*,int *,const int=80) const;

 public:
  
  decompose();
  ~decompose();

  void setup(const char);
  void runsvd();  

};

/* This class operates on gthe function fitfun. This requires that
   the function returns the functionat point x,number of parameters
   parmeters P and linear part of those parameters 
*/
class Lsvd : public svd
{
 private:
  
  double* Xval;
  double* Yval;
  double* Eval;
  int nlen;    //length
  double* Yfit;   //Modified Y Values -- minus fixed part.
  double* parts;  //section for the function parts.

  int nparam;   //Total parameters
  int ntrue;    //Number of un-fixed paramerters
  int* Fixed;   //Array of fixed/not fixed
  double* PP;   //Parameters (length nparam)
  double chi2;  //chi for the current fit

  double (*fitfun)(const double,const int,const double*,double*);

  void resizeYfit(const int =0);  //default is to delete

public:
  
  Lsvd();
  virtual ~Lsvd();
  
  int setParam(const int);  //set all zero...
  int setParam(const double*,const int =0);
  int setParam(const double*,const int*,const int =0);
  int setParam(const int*,const int =0);

  void setData(const int,const double*,const double*,const double* =0);
  void setValues(const double*,const double*,const double* =0);
  void prepArrays();
  void setFunc(double (*FF)(const double,const int,const double*,double*));
  double fit();
  void printParam() const;
  void copyParam(double*) const;
  double chi() const { return chi2; }
};

/*class svd_linfit : public svd
{
 private:
  
 public:

  svd_linfit();
  ~svd_linfit();
}; 
*/

#define SIGN(a,b) ((b)>=0.0 ? fabs(a) : -fabs(a))

#endif












