#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <vector>
#include <string>
#include "svd.h"
#include "fglo.h"

svd::svd() : m(0),n(0),A(0),W(0),U(0),V(0)
{}

svd::~svd()
{
  freematrix(A);
  freematrix(U);
  freematrix(V);
  delete [] W;
}

double 
svd::getWeight(const int pt) const
  /* Return the diagonal element of W */
{
  return (!W || pt<0 || pt>=n) ?
      0.0 : W[pt];
}

int
svd::checkA() const
  /* Check routine for A  == U.W.V^T*/
{
  int errcnt;
  for(int i=0;i<m;i++)
    for(int j=0;j<n;j++)
      {
	double ta(0.0);
	for(int k=0;k<n;k++)
	  ta+=W[k]*U[i][k]*V[j][k];
	if (fabs((ta-A[i][j])/ta)>1e-8)
	  {
	    //	    cout<<"Error with A["<<i<<"]["<<j<<"] == "<<
	    //	      A[i][j]<<"-- Ta == "<<ta<<endl;
	    errcnt++;
	  }
      }
  return errcnt;
}

void
svd::setA(const int aa,const int bb,const double** Av)
  /* General Set up matrix  */
{
  if (aa!=m || bb!=n)
    {
      freematrix(A);
      freematrix(U);
      freematrix(V);
      delete [] W;
      V=matrix(bb,bb);
      W=new double[bb];
      U=matrix(aa,bb);
      A=matrix(aa,bb);
    }
  if (Av)
    {
      for(int im=0;im<m;im++)
	for(int in=0;in<n;in++)
	  A[im][in]=Av[im][in];
    }
  m=aa;
  n=bb;
  return;
}

void
svd::svdbksb(const double* B,double* X) const
  /* 
     Calculates for
     A*X=B ; A already decoposed into U,W,V
  */
{
  double *tmp = new double[n];
  double s;
  for(int j=0;j<n;j++)
    {
      s=0.0;
      if (W[j])
	{
	  for(int i=0;i<m;i++)
	    s += U[i][j]*B[i];
	  s /= W[j];
	}
      tmp[j]=s;
    }
  for(int j=0;j<n;j++)
    {
      s=0.0;
      for(int i=0;i<n;i++)
	s+=V[j][i]*tmp[i];
      X[j]=s;
    }
  delete [] tmp;
  return;
}

int
svd::removeSingular(const double Tol)
  /* After svdcmp this removed singular solutions from the matrix W
     testing on the tolorace given */
{
  if (Tol<=0.0)
    return 0;
  double wmax=0.0;
  for(int j=0;j<n;j++)
    if (W[j]>wmax)
      wmax=W[j];
  double threshold=Tol*wmax;
  int cnt;
  for(int j=0;j<n;j++)
    if (W[j]<threshold) 
      {
	W[j]=0.0;
	cnt++;
      }
  return cnt;  //number removed.
}


int
svd::svdcmp()
  /* 
     Assumes that A has been built and set assumes that  
     U,V,W are all allocated
     Calcuates :: A= U W V^T 
     Returns --  U,W and V -- Not V^T
  */
{
  if (n<1 || m<1 || !A || !V || !U)
    return 1;
  
  for(int i=0;i<m;i++)   //copy matrix...
    for(int j=0;j<n;j++)
      U[i][j]=A[i][j];
  

  double* rv1=new double[n];
  double g(0.0);
  double scale(0.0);
  double s(0.0);
  double anorm(0.0);
  double f,h;
  int l,nm;

  for(int i=0;i<n;i++)
    {
      l=i+1;
      rv1[i]=scale*g;
      g=s=scale=0.0;
      if (i<m) 
	{
	  for(int k=i;k<m;k++)
	    scale += fabs(U[k][i]);
	  if (scale)
	    {
	      for(int k=i;k<m;k++)
		{
		  U[k][i] /= scale;
		  s+=U[k][i]*U[k][i];
		}
	      f=U[i][i];
	      g = (f>=0.0) ? -sqrt(s) : sqrt(s);
	      h=f*g-s;
	      U[i][i]=f-g;
	      for(int j=l;j<n;j++)
		{
		  s=0.0;
		  for(int k=i;k<m;k++)
		    s += U[k][i]*U[k][j];
		  f=s/h;
		  for(int k=i;k<m;k++)
		    U[k][j]+=f*U[k][i];
		}
	      for(int k=i;k<m;k++)
		U[k][i] *= scale;
	    }
	}
      W[i]=scale*g;
      g=s=scale=0.0;
      if (i<m && i!=n-1)
	{
	  for(int k=l;k<n;k++)
	    scale+=fabs(U[i][k]);
	  if(scale)
	    {
	      for(int k=l;k<n;k++)
		{
		  U[i][k]/=scale;
		  s+=U[i][k]*U[i][k];
		}
	      f=U[i][l];
	      g = (f>=0.0) ? -sqrt(s) : sqrt(s);
	      h=f*g-s;
	      U[i][l]=f-g;
	      for(int k=l;k<n;k++)
		rv1[k]=U[i][k]/h;
	      for(int j=l;j<m;j++)
		{
		  s=0.0;
		  for(int k=l;k<n;k++)
		    s+= U[j][k]*U[i][k];
		  for(int k=l;k<n;k++)
		    U[j][k]+=s*rv1[k];
		}
	      for(int k=l;k<n;k++)
		U[i][k]*=scale;
	    }
	}
      double hval=fabs(W[i])+fabs(rv1[i]);
      if (anorm<hval)
	anorm=hval;
    }
  for(int i=n-1;i>=0;i--)  //right hand bit!
    {
      if (i < n-1)
	{
	  if (g)
	    {
	      for(int j=l;j<n;j++)
		V[j][i]=(U[i][j]/U[i][l])/g;
	      for(int j=l;j<n;j++)
		{
		  s=0.0;
		  for(int k=l;k<n;k++)
		    s+= U[i][k]*V[k][j];
		  for(int k=l;k<n;k++)
		    V[k][j]+=s*V[k][i];
		}
	    }
	  for(int j=l;j<n;j++)
	    V[i][j]=V[j][i]=0.0;
	}
      V[i][i]=1.0;
      g=rv1[i];
      l=i;
    }
  
  for(int i=((m<n) ? m : n)-1;i>=0;i--)     //left parts
    {
      l=i+1;
      g=W[i];
      for(int j=l;j<n;j++)
	U[i][j]=0.0;
      if (g)
	{
	  g=1.0/g;
	  for(int j=l;j<n;j++)
	    {
	      s=0.0;
	      for(int k=l;k<m;k++)
		s+=U[k][i]*U[k][j];
	      f=(s/U[i][i])*g;
	      for(int k=i;k<m;k++)
		U[k][j]+=f*U[k][i];
	    }
	  for(int j=i;j<m;j++)
	    U[j][i]*=g;
	}
      else //of (g)
	for(int j=i;j<m;j++)
	  U[j][i]=0.0;
      U[i][i]++;
    }

  double c,x,y,z;
  for(int k=n-1;k>=0;k--)
    {
      for(int its;its<30;its++) //assume no more than 30 singular values.
	{
	  int flag=1;
	  for(l=k;l>=0;l--)  //variable has exit status 
	    {
	      nm=l-1;   //rv1[0]=0.0 here ALWAYS  (hopefully)
	      if ((fabs(rv1[l])+anorm) == anorm)
		{
		  flag=0;
		  break;
		}
	      if ((fabs(W[nm])+anorm) == anorm) 
		break;
	    }
	  if (flag)
	    {
	      c=0.0;
	      s=1.0;
	      for(int i=l;i<=k;i++)
		{
		  f=s*rv1[i];
		  rv1[i]*=c;
		  if ((fabs(f)+anorm) == anorm)
		    break;
		  g=W[i];
		  h=pythag(f,g);
		  W[i]=h;
		  h=1.0/h;
		  c=g*h;
		  s= -f*h;
		  for(int j=0;j<m;j++)
		    {
		      y=U[j][nm];
		      z=U[j][i];
		      U[j][nm]=y*c+z*s;
		      U[j][i]=z*c-y*s;
		    }
		}
	    }
	  z=W[k];
	  if (l==k)
	    {
	      if (z<0.0)
		{
		  W[k]= -z;
		  for(int j=0;j<n;j++)
		    V[j][k]= -V[j][k];
 		}
	      break;
	    }
	  if (its == 30)
	    cerr<<"No Convergence at iteration 30"<<endl;
	  x=W[l];
	  nm=k-1;
	  y=W[nm];
	  g=rv1[nm];
	  h=rv1[k];
	  f=((y-z)*(y+z)+(g-h)*(g+h))/(2.0*h*y);
	  g=pythag(f,1.0);
	  f=((x-z)*(x+z)+h*((y/(f+SIGN(g,f)))-h))/x;
	  c=s=1.0;
	  for(int j=l;j<=nm;j++)
	    {
	      int ii=j+1;
	      g=rv1[ii];
	      y=W[ii];
	      h=s*g;
	      g=c*g;
	      z=pythag(f,h);
	      rv1[j]=z;
	      c=f/z;
	      s=h/z;
	      f=x*c+g*s;
	      g=g*c-x*s;
	      h=y*s;
	      y *= c;
	      for(int jj=0;jj<n;jj++)
		{
		  x=V[jj][j];
		  z=V[jj][ii];
		  V[jj][j]=x*c+z*s;
		  V[jj][ii]=z*c-x*s;
		}
	      z=pythag(f,h);
	      W[j]=z;
	      if (z)
		{
		  z=1.0/z;
		  c=f*z;
		  s=h*z;
		}
	      f=c*g+s*y;
	      x=c*y-s*g;
	      for(int jj=0;jj<m;jj++)
		{
		  y=U[jj][j];
		  z=U[jj][ii];
		  U[jj][j]=y*c+z*s;
		  U[jj][ii]=z*c-y*s;
		}
	    }
	  rv1[l]=0.0;
	  rv1[k]=f;
	  W[k]=x;
	}
    }
  delete [] rv1;
  return 0;
}
		

double 
svd::pythag(const double A,const double B) const
{
  double absa,absb;
  absa=fabs(A);
  absb=fabs(B);
  if (absa>absb) 
    return absa*sqrt(1.0+(absb/absa)*(absb/absa));
  else
    return (absb ==0.0 ? 0.0 : absb*sqrt(1.0+(absa/absb)*(absa/absb)));
}




decompose::decompose() : svd(),xlen(0),xpts(0),
			 outgrp(-1),maxout(0)
{}

decompose::~decompose()
{
  delete [] xpts;
}

/* 
void 
decompose::setup(const char ans)
  / * Specifically this sets up the arrays from an input list. * /
{
  extern Spec_In storage_;
  extern wback hold_;

  int grp;
  char ss[256];
  int active[tg];
  int flag=cmdnumber(hold_.is,grp);
  while(!flag || grp>tg || grp<1 )
    {
      flag=2;
      sprintf(ss,"Enter first output grp =>");
      l_c(ss,0);
      if (!cmdnumber(ss,grp)) return;
    }
  outgrp=grp-1;

  if (flag>1 || !getactive(hold_.is,active,holdlen))
    {
      sprintf(ss,"Enter list of input grps =>");
      l_c(ss,0);
      if (!getactive(ss,active,255)) return;
    }
  int count=0;
  std::vector<int> Alist;
  for(int i=0;i<tg;i++)
    if (active[i])
      {
	count++;
	Alist.push_back(i);
      }
  if (count<1) return;
  int j,Tpt,error(0);
  for(int i=0;i<count;i++)
    {
      j=Alist[i];
      sprintf(ss,"Grp %d: %d pts",j,storage_.stpnt[j]);
      l_c(ss,1);
      if (i)
	{
	  if (storage_.stpnt[j]!=Tpt)
	    error=1;
	}
      else
	{
	  Tpt=storage_.stpnt[j];
	}
    }
  if (Tpt<2 || error)
    {
      l_c("Error with number of points in grps",1);
      return;
    }

  if (Tpt!=xlen)
    {
      if (xpts)
	delete [] xpts;
      xpts=new double[Tpt];
      xlen=Tpt;
    }
  ngrp=count;
  setA(xlen,ngrp,0);  //0 -- we set A later...  
  //initialise A
  
  double** Am = getA();
  for(int i=0;i<ngrp;i++)
   {
     j=Alist[i];
     for(int i=0;i<xlen;i++)
       Am[i][j]=storage_.story[j][i];
   }
  j=Alist[0];
  for(int i=0;i<xlen;i++)
    xpts[i]=storage_.storx[j][i];
  return;
}
* /

/*
int
decompose::getactive(const char* St,int* active,const int leng) const
  / * job is to read a list 5,6-10,20 etc . and find the active
     groups * /
{
  char ss[256];
  strncpy(ss,St,leng);
  int aflag(0);
  for(int i=0;i<tg;i++)
    active[i]=0;
  int count;
  int ra,rb,th;
  for(int i=0;i<leng && ss[i];i++)
    {
      if (ss[i]=='-')
	{
	  aflag=1;
	  ss[i]=' ';
	  count=0;
	  while(cmdnumber(ss,ra,i))
	    {
	      if (ra>0 && ra<=tg)
		{
		  count++;
		  active[ra-1]=1;
		}
	      else
		return 0; //invalid number removes all
	    }
	  if (!count) return 0;  //not a valid - prelist
	  if (!cmdnumber(ss,rb,leng) || 
	      rb<1 || rb>tg)
	    break;
	  if (ra>rb)
	    {
	      th=ra;
	      ra=rb;
	      rb=th;
	    }
	  for(ra--;ra<rb;ra++)
	    active[ra]=1;
	}
    }	      
  while(cmdnumber(ss,ra,leng))
    {
      aflag=1;
      if (ra>tg || ra<1)
	return 0;
      active[ra-1]=1;
    }
  return aflag;   //return 1 on success.
}
*/

/*
void 
decompose::runsvd() 
{
  extern Spec_In storage_;
  extern titls about_;

  if (svdcmp()) 
    {
      cerr<<"Unable to run decomposition of SVD matrix"<<endl;
      return;
    }
  int mc;
  if (maxout==0 || maxout>tg-outgrp) 
    mc=((tg-outgrp)>ngrp) ? ngrp : tg-outgrp;
  else
    mc=(maxout>ngrp) ? ngrp : maxout;
  
  char ss[256];
  for(int i=0;i<mc;i++)
    {
      sprintf(ss,"Eigenvalue %d : %10.6f",i+1,getWeight(i));
      cout<<ss<<endl;;
      double *X=storage_.storx[i+outgrp];
      double *Y=storage_.story[i+outgrp];
      double *E=storage_.store[i+outgrp];
      double **Am = getA();
      for(int k=0;k<xlen;k++)
	{
	  X[k]=xpts[k];
	  Y[k]=Am[k][i];
	  E[k]=0.0;
	}
      storage_.stpnt[outgrp+i]=xlen;
      sprintf(about_.hd[outgrp+i],"Svd comp. %f",getWeight(i));
    }
  return;
}
*/

Lsvd::Lsvd() : svd(),Xval(0),Yval(0),Eval(0), 
  nlen(0),Yfit(0),parts(0),
  nparam(0),ntrue(0),Fixed(0),
  PP(0),chi2(-1.0),fitfun(0)
{ }

Lsvd::~Lsvd()
{
  delete [] Xval;
  delete [] Yval;
  delete [] Eval;
  delete [] Yfit;
  delete [] Fixed;
  delete [] PP;
}

int
Lsvd::setParam(const int* Af,const int NP)
  /* Af sets the fixed array an updated parameters */
{
  if (nparam<1 && NP<1)
    {
      cerr<<"No parameters defined"<<endl;
      return 0;
    }
  if (NP>0 && nparam!=NP)  //redefine memory.
    {
      delete [] Fixed;
      Fixed=new int[NP];
      delete [] PP;   //do this hear as well as in fit param
      PP=new double[NP];  
      nparam=NP;
    }
  ntrue=0;
  for(int i=0;i<nparam;i++)
    {
      Fixed[i]=Af[i];
      if (!Af[i]) ntrue++;
    }
  return ntrue;
}


int 
Lsvd::setParam(const int NP)
/* Drastic function to set everything to zero */
{
  if (nparam<1 && NP<1)
    {
      cerr<<"No parameters defined"<<endl;
      return 0;
    }
  if (NP>0 && nparam!=NP)  //redefine memory.
    {
      delete [] parts;
      parts=new double[NP];
      delete [] Fixed;
      Fixed=new int[NP];
      delete [] PP;   //do this hear as well as in fit param
      PP=new double[NP];  
      nparam=NP;
    }
  for(int i=0;i<nparam;i++)
    {
      PP[i]=0.0;
      Fixed[i]=0;
    }
  ntrue=nparam;
  return nparam;  
}

int
Lsvd::setParam(const double* Ip,const int NP)
  /* Af sets the fixed array an updated parameters */
{
  if (nparam<1 && NP<1)
    {
      cerr<<"No parameters defined"<<endl;
      return 0;
    }
  if (NP>0 && nparam!=NP)  //redefine memory.
    {
      delete [] parts;
      parts=new double[NP];
      delete [] Fixed;
      Fixed=new int[NP];
      delete [] PP;   //do this hear as well as in fit param
      PP=new double[NP];  
      nparam=NP;
      for(int i=0;i<nparam;i++)  //incase it is used without set fixed
	Fixed[i]=0;
      ntrue=nparam;
    }
  for(int i=0;i<nparam;i++)
    {
      PP[i]=Ip[i];
    }

  return nparam;
}

int
Lsvd::setParam(const double* Ip,const int* Af,const int NP)
  /* set both the parameters and fixed points */
{
  setParam(Ip,NP);
  return setParam(Af,NP);
}

void 
Lsvd::resizeYfit(const int NL)
  /* Helper function to resize the input data stream */
{

  if (NL!=nlen)
    {
      delete [] Xval;
      delete [] Yval;
      delete [] Eval;
      delete [] Yfit;
      Yfit = (NL>0) ? new double[NL] : 0;
      Yval = (NL>0) ? new double[NL] : 0;
      Xval = (NL>0) ? new double[NL] : 0;
      Eval = (NL>0) ? new double[NL] : 0;
      nlen=NL;
    }
  return; 
}


double
Lsvd::fit()
{
  if (svdcmp())
    {
      cerr<<"Unable to run decomposition of SVD matrix"<<endl;
      return -1.0;
    }
  //  checkA();  Debug not now needed ??
  double* FitP=new double [ntrue];
  removeSingular(1e-10);
  svdbksb(Yfit,FitP);
  // move parameters to correct position
  int cnt=0;
  for(int i=0;i<nparam;i++)
    if (!Fixed[i])
      {
	PP[i]=FitP[cnt];
	cnt++;
      }
  delete [] FitP;
  //calc chi.

  chi2=0.0;
  double sum,tmp;
  for(int i=0;i<nlen;i++)
    {
      sum=(*fitfun)(Xval[i],nparam,PP,parts);
      tmp = (Eval[i]>0.0) ? (Yval[i]-sum)/Eval[i] : Yval[i]-sum;
      chi2+=tmp*tmp;
    }
  char ss[255];
  sprintf(ss,"Chi^2 == %g",chi2);
  cout<<ss<<endl;
  return chi2;
}

void 
Lsvd::copyParam(double* Pval) const
{
  for(int i=0;i<nparam;i++)
    {
      Pval[i]=PP[i];
    }
  return;
}

void 
Lsvd::printParam() const
{
  char ss[255];
  for(int i=0;i<nparam;i++)
    {
      if (Fixed[i])
	sprintf(ss,"Fixed    P[%d] = %12.6g",i,PP[i]);
      else
	sprintf(ss,"Variable P[%d] = %12.6g",i,PP[i]);
      cout<<ss<<endl;
    }
  return;
}

void
Lsvd::setFunc(double (*FF)(const double,const int,
			   const double*,double*))
{
  fitfun=FF;
  return;
}


void
Lsvd::setData(const int size,const double* X,const double *Y,
	      const double* E)
{
  if (!size) return;
  resizeYfit(size);
  for(int i=0;i<size;i++)
    {
      Xval[i]=X[i];
      Yval[i]=Y[i];
      Eval[i]=(E) ? E[i] : 1.0;
    }
  return;
}


void
Lsvd::prepArrays()
{
  
  if (ntrue<1)
    return;

  setA(nlen,ntrue); //set up matrix.
  double** Amatrix=getA();  //get copy to fill.

  double tmp;
  for(int i=0;i<nlen;i++)
    {
      (*fitfun)(Xval[i],nparam,PP,parts);
      tmp=(Eval[i]>0.0) ? Eval[i] : 1.0; 
      Yfit[i]=Yval[i];
      for(int j=0;j<nparam;j++)
	{
	  if (!Fixed[j])
	    Amatrix[i][j]=parts[j]/tmp;  //init A[][] in svd.
	  else
	    Yfit[i]-=parts[j];  //note subtract now.
	}
      Yfit[i]/=tmp;
    }
  return;
}

double 
polyvalues(const double x,const int N,const double* P,double* out)
  /* very simple polynominal */
{
  if (N>0)
    {
      out[0]=1.0;
      double sum=P[0];
      for (int i=1;i<N;i++)
	{
	  out[i]=out[i-1]*x;
	  sum+=out[i]*P[i];
	}
      return sum;
    }
  return 0.0;
}






