#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "corpy.h"
#include "info.h"
#include "datain.h"
#include "fglo.h"

int main()
{
  corpy A;
  Param Names;
  
  char rawfile[255];
  char corfile[255];
  char listfile[255];
  char datafile[255];
  cout<<"Enter info file :: ";
  cin.getline(rawfile,256,'\n');
  cout<<endl;
  strip(rawfile);
  if (Names.inforead(rawfile))
    {
      cerr<<"Error with info file "<<rawfile<<endl;
      exit(1);
    }

  cout<<"Enter cor file :: ";
  cin.getline(corfile,256,'\n');
  cout<<endl;
  strip(corfile);
  cout<<"Enter list file :: ";
  cin.getline(listfile,256,'\n');
  cout<<endl;
  strip(listfile);
  
  if (A.open(corfile))
    exit(1);
  
  DataIn Back;
  DataIn Van;
  Back.read(Names.Bground());
  Van.read(Names.Vanadium());
  Van-=Back;                //subtract backgroud
  Van.mult(A,A.PvVan());    // Mult by A_(v,v)

  DataIn CVan(Van); 
  CVan.progressFit(A.Vpow(),A.VStart(),
		   A.VEnd()); //Smooth by polynominal

  Van.write("VanCheck.dat");
  CVan.write("VanCheck.dat",1);

  DataIn Heat;
  DataIn Tube;
  DataIn Samp;
  
  Heat.read(Names.Heater());
  Tube.read(Names.Can());
  Samp.read(Names.Sample());
  
}
  






