#include <fstream.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <list>
#include <string>
#include "fglo.h"
#include "info.h"

Param::Param()
{
  Backfile[0]=0;
  Sampfile[0]=0;
  Heatfile[0]=0;
  Vanfile[0]=0;
  Canfile[0]=0;
  Cdfile[0]=0;
}

Param::~Param()
{}


int
Param::inforead(const char *Fname)
{
  ifstream isf;
  isf.open(Fname);
  if (!isf)
    return -1;
  char ss[255];
  while (isf)
    {
      isf.getline(ss,255,'\n');  
      while (!isf.fail())
	{
	  string Einfo = ss;
	  string::size_type pos;
	  pos = Einfo.find_first_of("#!");
	  if (pos!=string::npos)
	    Einfo.erase(pos); //remove trailing comments
	  //Background 
	  if (Einfo.find("Back")!=string::npos)  
	    {
	      int start,len;  //dummy return variables.
	      char File[81];
	      if ((pos=Einfo.find_first_of("=:")) != string::npos)
		{
		  extractname(File,Einfo.c_str(),
			      Einfo.size(),start,len,80);
		}
	      strncpy(Backfile,File,255);
	    }
	  else if (Einfo.find("Can")!=string::npos)  
	    {
	      int start,len;  //dummy return variables.
	      char File[81];
	      if ((pos=Einfo.find_first_of("=:")) != string::npos)
		{
		  extractname(File,Einfo.c_str(),
			      Einfo.size(),start,len,80);
		}
	      strncpy(Canfile,File,255);
	    }
	  else if (Einfo.find("Heat")!=string::npos)  
	    {
	      int start,len;  //dummy return variables.
	      char File[81];
	      if ((pos=Einfo.find_first_of("=:")) != string::npos)
		{
		  extractname(File,Einfo.c_str(),
			      Einfo.size(),start,len,80);
		}
	      strncpy(Heatfile,File,255);
	    }
	  else if (Einfo.find("Cadn")!=string::npos)  
	    {
	      int start,len;  //dummy return variables.
	      char File[81];
	      if ((pos=Einfo.find_first_of("=:")) != string::npos)
		{
		  extractname(File,Einfo.c_str(),
			      Einfo.size(),start,len,80);
		}
	      strncpy(Cdfile,File,255);
	    }
	  else if (Einfo.find("Van")!=string::npos)  
	    {
	      int start,len;  //dummy return variables.
	      char File[81];
	      if ((pos=Einfo.find_first_of("=:")) != string::npos)
		{
		  extractname(File,Einfo.c_str(),
			      Einfo.size(),start,len,80);
		}
	      strncpy(Vanfile,File,255);
	    }
	  else if (Einfo.find("Sam")!=string::npos)  
	    {
	      int start,len;  //dummy return variables.
	      char File[81];
	      if ((pos=Einfo.find_first_of("=:")) != string::npos)
		{
		  extractname(File,Einfo.c_str(),
			      Einfo.size(),start,len,80);
		}
	      strncpy(Sampfile,File,255);
	    }
	  isf.getline(ss,255,'\n');  
	}
    }
  isf.close();
  return 0;
}










