#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "svd.h"
#include "fglo.h"

int
extractname(char* s,const char* in,const int leng,int &start,int len,
	    int max_len)
  /* s is longest string with a A-z character in it 
      and zero it to  ' ' or zspc 
  in == input string
  leng == max length
  start == coordiante the the start 
  len == length of found string
  max_len == max possible length ot return
  */
{
   if (!max_len)
     max_len=leng+1;
   int c_start=0;
   int c_len=0;
   int b_len=0;
   int b_start=0;
   int i=0;
   while (i<=leng)
     {
       if (i!=leng && !in[i])   //prevent over access
	 i=leng;   //if zero finish
       if (i!=leng && in[i] && in[i]!=' ' && in[i]!=',')  //a proper char
	 if (!c_len)           //start of new word
	   {
	     c_start=i;
	     c_len=1;
	   }
	 else
	   c_len++;            //cont of word 
       else                    //not a good char
	 {
	   int only_number=1;
	   if (c_len>b_len)
	     {
	       for(int i=c_start;only_number && i<c_start+c_len;i++)
		 if (in[i]!='.' && in[i]!='+' &&
		     in[i]!='-' && in[i]!='e' && in[i]!='E'
		     && (in[i]<'0' || in[i]>'9') )
		   only_number=0;
	       if (!only_number)
		 {
		   b_len=c_len;
		   b_start=c_start;
		 }
	     }
	   c_len=0;
	 }
       i++;
     }
   if (b_len<3)
     {
       if (max_len>0) s[0]=0;
       return 1;
     }
   if (max_len>b_len)
     {
       strncpy(s,in+b_start,b_len);
       s[b_len]=0;
     }
   else
     strncpy(s,in+b_start,max_len);
   start=b_start;
   len=b_len;
   return 0;
}

double** 
matrix(const int m,const int n)
{
  if (m<1) return 0;
  if (n<1) return 0;
  double *pv=new double[(m*n)];
  double **pd=new double*[m];
  if (!pd) {
    cout<<"No room for matrix!";
    exit(1);
  }
  for (int i=0;i<m;i++)
    pd[i]=pv + (i*n);
  return pd;
}

float** 
fmatrix(const int m,const int n)
{
  if (m<1) return 0;
  if (n<1) return 0;
  float *pv=new float[(m*n)];
  float **pd=new float*[m];
  if (!pd) {
    cout<<"No room for matrix!";
    exit(1);
  }
  for (int i=0;i<m;i++)
    pd[i]=pv + (i*n);
  return pd;
}

int** 
imatrix(const int m,const int n)
{
  if (m<1) return 0;
  if (n<1) return 0;
  int *pv=new int[(m*n)];
  int **pd=new int*[m];
  if (!pd) {
    cout<<"No room for matrix!";
    exit(1);
  }
  for (int i=0;i<m;i++)
    pd[i]=pv + (i*n);
  return pd;
}

void 
freematrix(int **pd)
{
  if (!pd) return;
  delete [] *pd;
  delete [] pd;
  return;
}

void 
freematrix(float **pd)
{
  if (!pd) return;
  delete [] *pd;
  delete [] pd;
  return;
}

void 
freematrix(double **pd)
{
  if (!pd) return;
  delete [] *pd;
  delete [] pd;
  return;
}

void strip(char *S)
{
  int i=strlen(S)-1;
  for(;i>=0 && 
	(S[i]=='\t' || S[i]==' ');i--);
  S[i+1]=0;
  return;
}

template<class T> int
cmdnumber(char *mc,T& num,const int len)
  /* returns 1 on success and 0 on failure */
{
  if (len<1) return 0;
  int i,j;
  j=0;

  for(i=0;i<len && mc[i] && 
	(mc[i]=='\t' || mc[i]==' '  || mc[i]==',');i++);
  if(i==len || !mc[i]) return 0;
  char *ss=new char[len+1];
  for(;i<len && mc[i]!='\n' && mc[i] 
       && mc[i]!='\t' && mc[i]!=' ' && mc[i]!=',';i++)
    {
      ss[j]=mc[i];
      j++;
    }
  if (!j)
    { 
      delete [] ss;
      return 0;         //This should be impossible
    }
  ss[j]=0;
  char **endptr=new char*;
  double nmb = strtod(ss,endptr); 
  if (!nmb && *endptr == ss)
    {
      delete endptr;
      delete [] ss;
      return 0;
    }
  num = (T) nmb;
  for(int j=0;j<i && mc[j];j++)
    mc[j]=' ';
  delete endptr;
  delete [] ss;
  return 1;
}

int 
checkname(char* S)
{
  return 1;
}


template<typename T>
int
write_stream(const char* s,const int npts,const T* X,const T* A,
	     const T* B,const int append)
{
  ofstream of;
  if (append)
    {
      if (!s)
	of.open("check.dat",ios::app);
      else
	of.open(s,ios::app);
    }
  else
    {
      if (!s)
	of.open("check.dat");
      else
	of.open(s);
    }

  if (!of)
    {
      cout<<"Error opening gor file"<<endl;  
      return 1;
    }
  
  of.setf(ios::scientific,ios::floatfield);
  of.precision(10);
  of<<" 3 "<< npts <<" "<<" 0.1 0.1 "<<endl;
  of<<"# "<< *s <<endl;
  for(int i=0;i<npts;i++)
    of<<" "<<X[i]<<" "<<A[i]<<" "<<B[i]<<endl;     
  of.close();
  return 0;
}


double 
svdpoly(const double* X,const double* Y,const int Alen,
	const int polyPow,double* Pout)  
{
  Lsvd Lfit;
  Lfit.setData(Alen,X,Y);
  Lfit.setFunc(polyvalues);
  Lfit.setParam(polyPow);
  Lfit.prepArrays();
  Lfit.fit();
  Lfit.copyParam(Pout);
  return Lfit.chi();
}

double 
svdpoly(const double* X,const double* Y,const double* E,const int Alen,
	const int polyPow,double* Pout)  
{
  Lsvd Lfit;
  Lfit.setData(Alen,X,Y,E);
  Lfit.setFunc(polyvalues);
  Lfit.setParam(polyPow);
  Lfit.prepArrays();
  Lfit.fit();
  Lfit.copyParam(Pout);
  return Lfit.chi();
}

template int cmdnumber(char *,double&,const int);
template int cmdnumber(char *,int&,const int);
template int write_stream(const char*,const int,const double*,
			 const double*,const double*,const int);





