#ifndef DataIn_h
#define DataIn_h

class DataIn
{
 private:

  double* Angle;
  double* Yval;
  double* Err;
  int Npts;

  void resize(const int N);
  double polyval(const int,const double*,const double) const;

 public:

  DataIn();
  DataIn(const DataIn&);
  DataIn& operator=(const DataIn&);
  DataIn& operator-=(const DataIn&);
  DataIn operator-(const DataIn&) const;
  DataIn& operator*=(const DataIn&);
  DataIn operator*(const DataIn&) const;
  ~DataIn();

  DataIn& mult(const corpy&,const double*);
  int read(const char* Fn);
  int NPts() const { return Npts; }
  void progressFit(const int,const double,const double);
  int write(const char*,const int =0) const;

};

#endif;

