#ifndef corpy_h
#define corpy_h

class corpy
{
  const int size;
  const double Astep;
  const double Ascale;
  string title;
  int van_pow;    //polynominal power to fit to van
  double Vstart;  //start / end of van angles
  double Vend;    
  double waveL;  //wavelenght
  double MultScat;

  double* VanP;  //Ax,y arrays
  double* SamP;
  double* CanP;
  double* HeatP;
  
  double* VanFit;
  double* SamFit;
  double* CanFit;
  double* HeatFit;

  void fitvalue();

 public:
  
  corpy(const int =8);
  ~corpy();
  int open(const char*);
  double EVan(const double) const;
  double EHeat(const double) const;
  double ECan(const double) const;
  double ESam(const double) const;
  double* PvVan() const { return VanFit; }
  double* PvCan() const { return CanFit; }
  double* PvHeat() const { return HeatFit; }
  double* PvSam() const { return SamFit; }
  double polyval(const double*,const double) const;
  
  double Vpow() const { return van_pow; }
  double VStart() const { return Vstart; }
  double VEnd() const { return Vend; }

  void debug();
};



#endif
