#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <string>
#include <vector>
#include "corpy.h"
#include "fglo.h"

corpy::corpy(const int sze) : 
  size(sze),Astep(20.0),Ascale(140.0),VanP(new double[size]),
  SamP(new double[size]),CanP(new double[size]),
  HeatP(new double[size]),VanFit(new double[size]),
  SamFit(new double[size]),CanFit(new double[size]),
  HeatFit(new double[size])
{}

corpy::~corpy()
{
  delete [] VanP;
  delete [] SamP;
  delete [] CanP;
  delete [] HeatP;

  delete [] VanFit;
  delete [] SamFit;
  delete [] CanFit;
  delete [] HeatFit;

}

int
corpy::open(const char* Fname)
{
  ifstream corIn(Fname);
  char ss[255];
  if (!corIn)
    {
      cerr<<"Can't open cor file "<<*Fname<<endl;
      return -1;
    }
  corIn.ignore(255,'\n');
  corIn.getline(ss,255,'\n');
  strip(ss);
  title=ss;
  corIn>>van_pow>>Vstart>>Vend;
  corIn>>waveL;
  corIn.ignore(255,'\n');
  for(int i=0;i<size;i++)
    corIn>>VanP[i];
  corIn.ignore(255,'\n');
  corIn.ignore(255,'\n');
  for(int i=0;i<size;i++)
    corIn>>SamP[i];
  for(int i=0;i<size;i++)
    corIn>>CanP[i];
  for(int i=0;i<size;i++)
    corIn>>HeatP[i];
  corIn>>MultScat;
  if (!corIn)
    {
      cerr<<"Cor file failed"<<endl;
      corIn.close();
      return -2;
    }
  cout<<"Cor file successfully read"<<endl;      
  corIn.close();
  fitvalue();
  return 0;
}

void
corpy::fitvalue()
{
  double x[size];
  for(int i=0;i<size;i++)
    x[i]=(i*Astep)/Ascale;
  svdpoly(x,VanP,size,size-1,VanFit); 
  svdpoly(x,SamP,size,size-1,SamFit); 
  svdpoly(x,CanP,size,size-1,CanFit); 
  svdpoly(x,HeatP,size,size-1,HeatFit); 
  return;
}

double
corpy::polyval(const double* P,const double x) const
{
  double sum=P[0];
  double xx=x/Ascale;
  for(int i=1;i<size-1;i++)
    {
      sum+=P[i]*xx;
      xx*=x/Ascale;
    }
  return sum;
}

void
corpy::debug()
{
  return;
}


double
corpy::EVan(const double x) const
{
  return polyval(VanFit,x);
}

double
corpy::ECan(const double x) const
{
  return polyval(CanFit,x);
}

double
corpy::EHeat(const double x) const
{
  return polyval(HeatFit,x);
}

double
corpy::ESam(const double x) const
{
  return polyval(SamFit,x);
}
















