#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string>

struct bval_card
{
  char sym[2];                                     //  2
  int at_no,at_wt,iaflag,isflag,ispin;             // 20
  int next_i;                                      //  4
  float bcoh[2],binc[2],scoh[2],sinc[2],sscat[2];  // 40
  float sabs[2],bplus[2],bminus[2];                // 24
  float	eres[5],gamres[5],gamnre[5],abund;         // 64
  char refs[5][80];                                //400
  char misc[5][80];                                //400
  int jspin[5];                                    // 20
  float bimag,biimag,atwght;                       // 12
};                                                // ----
                                               //   986
struct bval_sym
{
  int line;
  char sym[2];
}; 




void getcard(ifstream &,bval_card &);

extern "C" void getval_(char *,int *,float *,float *,
       float *,float *,int *,int *);
void getval(char *,int *,float *,float *,
       float *,float *,int *,int *);

void
getval_(char *sym,int *isotop,float *atwt,float *bcoh,
       float *sscat,float *sabs,int *iaflag,int *ierr)
{
  getval(sym,isotop,atwt,bcoh,sscat,sabs,iaflag,ierr);
}


void 
getval(char *sym,int *isotop,float *atwt,float *bcoh,
       float *sscat,float *sabs,int *iaflag,int *ierr)
{
  char sst[255];
  static bval_sym Bindex[100];
  static int FirstR=0;
  ifstream infile;
  infile.open("bvals2.dat",ios::nocreate|ios::in);
  if (!infile)
    infile.open("/home/ansell/neut/bvals2.dat",ios::nocreate|ios::in);
  bval_card card;
  if (!infile) 
    {
      *ierr=3;
      return;
    }
  if (!FirstR)
    {
      infile.seekg(4000,ios::beg);
      for(int i=0;i<100;i++)
	{
	  infile.read(sst,6);
	  Bindex[i].line = *(int*) (sst);
	  Bindex[i].sym[0] = sst[4];
	  Bindex[i].sym[1] = sst[5];
	}
      FirstR=1;
    }
  if (sym[0]>='a' && sym[0]<='z')
    sym[0]-='a'-'A';
  if (sym[1]>='a' && sym[1]<='z')
    sym[1]-='a'-'A';
  if(sym[1]==' ')
    {
      sym[1]=sym[0];
      sym[0]=' ';
    }
  int i;
  for(i=0;i<100 && (sym[0]!=Bindex[i].sym[0]
              || sym[1]!=Bindex[i].sym[1]);i++);
  if (i==100)
    {
      *ierr=1;
      return;
    }
  int indx=4000*(Bindex[i].line-1);
  infile.seekg(indx,ios::beg);
  getcard(infile,card);
  while(card.at_wt!= *isotop)
    {
      if (!card.next_i)
	{
	  *ierr=2;
	  return;
	}
      //      cout<<"NEXT INDEX AT "<<card.next_i<<endl;
      indx=4000*(card.next_i-1);
      infile.seekg(indx,ios::beg);
      getcard(infile,card);
    }
  *atwt=card.atwght;
  *bcoh=card.bcoh[0];
  *sscat=card.sscat[0];
  *sabs=card.sabs[0];
  *iaflag=card.iaflag;
  infile.close();
  
  *ierr=0;       // successful completionq
  return;
}

void
getcard(ifstream &infile,bval_card &card)
{
  char space[986];
      
  infile.read(space,986);
  int ct=2;
  card.sym[0]=space[0];
  card.sym[1]=space[1];
  card.at_no= *(int*) (space+ct); ct+=4;
  card.at_wt= *(int*) (space+ct); ct+=4;
  card.iaflag= *(int*) (space+ct);ct+=4;
  card.isflag= *(int*) (space+ct); ct+=4;
  card.ispin= *(int*) (space+ct); ct+=4;
  card.next_i= *(int*) (space+ct); ct+=4;
  card.bcoh[0]= *(float*) (space+ct); ct+=4;
  card.bcoh[1]= *(float*) (space+ct); ct+=4;
  card.binc[0]= *(float*) (space+ct); ct+=4;
  card.binc[1]= *(float*) (space+ct); ct+=4;
  card.scoh[0]= *(float*) (space+ct); ct+=4;
  card.scoh[1]= *(float*) (space+ct); ct+=4;
  card.sinc[0]= *(float*) (space+ct); ct+=4;
  card.sinc[1]= *(float*) (space+ct); ct+=4;
  card.sscat[0]= *(float*) (space+ct); ct+=4;
  card.sscat[1]= *(float*) (space+ct); ct+=4;
  card.sabs[0]= *(float*) (space+ct); ct+=4;
  card.sabs[1]= *(float*) (space+ct); ct+=4;
  card.bplus[0]= *(float*) (space+ct); ct+=4;
  card.bplus[1]= *(float*) (space+ct); ct+=4;
  card.bminus[0]= *(float*) (space+ct); ct+=4;
  card.bminus[1]= *(float*) (space+ct); ct+=4;
  for(int i=0;i<5;i++)
    {
      card.eres[i]=*(float*) (space+ct);
      ct+=4;
    }
  for(int i=0;i<5;i++)
    {
      card.gamres[i]=*(float*) (space+ct);
      ct+=4;
    }
  for(int i=0;i<5;i++)
    {
      card.gamnre[i]=*(float*) (space+ct);
      ct+=4;
    }
  card.abund= *(float*) (space+ct); ct+=4;
  for(int i=0;i<5;i++)
    {
      strncpy(card.refs[i],(space+ct),80); 
      ct+=80;
    }
  for(int i=0;i<5;i++)
    {
      strncpy(card.misc[i],space+ct,80); 
      ct+=80;
    }
  for(int i=0;i<5;i++)
    {
      card.jspin[i]=*(int*) (space+ct);
      ct+=4;
    }
  card.bimag= *(float*) (space+ct); ct+=4;
  card.biimag= *(float*) (space+ct); ct+=4;
  card.atwght= *(float*) (space+ct); ct+=4;

  return;
}




