	Program Matrix

	Implicit none
	
	double precision mat(8,7),iex(7,7)
	character dec*2,dec1*1
	character*10 top(8),line(7)
	common /ttt/top,line
	common mat,iex

	call input
10	WRITE(6,*)'What would you like to do?'
	READ(5,'(a2)')dec
	dec1=dec(1:1)
	if (dec1.eq.'a') call add
	if (dec1.eq.'s') call sub
	if (dec.eq.'ul') call load
	if (dec.eq.'ud') call save
	if (dec1.eq.'c') call change(dec)
	if (dec1.eq.'h') call help
	if (dec1.eq.'m') call mult(dec)
	if (dec1.eq.'d') call divide(dec)
	if (dec.eq.'e') call ddisplay
	if (dec1.eq.'l') call display
	if (dec1.eq.'q') stop
	if (dec1.eq.'x') call expand(dec)
	goto 10
	end
c	**************************************************************
	subroutine help
c	*************************************************************

	WRITE(6,*)'a :-- add (r:-row)'
	WRITE(6,*)'d :-- divide (r:-row)'
	WRITE(6,*)'e :-- eigenmatrix'
	WRITE(6,*)'c :-- swap two rows (c:-colums)'
	WRITE(6,*)'l :-- display matrix'
	WRITE(6,*)'m :-- mult (r:-row)'
	WRITE(6,*)'q :-- quit'
	WRITE(6,*)'s :-- subtract (r:-row)'
	WRITE(6,*)'ul :- upload data'
	WRITE(6,*)'ud :- download data'
	WRITE(6,*)'x :-- expand (e:-row)'
	
	RETURN
	END
c	*********************************************
	subroutine change(dec)
c	*********************************************

	double precision mat(8,7),iex(7,7),mt
	integer i,j,row
	character dec*2
	character*10 top(8),line(7),temp
	common /ttt/top,line
	common mat,iex	
	
	IF (dec(2:2).ne.'c') THEN
	  write(6,*)'What two rows to swap'
	  READ(5,*,ERR=976)row1,row2
	  IF ((row2.gt.7).or.(row2.lt.1)) return
	  IF ((row1.gt.7).or.(row1.lt.1)) return
	  do i=1,8
             mt=mat(i,row1)
             mat(i,row1)=mat(i,row2)
	     mat(i,row2)=mt
	  enddo
	  do i=1,7
	    mt=iex(i,row1)
	    iex(i,row1)=iex(i,row2)
	    iex(i,row2)=mt
	  enddo
	  do i=1,7
	    mt=iex(row1,i)
	    iex(row1,i)=iex(row2,i)
	    iex(row2,i)=mt
	  enddo
	  temp=line(row1)
          line(row1)=line(row2)
	  line(row2)=temp
	ELSE
	  write(6,*)'What two colums to swap'
	  READ(5,*,ERR=976)row1,row2
	  IF ((row2.gt.8).or.(row2.lt.1)) return
	  IF ((row1.gt.8).or.(row1.lt.1)) return
	  
	  do i=1,7
	     mt=mat(row2,i)
	     mat(row2,i)=mat(row1,i)
	     mat(row1,i)=mt
	  enddo
	  temp=top(row1)
	  top(row1)=top(row2)
	  top(row2)=temp
	ENDIF
	call display


976	return
	end

c	*********************************************
	subroutine expand(dec)
c	*********************************************

	double precision mat(8,7),iex(7,7),add
	integer i,j,row
	character dec*2
	character*10 top(8),line(7)
	common /ttt/top,line
	common mat,iex	

3000	FORMAT(1x,G15.8,3x,'|',3x,a10)
3001    FORMAT(1x,G15.8,3x,'|',3x,a10)
3002	FORMAT(1x,' The sum of the prefactors is ',G15.8)
	add=0.0
987	WRITE(6,*)'Which row to expand'
	READ(5,*,ERR=987)row
	IF ((row.gt.7).or.(row.lt.1)) goto 987
	IF (dec.ne.'xe') THEN
	WRITE(6,'(3x,a10)')line(row)
	  DO j=1,8
	    add=add+mat(j,row)
	    WRITE(6,3000)mat(j,row),top(j)
	  ENDDO
	WRITE(6,3002)add
	ELSE
	DO i=1,7
	    WRITE(6,3001)iex(i,row),line(i)
	ENDDO
	ENDIF
	RETURN
	END

c	*********************************************
	subroutine save
c	*********************************************

	double precision mat(8,7),iex(7,7)
	integer i,j
	character infile*15
	common mat,iex	

3000	FORMAT(1x,G15.8)
3001    FORMAT(1x,G15.8)

	WRITE(6,*)'What is the file name to save'
	READ(5,'(a15)')infile
	OPEN(15,FILE=infile,STATUS='NEW')
	DO i=1,7
	  DO j=1,8	
	    WRITE(15,3000)mat(j,i)
	  ENDDO
	ENDDO
	DO i=1,7
	  DO j=1,7
	    WRITE(15,3001)iex(i,j)
	  ENDDO
	ENDDO
	CLOSE(15)
	RETURN
	END

c 	**********************************************
	subroutine load
c	**********************************************

	double precision mat(8,7),iex(7,7)
	integer i,j
	character infile*15
	character*10 top(8),line(7)
	common /ttt/top,line
	common mat,iex

	WRITE(6,*)'What is the input file'
	READ(5,'(a15)')infile
	OPEN(14,FILE=infile,ERR=96,STATUS='OLD')
	DO i=1,7
	 DO j=1,8
	   READ(14,*)mat(j,i)
	 ENDDO
	ENDDO
	DO i=1,7
	  DO j=1,7
	   READ(14,*)iex(i,j)
	  ENDDO
	ENDDO
	do i=1,8
	  READ(14,'(A10)',err=95,end=95)top(i)
	enddo
	do i=1,7
	  READ(14,'(a10)',err=95,end=95)line(i)
	enddo
95	CLOSE(14)
	call display
	RETURN

96	WRITE(6,*)'File error'
	RETURN
	END

c	***********************************************
	subroutine divide(dec)
c	***********************************************
c	enter mr to get row divided by an internal element
c
	double precision mat(8,7),iex(7,7)
	character dec*2
	integer i,j,k
	double precision fact
	common mat,iex

	WRITE(6,*)'What row to divide'
	READ(5,*,ERR=98)k
	if ((k.gt.7).or.(k.lt.1)) return
	if (dec(2:2).ne.'r') then
	  WRITE(6,*)'What factor to divide by' 	
	  READ(5,*,ERR=98)fact
	ELSE
97	  WRITE(6,*)'Which coloum,row to use as the factor'
	  READ(5,*,err=97)i,j
	  IF ((MIN(i,j).le.0).or.(i.gt.8).or.(j.gt.7)) return
	  fact=mat(i,j)
	ENDIF
	if (ABS(fact).le.1E-10) return
	do i=1,8
	  mat(i,k)=mat(i,k)/fact
	enddo
	do i=1,7
	  iex(i,k)=iex(i,k)/fact
	enddo
	call display

98	RETURN
	END

c	***********************************************
	subroutine mult(dec)
c	***********************************************
c	enter mr to get row multiplyed by an internal element
c
	double precision mat(8,7),iex(7,7)
	character dec*2
	integer i,j,k
	double precision fact
	common mat,iex

	WRITE(6,*)'What row to mult'
	READ(5,*,ERR=98)k
	if ((k.gt.7).or.(k.lt.1)) return
	if (dec(2:2).ne.'r') then
	  WRITE(6,*)'What factor to multiply by' 	
	  READ(5,*,ERR=98)fact
	ELSE
97	  WRITE(6,*)'Which coloum,row to use as the factor'
	  READ(5,*,err=97)i,j
	  IF ((MIN(i,j).le.0).or.(i.gt.8).or.(j.gt.7)) return
	  fact=mat(i,j)
	ENDIF
	do i=1,8
	  mat(i,k)=mat(i,k)*fact
	enddo
	do i=1,7
	  iex(i,k)=iex(i,k)*fact
	enddo
	call display

98	RETURN
	END

c	************************************************
	subroutine sub
c	************************************************

	double precision mat(8,7),iex(7,7)
	integer i,j,k

	common mat,iex

11	WRITE(6,*)'Enter row - row (out of range to return)'
	READ(5,*,err=11)i,j
	if ((MAX(i,j).gt.7).or.(MIN(i,j).lt.1)) return
	
	do k=1,8
	  mat(k,i)=mat(k,i)-mat(k,j)
	enddo
	do k=1,7
	  iex(k,i)=iex(k,i)-iex(k,j)
	enddo
	call display
	return
	end

c	************************************************
	subroutine add
c	************************************************

	double precision mat(8,7),iex(7,7)
	integer i,j,k

	common mat,iex

11	WRITE(6,*)'Enter row + row (out of range to return)'
	READ(5,*,err=11)i,j
	if ((MAX(i,j).gt.7).or.(MIN(i,j).lt.1)) return
	
	do k=1,8
	  mat(k,i)=mat(k,i)+mat(k,j)
	enddo
	do k=1,7
	  iex(k,i)=iex(k,i)+iex(k,j)
	enddo
	call display
	return
	end

		



c	*************************************************
	subroutine input
c	*************************************************

	integer i,j
	double precision mat(8,7),iex(7,7)
	character ans*1
	common mat,iex

1000	FORMAT(1x,'enter the bval for row ',I2,' and position ',I2)
	WRITE(6,*)'Do you have a saved file?'
	READ(5,'(a1)')ans
	IF (ans.ne.'y') THEN

	DO i=1,7
	  DO j=1,8
		WRITE(6,1000)i,j
	        READ(5,*)mat(j,i)
	  ENDDO
	ENDDO
	DO i=1,7
	  iex(i,i)=1.0
	ENDDO
	call display
	ELSE
	  call load
	ENDIF
	 
	RETURN
	END

c	*************************************************
	subroutine display
c	*************************************************

	implicit none
	
	integer i,j
	double precision mat(8,7),iex(7,7)
	character dec*2
	character*10 top(8),line(7)
	common /ttt/top,line
	common mat,iex

2000	FORMAT(1x,8(F9.3,1x))
2001	FORMAT(1x,8(A8,2x))
2002	FORMAT(1x,8('---------',1x))

	  WRITE(6,*)'The Matrix '
	  WRITE(6,*)' '
	  WRITE(6,2001)(top(i),i=1,8)
	  WRITE(6,2002)
	  DO i=1,7
	     WRITE(6,2000)(mat(j,i),j=1,8)
	  ENDDO
	RETURN
	  END	  
c      *************************************************
	subroutine ddisplay
c      **************************************************
	implicit none
	
	integer i,j
	double precision mat(8,7),iex(7,7)
	character dec*2
	character*10 top(8),line(7)
	common /ttt/top,line
	common mat,iex

2000	FORMAT(1x,7(A9,2x))
2001	FORMAT(1x,7(F9.4,2x))
2002	FORMAT(1x,7('---------',2x))
	  WRITE(6,*)'The experimental matrix'  
	  WRITE(6,*)' '
	  write(6,2000)(line(i),i=1,7)
	  write(6,2002)
	  do i=1,7
	     write(6,2001)(iex(j,i),j=1,7)
	  enddo
	  RETURN
	  END
	
