C*****************************************
      SUBROUTINE INTERP(DATA,NDATA,QSTEP)
C*****************************************
C
C**** DATA CONDENSED INTO EVENLY SPACED BINS
C
      DIMENSION STORE(3,2000)
      DIMENSION DATA(3,NDATA),MULT(10),MINUS(10)
      REAL*8 SUM1,SUMX,SUMY,SUMXX,SUMXY
      REAL*8 WEIGHT,VDEN,GRAD,CONS,QMID
      DATA MINUS/ 0,1,2,3,4,5,6,7,8,9 /
      DATA NST/ 6 /
C
      DO 801 K=1,10
        MULT(K)=0
  801 CONTINUE
        NER=0
        QHALF=QSTEP*0.5
        QEND=AINT((DATA(1,1)-QHALF)/QSTEP)*QSTEP+QHALF
        IF(DATA(1,1)-QHALF.LT.0.0)QEND=QEND-QSTEP
        KOLD=0
        KNEW=0
C
C**** CONSIDER NEXT NEW BIN
C
  811 CONTINUE
        QEND=QEND+QSTEP
        KBIN=0
        SUM1 =0.0
        SUMX =0.0
        SUMY =0.0
        SUMXX=0.0
        SUMXY=0.0
C
C**** CONSIDER NEXT OLD BIN
C
  815 CONTINUE
      IF(DATA(1,KOLD+1).GT.QEND)GO TO 821
        KOLD=KOLD+1
      IF(DATA(3,KOLD).LE.0.0)GO TO 815
        KBIN=KBIN+1
        WEIGHT=1./DATA(3,KOLD)**2
        SUM1 =SUM1 +WEIGHT
        SUMX =SUMX +WEIGHT*DATA(1,KOLD)
        SUMY =SUMY +WEIGHT*DATA(2,KOLD)
        SUMXX=SUMXX+WEIGHT*DATA(1,KOLD)**2
        SUMXY=SUMXY+WEIGHT*DATA(1,KOLD)*DATA(2,KOLD)
      IF(KOLD.LT.NDATA)GO TO 815
C
C**** CALCULATE MEASUREMENT IN NEW BIN
C
  821 CONTINUE
        KNEW=KNEW+1
        KPLUS=MIN0(KBIN+1,10)
        MULT(KPLUS)=MULT(KPLUS)+1
        QMID=QEND-QHALF
      IF(KBIN.LE.1)GO TO 823
        VDEN=1./(SUM1*SUMXX-SUMX**2)
        GRAD=(SUM1*SUMXY-SUMX*SUMY)*VDEN
        CONS=(SUMY*SUMXX-SUMX*SUMXY)*VDEN
        STORE(1,KNEW)=QMID
        STORE(2,KNEW)=QMID*GRAD+CONS
        STORE(3,KNEW)=DSQRT(1.D0/SUM1+SUM1*VDEN*(QMID-SUMX/SUM1)**2)
      GO TO 829
  823 CONTINUE
      IF(KBIN.LE.0)GO TO 826
        STORE(1,KNEW)=QMID
        STORE(2,KNEW)=DATA(2,KOLD)
        STORE(3,KNEW)=DATA(3,KOLD)
      GO TO 829
  826 CONTINUE
        NER=NER+1
        IF(NER.LE.10)WRITE(NST,2826)QMID
        STORE(1,KNEW)=QMID
        STORE(2,KNEW)=0.0
        STORE(3,KNEW)=0.0
  829 CONTINUE
      IF(KOLD.LT.NDATA)GO TO 811
C
      DO 831 K=1,KNEW
        DATA(1,K)=STORE(1,K)
        DATA(2,K)=STORE(2,K)
        DATA(3,K)=STORE(3,K)
  831 CONTINUE
        IF(KNEW.GT.KOLD)WRITE(NST,2829)
C
C**** OUTPUT RECORDS
C
        NDATA=KNEW
        WRITE(NST,2831)KOLD,KNEW
        WRITE(NST,2833)(MINUS(J),MULT(J),J=1,10)
      RETURN
C------------
 2826 FORMAT(/' *** INTERP WARNING - QSTEP TOO SMALL ***'/
     &   ' NO STORE FOR BIN AT',F7.3)
 2829 FORMAT(/' *** INTERP WARNING - DATA ARRAY LENGTH HAS',
     &    ' BEEN EXTENDED')
 2831 FORMAT(/1X,I4,' POINTS CONDENSED INTO',I4,' BINS')
 2833 FORMAT(' MAPPING MULTIPLICITY FREQUENCIES =',
     &   (T37,5(I1,'/',I3,3X)))
      END
