C****************************************************************
C								*
C	CORRECTIONS PROGRAMME FOR VANADIUM & SAMPLES		*
C	INCLUDES CORRECTIONS FOR ATTENUATION, MULTIPLE 		*
C	SCATTERING & PLACZEK EFFECTS				*
C	N.B. CORPY2 IS IDENTICAL TO CORPY EXCEPT THAT PLAZCEK	*
C	CORRECTIONS ARE NOT DONE ON THE SAMPLE			*
C								*
C	INPUT AND OUTPUT STREAMS ARE DEFINED AS			*
C								*
C	5	TERMINAL INPUT					*
C	6	TERMINAL OUTPUT					*
C	10	PRINTER OUTPUT					*
C	11	DATA OUTPUT					*
C								*
C	BASED ON PROGRAMMES DEVELOPED AT BRISTOL UNIV. BY M.GAY *
C	USES ATCOR ROUTINE (PONCET) FOR SELF ABSORPTION 	*
C	CORRECTIONS						*
C								*
C	MODIFIED FOR USE ON ILL VAX8600 USING FORTRAN-77	*
C								*
C	BY A.C.B. 						*
C								*
C	NO EXTERNAL SUBROUTINES CALLED				*
C	INTERNAL SUBROUTINES:					*
C		ACYLV - VANADIUM ABSORPTION FACTORS		*
C		SCAT  -	MULTIPLE SCATTERING CORRECTIONS		*
C		PLACZ - PLACZEK CORRECTIONS			*
C		ATCOR - SAMPLE,CONTAINER & FURNACE ABSORPTION	*
C								*
C	CREATED       :7-FEB-86					*
C	LAST MODIFIED :7-FEB-86					*
C								*
C	COMPILE AND LINK:					*
C	FOR CORPY2						*
C	LINK CORPY2						*
C								*
C****************************************************************
C
	DIMENSION AFACV(8),PLACOR(8),PVAN(8),Q1(8),Q2(8),Q3(8)
	DIMENSION TITLE(10),DATE(6)
	CHARACTER*80 CORFIL,PRFILE
	CHARACTER*80 Tle
        character*1 ans,YES
C
C	VANADIUM ROOM TEMPERATURE CONSTANTS
C
	DATA ATWTV,SIGSV,SIGAV,TEMPV,RHOV/50.94,4.99,4.98,21.,5.96/
C
C	DETECTOR CONSTANT FOR PLACZEK CORRECTIONS
C
	DATA C1,C2,C3/0.548,0.0136,0.271/	!Saclay at 0.7A
	DATA PI /3.14159265/
	DATA YES/'Y'/
10	FORMAT(A80)
20	FORMAT(' INPUT THE NAME OF THE PARAMETER FILE')
30	FORMAT(' INPUT NAME OF THE CORRECTIONS FILE')

1010	FORMAT(' INPUT WAVEL,BEAMH,BEAMW')
1020	FORMAT(' DO YOU WISH TO SKIP THE VANADIUM CALCULATIONS ?')
1030	FORMAT(A1)
1040	FORMAT(' INPUT VRODH,VRODR')
1050	FORMAT(' INPUT RAD1,RAD2,RAD3,RAD4,CMU,HMU,TEMPS')
1060	FORMAT(' INPUT SAMPLE TITLE (20 CHARACTERS MAXIMUM)')
1070	FORMAT(' INPUT ATWTS,RHOS,SIGSS,SIGAS')
1080	FORMAT(' IS THERE ANOTHER SAMPLE ?')
2000	FORMAT(' PROGRAMME CORPY VERSION 4  (2-FEB-86)')
2050	FORMAT(10A4)
2060  	FORMAT(5X,' NEUTRON BEAM HEIGHT',' ... ',F7.2,' CM.'//
     1		5X,' NEUTRON BEAM WIDTH ... ',F7.2,' CM.'//
     2		5X,' NEUTRON WAVELENGTH ... ',F7.2,' ANGSTROMS')
2070	FORMAT(//' VANADIUM PARAMETERS'//
     1		5X,'TEMPERATURE',3X,' ... ',F7.1,' DEGREES C'//
     2		5X,'RADIUS    ',' ... ',F7.3,' CM.'
     3		//5X,'HEIGHT OF VAN. ROD ',' ... ',F7.2,' CM.')
2090	FORMAT(//' SAMPLE PARAMETERS     ',10A4//
     1		5X,'RADII SAMPLE/CONTAINER/HEATER INNER & OUTER/ =',
     2		4F7.3//,5X,'ATTENUATION COEFFS. CONTAINER/HEATER/ =',
     3		2F7.3,5X,'TEMPERATURE',4X,' ... ',F7.1,'DEGREES C')
2105	FORMAT(/5X,'ATOMIC WEIGHT',1X,' ... ',F7.2//5X,'DENSITY',2X,
     1	    ' ... ',F7.3,' GM/CM.**3'//
     2	    5X,'SCATTERING C/S',' ... ',F7.2,'BARNS'//5X,'ABSORPTION',
     3	    ' C/S',' ... ',F7.2,' BARNS')
2110	FORMAT(8X,I3,1X,5(4X,F6.3))
2120	FORMAT(//'PVAN =',2X,8F8.4)
2130	FORMAT(//'  Q1 (ABSORPTION)',8F8.3//' Q2 (CONTAINER) ',8F8.3//
     1		'Q3 (HEATER)      ',8F8.3//' Q4 (MULTIPLE)  ',F8.3)
2140	FORMAT(//' MACHINE PARAMETERS',11X,'CYLINDRICAL GEOMETRY'/)
2150	FORMAT(//5X,'2*THETA'/7X,'DEGREES  PLACZ.COR   1+MS   A(V,V)'/)
2160	FORMAT(//5X,'ANGLE',T15,' PLACZ',T22,'A(S,SCH)',T31,'A(C,CH)',
     1	      T39,'A(C,SCH)',T48,'A(H,H)',T55,'A(H,CH)',T63,'A(H,SCH)')
2165	FORMAT(5X,F4.0,5X,7(F6.3,2X))
2168	FORMAT(/5X,'1+MS =',F6.3)
2180	FORMAT(8(1X,F8.5))
2190	FORMAT(/5X,'ATTENUATION COEFF.  ',' ... ',F7.3)
3000    FORMAT(1X,'1'/1X,A78)
3001	FORMAT(1X,I1,1X,F4.1,1X,F5.1)
3002	FORMAT(1X,F5.3,2X,F4.2,2X,I1)
3003	FORMAT(1X,I1,1X,I1)
3004	FORMAT(1X,2(I1,1X,I2,1X))
3005	FORMAT(1X,A79)
3006	FORMAT(A80)
C
C		SET UP INPUT AND OUTPUT FILES
C
	WRITE(6,20)
	READ(5,10)PRFILE
	WRITE(6,30)
	READ(5,10)CORFIL
	OPEN(11,FILE=CORFIL)
	OPEN(10,FILE=PRFILE)
C
C		VANADIUM CORRECTIONS
C
	WRITE(6,2000)
	WRITE(10,2000)
	PIBY18=PI/18.
	WRITE(6,1010)
	READ(5,*)WAVEL,BEAMH,BEAMW
	WRITE(10,2140)
	WRITE(10,2060)BEAMH,BEAMW,WAVEL
	WRITE(6,1040)
	READ(5,*)VRODH,VRODR
	WRITE(6,1060)
        READ(5,3006)Tle
	SIGTV=SIGSV+SIGAV*WAVEL/1.798
	WRITE(10,2070)TEMPV,VRODR,VRODH
	WRITE(10,2105)ATWTV,RHOV,SIGSV,SIGAV
	RSIGV=SIGSV/SIGTV
	VMU=0.60233*RHOV*SIGTV/ATWTV
	WRITE(10,2190)VMU
	WRITE(6,1020)
	WRITE(11,3000)Tle
	WRITE(11,3001)1,30.0,125.0
	WRITE(11,3002)wavel,0.04,0
	READ(5,1030)ANS
	IF (ANS.NE.YES)THEN
C
C		VANADIUM CALCULATIONS
C
	   CALL ACYLV(AFACV,VRODR,VMU)
	   CALL SCAT(VRODR,VRODH,SFACV,VMU,RSIGV)
	   CALL PLACZ(ATWTV,WAVEL,PLACOR,TEMPV,C1,C2,C3)
	   WRITE(10,2150)
	   do I=1,8
	      PVAN(I)=1.0/(SFACV*AFACV(I)*PLACOR(I))
	      J=20*(I-1)
	      WRITE(10,2110)J,PLACOR(I),SFACV,AFACV(I)
	   END DO
C
	   WRITE(10,2120)PVAN
	   WRITE(11,2180)PVAN
	   WRITE(11,3004)0,0
	END IF
C
C
	ANS=YES
	DO WHILE(ANS.EQ.YES)
C
C		SAMPLE CORRECTIONS
C		REPEAT THIS BLOCK FOR EACH SAMPLE
C:START
C
117	CONTINUE
C	RESTART IF ERROR DETECTED IN SUBROUTINE ATCOR
C
	WRITE(6,1060)
	READ(5,2050)TITLE
	WRITE(6,1050)
	READ(5,*)RAD1,RAD2,RAD3,RAD4,CMU,HMU,TEMPS
	WRITE(10,2090)TITLE,RAD1,RAD2,RAD3,RAD4,CMU,HMU,TEMPS
	WRITE(6,1070)
	READ(5,*)ATWTS,RHOS,SIGSS,SIGAS
	WRITE(10,2105)ATWTS,RHOS,SIGSS,SIGAS
	SIGTS=SIGSS+SIGAS*WAVEL/1.798
	RSIGS=SIGSS/SIGTS
	CONST=RHOV*ATWTS*SIGSV*(VRODR/RAD1)**2*VRODH/(BEAMH*ATWTV*RHOS)
	SMU=0.60233*RHOS*SIGTS/ATWTS
	WRITE(10,2190)SMU
C
C	PLACZEK CORRECTIONS
C
	CALL PLACZ(ATWTS,WAVEL,PLACOR,TEMPS,C1,C2,C3)
	WRITE(10,2160)
	WRITE(6,2160)
	CONPI=PI/180.
	DO K=1,8
	   ANGLE=(K-1)*20.0
	   THETA=ANGLE*CONPI
	   CALL ATCOR(THETA,RAD1,RAD2,RAD3,RAD4,BEAMW,SMU,CMU,HMU,
     1                ASSCH,ACCH,ACSCH,AHSCH,AHCH,AHH,*117)
	   WRITE(10,2165)ANGLE,PLACOR(K),ASSCH,ACCH,ACSCH,AHH,AHCH,AHSCH
	   WRITE(6,2165)ANGLE,PLACOR(K),ASSCH,ACCH,ACSCH,AHH,AHCH,AHSCH
	   Q1(K)=CONST/(ASSCH*PLACOR(K))
	   Q2(K)=ACSCH/ACCH
	   Q3(K)=0.0
	   IF(HMU.GT.0.0)Q3(K)=(AHSCH-ACSCH*AHCH/ACCH)/AHH
	END DO
C
	CALL SCAT(RAD1,BEAMH,SFACS,SMU,RSIGS)
	Q4=SIGSS*(SFACS-1)
	WRITE(10,2168)SFACS
	WRITE(11,2180)Q1,Q2,Q3,Q4
	WRITE(10,2130)Q1,Q2,Q3,Q4
	WRITE(11,3003)0,0
	WRITE(11,3004)0,16,0,10
	WRITE(11,3003)1,0
	WRITE(11,3005)Tle
C
	WRITE(6,1080)
	READ(5,1030)ANS
C
C		IF ANOTHER SAMPLE REPEAT SAMPLE CALCULATIONS
C
	END DO
C:ENDSTART
	CLOSE(10)
	CLOSE(11)
	STOP
	END
C
C-----------------------------------------------------------------
C		SCAT
C-----------------------------------------------------------------
C
	SUBROUTINE SCAT(RAD,HEIGHT,SFAC,TMU,RSIG)
C
C	MULTIPLE SCATTERING CORRECTIONS
C
C	SFAC = 1 + MULTIPLE SCATTERING FACTOR=D/(D-1) ,D IS  DELTA
C
	DIMENSION SUMH1(256)
	DATA PI/ 3.14159265/
C
	X=HEIGHT/RAD
	NZ=INT(16*SQRT(X*SQRT(X))+0.5)
	IF(NZ.GT.256)NZ=256
	NRINC=INT(FLOAT(NZ)/X+0.5)
120	CONTINUE
C
	IF(NRINC.LT.4)THEN
	   WRITE(6,2999)
	   WRITE(10,2999)
2999	   FORMAT(' !#@** ERROR IN SCAT - STOPPING')
	   STOP
	END IF
	NZ=INT(FLOAT(NRINC)*X+0.5)
	IF(NZ.LE.256)GOTO 150
	NRINC=NRINC-1
	GOTO 120
C
150	AREA=0.5*PI*RAD**2
	HZ=HEIGHT/FLOAT(NZ)
	HZ2=HZ*HZ
	RINC=RAD/FLOAT(NRINC)
	PINC=PI/RINC
	DO I=1,NZ
	   SUMH1(I)=0.
	END DO
	DO IZ2=1,NZ
	   FIZ=FLOAT(IZ2-1)
	   H1Z=FIZ*FIZ*HZ2
	   DO IRAD1=1,NRINC
	      RAD1=(FLOAT(IRAD1)-0.5)*RINC
	      RAD11=RAD1*RAD1
	      DO IRAD2=1,NRINC
	 	 RAD2=(FLOAT(IRAD2)-0.5)*RINC
		 RAD22=RAD2*RAD2
		 RR=RAD1*RAD2
		 NAINC=INT(PINC*RAD2+0.5)
		 AINC=PI/FLOAT(NAINC)
	  	 RAD12=2.*RR
	 	 X=RR*AINC
		 SUMH=0.
		 DO IT2=1,NAINC
		    DSQ=H1Z+RAD11+RAD22-RAD12*COS((FLOAT(IT2)-.5)*AINC)
		    D=SQRT(DSQ)
		    SUMH=EXP(-TMU*D)/DSQ+SUMH
	  	 END DO
	         SUMH1(IZ2)=X*SUMH+SUMH1(IZ2)
	      END DO
	   END DO
	END DO
	SUMH=0.
	DO IZ1=2,NZ
           X=FLOAT(2*(NZ-IZ1+1))
	   SUMH=X*SUMH1(IZ1)+SUMH
	END DO	   
	X=RSIG*HZ*RINC**2/(2.*AREA*FLOAT(NZ))
	SFAC=1./(1.-TMU*X*(FLOAT(NZ)*SUMH1(1)+SUMH))
	RETURN
	END
C
C----------------------------------------------------------------
C		ACYLV
C----------------------------------------------------------------
C
C	ABSORPTION FOR VANADIUM
C
	SUBROUTINE ACYLV(AFACV,VRODR,VMU)
C
	DIMENSION AFACV(8)
	DATA PI /3.14159265/
C
	AREA=0.5*PI*VRODR**2
	RINC=VRODR/16.
	PINC=PI/RINC
	REA=RINC/AREA
	DV2=VRODR*VRODR
	DO I=1,8
	   ANGLE=0.5*PI*(1.-FLOAT(I-1)/9.)
	   HOLD1=0.
	   DO ISTEP1=1,16
	      ATTEN=0.
	      VRAD=(FLOAT(ISTEP1)-0.5)*RINC
	      VRAD2=VRAD*VRAD
	      NAINC=INT(PINC*VRAD+0.5)
	      AINC=PI/FLOAT(NAINC)
	      DO ISTEP2=1,NAINC
		 TAU=0.
		 DO J=1,3,2
		    VANGLE=(FLOAT(ISTEP2)-0.5)*AINC+FLOAT(J-2)*ANGLE
		    HOLD2=VRAD*COS(VANGLE)
		    DISTSQ=DV2+HOLD2*HOLD2-VRAD2
		    IF(DISTSQ.LE.0.0)THEN
		       DIST=0.
	 	    ELSE 
		       DIST=SQRT(DISTSQ)
		    END IF
		    TAU=VMU*(HOLD2+DIST)+TAU
		 END DO
	         ATTEN=EXP(-TAU)+ATTEN
	      END DO
	      HOLD1=AINC*VRAD*ATTEN+HOLD1
	   END DO
	   AFACV(I)=HOLD1*REA
	END DO
C
	RETURN
	END
C
C----------------------------------------------------------------
C		PLACZ
C----------------------------------------------------------------
C
	SUBROUTINE PLACZ(ATWT,WAVEL,PLAC,TEMP,C1,C2,C3)
C
C	PLACEK CORRECTIONS
C 
	DIMENSION PLAC(8)
	DATA PI/3.14159265/
	PIBY18=PI/18.
	CON=3*3.5115E-4*WAVEL**2*(TEMP+273.15)
	DO I=1,8
	   E=(1-COS(2*PIBY18*(I-1)))*2./ATWT
	   PLAC(I)=1.+(CON+E)/(2.*ATWT)+(C2*E-C1-C3*CON)*E
	END DO
C
	RETURN
	END
C	
C-----------------------------------------------------------------
C		ATCOR 
C-----------------------------------------------------------------
C
      SUBROUTINE ATCOR(THETA,R1,R2,R3,R4,SW,SMU,CMU,HMU,ASSCH,ACCH,ACSCH
     1,AHSCH,AHCH,AHH,*)                                         
C     ***************************************************************           
C THE LAST MODIFICATION TO THIS SUBROUTINE HAS BEEN MADE ON THE :       JUL 75 .
C                                                                               
C     THETA EST L'ANGLE DE DIFFUSION. it must be in radians            
C     SW = SLIT WIDTH .                                                         
C     Operating conditions that have to be satisfied :                       
C     1.      R2 < SW/2 < R3                                                    
C     2.      SQRT(R4**2-R3**2)  <OR= R1                                        
C     3.      SQRT(R3**2-D**2)  >OR= R2                                         
C                                                                               
      EXTERNAL F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,F11,F12,                          
     1 F13,F14,F15,F16,F17                                                      
      EXTERNAL G1,G2,G3,G4,G5,G6,G7,G8,G9,G10,G11,G12,                          
     1 G13,G14,G15,G16,G17,G18,G19                                              
      DIMENSION AAA(2),BBB(3)                                                   
      COMMON/CAP1/I/CAP2/CMU1/CAP3/HMU1/CAP4/SMU1/CAP5/R11/CAP6/R22             
     1/CAP7/R33/CAP8/R44/CAP9/THET1/CAP10/PI/CAP11/U(9),H(9) /CAP12/D           
      IRITE=6
      NNN=1                                                                     
      D=SW/2.0                                                                  
      A1=R2-D                                                                   
      A2=D-R3                                                                   
      A3=SQRT(ABS(R4*R4-R3*R3))-R1                                              
      A4=SQRT(ABS(R3*R3-D*D))-R2                                                
      IF(A1)22,23,23                                                            
  22  IF(A2)24,23,23                                                            
  24  IF(A3)25,25,23                                                            
  25  IF(A4)23,26,26                                                            
  23  WRITE(IRITE,27)R1,R2,R3,R4,SW                                             
  27  FORMAT(1H ,10X,"THE FOLLOWING PARAMETERS ARE NOT COMPATIBLE WITH
     1 THE PRESENT PROGRAM :",3X,3HR1=,E14.7,3X,3HR2=,E14.7,3X,
     2 3HR3=,E14.7,3X,3HR4=,E14.7,3X,3HSW=,E14.7/)                              
      STOP                                                                      
  26  CMU1=CMU                                                                  
      HMU1=HMU                                                                  
      SMU1=SMU                                                                  
      R11=R1                                                                    
      R22=R2                                                                    
      R33=R3                                                                    
      R44=R4                                                                    
      THET1=THETA                                                               
      NX=NNN                                                                    
      NY=NNN                                                                    
      PI=3.141592653589793                                                      
C     RACINES DU POLYNOME DE LEGENDRE DE DEGRE 9 :                              
      U(1)=0.968160239508                                                       
      U(2)=0.836031107327                                                       
      U(3)=0.613371432701                                                       
      U(4)=0.324253423404                                                       
      U(5)=0.0                                                                  
C     RESULTATS DES INTEGRATIONS DU POLYNOME D'INTERPOLATION DE                 
C     LAGRANGE CORRESPONDANT :                                                  
      H(1)=0.081274388362                                                       
      H(2)=0.180648160695                                                       
      H(3)=0.260610696403                                                       
      H(4)=0.312347077040                                                       
      H(5)=0.330239355001                                                       
      DO 7 I=6,9                                                                
      U(I)=-U(10-I)                                                             
  7   H(I)=H(10-I)                                                              
C                                                                               
C     CALCUL DE ASSCH                                                           
C                                                                               
      RINF=0.0                                                                  
      CALL GXY3(F1,G1,G2,RINF,R1,NX,NY,ASSCH)                                   
      ASSCH=2.0*(ASSCH/(PI*R1*R1))                                              
C                                                                               
C     CALCUL DE ACCH ET DE ACSCH                                                
C                                                                               
      CALL GXY3(F2,G1,G3,R1,R2,NX,NY,A1)                                        
      CTH=COS(THETA/2.0)                                                        
      IF(CTH-R1/R2) 2,2,1                                                       
    1 RINF=R1/CTH                                                               
      CALL GXY3(F2,G4,G2,RINF,R2,NX,NY,A0)                                      
      DO 4 I=1,2                                                                
      IF(THETA)19,19,20                                                         
  19  B2=0.0                                                                    
      C=0.0                                                                     
      GOTO 21                                                                   
  20  CALL GXY3(F3,G3,G5,R1,RINF,NX,NY,B2)                                      
      CALL GXY3(F4,G5,G2,R1,RINF,NX,NY,C)                                       
  21  CALL GXY3(F3,G3,G4,RINF,R2,NX,NY,B3)                                      
  4   AAA(I)=A1+A0+B2+B3+C                                                      
      GOTO 3                                                                    
    2 DO 5 I=1,2                                                                
      IF(THETA-PI)16,17,17                                                      
  17  B23=0.0                                                                   
      GOTO 18                                                                   
  16  CALL GXY3(F3,G3,G5,R1,R2,NX,NY,B23)                                       
  18  CALL GXY3(F4,G5,G2,R1,R2,NX,NY,C)                                         
  5   AAA(I)=A1+B23+C                                                           
   3  A1=2.0/(PI*(R2*R2-R1*R1))                                                 
      ACCH=A1*AAA(1)                                                            
      ACSCH=A1*AAA(2)                                                           
      SH=D*SQRT(R4*R4-D*D)-D*SQRT(R3*R3-D*D)                                    
      SH=2.0*(SH+R4*R4*ARCS(D/R4)-R3*R3*ARCS(D/R3))                             
      THET1=0.0                                                                 
      CALL GXY3(F5,G6,G7,R3,R4,NX,NY,A1)                                        
      DO 6 I=1,3                                                                
      IF(I-3)8,9,9                                                              
  8   CALL GXY3(F6,G7,G8,R3,R4,NX,NY,A2)                                        
  9   CALL GXY3(F7,G8,G9,R3,R4,NX,NY,A3)                                        
  6   BBB(I)=(A1+A2+A3)*(4.0/SH)                                                
      H00=BBB(1)                                                                
      CH00=BBB(2)                                                               
      SCH00=BBB(3)                                                              
      THET1=PI                                                                  
      CALL GXY3(F8,G9,G10,R3,R4,NX,NY,A1HPI)                                    
      CALL GXY3(F11,G13,G12,R3,R4,NX,NY,A3)                                     
      DO 10 I=1,3                                                               
      IF(I-3)11,12,12                                                           
  11  CALL GXY3(F10,G12,G5,R3,R4,NX,NY,A2)                                      
  12  CALL GXY3(F9,G5,G11,R3,R4,NX,NY,A1)                                       
  10  BBB(I)=(A1+A2+A3+A1HPI)*(2.0/SH)                                          
      HPI=BBB(1)                                                                
      CHPI=BBB(2)                                                               
      SCHPI=BBB(3)                                                              
      THET1=PI/2.0                                                              
      CALL GXY3(F8,G6,G14,R3,R4,NX,NY,A1)                                       
      CALL GXY3(F5,G14,G10,R3,R4,NX,NY,A2)                                      
      A1H90=A1+A2                                                               
      CALL GXY3(F12,G15,G16,R3,R4,NX,NY,A1)                                     
      CALL GXY3(F17,G13,G12,R3,R4,NX,NY,A7)                                     
      DO 13 I=1,3                                                               
      IF(I-3)14,15,15                                                           
  14  CALL GXY3(F13,G17,G15,R3,R4,NX,NY,A2)                                     
      CALL GXY3(F16,G12,G5,R3,R4,NX,NY,A6)                                      
  15  CALL GXY3(F14,G18,G17,R3,R4,NX,NY,A3)                                     
      CALL GXY3(F14,G19,G11,R3,R4,NX,NY,A4)                                     
      CALL GXY3(F15,G5,G19,R3,R4,NX,NY,A5)                                      
  13  BBB(I)=(A1H90+A1+A7+A2+A6+A3+A4+A5)*(1.0/SH)                              
      H90=BBB(1)                                                                
      CH90=BBB(2)                                                               
      SCH90=BBB(3)                                                              
      A1=(H90-H00-0.5*(HPI-H00))/(-(PI*PI)/4.0)                                 
      A2=(HPI-H00-4.0*(H90-H00))/(-PI)                                          
      AHH=A1*THETA*THETA+A2*THETA+H00                                           
      A1=(CH90-CH00-0.5*(CHPI-CH00))/(-(PI*PI)/4.0)                             
      A2=(CHPI-CH00-4.0*(CH90-CH00))/(-PI)                                      
      AHCH=A1*THETA*THETA+A2*THETA+CH00                                         
      A1=(SCH90-SCH00-0.5*(SCHPI-SCH00))/(-(PI*PI)/4.0)                         
      A2=(SCHPI-SCH00-4.0*(SCH90-SCH00))/(-PI)                                  
      AHSCH=A1*THETA*THETA+A2*THETA+SCH00                                       
      RETURN                                                                    
      END                                                                       
      SUBROUTINE  GXY3(F,PSI1X,PSI2X,XINF,XSUP,NX,NY,S)                         
      COMMON/CAP11/U(9),H(9)                                                    
      COMMON/KKK1/DX,XLI,PSI1L,PSI2L,DXLI,YKJLI                                 
      COMMON/KKK/K,L                                                            
      N=9                                                                       
      DX=(XSUP-XINF)/(FLOAT(NX)*2.0)                                            
      S=0.0                                                                     
      DO 1 I=1,NX                                                               
      SL=0.0                                                                    
      DO 2 L=1,N                                                                
      XLI=XINF+DX*(2.0*FLOAT(I)-1.0+U(L))                                       
      PSI2L=PSI2X(XLI)                                                          
      PSI1L=PSI1X(XLI)                                                          
      DXLI=(PSI2L-PSI1L)/(FLOAT(NY)*2.0)                                        
      SJ=0.0                                                                    
      DO 3 J=1,NY                                                               
      SK=0.0                                                                    
      DO 4 K=1,N                                                                
      YKJLI=PSI1L+DXLI*(2.0*FLOAT(J)-1.0+U(K))                                  
   4  SK=SK+H(K)*F(XLI,YKJLI)                                                   
   3  SJ=SJ+SK                                                                  
   2  SL=SL+H(L)*DXLI*2.0*FLOAT(NY)*SJ                                          
   1  S=S+SL                                                                    
      S=(S*DX)/(2.0*FLOAT(NY))                                                  
      RETURN                                                                    
      END                                                                       
      FUNCTION F1(R,OMEGA)                                                      
      COMMON/CAP5/R1/CAP6/R2/CAP7/R3/CAP8/R4/CAP2/CMU/CAP3/HMU/                 
     1CAP4/SMU/CAP9/THETA                                                       
      SL1=AA(R1,R,OMEGA)+BB(R1,R,OMEGA,THETA)                                   
      CL=AA(R2,R,OMEGA)+BB(R2,R,OMEGA,THETA)-SL1                                
      HL=AA(R4,R,OMEGA)-AA(R3,R,OMEGA)                                          
     1+BB(R4,R,OMEGA,THETA)-BB(R3,R,OMEGA,THETA)                                
      SL2=CC(R,OMEGA,THETA)                                                     
      SL=SL1-SL2                                                                
      F1=R*EXP(-(SMU*SL+CMU*CL+HMU*HL))                                         
      RETURN                                                                    
      END                                                                       
      FUNCTION F2(R,OMEGA)                                                      
      COMMON/CAP6/R2/CAP7/R3/CAP8/R4/CAP9/THETA/CAP3/HMU /CAP2/CMU              
      CL=AA(R2,R,OMEGA)+BB(R2,R,OMEGA,THETA)-CC(R,OMEGA,THETA)                  
      HL=AA(R4,R,OMEGA)-AA(R3,R,OMEGA)+BB(R4,R,OMEGA,THETA)-BB(R3,R,            
     1OMEGA,THETA)                                                              
      F2=R*EXP(-(CMU*CL+HMU*HL))                                                
      RETURN                                                                    
      END                                                                       
      FUNCTION F3(R,OMEGA)                                                      
      COMMON/CAP5/R1/CAP6/R2/CAP7/R3/CAP8/R4/CAP9/THETA/CAP2/CMU/               
     1CAP3/HMU/CAP4/SMU /CAP1/I                                                 
      SL=2.0*BB(R1,R,OMEGA,THETA)                                               
      CL=BB(R2,R,OMEGA,THETA)+AA(R2,R,OMEGA)-CC(R,OMEGA,THETA)-SL               
      HL=AA(R4,R,OMEGA)-AA(R3,R,OMEGA)+BB(R4,R,OMEGA,THETA)-BB(R3,R,            
     1OMEGA,THETA)                                                              
      IF(I-2) 1,2,2                                                             
   1  F3=R*EXP(-(CMU*CL+HMU*HL))                                                
      RETURN                                                                    
   2  F3=R*EXP(-(SMU*SL+CMU*CL+HMU*HL))                                         
      RETURN                                                                    
      END                                                                       
      FUNCTION F4(R,OMEGA)                                                      
      COMMON/CAP5/R1/CAP6/R2/CAP7/R3/CAP8/R4/CAP9/THETA/CAP2/CMU/               
     1CAP4/SMU/CAP3/HMU /CAP1/I                                                 
      SL=2.0*AA(R1,R,OMEGA)+2.0*BB(R1,R,OMEGA,THETA)                            
      CL=AA(R2,R,OMEGA)+BB(R2,R,OMEGA,THETA)-CC(R,OMEGA,THETA)-SL               
      HL=AA(R4,R,OMEGA)-AA(R3,R,OMEGA)+BB(R4,R,OMEGA,THETA)-BB(R3,R,            
     1OMEGA,THETA)                                                              
      IF(I-2) 1,2,2                                                             
  1   F4=R*EXP(-(CMU*CL+HMU*HL))                                                
      RETURN                                                                    
  2   F4=R*EXP(-(SMU*SL+CMU*CL+HMU*HL))                                         
      RETURN                                                                    
      END                                                                       
      FUNCTION F5(R,OMEGA)                                                      
      COMMON/CAP7/R3/CAP8/R4/CAP3/HMU/CAP9/THETA                                
      HL=BB(R4,R,OMEGA,THETA)-2.0*BB(R3,R,OMEGA,THETA)+AA(R4,R,OMEGA)-          
     1CC(R,OMEGA,THETA)                                                         
      F5=R*EXP(-(HMU*HL))                                                       
      RETURN                                                                    
      END                                                                       
      FUNCTION F6(R,OMEGA)                                                      
      COMMON/CAP6/R2/CAP7/R3/CAP8/R4/CAP9/THETA/CAP3/HMU /CAP2/CMU              
     1 /CAP1/I                                                                  
      CL=2.0*BB(R2,R,OMEGA,THETA)                                               
      HL=BB(R4,R,OMEGA,THETA)-2.0*BB(R3,R,OMEGA,THETA)+AA(R4,R,OMEGA)-          
     1CC(R,OMEGA,THETA)                                                         
      IF(I-2)1,2,2                                                              
  1   F6=R*EXP(-(HMU*HL))                                                       
      RETURN                                                                    
  2   F6=R*EXP(-(HMU*HL+CMU*CL))                                                
      RETURN                                                                    
      END                                                                       
      FUNCTION F7(R,OMEGA)                                                      
      COMMON/CAP5/R1/CAP6/R2/CAP7/R3/CAP8/R4/CAP9/THETA/CAP3/HMU/CAP2/          
     1CMU/CAP4/SMU /CAP1/I                                                      
      SL=2.0*BB(R1,R,OMEGA,THETA)                                               
      CL=2.0*BB(R2,R,OMEGA,THETA)-SL                                            
      HL=BB(R4,R,OMEGA,THETA)-2.0*BB(R3,R,OMEGA,THETA)+AA(R4,R,OMEGA)-          
     1CC(R,OMEGA,THETA)                                                         
      IF(I-2)1,2,3                                                              
  1   F7=R*EXP(-(HMU*HL))                                                       
      RETURN                                                                    
  2   F7=R*EXP(-(CMU*CL+HMU*HL))                                                
      RETURN                                                                    
   3  F7=R*EXP(-(SMU*SL+CMU*CL+HMU*HL))                                         
      RETURN                                                                    
      END                                                                       
      FUNCTION F8(R,OMEGA)                                                      
      COMMON/CAP8/R4/CAP9/THETA/CAP3/HMU                                        
      HL=AA(R4,R,OMEGA)+BB(R4,R,OMEGA,THETA)-CC(R,OMEGA,THETA)                  
      F8=R*EXP(-(HMU*HL))                                                       
      RETURN                                                                    
      END                                                                       
      FUNCTION F9(R,OMEGA)                                                      
      COMMON/CAP5/R1/CAP6/R2/CAP7/R3/CAP8/R4/CAP9/THETA/CAP4/SMU/               
     1 CAP3/HMU /CAP2/CMU /CAP1/I                                               
      SL=2.0*BB(R1,R,OMEGA,THETA)+2.0*AA(R1,R,OMEGA)                            
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA) +BB(R4,R,OMEGA,THETA)-               
     12.0*BB(R3,R,OMEGA,THETA)-CC(R,OMEGA,THETA)                                
      CL=2.0*AA(R2,R,OMEGA)+2.0*BB(R2,R,OMEGA,THETA)-SL                         
      IF(I-2)1,2,3                                                              
  1   F9=R*EXP(-(HMU*HL))                                                       
      RETURN                                                                    
  2   F9=R*EXP(-(CMU*CL+HMU*HL))                                                
      RETURN                                                                    
  3   F9=R*EXP(-(SMU*SL+CMU*CL+HMU*HL))                                         
      RETURN                                                                    
      END                                                                       
      FUNCTION F10(R,OMEGA)                                                     
      COMMON/CAP6/R2/CAP7/R3/CAP8/R4/CAP9/THETA/CAP3/HMU/                       
     1 CAP2/CMU /CAP1/I                                                         
      CL=2.0*AA(R2,R,OMEGA)-2.0*BB(R2,R,OMEGA,THETA)                            
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA)+BB(R4,R,OMEGA,THETA)-                
     12.0*BB(R3,R,OMEGA,THETA)-CC(R,OMEGA,THETA)                                
      IF(I-2) 1,2,2                                                             
  1   F10=R*EXP(-(HMU*HL))                                                      
      RETURN                                                                    
  2   F10=R*EXP(-(CMU*CL+HMU*HL))                                               
      RETURN                                                                    
      END                                                                       
      FUNCTION F11(R,OMEGA)                                                     
      COMMON/CAP8/R4/CAP9/THETA/CAP3/HMU/CAP7/R3                                
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA) +BB(R4,R,OMEGA,THETA)-               
     12.0*BB(R3,R,OMEGA,THETA)-CC(R,OMEGA,THETA)                                
      F11=R*EXP(-(HMU*HL))                                                      
      RETURN                                                                    
      END                                                                       
      FUNCTION F12(R,OMEGA)                                                     
      COMMON/CAP7/R3 /CAP8/R4 /CAP9/THETA /CAP3/HMU                             
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA)+BB(R4,R,OMEGA,THETA)                 
     1 -CC(R,OMEGA,THETA)                                                       
      F12=R*EXP(-(HMU*HL))                                                      
      RETURN                                                                    
      END                                                                       
      FUNCTION F13(R,OMEGA)                                                     
      COMMON/CAP7/R3 /CAP8/R4 /CAP9/THETA /CAP3/HMU /CAP6/R2                    
     1 /CAP2/CMU /CAP1/I                                                        
      CL=2.0*AA(R2,R,OMEGA)                                                     
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA)+BB(R4,R,OMEGA,THETA)                 
     1 -CC(R,OMEGA,THETA)                                                       
      IF(I-2)1,2,2                                                              
  1   F13=R*EXP(-(HMU*HL))                                                      
      RETURN                                                                    
  2   F13=R*EXP(-(HMU*HL+CMU*CL))                                               
      RETURN                                                                    
      END                                                                       
      FUNCTION F14(R,OMEGA)                                                     
      COMMON/CAP7/R3 /CAP8/R4 /CAP9/THETA /CAP3/HMU /CAP4/SMU                   
     1 /CAP5/R1  /CAP6/R2 /CAP2/CMU /CAP1/I                                     
      SL=2.0*AA(R1,R,OMEGA)                                                     
      CL=2.0*AA(R2,R,OMEGA)-SL                                                  
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA)+BB(R4,R,OMEGA,THETA)                 
     1 -CC(R,OMEGA,THETA)                                                       
      IF(I-2)1,2,3                                                              
  1   F14=R*EXP(-(HMU*HL))                                                      
      RETURN                                                                    
  2   F14=R*EXP(-(HMU*HL+CMU*CL))                                               
      RETURN                                                                    
   3  F14=R*EXP(-(HMU*HL+CMU*CL+SMU*SL))                                        
      RETURN                                                                    
      END                                                                       
      FUNCTION F15( R,OMEGA)                                                    
      COMMON/CAP5/R1/CAP6/R2/CAP7/R3/CAP8/R4/CAP9/THETA/CAP3/HMU/               
     1CAP2/CMU/CAP4/SMU/CAP1/I                                                  
      SL=2.0*AA(R1,R,OMEGA)                                                     
      CL=2.0*AA(R2,R,OMEGA)-SL                                                  
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA)+BB(R4,R,OMEGA,THETA)-                
     12.0*BB(R3,R,OMEGA,THETA)-CC(R,OMEGA,THETA)                                
      IF(I-2)1,2,3                                                              
  1   F15=R*EXP(-(HMU*HL))                                                      
      RETURN                                                                    
  2   F15=R*EXP(-(CMU*CL+HMU*HL))                                               
      RETURN                                                                    
    3 F15=R*EXP(-(SMU*SL+CMU*CL+HMU*HL))                                        
      RETURN                                                                    
      END                                                                       
      FUNCTION F16(R,OMEGA)                                                     
      COMMON/CAP6/R2 /CAP7/R3 /CAP8/R4 /CAP9/THETA /CAP3/HMU                    
     1 /CAP2/CMU /CAP1/I                                                        
      CL=2.0*AA(R2,R,OMEGA)                                                     
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA)-CC(R,OMEGA,THETA)                    
     1 +BB(R4,R,OMEGA,THETA)-2.0*BB(R3,R,OMEGA,THETA)                           
      IF(I-2)1,2,2                                                              
   1  F16=R*EXP(-(HMU*HL))                                                      
      RETURN                                                                    
  2   F16=R*EXP(-(HMU*HL+CMU*CL))                                               
      RETURN                                                                    
      END                                                                       
      FUNCTION F17(R,OMEGA)                                                     
      COMMON/CAP7/R3 /CAP8/R4 /CAP9/THETA /CAP3/HMU                             
      HL=AA(R4,R,OMEGA)-2.0*AA(R3,R,OMEGA)-CC(R,OMEGA,THETA)                    
     1 +BB(R4,R,OMEGA,THETA)-2.0*BB(R3,R,OMEGA,THETA)                           
      F17=R*EXP(-(HMU*HL))                                                      
      RETURN                                                                    
      END                                                                       
      FUNCTION G1(R)                                                            
      COMMON/CAP9/THETA/CAP10/PI                                                
      G1=0.5*(PI+THETA)                                                         
      RETURN                                                                    
      END                                                                       
      FUNCTION G2(R)                                                            
      COMMON/CAP9/THETA/CAP10/PI                                                
      G2=1.5*PI+0.5*THETA                                                       
      RETURN                                                                    
      END                                                                       
      FUNCTION G3(R)                                                            
      COMMON/CAP9/THETA/CAP10/PI/CAP5/R1                                        
      G3=0.5*PI+THETA+ARCC(R1/R)                                                
      RETURN                                                                    
      END                                                                       
      FUNCTION G4(R)                                                            
      COMMON/CAP9/THETA/CAP10/PI/CAP5/R1                                        
      G4=1.5*PI+THETA-ARCC(R1/R)                                                
      RETURN                                                                    
      END                                                                       
      FUNCTION G5(R)                                                            
      COMMON/CAP10/PI/CAP5/R1                                                   
      G5=1.5*PI+ARCC(R1/R)                                                      
      RETURN                                                                    
      END                                                                       
      FUNCTION G6(R)                                                            
      COMMON/CAP10/PI /CAP12/D                                                  
      G6=PI/2.0+ARCC(D/R)                                                       
      RETURN                                                                    
      END                                                                       
      FUNCTION G7(R)                                                            
      COMMON/CAP10/PI /CAP6/R2                                                  
      G7=PI/2.0+ARCC(R2/R)                                                      
      RETURN                                                                    
      END                                                                       
      FUNCTION G8(R)                                                            
      COMMON/CAP10/PI /CAP5/R1                                                  
      G8=PI/2.0+ARCC(R1/R)                                                      
      RETURN                                                                    
      END                                                                       
      FUNCTION G9(R)                                                            
      COMMON /CAP10/PI                                                          
      G9=PI                                                                     
      RETURN                                                                    
      END                                                                       
      FUNCTION G10(R)                                                           
      COMMON/CAP10/PI /CAP12/D                                                  
      G10=1.5*PI-ARCC(D/R)                                                      
      RETURN                                                                    
      END                                                                       
      FUNCTION G11(R)                                                           
      COMMON/CAP10/PI                                                           
      G11=2.0*PI                                                                
      RETURN                                                                    
      END                                                                       
      FUNCTION G12(R)                                                           
      COMMON/CAP10/PI /CAP6/R2                                                  
      G12=1.5*PI+ARCC(R2/R)                                                     
      RETURN                                                                    
      END                                                                       
      FUNCTION G13(R)                                                           
      COMMON/CAP10/PI /CAP12/D                                                  
      G13=1.5*PI+ARCC(D/R)                                                      
      RETURN                                                                    
      END                                                                       
      FUNCTION G14(R)                                                           
      COMMON /CAP10/PI /CAP7/R3                                                 
      G14=PI+ARCC(R3/R)                                                         
      RETURN                                                                    
      END                                                                       
      FUNCTION G15(R)                                                           
      COMMON /CAP6/R2                                                           
      G15=ARCS(R2/R)                                                            
      RETURN                                                                    
      END                                                                       
      FUNCTION G16(R)                                                           
      COMMON /CAP12/D                                                           
      G16=ARCS(D/R)                                                             
      RETURN                                                                    
      END                                                                       
      FUNCTION G17(R)                                                           
      COMMON /CAP5/R1                                                           
      G17=ARCS(R1/R)                                                            
      RETURN                                                                    
      END                                                                       
      FUNCTION G18(R)                                                           
      G18=0.0                                                                   
      RETURN                                                                    
      END                                                                       
      FUNCTION G19(R)                                                           
      COMMON /CAP10/PI /CAP7/R3                                                 
      G19=2.0*PI-ARCC(R3/R)                                                     
      RETURN                                                                    
      END                                                                       
      FUNCTION AA(RR,R,OMEGA)                                                   
      COMMON/JJJ/J                                                              
      S=SIN(OMEGA)                                                              
      AAAAA=RR*RR-R*R*S*S                                                       
      IF(AAAAA)2,1,1                                                            
  2   WRITE(6,111) J,RR,R,OMEGA,S ,AAAAA                                        
 111  FORMAT(1H ,3X,2HAA,3X,I4,3X,5(1PE13.6,3X))                                
      AAAAA=-AAAAA                                                              
  1   AA=SQRT(AAAAA)                                                            
      RETURN                                                                    
      END                                                                       
      FUNCTION BB(RR,R,OMEGA,THETA)                                             
      COMMON/JJJ/J                                                              
      COMMON/KKK/K,L                                                            
      COMMON/KKK1/DX,XLI,PSI1L,PSI2L,DXLI,YKJLI                                 
      S=SIN(OMEGA-THETA)                                                        
      BBBBB=RR*RR-R*R*S*S                                                       
      IF(BBBBB)2,1,1                                                            
  2   CONTINUE                                                                  
      WRITE(6,111)J,L,K,RR,R,OMEGA,S,THETA,BBBBB                                
 111  FORMAT(1H ,3X,3(I4,1X),2HBB,3X,6(1PE13.6,3X))                             
      WRITE(6,112)DX,XLI,PSI1L,PSI2L,DXLI,YKJLI                                 
 112  FORMAT(1H ,3X,6(1PE13.6,3X))                                              
      BBBBB=-BBBBB                                                              
  1   BB=SQRT(BBBBB)                                                            
      RETURN                                                                    
      END                                                                       
      FUNCTION CC(R,OMEGA,THETA)                                                
      CC=R*(COS(OMEGA-THETA)-COS(OMEGA))                                        
      RETURN                                                                    
      END                                                                       
      FUNCTION ARCC(X)                                                          
      COMMON/CAP10/PI                                                           
      ARCC=PI/2.0-ARCS(X)                                                       
      RETURN                                                                    
      END                                                                       
      FUNCTION ARCS(X)                                                          
      COMMON/CAP10/PI                                                           
      U=SQRT(1.0-X*X)                                                           
      IF(U)1,1,2                                                                
  1   ARCS=PI/2.0                                                               
      RETURN                                                                    
  2   ARCS=ATAN(X/U)                                                            
      RETURN                                                                    
      END                                                                       
