#!/usr/bin/perl -w

#$cdname=`pwd`;
#chop($cdname);

#first read in info file. 
#define $datafile ==name of bas string
my $fscat;
my $abs;
my $van_count;

$van_count=0;
# First get the basic files

proc_file("/home/ansell/Mason/vana6mm.reg1","vana6mm.tot1");
proc_file("/home/ansell/Mason/vana6mm.reg2","vana6mm.tot2");
proc_file("/home/ansell/Mason/tizrcellvide.reg1","tizr.tot1");
proc_file("/home/ansell/Mason/tizrcellvide.reg2","tizr.tot2");
proc_file("/home/ansell/Mason/clochevide.reg1","cryo.tot1");
proc_file("/home/ansell/Mason/clochevide.reg2","cryo.tot2");
proc_back("/home/ansell/Mason/clochevide.reg1","back.tot1");
proc_back("/home/ansell/Mason/clochevide.reg2","back.tot2");


while ($wholeline = <>)
{
    @line = split ' ',$wholeline;     #Strip comments
    @temp = split '\.',$line[0];
    $datahead= $temp[0];  
    $wholeline = <>;
    @line = split ' ',$wholeline;     #Strip comments
    $temp = $line[0];
    $wholeline = <>;
    @line = split ' ',$wholeline;     #Strip comments
    $maw = $line[0];
    $wholeline = <>;
    @line = split ' ',$wholeline;     #Strip comments
    $dens = $line[0];
    $wholeline = <>;
    @line = split ' ',$wholeline;     #Strip comments
    $fsct = $line[0];
    $wholeline = <>;
    @line = split ' ',$wholeline;     #Strip comments
    $abs = $line[0];

    cint($datahead,$temp,$maw,$dens,$fsct,$abs);
    system("/home/ansell/neut/corpy < cint.com");
    $fullfile="/home/ansell/Mason/".$datahead.".reg1";
    $prefile=$datahead.".tot1";
    proc_file($fullfile,$prefile);
    $fullfile="/home/ansell/Mason/".$datahead.".reg2";
    $prefile=$datahead.".tot2";
    proc_file($fullfile,$prefile);
    
    int_com($datahead,"cryo.tot1","vana6mm.tot1","cryo.tot1",
	    "tizr.tot1",".tot1");
    system("/home/ansell/neut/crsplat < int.com");
    spt_com($datahead);
    system("/home/ansell/neut/splat < spt.com");
    rename($datahead.".soq","temp.soq");
    $van_count++;
    rename("Vancheck.dat","VCheck".$van_count.".dat");
    

    int_com($datahead,"cryo.tot2","vana6mm.tot2","cryo.tot2",
	    "tizr.tot2",".tot2");
    system("/home/ansell/neut/crsplat < int.com");
    spt_com($datahead);
    system("/home/ansell/neut/splat < spt.com");
    $van_count++;
    rename("Vancheck.dat","VCheck".$van_count.".dat");
    $aver1=aver_file("temp.soq");
    $aver2=aver_file($datahead.".soq");
    open(SOQ,">>temp.soq");
    open(RSOQ,$datahead.".soq");
    $linecount=0;
    $aver1/=$aver2;
    while($wholeline=<RSOQ>)
    {
      $linecount++;
      if ($linecount>2)
	{
	  @line = split ' ', $wholeline;
	  for($i=0;$i < @line; $i+=2)
	    {
	      print SOQ " ",$line[$i]*$aver1," ",$line[$i+1];
	    }
          print SOQ "\n";
	}
      else
	{
	  print SOQ $wholeline;
	}
    }
    close(RSOQ);
    close(SOQ);
    rename("temp.soq",$datahead.".soq");

}

sub aver_file($)
{
  my $fname = shift;
  my ( $aver, $npts, $linecount);
  my $wholeline;
  print "Filne name::",$fname,"::\n";
  open(SOQ,"<$fname"); 
  $aver=0.0;
  $npts=0;
  $linecount=0;
  $place=0.0;
  while($wholeline=<SOQ>)
    {
      $linecount++;
      if ($linecount==1)
	{
	  @line = split ' ',$wholeline;
	  $spc=$line[2];
	}
      if ($linecount>2)
	{
	  @line = split ' ',$wholeline;
	  for ($i=0;$i< @line ;$i+=2)
	    {
	      if ($place>7.05 && $place<8.4)
		{
		  $aver += $line[$i];
		  $npts++;
		}
	      $place+=$spc;
	    }
	}
    }
  close(SOQ);
    
  if ($npts>0.0)
    {
      return $aver/$npts;
    }
  return 0.0;
}

sub spt_com(&@)
{
  my $fname = shift;
  open(SPT_OUT,">spt.com");
  print SPT_OUT "cr",$fname,"\n";
  print SPT_OUT $fname,".cor\n";
  print SPT_OUT $fname,".lis\n";
  print SPT_OUT $fname,".soq\n";
  print SPT_OUT "n\n";
  close(SPT_OUT);
}

sub int_com (&@)
{
  my $fname = shift;
  my $bell_file = shift;
  my $van_file = shift;
  my $back_file = shift;
  my $cell_file = shift;
  my $extn = shift;

  open(INT_OUT,">int.com");
  print INT_OUT "cr",$fname,"\n";
  $ffile=$fname.$extn;
  open(CFILE,"<$ffile");
  print "FILE ",$ffile,"\n";

  $wholeline=<CFILE>;
  $wholeline=<CFILE>;
  @list = split ' ',$wholeline;
  $start_ang = $list[0];
  $end_ang= $start_ang;
  while($wholeline=<CFILE>)
  {
    @list = split ' ',$wholeline;
    if ($end_ang < $list[0])
    {
	$end_ang = $list[0];
    }
  }
  close(CFILE);
  printf(INT_OUT "%4.4f,%4.4f\n",$start_ang,$end_ang);

  if ($start_ang>30)
  {
    $start_ang+=0.1*($end_ang-$start_ang);
    $end_ang-=0.1*($end_ang-$start_ang);
  }
  else
  {
    $start_ang+=0.2*($end_ang-$start_ang);
    $end_ang-=0.1*($end_ang-$start_ang);
  }      
  print "\n\n\n\n\n\n\n";
  print "Start_ANG ::",$start_ang," End Ang ::",$end_ang,"\n\n";
  $ffile=$fname.".cor";
  open(CINT1,"<$ffile");
  open(CINT2,">temp.cor");
  $count=0;
  while($wholeline = <CINT1>)
  {
      $count++;
      if ($count!=3)
      {
	print CINT2 $wholeline;
      }
      else
      {
	printf(CINT2 "4 %4.4f %4.4f\n",$start_ang,$end_ang);
      }
  }
  close(CINT1);
  close(CINT2);
  rename("temp.cor",$ffile);

  print INT_OUT "Empty Bell Jar\n";
  print INT_OUT $bell_file,"\n";
  print INT_OUT "Vanadium \n";
  print INT_OUT $van_file,"\n";
  print INT_OUT "Empty Bell Jar\n";
  print INT_OUT $back_file,"\n";
  print INT_OUT "Empty Cell\n";
  print INT_OUT $cell_file,"\n";
  print INT_OUT $fname,"\n";
  $fname.=$extn;
  print INT_OUT $fname,"\n";
  print INT_OUT "n\n";
  close(INT_OUT);
}
     
  

sub proc_back (&@)
{
  my $fname = shift;
  my $fileout = shift;
 
  
  open(REG,"<$fname");
  $lines=0;
  while($wholeline= <REG>)
  {
    $_ = $wholeline;
    chop;
    if (!(/^\ *$/) && !(/^\ *\#/))
    {
      $lines++;
    }
  }
  close(REG);
   open(REG,"<$fname");
  open(REG_OUT,">$fileout");
  print REG_OUT $lines,"\n";
  while($wholeline= <REG>)
  {
    $_ = $wholeline;
    chop;
    if (!(/^\ *$/) && !(/^\ *\#/))
    {
	@pts=split ' ',$wholeline;
	print REG_OUT " ",$pts[0]," 0.000 1.00\n";
    }
  }
  close(REG);
  close(REG_OUT);
}

sub proc_file (&@)
{
  my $fname = shift;
  my $fileout = shift;
 
  
  open(REG,"<$fname");
  $lines=0;
  while($wholeline= <REG>)
  {
    $_ = $wholeline;
    chop;
    if (!(/^\ *$/) && !(/^\ *\#/))
    {
      $lines++;
    }
  }
  close(REG);
  open(REG,"<$fname");
  open(REG_OUT,">$fileout");
  print REG_OUT $lines,"\n";
  while($wholeline= <REG>)
  {
    $_ = $wholeline;
    chop;
    if (!(/^\ *$/) && !(/^\ *\#/))
    {
	print REG_OUT $wholeline;
    }
  }
  close(REG);
  close(REG_OUT);
}
    
# CINT


sub cint (&@)
{
    my $filehead = shift;
    my $temp = shift;
    my $mean_atomic_weight=shift;
    my $density=shift;
    my $freescat=shift;
    my $abs=shift;

    open(CINT,">cint.com");
    print CINT "$filehead.par\n";
    print CINT "$filehead.cor\n";
    print CINT "0.7057\n";
    print CINT "2\n";   # beam size ? 
    print CINT "1\n";   # beam size no checked!!   
    print CINT "3.5\n";  # cell length
    print CINT "0.3\n";  # cell inner radius
    print CINT "$filehead\n";
    print CINT "n\n";
    print CINT "$filehead\n";
    print CINT "0.3\n";  
    print CINT "0.35\n";
    print CINT "1.25\n";
    print CINT "1.27\n";
    print CINT "0.353\n";    #TiZr null alloy @ 0.7
    print CINT "0.0\n";      # no background for heater
    print CINT "$temp\n";
    print CINT "$mean_atomic_weight\n";
    print CINT "$density\n";
    print CINT "$freescat\n";
    print CINT "$abs\n";
    print CINT "n\n";
    close(CINT);
}









