#!/usr/bin/perl -w
use lib "/home/ansell/exe/neut";
use Param;
#$cdname=`pwd`;
#chop($cdname);

#first read in info file. 
#define $datafile ==name of bas string
my $fscat;
my $abs;
my $van_count;
my $cwd = `pwd`;
$van_count=0;
# First get the basic files

while ($wholeline = <>)
{
    @line = split ' ',$wholeline;     
    @temp = split '\.',$line[0];      
    $datahead= $temp[0];              # reg file name.
    $wholeline = <>;
    @line = split ' ',$wholeline;     
    $temp = $line[0];                 # temperature (Celcius)
    $wholeline = <>;
    @line = split ' ',$wholeline;     
    $maw = $line[0];                  # Mean atomic weight
    $wholeline = <>;
    @line = split ' ',$wholeline;     
    $dens = $line[0];                 # density (Atoms/A^3)
    $wholeline = <>;
    @line = split ' ',$wholeline;     
    $fsct = $line[0];                 # *FREE* scattering cross sec (barns)
    $wholeline = <>;
    @line = split ' ',$wholeline;     
    $abs = $line[0];                  # absorption cross section AT 1.8

    cint($datahead,$temp,$maw,$dens,$fsct,$abs);
    system("/home/ansell/neut/corpy < cint.com");

    $PM=new Param();
    $PM->{EmptyBell}="Bell";
    $PM->{EmptyCell}="CellE";
    $PM->{Vanadium}="VanE";

    my @Alist = ( 1.9,4.1,9.1,11.6 ); # angle 0.1

    for(my $angle=0;$angle<4;$angle++)
      {
	my $extn=sprintf("grp%d",$angle+1);
	my $Eang = $Alist[$angle]+127.8;
	intCOM($datahead,$PM->{EmptyBell},$PM->{Vanadium},
	       $PM->{EmptyBell},$PM->{EmptyCell},$extn,
	       $Alist[$angle],$Eang);
	
	system("/home/ansell/neut/crsplat < int.com");
	spt_com($datahead);
	system("/home/ansell/neut/splat < spt.com");
	my $Sfile = $datahead."\.sq" . sprintf("%d",$angle+1);
	rename($datahead.".soq",$Sfile);
      }
}
exit(1);


sub aver_file($)
{
  my $fname = shift;
  my ( $aver, $npts, $linecount);
  my $wholeline;
  print "Filne name::",$fname,"::\n";
  open(SOQ,"<$fname"); 
  $aver=0.0;
  $npts=0;
  $linecount=0;
  $place=0.0;
  while($wholeline=<SOQ>)
    {
      $linecount++;
      if ($linecount==1)
	{
	  @line = split ' ',$wholeline;
	  $spc=$line[2];
	}
      if ($linecount>2)
	{
	  @line = split ' ',$wholeline;
	  for ($i=0;$i< @line ;$i+=2)
	    {
	      if ($place>7.05 && $place<8.4)
		{
		  $aver += $line[$i];
		  $npts++;
		}
	      $place+=$spc;
	    }
	}
    }
  close(SOQ);
    
  if ($npts>0.0)
    {
      return $aver/$npts;
    }
  return 0.0;
}

sub spt_com(&@)
{
  my $fname = shift;
  open(SPT_OUT,">spt.com");
  print SPT_OUT "cr",$fname,"\n";
  print SPT_OUT $fname,".cor\n";
  print SPT_OUT $fname,".lis\n";
  print SPT_OUT $fname,".soq\n";
  print SPT_OUT "n\n";
  close(SPT_OUT);
}

sub intCOM
{
  my $fname = shift;
  my $bell_file = shift;
  my $van_file = shift;
  my $back_file = shift;
  my $cell_file = shift;
  my $EXT = shift;
  my $start_ang=shift;
  my $end_ang=shift;
  my $extn = "\.".$EXT;

  open(INT_OUT,">int.com");
  print INT_OUT "cr",$fname,"\n";
  $ffile=$fname.$extn;
  printf(INT_OUT "%4.4f,%4.4f\n",$start_ang,$end_ang);
  print "\n\n\n\n\n\n\n";
  print "Start_ANG ::",$start_ang," End Ang ::",$end_ang,"\n\n";
  $ffile=$fname.".cor";

  print INT_OUT "Empty Bell Jar\n";
  print INT_OUT $bell_file.$extn,"\n";
  print INT_OUT "Vanadium \n";
  print INT_OUT $van_file.$extn,"\n";
  print INT_OUT "Empty Bell Jar\n";
  print INT_OUT $back_file.$extn,"\n";
  print INT_OUT "Empty Cell\n";
  print INT_OUT $cell_file.$extn,"\n";
  print INT_OUT $fname,"\n";
  $fname.=$extn;
  print INT_OUT $fname,"\n";
  print INT_OUT "n\n";
  close(INT_OUT);
}

sub int_com (&@)
{
  my $fname = shift;
  my $bell_file = shift;
  my $van_file = shift;
  my $back_file = shift;
  my $cell_file = shift;
  my $extn = shift;

  open(INT_OUT,">int.com");
  print INT_OUT "cr",$fname,"\n";
  $ffile=$fname.$extn;
  open(CFILE,"<$ffile");
  print "FILE ",$ffile,"\n";

  $wholeline=<CFILE>;
  $wholeline=<CFILE>;
  @list = split ' ',$wholeline;
  $start_ang = $list[0];
  $end_ang= $start_ang;
  while($wholeline=<CFILE>)
  {
    @list = split ' ',$wholeline;
    if ($end_ang < $list[0])
    {
	$end_ang = $list[0];
    }
  }
  close(CFILE);
  printf(INT_OUT "%4.4f,%4.4f\n",$start_ang,$end_ang);

  if ($start_ang>30)
  {
    $start_ang+=0.1*($end_ang-$start_ang);
    $end_ang-=0.1*($end_ang-$start_ang);
  }
  else
  {
    $start_ang+=0.2*($end_ang-$start_ang);
    $end_ang-=0.1*($end_ang-$start_ang);
  }      
  print "\n\n\n\n\n\n\n";
  print "Start_ANG ::",$start_ang," End Ang ::",$end_ang,"\n\n";
  $ffile=$fname.".cor";
  open(CINT1,"<$ffile");
  open(CINT2,">temp.cor");
  $count=0;
  while($wholeline = <CINT1>)
  {
      $count++;
      if ($count!=3)
      {
	print CINT2 $wholeline;
      }
      else
      {
	printf(CINT2 "4 %4.4f %4.4f\n",$start_ang,$end_ang);
      }
  }
  close(CINT1);
  close(CINT2);
  rename("temp.cor",$ffile);

  print INT_OUT "Empty Bell Jar\n";
  print INT_OUT $bell_file,"\n";
  print INT_OUT "Vanadium \n";
  print INT_OUT $van_file,"\n";
  print INT_OUT "Empty Bell Jar\n";
  print INT_OUT $back_file,"\n";
  print INT_OUT "Empty Cell\n";
  print INT_OUT $cell_file,"\n";
  print INT_OUT $fname,"\n";
  $fname.=$extn;
  print INT_OUT $fname,"\n";
  print INT_OUT "n\n";
  close(INT_OUT);
}
     
  

sub proc_back (&@)
{
  my $fname = shift;
  my $fileout = shift;
 
  
  open(REG,"<$fname");
  $lines=0;
  while($wholeline= <REG>)
  {
    $_ = $wholeline;
    chop;
    if (!(/^\ *$/) && !(/^\ *\#/))
    {
      $lines++;
    }
  }
  close(REG);
   open(REG,"<$fname");
  open(REG_OUT,">$fileout");
  print REG_OUT $lines,"\n";
  while($wholeline= <REG>)
  {
    $_ = $wholeline;
    chop;
    if (!(/^\ *$/) && !(/^\ *\#/))
    {
	@pts=split ' ',$wholeline;
	print REG_OUT " ",$pts[0]," 0.000 1.00\n";
    }
  }
  close(REG);
  close(REG_OUT);
}

sub proc_file (&@)
{
  my $fname = shift;
  my $fileout = shift;
 
  
  open(REG,"<$fname");
  $lines=0;
  while($wholeline= <REG>)
  {
    $_ = $wholeline;
    chop;
    if (!(/^\ *$/) && !(/^\ *\#/))
    {
      $lines++;
    }
  }
  close(REG);
  open(REG,"<$fname");
  open(REG_OUT,">$fileout");
  print REG_OUT $lines,"\n";
  while($wholeline= <REG>)
  {
    $_ = $wholeline;
    chop;
    if (!(/^\ *$/) && !(/^\ *\#/))
    {
	print REG_OUT $wholeline;
    }
  }
  close(REG);
  close(REG_OUT);
}
    
# CINT

sub cint (&@)
{
  my $wavelength = 0.7;
  my $filehead = shift;
  my $temp = shift;
  my $mean_atomic_weight=shift;
  my $density=shift;
  my $freescat=shift;
  my $abs=shift;

  open(CINT,">cint.com");
  print CINT "$filehead.par\n";
  print CINT "$filehead.cor\n";
  print CINT $wavelength,"\n";
  print CINT "2.6\n";   # beam size ? 
  print CINT "1.2\n";   # beam size no checked!!   
  print CINT "3.1\n";   # cell length
  print CINT "0.3\n";   # cell inner radius
  print CINT "$filehead\n";
  print CINT "n\n";
  print CINT "$filehead\n";
  print CINT "0.3\n";  
  print CINT "0.35\n";
  print CINT "1.25\n";
  print CINT "1.27\n";
  print CINT "0.498\n";    # "0.353\n";    #TiZr null alloy @ 0.7
  print CINT "0.000\n";      # no background for heater
  print CINT "$temp\n";
  print CINT "$mean_atomic_weight\n";
  print CINT "$density\n";
  print CINT "$freescat\n";
  print CINT "$abs\n";
  print CINT "n\n";
  close(CINT);
}









