package ScatMat;

sub new
{
  my $type = shift;
  my $class = ref($type) || $type;

  my $self = {
    nrows => 0,      # number of data sets 
    nuniq => 0,      # number of uniq to display
    npassive => 0,   # number of passive units to sum before display
    Active => undef, # display names 
    Others => undef, # array of collected others.
    Rows => undef,   # array of hashes for index parts.
    Eff => undef     # Array of interactions.
    };

  $self->{Active}= [ ];
  $self->{Others}= [ ];
  $self->{Rows}= [ ];
  $self->{Eff}= [ ];
  bless $self,$class;
  return $self;
}

sub readSct
{
  my $self=shift;
  my @FN;
  push(@FN,@_);
  my $fname;
  while (@FN)
    {
      $fname = shift @FN;
      my %Parts;
      open(FHA,$fname) or return -1;
      my $line;
      while($line = <FHA>)
	{
	  chop $line;
	  if ($line =~ /^\s*\(\s*(.*)-\s*(.*)\s*\)\s*=\s*(.*)$/ )
	    {
	      my $grpN;
	      if (ucfirst($1) cmp ucfirst($2))
		{
		  $grpN=ucfirst($2)."-".ucfirst($1);
		}
	      else
		{
		  $grpN=ucfirst($1)."-".ucfirst($2);
		}
	      $Parts{$grpN}=$3;
	    }
	}
      push(@{$self->{Rows}},\%Parts);
      close(FHA);
    }
  $self->{nrows} = scalar(@{$self->{Rows}});
  print "Number of rows == ",$self->{nrows},"\n";
  $self->makeRows();
  $self->makeNames();
		     
  return;
}

sub makeRows
{
  my $self=shift;
  my @rows;
  if ($self->{nrows}>0)
    {
      $self->{Eff} = [ ];
      for(my $i=0;$i<$self->{nrows};$i++)
	{
	  @rows = ( );
	  for(my $j=0;$j<$self->{nrows};$j++)
	    {
	      if ($i==$j)
		{
		  push(@rows,1.0);
		}
	      else
		{
		  push(@rows,0.0);
		}
	    }
	  push(@{$self->{Eff}},[ @rows ]);
	}
    }
  return;
}


sub makeNames
 # Fancy subroutine to pass all the keys of the hash table
 # and find those that are not changing (hence other-other type)
 # and list
{   
  my $self=shift;
  my @Oth= ( );  #Non-active
  my @Act= ( );  #active 
  my @fullkeys;  #All keys in all parts
 # First off get uniq keys....

  foreach my $Hr (@{$self->{Rows}})
    {
      foreach my $val (keys %{$Hr})
	{
	  push(@fullkeys,$val);
	}
    }
  my @Nkeys = sort { $a cmp $b } @fullkeys;
  @fullkeys = ( ); # Empty array again...
  my $lname = "";
  foreach my $vl (@Nkeys)
    {
      if ($lname ne $vl)
	{
	  push(@fullkeys,$vl);
	  $lname=$vl;
	}
    }
# Next determine the unchanges and the changed.
  my $Hr = $self->{Rows};
  KEYS: foreach my $vl (@fullkeys)  
    {
      if (!(exists($Hr->[0]{$vl})))
	{
	  push(@Act,$vl);
	}
      else
	{
	  my $staticVal=$Hr->[0]{$vl};
	  for(my $i=1;$i<$self->{nrows};$i++)
	    {
	      if (!exists($Hr->[$i]{$vl}) || 
		  $Hr->[$i]{$vl}!= $staticVal)
		{
		  push(@Act,$vl);
		  next KEYS;
		}
	    }
	  push(@Oth,$vl);
	}
    }
  $self->{Others}=[ @Oth ];
  $self->{Active}=[ @Act ];
  $self->{nuniq}=scalar(@Oth);
  $self->{npassive}=scalar(@Act);
  return;
}
  
sub display
{
  use constant unitLen => 10;
  my $space = "          ";
  my $self=shift; 
  my $Hr = $self->{Rows};
  # print units 
  print "          ";  # bit for name
  my $understring="          ";    
  foreach my $Akey (@{$self->{Active}})
    {
      my $sz= length($Akey);
      my $lsize = (unitLen-$sz)/2;
      my $rsize = unitLen-($lsize+$sz);
      print substr("            ",0,$lsize);
      print $Akey;
      print substr("            ",0,$rsize);
      $understring.=substr("            ",0,$lsize);
      $understring.=substr("-------------",0,$sz);
      $understring.=substr("            ",0,$rsize);
    }
  if ($self->{npassive}>0) 
    {
      print " Others";
      $understring.=" ------";
    }
  print "\n";
  print $understring,"\n";;
  return;
}

  
# DEBUG -----

sub printNames
{
  my $self=shift;
  print "Acitve::\n";
  print " ",join(" : ",@{$self->{Active}}),"\n";
  print "Others::\n";
  print " ",join(" : ",@{$self->{Others}}),"\n";
  return;
}

sub printrows
{
  my $self=shift;

  foreach my $Rr (@{$self->{Eff}})
    {
      print " ",join(" : ",@{$Rr}),"\n";
    }
  foreach my $Hr (@{$self->{Rows}})
    {
      print "\$Hr== ",$Hr,"\n"; 
      foreach my $val (keys %{$Hr})
	{
	  print $val,":";
	}
      print "\n";
    }
  return;
}

1;




