# Package for processing the RAW data from 
use lib "/home/ansell/exe/neut";
use strict;
package RawP;
use rawData;

use constant inAngle => 8.0; 
use constant subAngle => 7.0; 

sub new
{
  my $type=shift;
  my $class = ref($type) || $type;
  my $self = {
      Title => undef,
      Oangle => 0.0,
      filelist => undef,
      Eff => undef,
      GoodE => undef,  # Array of each unit, number of good detectors
      Mesh => undef
     };
  bless $self,$class;
#  $self->clearMesh();
  return $self;
}

sub clearMesh
{
  my $self=shift;
  $self->{Mesh}=[ ];
  for(my $i=0;$i<4;$i++)
    {
      for(my $j=0;$j<9;$j++)
	{
	  $self->{Mesh}[$i][$j]=undef;
	}
    }
  return;
}

sub setfilelist
{
  my $self=shift;
  my $Aref = shift;
  my $num;
  foreach my $aval (@{$Aref})
    {
      $num=sprintf("%.6d",$aval);
      push(@{$self->{filelist}},$num);
    }
  return;
}

sub procraw
{
  my $self=shift;

  my $EffR=$self->{Eff};
  my $fname;
  my $angle;
  my $line;
  
  foreach my $fname (@{$self->{filelist}})
    {
      if(!open(FTA,$fname))
	{
	  print "Unable to open ",$fname,"\n";
	  close(FTA);
	  next;
	}
      my $header=1;  # Pre-Sample flag
      my $dcount=0;  # Flag for offset angle
      my $nc=0;      # 
      my $exactAngle; # Actual offset angle of the whole detector unit
      my $mon_count;  # total monitor count
      while($header && ($line=<FTA>))
	{
	  chop $line;
	  if ($line =~ /^SAMPLE\s*:(.*\S)\s*$/)
	    {
	      $self->{Title}=$1;
	    }
	  if ($dcount)
	    {
	      $dcount++;
	      if ($dcount==10)
		{
		  my @pts = split ' ',$line;
		  $mon_count=$pts[0];
		}
	      if ($dcount==12)
		{
		  my @trueAVal=(1.8,4.0,9.0,11.5);
		  my @pts = split ' ',$line;
		  $exactAngle = $pts[0];
		  $angle=0 if ($pts[0]<2.8);
		  $angle=1 if ($pts[0]>=2.8 && $pts[0]<7.5);
		  $angle=2 if ($pts[0]>=7.5 && $pts[0]<10.8);
		  $angle=3 if ($pts[0]>=10.8);
		  if (abs($exactAngle-$trueAVal[$angle])>1e-4)
		    {
		      print "\n *** In file number ",$fname,
		       " expect == ",$trueAVal[$angle],
		      " actual == ",$exactAngle,"\n\n";
		      $exactAngle=$trueAVal[$angle];
		    }
		  $dcount=0;
		  $header=0;
		}
	    }
	  $dcount=1 if ($line =~ /DETECTOR/);
	}
      print "Title == ",$self->{Title}," in grp  ",$angle,
       " -- ",$mon_count,"\n";
      
# DEBUG
#      print "Angle == ",$exactAngle," grp ==",$angle,"\n";
      my $nst=0; # part of the spectra reading
      my @tData = ( );  # temp. holding fold
      my $unit=0; # Reset (count from zero -- eight)
      
      while ($line=<FTA>)
	{
	  chop $line;
	  if ($nst==0 && $line =~ /^IIII/)
	    {
	      $nst=1;
	    }
	  elsif ($nst==1)
	    {
	      $nst++;
	      my @pts = split ' ',$line;
	      if (!$#pts == 63) 
		{
		  print "Error with line split\n";
		}
	      @tData = ( );
	    }
	  elsif ($nst>1 && ($line =~ /^SSSS/))
	    {
	      # Mesh == all items, [0-4] == set range, unit == grp 0-9
	      my $Fref = new rawData;
	      my $tA = $exactAngle+$unit*(inAngle+subAngle);
	      $Fref->makeSubUnit($mon_count,$tA,$self->{Eff},\@tData);
	      if (defined($self->{Mesh}[$angle][$unit]))
		{
		  ($self->{Mesh}[$angle][$unit])->add($Fref);
		}
	      else
		{
		  $self->{Mesh}[$angle][$unit]=$Fref;
		}
	      $unit++;
	      $nst=0;
	    }
	  else 
	    {
	      my @pts=split ' ',$line;
	      push(@tData,@pts);
	    }
	}
      close(FTA);
      if ($nst>1)
	{
	  # Mesh == all items, [0-4] == set range, unit == grp 0-9
	  my $Fref = new rawData;
	  my $tA = $exactAngle+$unit*(inAngle+subAngle);
	  $Fref->makeSubUnit($mon_count,$tA,$self->{Eff},\@tData);
	  if (defined($self->{Mesh}[$angle][$unit]))
	    {
	      ($self->{Mesh}[$angle][$unit])->add($Fref);
	    }
	  else
	    {
	      $self->{Mesh}[$angle][$unit]=$Fref;
	    }
	  $nst=0;
	}
    }
  return;
}


sub writeFour
  # Write one of the four angle sections 
{
  my $self=shift;
  my $fname = shift;
  my $nmb=shift;
  my $append = (@_) ? shift : 0;

  if ($nmb>4 || $nmb<1)
    {
      print "Only four groups exist\n";
      return;
    }
  $nmb--;

  if(!$append)
    {
      print "Opening file...",$fname,"\n";
      open(FH,">$fname") or return 1;
      print "successful...\n";
      my $sumPts=0;
      for(my $i=0;$i<9;$i++)
	{
	  if (defined($self->{Mesh}[$nmb][$i]))
	    {
	      $sumPts+= $self->{Mesh}[$nmb][$i]->{Npts};
	    }
	}
      print FH " ",$sumPts,"\n";
      close(FH);
    }
  for(my $j=0;$j<9;$j++)  ## nine detector units.
    {
      if (defined($self->{Mesh}[$nmb][$j]))
	{
	  $self->{Mesh}[$nmb][$j]->writeNoHeader($fname,1);
	  $append=1;
	}
    }
  return;
}

sub readEff
{
  my $self=shift;
  my $fname = (@_) ? shift : "effd4c.eff";
  if (!open(EFF,$fname))
    {
      print "No efficiency file found\n";
      return -1;
    }
  my @eff = ( );
  my @Gd = ( );
  my $curr_grp=0;
  my $cnt=0;
  my $line;
  while($line=<EFF>)
    {
      if (!($line =~ /^\s*\#/) &&
	  !($line =~ /^\s*$/))
	{
	  my @pts = split ' ',$line;
	  if ($#pts>=2)
	    {
	      push(@eff,$pts[2]);
	      if ($pts[0]!=$curr_grp)
		{
		  push(@Gd,$cnt) if ($curr_grp);
		  $cnt=0;
		  $curr_grp=$pts[0];
		}
	      $cnt++ if ($pts[2]>0.0);
	    }
	 } 
    }
  push(@Gd,$cnt);
  close(EFF);
  $self->{Eff} = [ @eff ];
  $self->{GoodE} = [ @Gd ];
  return;
}

sub printEff
{
  my $self=shift;
  my $Ar=$self->{Eff};
  for(my $i=0;$i<=$#$Ar;$i++)
    {
      print "E[",$i,"]==",$Ar->[$i],"\n";
    }
}

sub writeALL
{
  my $self=shift;
  my $fname = shift;
  my $append=0;
  for(my $a=0;$a<4;$a++) ## four angles
    {
      for(my $j=0;$j<9;$j++)  ## nine detector units.
	{
	  if (defined($self->{Mesh}[$a][$j]))
	    {
	      $self->{Mesh}[$a][$j]->write($fname,$append);
	      $append=1;
	    }
	}
    }
  return;
}

sub writeLONG
{
  my $self=shift;
  my $fname = shift;
  my $append=0;
  for(my $a=0;$a<4;$a++) ## four angles
    {
      for(my $j=0;$j<9;$j++)  ## nine detector units.
	{
	  if (defined($self->{Mesh}[$a][$j]))
	    {
	      $self->{Mesh}[$a][$j]->writeNoHeader($fname,$append);
	      $append=1;
	    }
	}
    }
  return;
}

1;






