/* GrWinAll.h
 *
 * Copyright (C) 1998-2003 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin/english
 *
 */

#ifdef __WATCOMC__
typedef struct CHARACTER {
	char		*p;
	unsigned	l;
} CHARACTER;
#endif

//////////// low level functions ////////////////
int _errcheck(int ret);
int _sendmsg(int len);
LPVOID putWORD(LPVOID p, int x);
LPVOID putDWORD(LPVOID p, int x);
char *_copyBuff(int nDoc, char *s, int l);
int _setBuff(int nDoc, char *str);
int _getsizes(int n, int *w, int *h);
int _command0(char c, char d, char e);
int _command(int nDoc, char c, int x, int y, int z);
int _command1(int nDoc, char c, int x);
int _command2(int nDoc, char c, int x, int y);
int _printf(int nDoc, const char *fmt, ...);
int _senddata(int nDoc, LPCVOID dat, int len);
int _polydo(int nDoc, int nTool, LPCVOID p, int len);
void ErrorMessage(int fatal, const char *fmt, ...);
BOOL IsWinGUI(char *fname);
LRESULT OpenGrWndApp(HINSTANCE hinst);

#ifdef __F2C__
float rand_(void);
#endif
#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
float RAND(void);
#endif

#ifndef _MSC_VER
#if defined(__CYGWIN32__) || defined(__WATCOMC__) || defined(__LCC__)
int kbhit(void);
int getch (void);
int getche (void);
#else
int _kbhit(void);
#endif
int kbgetch(int N);
#endif

//////////// GrWin functions ////////////////
int GWinit(void);
int GWinitx(int bzi, int x, int y, int w, int h, int a, int m, int z, int d);
int GWquit(void);
int GWquitx(int mq);
int GWsize(int n, int *w, int *h);
int GWopen(int nDoc);
int GWopenx(int nDoc, int Width, int Height, int fc, int bc, 
		int Mode, char *fname);
int GWleave(void);
int GWjoin(int nDoc, int nWnd, int bDo, char *str);
int GWreset(void);
int GWclose(int nDoc);
int GWselect(int nDoc);
int GWshowwn(int nDoc, int show);
int GWshowfr(int show);
int GWarrange(int m);
int GWfirst(void);
int GWnext(int nDoc);

int GWerase(int n, int lrf);
int GWrefresh(void);
int GWvwmod(int m);
int GWmode(int md, int m);
int GWvport(float u1, float v1, float u2, float v2);
int GWport(float x1, float y1, float x2, float y2);
int GWgetvp(float *u1, float *v1, float *u2, float *v2);
int GWsetvpn(int vpn);
int GWsavevp(int vpn);
int GWindow(float x1, float y1, float x2, float y2);
int GWgetwn(float *x1, float *y1, float *x2, float *y2);
int GWnewpen(int c);
int GWsysclr(int index);
int GWgetpxl(float x, float y);
int GWsetpxl(float x, float y, int k);
int GWncolor(void);
int GWkcolor(int c);
int GWkrgb(int r, int g, int b);
int GWipalette(int c);
int GWsettxt(float h, float a, int o, int c, int b, char *face);
int GWgettxt(float *w, float *h, float *x, float *y, char *text);
int GWputtxt(float x, float y, char *text);
int GWsetsym(float h, float a, int o, int c, int b, char *face);
int GWgetsys(float *w, float *h, int c);
int GWputsym(float x, float y, int c);
int GWsetmsg(char *text);
int GWmsgbox(char *text);
int GWpause(char *text);
int GWsleep(int ms);
int GWsleep2(int ms);
int GWctime(void);
int GWidle(int *ch, float *x, float *y, int ms);
int GWidle2(int *ch, float *x, float *y, int ms);
int GWkybrd(int *ch, int *cnt, int *flg, int m);
int GWinput(char *ttl, char *str, int l);
int GWmouse(int *R, float *x, float *y);
int GWtimer(int MS, int N);
int GWevent(float *x, float *y);
int GWcappnt(float *x, float *y, char *txt);
int GWcaplin(float *x1, float *y1, float *x2, float *y2, char *txt);
int GWcaprect(float *x1, float *y1, float *x2, float *y2, char *txt);
int GWcapvec(float x1, float y1, float *x2, float *y2, char *txt);
int GWmove2(float x, float y);
int GWline2(float x, float y);
int GWgetpos(float *x, float *y);
int GWline(float x1, float y1, float x2, float y2);
int GWrect(float x1, float y1, float x2, float y2);
int GWsrect(float x1, float y1, float x2, float y2, int k);
int GWellipse(float x1, float y1, float x2, float y2);
int GWpolygon(float *points, int N, int mf);
int GWbezier(float *points, int N);
int GWflood(float x, float y);
int GWclear(int k);
int GWputmrk(float x, float y);
int GWsetmrk(int t, float s, int k, int kb, int m);
int GWgetmrk(int *t, float *s, int *k, int *kb, int *m);
int GWsetpen(int plt, int style, int width, int ROP);
int GWgetpen(int *plt, int *style, int *width, int *ROP);
int GWsetbrs(int plt, int style, int hatch);
int GWgetbrs(int *plt, int *style, int *hatch);
int GWsetxfrm(float *XFRM);
int GWgetxfrm(float *XFRM);
int GWsetrgn(float x1, float y1, float x2, float y2, int m);
int GWsetbk(int m);
int GWcapimg(int nb, float x1, float y1, float x2, float y2);
int GWclipimg(float x1, float y1, float x2, float y2);
int GWloadbmp(int nb, char *fname);
int GWsavebmp(int nb, char *fname);
int GWmakebmp(int nb, int w, int h, int bc, int *bits);
int GWcopybmp(int nb1, int nb2);
int GWdelbmp(int nb);
int GWsetbmp(int nb, float w, float h, int m, int t, int o);
int GWgetbmp(int nb, float *width, float *height, int *w, int *h, int *nc, 
	int *maxnb, char *fname, int l);
int GWputbmp(int nb, float x, float y, int bk);
float GWaspect(int N);
int GWloadCMB(int nm, char *fname);
int GWsaveCMB(int nm, char *fname);
int GWbegincmbcm(int nm, float w, float h);
int GWendcmb(void);
int GWcmbmrk(int nm, int t, float s, int k, int kb, int mix);
int GWsetcmb(int nm, float w, float h, int o);
int GWgetcmb(int nm, float *width, float *height, 
	float *w, float *h, int *maxnb, char *fname, int l);
int GWputcmb(int nm, float x, float y, float w, float h, int o);
int GWcopycmb(int nb1, int nb2);
int GWdelcmb(int nb);
int GWsavecc(char *fname);
int GWloadcc(char *fname);
int GWcolor(int k, int dest);
int GWsave(char *fname);
int GWsaveas(int format, int viewmode, int width, int height, char *fname);
int GWload(int ic, char *fname);
int GWprint(int n, int m);
int GWfiledlg(char *fname, int l);
int GWversion(int n, char *s, int l);
int GWfnt2bmp(int n, int w, int h, int u, int v, char *text);
int GWldcpos(float x, float y, int *u, int *v);
int GWldcsiz(float w, float h, int *u, int *v);
int GWpxlsiz(float *x, float *y);
int GWrrect(float x1, float y1, float x2, float y2, float w, float h);
int GWarc(float x1, float y1, float x2, float y2, float a, float aw);
int GWchord(float x1, float y1, float x2, float y2, float a, float aw);
int GWpie(float x1, float y1, float x2, float y2, float a, float aw);
int GWpolylin(float *points, int N);
int GWplot1(int M, int N, float P1, float PN, float W, float O, 
			float A, float B, float *ARRY);
int GWsetogn(int s, int d);
int GWanchor(int n);
int GWflush(int ogn);
float GWfmax(void);

// tortoise graphics
int GWTspawn(int it, int s, int m);
int GWTturn(int it, float a);
int GWTforward(int it, float d);
int GWTshift(int it, float dx, float dy);
int GWTmove2(int it, float x, float y);
int GWTclone(int it1, int it2);
int GWTremove(int it);
int GWTsetpos(int it, float x, float y);
int GWTgetpos(int it, float *x, float *y);
int GWTsetdir(int it, float a);
int GWTgetdir(int it, float *a);
int GWTsetcol(int it, int pc);
int GWTgetcol(int it);
int GWTsetpen(int it, int pc, int ps, int pw);
int GWTgetpen(int it, int *pc, int *ps, int *pw);
int GWTsetmrk(int it, int t, float s, int k, int ks, int kb, int mix);
int GWTgetmrk(int it, int *t, float *s, int *k, int *ks, int *kb, int *m);
int GWTsetsym(int it, int m);
int GWTgetsym(int it, float *w, float *h, int *c);
int GWTsetbmp(int it, int b, float w, float h, int x, int t, int o);
int GWTsetcmb(int it, int c, float w, float h, int o);

///////////////////////////////////////////////////////////////////////
int GW_init(int bzi, int x, int y, int w, int h, int a, int m, int z, int d);
int GW_quit(int bPause);
int GW_open(int nDoc, int Width, int Height, int fc, int bc, int Mode, 
		char *fname);
int GW_join(int nDoc, int nCli, int bDo, char *str);
int GW_reset(int nDoc);
int GW_close(int nDoc);
int GW_getvp(int nDoc, int *u1, int *v1, int *u2, int *v2);
COLORREF GW_syscolor(int nindex);
int GW_kcolor(int c);
int GW_krgb(int r, int g, int b);
int GW_ipalette(int c);
int GW_savecc(int nDoc, char *fname);
int GW_loadcc(int nDoc, char *fname);
int GW_save(int nDoc, char *fname);
int GW_saveas(int nDoc, int format, int viewmode, int width, int height, char *fname);
int GW_load(int nDoc, int ic, char *fname);
int GW_print(int nDoc, int nMode);
int GW_filedlg(int nDoc, char *fname, int l);
int GW_getpixel(int nDoc, int x, int y);
int GW_setpixel(int nDoc, int x, int y, int k);
int GW_color(int nDoc, int k, int dest);
int GW_next(int nDoc);
int GW_idle(int nDoc, int *ch, int *u, int *v, int ms);
int GW_idle2(int nDoc, int *ch, int *u, int *v, int ms);
int GW_kybrd(int nDoc, int *ch, int *cnt, int *flg, int m);
int GW_input(int nDoc, char *ttl, char *str, int l);
int GW_mouse(int nDoc, int *R, int *x, int *y);
int GW_timer(int nDoc, int MS, int N);
int GW_event(int nDoc, int *x, int *y);
int GW_viewmode(int nDoc, int m);
int GW_mode(int nDoc, int mr, int mb);
int GW_erase(int nDoc, int n, int lrf);
int GW_refresh(int nDoc);
int GW_selwin(int nDoc);
int GW_arrange(int nDoc, int m);
int GW_wsize(int nDoc, int wnd, int *width, int *height);
int GW_cappoint(int nDoc, int *x, int *y, char *txt);
int GW_capline(int nDoc, int *x1, int *y1, int *x2, int *y2, char *txt);
int GW_caprect(int nDoc, int *x1, int *y1, int *x2, int *y2, char *txt);
int GW_getpoint(int nDoc, int *x, int *y);
int GW_getrect(int nDoc, int *x1, int *y1, int *x2, int *y2);
int GW_settext(int nDoc, int h, int a, int o, int c, int b, char *face);
int GW_gettext(int nDoc, int *w, int *h, int *x, int *y, char *txt);
int GW_puttext(int nDoc, int x, int y, char *txt);
int GW_setsymbol(int nDoc, int h, int a, int o, int c, int b, char *face);
int GW_getsymbol(int nDoc, int *w, int *h, int c);
int GW_putsymbol(int nDoc, int x, int y, int c);
int GW_setmsg(int nDoc, char *txt);
int GW_msgbox(int nDoc, char *txt);
int GW_pause(int nDoc, char *txt);
int GW_sleep(int nDoc, int ms);
int GW_sleep2(int nDoc, int ms);
int GW_ctime(int nDoc);
int GW_move2(int nDoc, int x, int y);
int GW_line2(int nDoc, int x, int y);
int GW_line(int nDoc, int x1, int y1, int x2, int y2);
int GW_rectangle(int nDoc, int x1, int y1, int x2, int y2);
int GW_solidrect(int nDoc, int x1, int y1, int x2, int y2, int k);
int GW_ellipse(int nDoc, int x1, int y1, int x2, int y2);
int GW_polygon(int nDoc, POINT* pnts, int nbyte, int mf);
int GW_bezier(int nDoc, POINT *pnts, int nbyte);
int GW_flood(int nDoc, int x, int y);
int GW_clear(int nDoc, int k);
int GW_setmark(int nDoc, int type, int size, int k, int kb, int ROP);
int GW_putmark(int nDoc, int x, int y);
int GW_setbk(int nDoc, int m);
int GW_getmrk(int nDoc, int *t, int *s, int *k, int *kb, int *m);
int GW_capimage(int nDoc, int nb, int x1, int y1, int x2, int y2);
int GW_clipimage(int nDoc, int x1, int y1, int x2, int y2);
int GW_loadbitmap(int nDoc, int nb, char *fname);
int GW_savebitmap(int nDoc, int nb, char *fname);
int GW_makebitmap(int nDoc, int nb, int w, int h, int bc, int *bits);
int GW_setbitmap(int nDoc, int nb, int w, int h, int m, int t, int o);
int GW_copybitmap(int nDoc, int nb1, int nb2);
int GW_delbmp(int nDoc, int nb);
int GW_getbitmap(int nDoc, int nb, int *width, int *height, 
	int *bw, int *bh, int *nc, int *maxnb, char *fname, int l);
int GW_putbitmap(int nDoc, int nb, int x, int y, int bk);
int GW_rembitmap(int nDoc, int nb);
int GW_setmrk(int nDoc, int t, int s, int k, int kb, int m);
int GW_setpen(int nDoc, int c, int ps, int pw, int pm);
int GW_getpen(int nDoc, int *c, int *ps, int *pw, int *pm);
int GW_setbrush(int nDoc, int c, int bs, int bh);
int GW_setxfrm(int nDoc, int x0, int y0, float t11, float t12, float t21, float t22);
int GW_getxfrm(int nDoc, int *x0, int *y0, float *t11, float *t12, float *t21, float *t22);
int GW_setrgn(int nDoc, int u1, int v1, int u2, int v2, int m);

int GW_font2bitmap(int nDoc, int nb, int w, int h, int u, int v, char *text);
int GW_getpos(int nDoc, int *u, int *v);
int GW_roundrect(int nDoc, int u1, int v1, int u2, int v2, int w, int h);
int GW_arc(int nDoc, int u1, int v1, int u2, int v2, 
		   int u3, int v3, int u4, int v4);
int GW_chord(int nDoc, int u1, int v1, int u2, int v2, 
		   int u3, int v3, int u4, int v4);
int GW_pie(int nDoc, int u1, int v1, int u2, int v2, 
		   int u3, int v3, int u4, int v4);
int GW_polyline(int nDoc, POINT *pnts, int N);
int GW_plot1(int nDoc, int M, int N, int P1, int PN, int W, int O, INT *ARRY);
int GW_flush(int nDoc, int ogn);
int GW_loadCMB(int nDoc, int nm, char *fname);
int GW_saveCMB(int nDoc, int nm, char *fname);
int GW_begincmb(int nDoc, int nm, int w, int h);
int GW_endcmb(int nDoc);
int GW_cmbmrk(int nDoc, int nm, int t, int s, int k, int kb, int mix);
int GW_setcmb(int nDoc, int nm, int w, int h, int o);
int GW_getcmb(int nDoc, int nm, int *width, int *height, 
	int *mw, int *mh, int *maxnb, char *fname, int l);
int GW_putcmb(int nDoc, int nm, int x, int y, int w, int h, int o);
int GW_copycmb(int nDoc, int nb1, int nb2);
int GW_delcmb(int nDoc, int nb);

//////////// Fortran routines ////////////////
#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
int GWJOIN(int *ret, int *nDoc, int *nWnd, int *bDo, CHARACTER *str);
int GWOPENX(int *ret, int *nDoc, int *Width, int *Height, 
		int *fc, int *bc, int *Mode, CHARACTER *fname);
int GWSETTXT(int *ret, float *h, float *a, int *o, 
		int *c, int *b, CHARACTER *face);
int GWGETTXT(int *ret, float *w, float *h, float *x, float *y, 
		CHARACTER *text);
int GWPUTTXT(int *ret, float *x, float *y, CHARACTER *text);
int GWSETSYM(int *ret, float *h, float *a, int *o, 
		int *c, int *b, CHARACTER *face);
int GWSETMSG(int *ret, CHARACTER *text);
int MSGBOX(CHARACTER *text);
int GWPAUSE(int *ret, CHARACTER *text);
int GWINPUT(int *ret, CHARACTER *ttl, CHARACTER *str);
int GWCAPPNT(int *ret, float *x, float *y, CHARACTER *text);
int GWCAPLIN(int *ret, float *x1, float *y1, float *x2, float *y2, 
		CHARACTER *text);
int GWCAPRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
		CHARACTER *text);
int GWCAPVEC(int *ret, float *x1, float *y1, float *x2, float *y2, 
		CHARACTER *text);
int GWLOADBMP(int *ret, int *nb, CHARACTER *fname);
int GWSAVEBMP(int *ret, int *nb, CHARACTER *fname);
int GWGETBMP(int *ret, int *nb, float *width, float *height, 
		int *w, int *h, int *nc, int *maxnb, CHARACTER *fname);
int GWSAVECC(int *ret, CHARACTER *fname);
int GWLOADCC(int *ret, CHARACTER *fname);
int GWSAVE(int *ret, CHARACTER *fname);
int GWSAVEAS(int *ret, int *format, int *viewmode, int *width, int *height, CHARACTER *fname);
int GWLOAD(int *ret, int *ic, CHARACTER *fname);
int GWVERSION(int *ret, int *n, CHARACTER *s);
int GWFILEDLG(int *ret, CHARACTER *fname);
int GWFNT2BMP(int *ret, int *nb, int *w, int *h, int *u, int *v, 
			CHARACTER *text);
int GWLOADCMB(int *ret, int *nm, CHARACTER *fname);
int GWSAVECMB(int *ret, int *nm, CHARACTER *fname);
int GWGETCMB(int *ret, int *nm, float *width, float *height, 
		float *w, float *h, int *maxnb, CHARACTER *fname);
#else
int GWJOIN(int *ret, int *nDoc, int *nWnd, int *bDo, char *str, int l);
int GWOPENX(int *ret, int *nDoc, int *Width, int *Height, 
		int *fc, int *bc, int *Mode, char *fname, int l);
int GWSETTXT(int *ret, float *h, float *a, int *o, 
		int *c, int *b, char *face, int l);
int GWGETTXT(int *ret, float *w, float *h, float *x, float *y, 
		char *text, int l);
int GWPUTTXT(int *ret, float *x, float *y, char *text, int l);
int GWSETSYM(int *ret, float *h, float *a, int *o, 
		int *c, int *b, char *face, int l);
int GWSETMSG(int *ret, char *text, int l);
int MSGBOX(char *text, int l);
int GWPAUSE(int *ret, char *text, int l);
int GWINPUT(int *ret, char *ttl, char *str, int l1, int l);
int GWCAPPNT(int *ret, float *x, float *y, char *text, int l);
int GWCAPLIN(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int GWCAPRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int GWCAPVEC(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int GWLOADBMP(int *ret, int *nb, char *fname, int l);
int GWSAVEBMP(int *ret, int *nb, char *fname, int l);
int GWGETBMP(int *ret, int *nb, float *width, float *height, 
		int *w, int *h, int *nc, int *maxnb, char *fname, int l);
int GWSAVECC(int *ret, char *fname, int l);
int GWLOADCC(int *ret, char *fname, int l);
int GWSAVE(int *ret, char *fname, int l);
int GWSAVEAS(int *ret, int *format, int *viewmode, int *width, int *height, char *fname, int l);
int GWLOAD(int *ret, int *ic, char *fname, int l);
int GWVERSION(int *ret, int *n, char *s, int l);
int GWFILEDLG(int *ret, char *fname, int l);
int GWFNT2BMP(int *ret, int *nb, int *w, int *h, int *u, int *v, 
			char *text, int l);
int GWLOADCMB(int *ret, int *nm, char *fname, int l);
int GWSAVECMB(int *ret, int *nm, char *fname, int l);
int GWGETCMB(int *ret, int *nm, float *width, float *height, 
		float *w, float *h, int *maxnb, char *fname, int l);
#endif
int GWINIT(int *ret);
int GWINITX(int *bzi, int *ret, int *x, int *y, int *w, int *h, 
		int *a, int *m, int *z, int *d);
int GWQUIT(int *ret);
int GWQUITX(int *ret, int *mq);
int GWSIZE(int *ret, int *n, int *w, int *h);
int GWOPEN(int *ret, int *nDoc);
int GWLEAVE(int *ret);
int GWRESET(int *ret);
int GWCLOSE(int *ret, int *nDoc);
int GWSELECT(int *ret, int *nDoc);
int GWSHOWWN(int *ret, int *nDoc, int *show);
int GWSHOWFR(int *ret, int *show);
int GWARRANGE(int *ret, int *m);
int GWFIRST(int *ret);
int GWNEXT(int *ret, int *nDoc);
int GWVPORT(int *ret, float *u1, float *v1, float *u2, float *v2);
int GWPORT(int *ret, float *x1, float *y1, float *x2, float *y2);
int GWGETVP(int *ret, float *u1, float *v1, float *u2, float *v2);
int GWSETVPN(int *ret, int *vpn);
int GWSAVEVP(int *ret, int *vpn);
int GWINDOW(int *ret, float *x1, float *y1, float *x2, float *y2);
int GWGETWN(int *ret, float *x1, float *y1, float *x2, float *y2);
int GWSYSCLR(int *ret, int *index);
int GWERASE(int *ret, int *n, int *lrf);
int GWREFRESH(int *ret);
int GWRVWMOD(int *ret, int *m);
int GWMODE(int *ret, int *md, int *m);
int GWGETPXL(int *ret, float *x, float *y);
int GWSETPXL(int *ret, float *x, float *y, int *k);
int GWNCOLOR(int *ret);
int KCOLOR(int *c);
int KRGB(int *r, int *g, int *b);
int IPALETTE(int *c);
int GWGETSYM(int *ret, float *w, float *h, int *c);
int GWPUTSYM(int *ret, float *x, float *y, int *c);
int GWSLEEP(int *ret, int *ms);
int GWSLEEP2(int *ret, int *ms);
int GWCTIME(int *ret);
int GWIDLE(int *ret, int *ch, float *x, float *y, int *ms);
int GWIDLE2(int *ret, int *ch, float *x, float *y, int *ms);
int GWKYBRD(int *ret, int *ch, int *cnt, int *flg, int *m);
int GWMOUSE(int *ret, int *R, float *x, float *y);
int GWTIMER(int *ret, int *MS, int *N);
int GWEVENT(int *ret, float *x, float *y);
int GWMOVE2(int *ret, float *x, float *y);
int GWLINE2(int *ret, float *x, float *y);
int GWGETPOS(int *ret, float *x, float *y);
int GWLINE(int *ret, float *x1, float *y1, float *x2, float *y2);
int GWRECT(int *ret, float *x1, float *y1, float *x2, float *y2);
int GWSRECT(int *ret, float *x1, float *y1, float *x2, float *y2, int *k);
int GWELLIPSE(int *ret, float *x1, float *y1, float *x2, float *y2);
int GWPOLYGON(int *ret, float *points, int *N, int *mf);
int GWBEZIER(int *ret, float *points, int *N);
int GWFLOOD(int *ret, float *x, float *y);
int GWCLEAR(int *ret, int *k);
int GWPUTMRK(int *ret, float *x, float *y);
int GWSETMRK(int *ret, int *t, float *s, int *k, int *kb, int *m);
int GWGETMRK(int *ret, int *t, float *s, int *k, int *kb, int *m);
int GWSETPEN(int *ret, int *plt, int *style, int *width, int *ROP);
int GWGETPEN(int *ret, int *plt, int *style, int *width, int *ROP);
int GWSETBRS(int *ret, int *plt, int *style, int *hatch);
int GWGETBRS(int *ret, int *plt, int *style, int *hatch);
int GWSETXFRM(int *ret, float *XFRM);
int GWGETXFRM(int *ret, float *XFRM);
int GWSETRGN(int *ret, float *x1, float *y1, float *x2, float *y2, int *m);
int GWSETBK(int *ret, int *m);
int GWCAPIMG(int *ret, int *nb, float *x1, float *y1, float *x2, float *y2);
int GWCLIPIMG(int *ret, float *x1, float *y1, float *x2, float *y2);
int GWMAKEBMP(int *ret, int *nb, int *w, int *h, int *bc, int *bits);
int GWCOPYBMP(int *ret, int *nb1, int *nb2);
int GWDELBMP(int *ret, int *nb);
int GWSETBMP(int *ret, int *nb, float *w, float *h, int *m, int *t, int *o);
int GWPUTBMP(int *ret, int *nb, float *x, float *y, int *bk);
int GWCOLOR(int *ret, int *k, int *dest);
int GWPRINT(int *ret, int *n, int *m);
int GWLDCPOS(int *ret, float *x, float *y, int *u, int *v);
int GWLDCSIZ(int *ret, float *w, float *h, int *u, int *v);
int GWPXLSIZ(int *ret, float *x, float *y);
int GWRRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *w, float *h);
int GWARC(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int GWCHORD(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int GWPIE(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int GWPOLYLIN(int *ret, float *points, int *N);
int GWPLOT1(int *ret, int *M, int *N, float *P1, float *PN, float *W, 
			float *O, float *A, float *B, float *ARRY);
int GWSETOGN(int *ret, int *s, int *d);
int GWANCHOR(int *ret, int *n);
int GWFLUSH(int *ret, int *ogn);
int GWBEGINCMB(int *ret, int *nm, float *w, float *h);
int GWENDCMB(int *ret);
int GWCMBMRK(int *ret, int *nm, int *t, float *s, int *k, int *kb, 
		int *mix);
int GWSETCMB(int *ret, int *nm, float *w, float *h, int *o);
int GWPUTCMB(int *ret, int *nm, 
		float *x, float *y, float *w, float *h, int *o);
int GWCOPYCMB(int *ret, int *nb1, int *nb2);
int GWDELCMB(int *ret, int *nb);

// tortoise graphics
int GWTSPAWN(int *ret, int *it, int *s, int *m);
int GWTTURN(int *ret, int *it, float *a);
int GWTFORWARD(int *ret, int *it, float *d);
int GWTSHIFT(int *ret, int *it, float *dx, float *dy);
int GWTMOVE2(int *ret, int *it, float *x, float *y);
int GWTCLONE(int *ret, int *it1, int *it2);
int GWTREMOVE(int *ret, int *it);
int GWTSETPOS(int *ret, int *it, float *x, float *y);
int GWTGETPOS(int *ret, int *it, float *x, float *y);
int GWTSETDIR(int *ret, int *it, float *a);
int GWTGETDIR(int *ret, int *it, float *a);
int GWTSETCOL(int *ret, int *it, int *pc);
int GWTGETCOL(int *pc, int *it);
int GWTSETPEN(int *ret, int *it, int *pc, int *ps, int *pw);
int GWTGETPEN(int *ret, int *it, int *pc, int *ps, int *pw);
int GWTSETMRK(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *mix);
int GWTGETMRK(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *m);
int GWTSETSYM(int *ret, int *it, int *m);
int GWTGETSYM(int *ret, int *it, float *w, float *h, int *c);
int GWTSETBMP(int *ret, int *it, int *b, float *w, float *h, int *x, int *t, int *o);
int GWTSETCMB(int *ret, int *it, int *c, float *w, float *h, int *o);

//function
float GWASPECT(int *n);
int KBGETCH(int *n);

// calcomp
int PLOTS(float *x, float *y, int *ld);
int PLOTE(int *dmy);
int PLOT(float *x, float *y, int *ip);
int NEWPEN(int *c);
#ifdef __WATCOMC__
int SYMBOL(float *x, float *y, float *height, CHARACTER *text, 
		float *angle, int *nchar);
#else
int SYMBOL(float *x, float *y, float *height, char *text, 
		float *angle, int *nchar, int l);
#endif
int NUMBER(float *x, float *y, 
	float *height, float *d, float *angle, int *nd);
int GCLS(int *dmy);
float GWFMAX(void);
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWINIT(int *ret);
int __stdcall GWINITX(int *bzi, int *ret, int *x, int *y, int *w, int *h, 
		int *a, int *m, int *z, int *d);
int __stdcall GWQUIT(int *ret);
int __stdcall GWQUITX(int *ret, int *mq);
int __stdcall GWSIZE(int *ret, int *n, int *w, int *h);
int __stdcall GWOPEN(int *ret, int *nDoc);
int __stdcall GWOPENX(int *ret, int *nDoc, int *Width, int *Height, 
		int *fc, int *bc, int *Mode, char *fname, int l);
int __stdcall GWLEAVE(int *ret);
int __stdcall GWJOIN(int *ret, int *nDoc, int *nWnd, int *bDo, char *str, int l);
int __stdcall GWRESET(int *ret);
int __stdcall GWCLOSE(int *ret, int *nDoc);
int __stdcall GWSELECT(int *ret, int *nDoc);
int __stdcall GWSHOWWN(int *ret, int *nDoc, int *show);
int __stdcall GWSHOWFR(int *ret, int *show);
int __stdcall GWARRANGE(int *ret, int *m);
int __stdcall GWFIRST(int *ret);
int __stdcall GWNEXT(int *ret, int *nDoc);
int __stdcall GWVPORT(int *ret, float *u1, float *v1, float *u2, float *v2);
int __stdcall GWPORT(int *ret, float *x1, float *y1, float *x2, float *y2);
int __stdcall GWGETVP(int *ret, float *u1, float *v1, float *u2, float *v2);
int __stdcall GWSETVPN(int *ret, int *vpn);
int __stdcall GWSAVEVP(int *ret, int *vpn);
int __stdcall GWINDOW(int *ret, float *x1, float *y1, float *x2, float *y2);
int __stdcall GWGETWN(int *ret, float *x1, float *y1, float *x2, float *y2);
int __stdcall GWSYSCLR(int *ret, int *index);
int __stdcall GWERASE(int *ret, int *n, int *lrf);
int __stdcall GWREFRESH(int *ret);
int __stdcall GWRVWMOD(int *ret, int *m);
int __stdcall GWMODE(int *ret, int *md, int *m);
int __stdcall GWGETPXL(int *ret, float *x, float *y);
int __stdcall GWSETPXL(int *ret, float *x, float *y, int *k);
int __stdcall GWNCOLOR(int *ret);
int __stdcall KCOLOR(int *c);
int __stdcall KRGB(int *r, int *g, int *b);
int __stdcall IPALETTE(int *c);
int __stdcall GWSETTXT(int *ret, float *h, float *a, int *o, 
		int *c, int *b, char *face, int l);
int __stdcall GWGETTXT(int *ret, float *w, float *h, float *x, float *y, 
		char *text, int l);
int __stdcall GWPUTTXT(int *ret, float *x, float *y, char *text, int l);
int __stdcall GWSETSYM(int *ret, float *h, float *a, int *o, 
		int *c, int *b, char *face, int l);
int __stdcall GWGETSYM(int *ret, float *w, float *h, int *c);
int __stdcall GWPUTSYM(int *ret, float *x, float *y, int *c);
int __stdcall GWSETMSG(int *ret, char *text, int l);
int __stdcall MSGBOX(char *text, int l);
int __stdcall GWPAUSE(int *ret, char *text, int l);
int __stdcall GWSLEEP(int *ret, int *ms);
int __stdcall GWSLEEP2(int *ret, int *ms);
int __stdcall GWCTIME(int *ret);
int __stdcall GWIDLE(int *ret, int *ch, float *x, float *y, int *ms);
int __stdcall GWIDLE2(int *ret, int *ch, float *x, float *y, int *ms);
int __stdcall GWKYBRD(int *ret, int *ch, int *cnt, int *flg, int *m);
int __stdcall GWINPUT(int *ret, char *ttl, int l1, char *str, int l);
int __stdcall GWMOUSE(int *ret, int *R, float *x, float *y);
int __stdcall GWTIMER(int *ret, int *MS, int *N);
int __stdcall GWEVENT(int *ret, float *x, float *y);
int __stdcall GWCAPPNT(int *ret, float *x, float *y, char *text, int l);
int __stdcall GWCAPLIN(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int __stdcall GWCAPRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int __stdcall GWCAPVEC(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int __stdcall GWMOVE2(int *ret, float *x, float *y);
int __stdcall GWLINE2(int *ret, float *x, float *y);
int __stdcall GWGETPOS(int *ret, float *x, float *y);
int __stdcall GWLINE(int *ret, float *x1, float *y1, float *x2, float *y2);
int __stdcall GWRECT(int *ret, float *x1, float *y1, float *x2, float *y2);
int __stdcall GWSRECT(int *ret, float *x1, float *y1, float *x2, float *y2, int *k);
int __stdcall GWELLIPSE(int *ret, float *x1, float *y1, float *x2, float *y2);
int __stdcall GWPOLYGON(int *ret, float *points, int *N, int *mf);
int __stdcall GWBEZIER(int *ret, float *points, int *N);
int __stdcall GWFLOOD(int *ret, float *x, float *y);
int __stdcall GWCLEAR(int *ret, int *k);
int __stdcall GWPUTMRK(int *ret, float *x, float *y);
int __stdcall GWSETMRK(int *ret, int *t, float *s, int *k, int *kb, int *m);
int __stdcall GWGETMRK(int *ret, int *t, float *s, int *k, int *kb, int *m);
int __stdcall GWSETPEN(int *ret, int *plt, int *style, int *width, int *ROP);
int __stdcall GWGETPEN(int *ret, int *plt, int *style, int *width, int *ROP);
int __stdcall GWSETBRS(int *ret, int *plt, int *style, int *hatch);
int __stdcall GWGETBRS(int *ret, int *plt, int *style, int *hatch);
int __stdcall GWSETXFRM(int *ret, float *XFRM);
int __stdcall GWGETXFRM(int *ret, float *XFRM);
int __stdcall GWSETRGN(int *ret, float *x1, float *y1, float *x2, float *y2, int *m);
int __stdcall GWSETBK(int *ret, int *m);
int __stdcall GWCAPIMG(int *ret, int *nb, float *x1, float *y1, float *x2, float *y2);
int __stdcall GWCLIPIMG(int *ret, float *x1, float *y1, float *x2, float *y2);
int __stdcall GWLOADBMP(int *ret, int *nb, char *fname, int l);
int __stdcall GWSAVEBMP(int *ret, int *nb, char *fname, int l);
int __stdcall GWMAKEBMP(int *ret, int *nb, int *w, int *h, int *bc, int *bits);
int __stdcall GWCOPYBMP(int *ret, int *nb1, int *nb2);
int __stdcall GWDELBMP(int *ret, int *nb);
int __stdcall GWSETBMP(int *ret, int *nb, float *w, float *h, int *m, int *t, int *o);
int __stdcall GWGETBMP(int *ret, int *nb, float *width, float *height, 
		int *w, int *h, int *nc, int *maxnb, char *fname, int l);
int __stdcall GWPUTBMP(int *ret, int *nb, float *x, float *y, int *bk);
int __stdcall GWSAVECC(int *ret, char *fname, int l);
int __stdcall GWLOADCC(int *ret, char *fname, int l);
int __stdcall GWCOLOR(int *ret, int *k, int *dest);
int __stdcall GWSAVE(int *ret, char *fname, int l);
int __stdcall GWSAVEAS(int *ret, int *format, int *viewmode, int *width, int *height, char *fname, int l);
int __stdcall GWLOAD(int *ret, int *ic, char *fname, int l);
int __stdcall GWVERSION(int *ret, int *n, char *s, int l);
int __stdcall GWPRINT(int *ret, int *n, int *m);
int __stdcall GWFILEDLG(int *ret, char *fname, int l);
int __stdcall GWFNT2BMP(int *ret, int *nb, int *w, int *h, int *u, int *v, 
			char *text, int l);
int __stdcall GWLDCPOS(int *ret, float *x, float *y, int *u, int *v);
int __stdcall GWLDCSIZ(int *ret, float *w, float *h, int *u, int *v);
int __stdcall GWPXLSIZ(int *ret, float *x, float *y);
int __stdcall GWRRECT(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *w, float *h);
int __stdcall GWARC(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int __stdcall GWCHORD(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int __stdcall GWPIE(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int __stdcall GWPOLYLIN(int *ret, float *points, int *N);
int __stdcall GWPLOT1(int *ret, int *M, int *N, float *P1, float *PN, float *W, 
			float *O, float *A, float *B, float *ARRY);
int __stdcall GWSETOGN(int *ret, int *s, int *d);
int __stdcall GWANCHOR(int *ret, int *n);
int __stdcall GWFLUSH(int *ret, int *ogn);
int __stdcall GWLOADCMB(int *ret, int *nm, char *fname, int l);
int __stdcall GWSAVECMB(int *ret, int *nm, char *fname, int l);
int __stdcall GWBEGINCMB(int *ret, int *nm, float *w, float *h);
int __stdcall GWENDCMB(int *ret);
int __stdcall GWCMBMRK(int *ret, int *nm, int *t, float *s, int *k, int *kb, 
		int *mix);
int __stdcall GWSETCMB(int *ret, int *nm, float *w, float *h, int *o);
int __stdcall GWGETCMB(int *ret, int *nm, float *width, float *height, 
		float *w, float *h, int *maxnb, char *fname, int l);
int __stdcall GWPUTCMB(int *ret, int *nm, 
		float *x, float *y, float *w, float *h, int *o);
int __stdcall GWCOPYCMB(int *ret, int *nb1, int *nb2);
int __stdcall GWDELCMB(int *ret, int *nb);

// tortoise graphics
int __stdcall GWTSPAWN(int *ret, int *it, int *s, int *m);
int __stdcall GWTTURN(int *ret, int *it, float *a);
int __stdcall GWTFORWARD(int *ret, int *it, float *d);
int __stdcall GWTSHIFT(int *ret, int *it, float *dx, float *dy);
int __stdcall GWTMOVE2(int *ret, int *it, float *x, float *y);
int __stdcall GWTCLONE(int *ret, int *it1, int *it2);
int __stdcall GWTREMOVE(int *ret, int *it);
int __stdcall GWTSETPOS(int *ret, int *it, float *x, float *y);
int __stdcall GWTGETPOS(int *ret, int *it, float *x, float *y);
int __stdcall GWTSETDIR(int *ret, int *it, float *a);
int __stdcall GWTGETDIR(int *ret, int *it, float *a);
int __stdcall GWTSETCOL(int *ret, int *it, int *pc);
int __stdcall GWTGETCOL(int *pc, int *it);
int __stdcall GWTSETPEN(int *ret, int *it, int *pc, int *ps, int *pw);
int __stdcall GWTGETPEN(int *ret, int *it, int *pc, int *ps, int *pw);
int __stdcall GWTSETMRK(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *mix);
int __stdcall GWTGETMRK(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *m);
int __stdcall GWTSETSYM(int *ret, int *it, int *m);
int __stdcall GWTGETSYM(int *ret, int *it, float *w, float *h, int *c);
int __stdcall GWTSETBMP(int *ret, int *it, int *b, float *w, float *h, int *x, int *t, int *o);
int __stdcall GWTSETCMB(int *ret, int *it, int *c, float *w, float *h, int *o);

//function
float __stdcall GWASPECT(int *n);
int __stdcall KBHIT(void);
int __stdcall KBGETCH(int *n);

// calcomp
int __stdcall PLOTS(float *x, float *y, int *ld);
int __stdcall PLOTE(int *dmy);
int __stdcall PLOT(float *x, float *y, int *ip);
int __stdcall NEWPEN(int *c);
int __stdcall SYMBOL(float *x, float *y, float *height, char *text, int l, 
		float *angle, int *nchar);
int __stdcall NUMBER(float *x, float *y, 
	float *height, float *d, float *angle, int *nd);
int __stdcall GCLS(int *dmy);
float __stdcall GWFMAX(void);
#else
int gwinit_(int *ret);
int gwinitx_(int *bzi, int *ret, int *x, int *y, int *w, int *h, 
		int *a, int *m, int *z, int *d);
int gwquit_(int *ret);
int gwquitx_(int *ret, int *mq);
int gwsize_(int *ret, int *n, int *w, int *h);
int gwopen_(int *ret, int *nDoc);
int gwopenx_(int *ret, int *nDoc, int *Width, int *Height, int *fc, int *bc, 
		int *Mode, char *fname, int l);
int gwleave_(int *ret);
int gwjoin_(int *ret, int *nDoc, int *nWnd, int *bDo, char *str, int l);
int gwreset_(int *ret);
int gwclose_(int *ret, int *nDoc);
int gwselect_(int *ret, int *nDoc);
int gwshowwn_(int *ret, int *nDoc, int *show);
int gwshowfr_(int *ret, int *show);
int gwarrange_(int *ret, int *m);
int gwfirst_(int *ret);
int gwnext_(int *ret, int *nDoc);
int gwvport_(int *ret, float *u1, float *v1, float *u2, float *v2);
int gwport_(int *ret, float *x1, float *y1, float *x2, float *y2);
int gwgetvp_(int *ret, float *u1, float *v1, float *u2, float *v2);
int gwsetvpn_(int *ret, int *vpn);
int gwsavevp_(int *ret, int *vpn);
int gwindow_(int *ret, float *x1, float *y1, float *x2, float *y2);
int gwgetwn_(int *ret, float *x1, float *y1, float *x2, float *y2);
int gwsysclr_(int *ret, int *index);
int gwerase_(int *ret, int *n, int *lrf);
int gwrefresh_(int *ret);
int gwrvwmod_(int *ret, int *m);
int gwmode_(int *ret, int *md, int *m);
int gwgetpxl_(int *ret, float *x, float *y);
int gwsetpxl_(int *ret, float *x, float *y, int *k);
int gwncolor_(int *ret);
int kcolor_(int *c);
int krgb_(int *r, int *g, int *b);
int ipalette_(int *c);
int gwsettxt_(int *ret, float *h, float *a, int *o, 
		int *c, int *b, char *face, int l);
int gwgettxt_(int *ret, float *w, float *h, float *x, float *y, 
		char *text, int l);
int gwputtxt_(int *ret, float *x, float *y, char *text, int l);
int gwsetsym_(int *ret, float *h, float *a, int *o, 
		int *c, int *b, char *face, int l);
int gwgetsym_(int *ret, float *w, float *h, int *c);
int gwputsym_(int *ret, float *x, float *y, int *c);
int gwsetmsg_(int *ret, char *text, int l);
int msgbox_(char *text, int l);
int gwpause_(int *ret, char *text, int l);
int gwsleep_(int *ret, int *ms);
int gwsleep2_(int *ret, int *ms);
int gwctime_(int *ret);
int gwidle_(int *ret, int *ch, float *x, float *y, int *ms);
int gwidle2_(int *ret, int *ch, float *x, float *y, int *ms);
int gwkybrd_(int *ret, int *ch, int *cnt, int *flg, int *m);
int gwinput_(int *ret, char *ttl, char *str, int l1, int l);
int gwmouse_(int *ret, int *R, float *x, float *y);
int gwtimer_(int *ret, int *MS, int *N);
int gwevent_(int *ret, float *x, float *y);
int gwcappnt_(int *ret, float *x, float *y, char *text, int l);
int gwcaplin_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int gwcaprect_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int gwcapvec_(int *ret, float *x1, float *y1, float *x2, float *y2, 
		char *text, int l);
int gwmove2_(int *ret, float *x, float *y);
int gwline2_(int *ret, float *x, float *y);
int gwgetpos_(int *ret, float *x, float *y);
int gwline_(int *ret, float *x1, float *y1, float *x2, float *y2);
int gwrect_(int *ret, float *x1, float *y1, float *x2, float *y2);
int gwsrect_(int *ret, float *x1, float *y1, float *x2, float *y2, int *k);
int gwellipse_(int *ret, float *x1, float *y1, float *x2, float *y2);
int gwpolygon_(int *ret, float *points, int *N, int *mf);
int gwbezier_(int *ret, float *points, int *N);
int gwflood_(int *ret, float *x, float *y);
int gwclear_(int *ret, int *k);
int gwputmrk_(int *ret, float *x, float *y);
int gwsetmrk_(int *ret, int *t, float *s, int *k, int *kb, int *m);
int gwgetmrk_(int *ret, int *t, float *s, int *k, int *kb, int *m);
int gwsetpen_(int *ret, int *plt, int *style, int *width, int *ROP);
int gwgetpen_(int *ret, int *plt, int *style, int *width, int *ROP);
int gwsetbrs_(int *ret, int *plt, int *style, int *hatch);
int gwgetbrs_(int *ret, int *plt, int *style, int *hatch);
int gwcapimg_(int *ret, int *nb, float *x1, float *y1, float *x2, float *y2);
int gwsetxfrm_(int *ret, float *XFRM);
int gwgetxfrm_(int *ret, float *XFRM);
int gwsetrgn_(int *ret, float *x1, float *y1, float *x2, float *y2, int *m);
int gwsetbk_(int *ret, int *m);
int gwclipimg_(int *ret, float *x1, float *y1, float *x2, float *y2);
int gwloadbmp_(int *ret, int *nb, char *fname, int l);
int gwsavebmp_(int *ret, int *nb, char *fname, int l);
int gwmakebmp_(int *ret, int *nb, int *w, int *h, int *bc, int *bits);
int gwcopybmp_(int *ret, int *nb1, int *nb2);
int gwdelbmp_(int *ret, int *nb);
int gwsetbmp_(int *ret, int *nb, float *w, float *h, int *m, int *t, int *o);
int gwgetbmp_(int *ret, int *nb, float *width, float *height, 
		int *w, int *h, int *nc, int *maxnb, char *fname, int l);
int gwputbmp_(int *ret, int *nb, float *x, float *y, int *bk);
int gwsavecc_(int *ret, char *fname, int l);
int gwloadcc_(int *ret, char *fname, int l);
int gwcolor_(int *ret, int *k, int *dest);
int gwsave_(int *ret, char *fname, int l);
int gwsaveas_(int *ret, int *format, int *viewmode, int *width, int *height, char *fname, int l);
int gwload_(int *ret, int *ic, char *fname, int l);
int gwversion_(int *ret, int *n, char *s, int l);
int gwprint_(int *ret, int *n, int *m);
int gwfiledlg_(int *ret, char *fname, int l);
int gwfnt2bmp_(int *ret, int *nb, int *w, int *h, int *u, int *v, 
			char *text, int l);
int gwldcpos_(int *ret, float *x, float *y, int *u, int *v);
int gwldcsiz_(int *ret, float *w, float *h, int *u, int *v);
int gwpxlsiz_(int *ret, float *x, float *y);
int gwrrect_(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *w, float *h);
int gwarc_(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int gwchord_(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int gwpie_(int *ret, float *x1, float *y1, float *x2, float *y2, 
			float *a, float *aw);
int gwpolylin_(int *ret, float *points, int *N);
int gwplot1_(int *ret, int *M, int *N, float *P1, float *PN, float *W, 
			float *O, float *A, float *B, float *ARRY);
int gwsetogn_(int *ret, int *s, int *d);
int gwanchor_(int *ret, int *n);
int gwflush_(int *ret, int *ogn);
int gwloadcmb_(int *ret, int *nm, char *fname, int l);
int gwsavecmb_(int *ret, int *nm, char *fname, int l);
int gwbegincmb_(int *ret, int *nm, float *w, float *h);
int gwendcmb_(int *ret);
int gwcmbmrk_(int *ret, int *nm, int *t, float *s, int *k, int *kb, int *mix);
int gwclosecmb_(int *ret);
int gwsetcmb_(int *ret, int *nm, float *w, float *h, int *o);
int gwgetcmb_(int *ret, int *nm, float *width, float *height, 
		float *w, float *h, int *maxnb, char *fname, int l);
int gwputcmb_(int *ret, int *nm, 
		float *x, float *y, float *w, float *h, int *o);
int gwcopycmb_(int *ret, int *nb1, int *nb2);
int gwdelcmb_(int *ret, int *nb);

// tortoise graphics
int gwtspawn_(int *ret, int *it, int *s, int *m);
int gwtturn_(int *ret, int *it, float *a);
int gwtforward_(int *ret, int *it, float *d);
int gwtshift_(int *ret, int *it, float *dx, float *dy);
int gwtmove2_(int *ret, int *it, float *x, float *y);
int gwtclone_(int *ret, int *it1, int *it2);
int gwtremove_(int *ret, int *it);
int gwtsetpos_(int *ret, int *it, float *x, float *y);
int gwtgetpos_(int *ret, int *it, float *x, float *y);
int gwtsetdir_(int *ret, int *it, float *a);
int gwtgetdir_(int *ret, int *it, float *a);
int gwtsetcol_(int *ret, int *it, int *pc);
int gwtgetcol_(int *pc, int *it);
int gwtsetpen_(int *ret, int *it, int *pc, int *ps, int *pw);
int gwtgetpen_(int *ret, int *it, int *pc, int *ps, int *pw);
int gwtsetmrk_(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *mix);
int gwtgetmrk_(int *ret, int *it, int *t, float *s, int *k, int *ks, int *kb, int *m);
int gwtsetsym_(int *ret, int *it, int *m);
int gwtgetsym_(int *ret, int *it, float *w, float *h, int *c);
int gwtsetbmp_(int *ret, int *it, int *b, float *w, float *h, int *x, int *t, int *o);
int gwtsetcmb_(int *ret, int *it, int *c, float *w, float *h, int *o);

//functions
float gwaspect_(int *n);
int kbhit_(void);
int kbgetch_(int *n);

// calcomp
int plots_(float *x, float *y, int *ld);
int plote_(int *dmy);
int plot_(float *x, float *y, int *ip);
int newpen_(int *c);
int symbol_(float *x, float *y, float *height, char *text, 
		float *angle, int *nchar, int l);
int number_(float *x, float *y, 
	float *height, float *d, float *angle, int *nd);
int gcls_(int *dmy);
float gwfmax_(void);
#endif
#endif
