/* Emf.c
 *
 * Copyright (C) 1998-2001 by TAMARIBUCHI, Tsuguhiro
 *
 *   WWW: http://sip.sci.shizuoka.ac.jp/grwin
 *
 */

#include "gw.h"


/*0
R{Et@C̓ǂݍ
*******************************************************************************
[F] SUBROUTINE GWLOADCMB(IRTN, NM, FN)
    INTEGER IRTN, NM
    CHARACTER FN*(*)

[C] int GWloadcmb(int NM, char *FN);
-------------------------------------------------------------------------------
()
    R{Et@CR{ǂݍŁCR{ԍ NM ɓo^BR{Ƃ
	g̕`IuWFNĝƂŁC쐬ꂽR{͑傫ςĉʂɉx
	`悵Ct@Cɕۑ邱ƂłBR{Et@C̓R{\
	`IuWFNgg^t@CƓt@C`ŕۑ̂ŁCf
	tHg̊gqɂ͊g^t@CƓ .emf pBUo^ꂽ
	R{͂̃R{ԍw肷邱Ƃɂ艽xłp邱ƂłBR
	{̓o^ɏ݂͐ĂȂȂC̓[CVXeE[\[X
	̗ʂɈˑBVXeE[\[Xg؂Ƃ̓ɂĂ͂قƂ
	`FbNsĂȂ̂ŗvӁB
-------------------------------------------------------------------------------
(͕ϐ)
    NM = R{ԍ(1`): ǂݍ񂾃R{ۑz̗vfԍB
         NM = 0 ƂƖgp̔zvfgB
    FN = R{Et@C(R{Et@C͎st@CƓfBNgɒu
         CtpXŎw肵Ȃ΂ȂȂ)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = R{o^ꂽzvf̔ԍBsƂ 0 ԂB
_______________________________________________________________________________
*/
/*E
Load Metafile
*******************************************************************************
[F] SUBROUTINE GWLOADCMB(IRTN, NM, FN)
    INTEGER IRTN, NM
    CHARACTER FN*(*)

[C] int GWloadcmb(int NM, char *FN);
-------------------------------------------------------------------------------
Description
    Load a combo file into a combo, a set of graphic objects, with the combo 
    number NM.   A combo file, whose default file extention is *.emf, is 
    composed of the graphic objects of a combo with the same format as an 
    enhanced-format metafile.   If NM = 0 is specified unused array element is 
    used. Maximun number of stored combos depends on amount of available system 
    resources though is not restricted.  It should be noted that no test has 
    been done for the case where available system resources are exhausted.

Input
    NM = combo number (>0) or 0 to use unused array element.
    FN = metafile name (the metafile must be in the same directory as the 
         .exe file for the application unless specified as full path).

Output
  IRTN = combo number used (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWLOADCMB "^";
int GWLOADCMB(int *ret, int *nm, CHARACTER *fname)
#else
int GWLOADCMB(int *ret, int *nm, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWLOADCMB(int *ret, int *nm, char *fname, int l)
#else
int gwloadcmb_(int *ret, int *nm, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_loadcmb(nDOC, *nm, _copyBuff(nDOC, fname->p, fname->l)));
#else
	return (*ret = GW_loadcmb(nDOC, *nm, _copyBuff(nDOC, fname, l)));
#endif
}

int GWloadcmb(int nm, char *fname)
{
	return GW_loadcmb(nDOC, nm, fname);
}

int GW_loadcmb(int nDoc, int nm, char *fname)
{
	int ret;
	FILE *fp;
	if(_setBuff(nDoc, fname) == 0) _setBuff(nDoc, "*.emf");
	if((fp = fopen(GW_Buffer(nDoc), "r"))) {
		fclose(fp);
	} else {
		if(_command1(nDoc, GW_CMD, CMD_FILE_DIALOG) != IDOK)
			return 0;
	}
	if(_command2(nDoc, GW_EMF, EMF_LOADFILE, nm) && 
		sscanf(GW_Buffer(nDoc), "%d", &ret))
		return ret;
	return 0;
}


/*0
R{tBɕۑ
*******************************************************************************
[F] SUBROUTINE GWSAVECMB(IRTN, NM, FN)
    INTEGER IRTN, NM
    CHARACTER FN*(*)

[C] int GWsavecmb(int NM, char *FN);
-------------------------------------------------------------------------------
()
    ԍ NM ̃R{R{Et@CɕۑB
-------------------------------------------------------------------------------
(͕ϐ)
    NM = R{ԍ
    FN = R{Et@C
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Save Combo as Combo File
*******************************************************************************
[F] SUBROUTINE GWSAVECMB(IRTN, NM, FN)
    INTEGER IRTN, NM
    CHARACTER FN*(*)

[C] int GWsavecmb(int NM, char *FN);
-------------------------------------------------------------------------------
Description
    Save a combo as a combo file.

Input
    NM = combo number to be saved as a combo file
    FN = combo file name

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWSAVECMB "^";
int GWSAVECMB(int *ret, int *nm, CHARACTER *fname)
#else
int GWSAVECMB(int *ret, int *nm, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWSAVECMB(int *ret, int *nm, char *fname, int l)
#else
int gwsavecmb_(int *ret, int *nm, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	return (*ret = GW_savecmb(nDOC, *nm, _copyBuff(nDOC, fname->p, fname->l)));
#else
	return (*ret = GW_savecmb(nDOC, *nm, _copyBuff(nDOC, fname, l)));
#endif
}

int GWsavecmb(int nm, char *fname)
{
	return GW_savecmb(nDOC, nm, fname);
}

int GW_savecmb(int nDoc, int nm, char *fname)
{
	if(_setBuff(nDoc, fname) == 0) _setBuff(nDoc, "*.emf");
	if(_command2(nDoc, GW_EMF, EMF_SAVEFILE, nm))
		return nDoc;
	return 0;
}


/*0
}[NR{Ƃč쐬
*******************************************************************************
[F] SUBROUTINE GWCMBMRK(IRTN, NM, MT, S, K, KB, MX)
    INTEGER IRTN, NM, MT, K, KB, MX
    REAL S

[C] int GWcmbmrk(int NM, int MT, float S, int K, int KB, int MX);
-------------------------------------------------------------------------------
()
   }[Nԍ MT(0-6)C傫 S([hWn)C}[N̘_Fԍ KC}[N
   wiF̘_Fԍ KBC[h MX Ŏw肳ꂽ}[N (GWSETMRK ̍Q) 
   R{ƂăR{ԍ NM ɓo^B}[N (GWSETMRK ̍Q) ͕
   ȂBMT, S, K, KB, MX ɕsȒlw肳ꂽꍇɂ̓}[Ňݒlg
   DNM = 0 ܂́Cw肵R{ԍ NM ̃R{gĂƂɂ́C
   gp̔ԍgB
-------------------------------------------------------------------------------
(͕ϐ)
   NM = o^]R{ԍ
   MT = 0: _
        1: 
        2: {
        3: ~
        4: {Ɓ~d˂킹
        5: 
        6: 
    S = }[N̍([hWn) >= 0.0
    K = }[N̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ̓}[Ňݒl
   KB = }[N̔wiF̘_Fԍ(GWCOLOR ̍Q)
        -1 ̏ꍇ̓}[Ňݒl
   MX = }[N̍[h(GWSETPEN ̍Q)
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ۂɓo^ꂽR{ԍBsƂ 0 Ԃ
_______________________________________________________________________________
*/
/*E
Create Mark as a Combo
*******************************************************************************
[F] SUBROUTINE GWCMBMRK(IRTN, NM, MT, S, K, KB, MX)
    INTEGER IRTN, NM, MT, K, KB, MX
    REAL S

[C] int GWcmbmrk(int NM, int MT, float S, int K, int KB, int MX);
-------------------------------------------------------------------------------
Description
   Creates a mark (see GWSETMRK) as a combo of the combo number NM with using 
   mark number MT, size S in world coordinate, logical mark color K, logical 
   background mark color KB, and the mix mode MX.  The mark attributes (see 
   GWSETMRK) are unchanged.   If a specified parameter is invalid, the 
   corresponding current mark attribute is used.  When NM = 0 or the specified 
   combo number has already in use, an available number is used.  

Input
   NM = combo number
   MT = 0: dot
        1: solid rectangle
        2: +
        3: x
        4: superposition of + and X
        5: filled rectangle
        6: filled circle
    S = height in the world coordinate >= 0.0
    K = logical mark color value (see GWCOLOR)
      = -1: the current mark color
   KB = logical mark background color value (see GWCOLOR)
      = -1: the current mark background color
   MX = mix mode for the mark (see GWSETPEN)

Output
  IRTN = the combo number used
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCMBMRK "^";
#endif
int GWCMBMRK(int *ret, int *nm, int *t, float *s, int *k, int *kb, 
		int *mix)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCMBMRK(int *ret, int *nm, int *t, float *s, int *k, int *kb, 
		int *mix)
#else
int gwcmbmrk_(int *ret, int *nm, int *t, float *s, int *k, int *kb, int *mix)
#endif
#endif
{
	return (*ret = GW_cmbmrk(nDOC, *nm, *t, WCtoLPh(*s), *k, *kb, *mix));
}

int GWcmbmrk(int nm, int t, float s, int k, int kb, int mix)
{
	return GW_cmbmrk(nDOC, nm, t, WCtoLPh(s), k, kb, mix);
}

int GW_cmbmrk(int nDoc, int nm, int t, int s, int k, int kb, int mix)
{
	int ret = 0;

	if((t < 0) || (t >= Mt_N))
		t = GW_Params(nDoc)->p.GW_Mt;

	if((s >= 0) && (GW_Params(nDoc)->p.GW_Ms != s))
		GW_Params(nDoc)->c.i.p0 = s;
	else
		GW_Params(nDoc)->c.i.p0 = GW_Params(nDoc)->p.GW_Ms;

	if((k != -1) && (GW_Params(nDoc)->p.GW_Mc != k))
		GW_Params(nDoc)->c.i.p1 = k;
	else
		GW_Params(nDoc)->c.i.p1 = GW_Params(nDoc)->p.GW_Mc;

	if((kb != -1) && (GW_Params(nDoc)->p.GW_Mb != kb))
		GW_Params(nDoc)->c.i.p2 = kb;
	else
		GW_Params(nDoc)->c.i.p2 = GW_Params(nDoc)->p.GW_Mb;

	if((mix >=0) && (GW_Params(nDoc)->p.GW_Mm != mix))
		GW_Params(nDoc)->c.i.p3 = mix;
	else
		GW_Params(nDoc)->c.i.p3 = GW_Params(nDoc)->p.GW_Mm;

	if(_command(nDoc, GW_EMF, EMF_MARK, nm, t))
		sscanf(GW_Buffer(nDoc), "%d", &ret);

	return ret;
}


/*0
R{̍쐬Jn
*******************************************************************************
[F] SUBROUTINE GWBEGINCMB(IRTN, NM, W, H)
    INTEGER IRTN, NM
    REAL W, H

[C] int GWbegincmb(int NM, float W, float H);
-------------------------------------------------------------------------------
()
    R{̍쐬JnCR{ԍ NM \񂷂BR{Ƃ͈g̕`Iu
    WFNĝƂŁC쐬ꂽR{͑傫ςĉʂɉxł`悵C
    t@Cɕۑ邱ƂłB\񂵂R{ GWENDCMB ō쐬I
    ܂ł͎gpłȂBGWBEGINCMB  GWENDCMB ̌Ăяo̊ԂɎsꂽ`施
    ߂ׂăR{֑gݍ܂C̊ԉʂɂ͉`悳ȂB
-------------------------------------------------------------------------------
(͕ϐ)
    NM = R{ԍ(1`): R{ۑz̗vfԍB
         NM = 0 ƂƖgp̔zvfgB
     W = R{̕( > 0: [hW)
     H = R{̍( > 0: [hW)
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = \񂵂R{̔zvfԍBsƂ 0 ԂB
_______________________________________________________________________________
*/
/*E
Begin Making a Combo
*******************************************************************************
[F] SUBROUTINE GWBEGINCMB(IRTN, NM, W, H)
    INTEGER IRTN, NM
    REAL W, H

[C] int GWbegincmb(int NM, float W, float H);
-------------------------------------------------------------------------------
Description
    Begins making a combo, a set of graphic objects, on memory and reserve the 
    combo number NM for later uses.   When NM = 0 an unused array element is 
    used.   The combo being made with the reserved combo number cannot be used 
    until it is successfully closed by GWENDCMB.  A combo can be used to draw 
    a set of objects as an object, and can be saved in a file.

Input
    NM = combo number (>0)
     W = width of the combo ( > 0: world coordinate)
     H = height of the combo ( > 0: world coordinate)

Output
  IRTN = the reserved combo number (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWBEGINCMB "^";
#endif
int GWBEGINCMB(int *ret, int *nm, float *w, float *h)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWBEGINCMB(int *ret, int *nm, float *w, float *h)
#else
int gwbegincmb_(int *ret, int *nm, float *w, float *h)
#endif
#endif
{
	if(*w <= 0.0f || *h <= 0.0f)
		return (*ret = GW_begincmb(nDOC, *nm, 0, 0));
	return (*ret = GW_begincmb(nDOC, *nm, WCtoLPw(*w), WCtoLPh(*h)));
}

int GWbegincmb(int nm, float w, float h)
{
	if(w <= 0.0f || h <= 0.0f)
		return GW_begincmb(nDOC, nm, 0, 0);
	return GW_begincmb(nDOC, nm, WCtoLPw(w), WCtoLPh(h));
}

int GW_begincmb(int nDoc, int nm, int w, int h)
{
	int ret;
	GW_Params(nDoc)->c.i.p0 = w;
	GW_Params(nDoc)->c.i.p1 = h;
	if(_command2(nDoc, GW_EMF, EMF_BEGIN, nm)&&
		sscanf(GW_Buffer(nDoc), "%d", &ret))
		return ret;
	return 0;
}


/*0
R{̍쐬I
*******************************************************************************
[F] SUBROUTINE GWENDCMB(IRTN)
    INTEGER IRTN

[C] int GWendcmb(void);
-------------------------------------------------------------------------------
()
    R{ւ̕`ICR{gp\ɂB
-------------------------------------------------------------------------------
(͕ϐ)
    Ȃ
-------------------------------------------------------------------------------
(o͕ϐ)
  IRTN = 쐬R{̔zvfԍ (>0)BsƂ 0 ԂB
_______________________________________________________________________________
*/
/*E
End Making a Combo
*******************************************************************************
[F] SUBROUTINE GWENDCMB(IRTN)
    INTEGER IRTN

[C] int GWendcmb(void);
-------------------------------------------------------------------------------
Description
    Ends making a combo and makes the combo available for drawings.

Input
    none

Output
  IRTN = the number (>0) of the generated combo, or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWENDCMB "^";
#endif
int GWENDCMB(int *ret)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWENDCMB(int *ret)
#else
int gwendcmb_(int *ret)
#endif
#endif
{
	return (*ret = GW_endcmb(nDOC));
}

int GWendcmb(void)
{
	return GW_endcmb(nDOC);
}

int GW_endcmb(int nDoc)
{
	return _command1(nDoc, GW_EMF, EMF_END);
}


/*1
R{̕`
*******************************************************************************
[F] SUBROUTINE GWPUTCMB(IRTN, NM, X, Y, W, H, IOF)
    INTEGER IRTN, NM, IOF
    REAL X, Y, W, H

[C] int GWputcmb(int NM, float X, float Y, float W, float H, int IOF);
-------------------------------------------------------------------------------
()
    w肳ꂽo^ς݃R{ NM ʒu (X, Y) ɁC WC H ŕ`悷
    BW = 0.0 ܂ H = 0.0 ̏ꍇɂ͍쐬̑傫ŕ`悳BIOF ɂ 
    (X, Y) Ŏw肷_ǂɒuw肷B
-------------------------------------------------------------------------------
(͕ϐ)
    NM = R{ԍB
     X = _ X W([hWn)B
     Y = _ Y W([hWn)B
     W = ʏ̕([hWn)B
     H = ʏ̍([hWn)B
   IOF = _̈ʒuw肷
       = 0:  (ftHg)
       = 1: 
       = 2: E
       = 3: E
       = 4: 
       = 5: 
       = 6: 
       = 7: E
       = 8: 

-------------------------------------------------------------------------------
(o͕ϐ)
   IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Draw Combo
*******************************************************************************
[F] SUBROUTINE GWPUTCMB(IRTN, NM, X, Y, W, H, IOF)
    INTEGER IRTN, NM, IOF
    REAL X, Y, W, H

[C] int GWputcmb(int NM, float X, float Y, float W, float H, int IOF);
-------------------------------------------------------------------------------
Description
    Draws a stored combo NM at the point (X, Y) with the width W and the 
    height H.  If W == 0.0 or H == 0.0 the corresponding size on generated are 
    used.  The parameter IOF specifies the reference point of the bit map. 

Input
    NM = combo number to be drawn
     X = the world x-coordinate of the reference point of the combo
     Y = the world y-coordinate of the reference point of the combo
     W = width of the bitmap in the world coordinate system
     H = height of the bitmap in the world coordinate system
   IOF = set the reference point at
       = 0: center (default)
       = 1: bottom-left
       = 2: bottom-right
       = 3: top-right
       = 4: top-left
       = 5: left
       = 6: bottom
       = 7: right
       = 8: top

Output
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWPUTCMB "^";
#endif
int GWPUTCMB(int *ret, int *nm, float *x, float *y, float *w, float *h, int *o)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWPUTCMB(int *ret, int *nm, float *x, float *y, float *w, float *h, int *o)
#else
int gwputcmb_(int *ret, int *nm, float *x, float *y, float *w, float *h, int *o)
#endif
#endif
{
	return (*ret = GWputcmb(*nm, *x, *y, *w, *h, *o));
}

int GWputcmb(int nm, float x, float y, float w, float h, int o)
{
	int iw, ih;

	if(w > 0.0)
		iw = WCtoLPw(w);
	else if(w < 0.0)
		iw = -WCtoLPw(-w);
	else
		iw = 0;

	if(h > 0.0)
		ih = WCtoLPh(h);
	else if(h < 0.0)
		ih = -WCtoLPh(-h);
	else
		ih = 0;

	return GW_putcmb(nDOC, nm, WCtoLPx(x), WCtoLPy(y), iw, ih, o);
}

int GW_putcmb(int nDoc, int nm, int x, int y, int w, int h, int o)
{
	if(nm >= 0) (GW_Params(nDoc)->p.GW_Fn) = nm;
	if(o >= 0) (GW_Params(nDoc)->p.GW_Fo) = o;
	GW_Params(nDoc)->c.i.p0 = w;
	GW_Params(nDoc)->c.i.p1 = h;
	return (_command(nDoc, GW_GENDOTOOL, TOOL_EMF, x, y));
}


/*0
R{̑擾
*******************************************************************************
[F] SUBROUTINE GWGETCMB(IRTN, NM, W, H, W0, H0, MAXNM, FN)
    INTEGER IRTN, NM, MAXNM
    CHARACTER FN*(*)
    REAL W, H, W0, H0

[C] int GWgetcmb(int NM, float *W, float *H, float *W0, float *H0, 
		int *MAXNM, char *FN, int l);
-------------------------------------------------------------------------------
()
    o^ς݃R{̑擾BNM ɖo^C邢͕sȃR{ԍw
    ꂽꍇɂ MAXNM ɗLȒlԂB
-------------------------------------------------------------------------------
(͕ϐ)
    NM = 擾R{̔ԍ (>0)B
     l = char ϐ FN ̒ ([C])
-------------------------------------------------------------------------------
(o͕ϐ)
     W = `掞̃R{̕([hW)B
     H = `掞̃R{̍([hW)B
    W0 = ^t@CƂĂ̕(mm)B
    H0 = ^t@CƂĂ̍(mm)B
 MAXNM = o^ς݃R{ԍ̍őlB
    FN = ^t@CB FN == NULL ([C]) ܂ FN ̒\łȂꍇ
    B
  IRTN = ^[ER[h
_______________________________________________________________________________
*/
/*E
Get Attributes of Combo
*******************************************************************************
[F] SUBROUTINE GWGETCMB(IRTN, NM, W, H, W0, H0, MAXNM, FN)
    INTEGER IRTN, NM, MAXNM
    CHARACTER FN*(*)
    REAL W, H, W0, H0

[C] int GWgetcmb(int NM, float *W, float *H, float *W0, float *H0, 
		int *MAXNM, char *FN, int l);
-------------------------------------------------------------------------------
Description
    Gets attributes of a combo.  If an unregistered or invalid value is 
    specified for NM, only the value of MAXNM is returned.

Input
    NM = combo number (>0).
     l = length of the char variable FN ([C])

Output
     W = width of the combo in the world coordinate
     H = height of the combo in the world coordinate
    W0 = width of the combo in mm as a metafile
    H0 = height of the combo in mm as a metafile
 MAXNM = maximum combo number of stored combos
    FN = metafile name.  If FN == NULL ([C]) or the length of the FN is 
    insufficient to retrieve the file name, no value returns.
  IRTN = return code
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWGETCMB "^";
int GWGETCMB(int *ret, int *nm, float *width, float *height, 
		float *w, float *h, int *maxnb, CHARACTER *fnm)
#else
int GWGETCMB(int *ret, int *nm, float *width, float *height, 
		float *w, float *h, int *maxnb, char *fname, int l)
#endif
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWGETCMB(int *ret, int *nm, float *width, float *height, 
		float *w, float *h, int *maxnb, char *fname, int l)
#else
int gwgetcmb_(int *ret, int *nm, float *width, float *height, 
		float *w, float *h, int *maxnb, char *fname, int l)
#endif
#endif
{
#ifdef __WATCOMC__
	int i, l;
	char *fname = NULL;
	l = sizeof(char)*fnm->l + 1;
	if(l > 2) 	// '' forbidden on WATCOM Fortran
		fname = (char*)malloc(l);
	else
		l = 0;
	*ret = GWgetcmb(*nm, width, height, w, h, maxnb, fname, l);
	if(fname) {
		strncpy(fnm->p, fname, l-1);
		free(fname);
		i = strlen(fnm->p);
		while(i < l)
			fnm->p[i++] = ' ';
	}
	return *ret;
#else
	int i;
	if(l == 0) fname = NULL;
	*ret = GWgetcmb(*nm, width, height, w, h, maxnb, fname, l);
	if(fname) {
		i = strlen(fname);
		while(i < l)
			fname[i++] = ' ';
	}
	return *ret;
#endif
}

int GWgetcmb(int nm, float *width, float *height, 
	float *w, float *h, int *maxnb, char *fname, int l)
{
	int ret, w1 = 0, h1 = 0, w0 = 0, h0 = 0, 
		*w1p = NULL, *h1p = NULL, *w0p = NULL, *h0p = NULL;
	if(width) w1p = &w1;
	if(height) h1p = &h1;
	if(w) w0p = &w0;
	if(h) h0p = &h0;
	ret = GW_getcmb(nDOC, nm, w1p, h1p, w0p, h0p, maxnb, fname, l);
	if(ret) {
		GW_asgn(width, LPtoWCw(w1));
		GW_asgn(height, LPtoWCh(h1));
		GW_asgn(w, w0/100.0f);
		GW_asgn(h, h0/100.0f);
	}
	return ret;
}

int GW_getcmb(int nDoc, int nm, int *width, int *height, 
	int *mw, int *mh, int *maxnb, char *fname, int l)
{
	int ret;
	if((ret = _command2(nDoc, GW_EMF, EMF_ATTR, nm))) {
		GW_asgn(width, GW_Params(nDoc)->x);
		GW_asgn(height, GW_Params(nDoc)->y);
		GW_asgn(mw, GW_Params(nDoc)->c.i.p0);
		GW_asgn(mh, GW_Params(nDoc)->c.i.p1);
		if(fname) {
			if(l > (int)strlen(GW_Buffer(nDoc))) 
				strcpy(fname, GW_Buffer(nDoc));
			else
				ret = 0;
		}
	}
	GW_asgn(maxnb, GW_Params(nDoc)->c.i.p3);
	return ret;
}


/*0
ۑR{̃Rs[o^
*******************************************************************************
[F] SUBROUTINE GWCOPYCMB(IRTN, NM1, NM2)
    INTEGER IRTN, NM1, NM2

[C] int GWcopycmb(int NM1, int NM2);
-------------------------------------------------------------------------------
()
    R{ԍ NM1 (0 ` MAXNM)ɓo^ĂR{R{ԍ NM2 ɍēo^
    B
-------------------------------------------------------------------------------
(͕ϐ)
  NM1 = o^̃R{ԍ
  NM2 = o^̃R{ԍBNM = 0 ƂƖgp̔zvfgB
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ۂɓo^ꂽR{ԍB
_______________________________________________________________________________
*/
/*E
Copy Stored Combo
*******************************************************************************
[F] SUBROUTINE GWCOPYCMB(IRTN, NM1, NM2)
    INTEGER IRTN, NM1, NM2

[C] int GWcopycmb(int NM1, int NM2);
-------------------------------------------------------------------------------
Description
    Copy stored combo of the combo number NM1 to a combo with combo number NM2.

Input
  NM1 = combo number of the combo to be copied
  NM2 = destination combo number (>0), or NM = 0 for using unused array 
        element.
Output
  IRTN = combo number used (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWCOPYCMB "^";
#endif
int GWCOPYCMB(int *ret, int *nb1, int *nb2)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWCOPYCMB(int *ret, int *nb1, int *nb2)
#else
int gwcopycmb_(int *ret, int *nb1, int *nb2)
#endif
#endif
{
	return (*ret = GW_copycmb(nDOC, *nb1, *nb2));
}

int GWcopycmb(int nb1, int nb2)
{
	return GW_copycmb(nDOC, nb1, nb2);
}

int GW_copycmb(int nDoc, int nb1, int nb2)
{
	int ret;
	if(_command(nDoc, GW_EMF, EMF_COPY, nb1, nb2) && 
		sscanf(GW_Buffer(nDoc), "%d", &ret) == 1)
		return ret;
	return 0;
}


/*0
R{̓o^폜
*******************************************************************************
[F] SUBROUTINE GWDELCMB(IRTN, NM)
    INTEGER IRTN, NM

[C] int GWdelcmb(int NM);
-------------------------------------------------------------------------------
()
    R{ԍ NM (0 ` MAXNM) ̃R{̓o^폜Bw肳ꂽR{ԍ
    gp̏ꍇ͉ȂB
-------------------------------------------------------------------------------
(͕ϐ)
  NM = 폜R{̔ԍ
-------------------------------------------------------------------------------
(o͕ϐ)
 IRTN = ۂɍ폜ꂽR{̔ԍB
_______________________________________________________________________________
*/
/*E
Delete Combo
*******************************************************************************
[F] SUBROUTINE GWDELCMB(IRTN, NM)
    INTEGER IRTN, NM

[C] int GWdelcmb(int NM);
-------------------------------------------------------------------------------
Description
    Deletes stored combo of the combo number NM.   If the spesified combo 
    number is not used, nothing is done.

Input
  NM = combo number of the combo to be deleted

Output
  IRTN = combo number deleted (>0), or 0 if failed.
_______________________________________________________________________________
*/

#if defined(__INTEL_COMPILER) || defined(__WATCOMC__)
#ifdef __WATCOMC__
#pragma aux GWDELCMB "^";
#endif
int GWDELCMB(int *ret, int *nb)
#else
#if defined(_MSC_VER) && !defined(__F2C__)
int __stdcall GWDELCMB(int *ret, int *nb)
#else
int gwdelcmb_(int *ret, int *nb)
#endif
#endif
{
	return (*ret = GW_delcmb(nDOC, *nb));
}

int GWdelcmb(int nb)
{
	return GW_delcmb(nDOC, nb);
}

int GW_delcmb(int nDoc, int nb)
{
	int ret;
	if(_command2(nDoc, GW_EMF, EMF_DEL, nb) && 
		sscanf(GW_Buffer(nDoc), "%d", &ret) == 1)
		return ret;
	return 0;
}
