static const char *RcsId = "$Header: /mntdirect/_segfs/tango/tools/pogo/templates/tango2/cpp/RCS/DevServClass.cpp,v 1.2 2001/04/24 13:50:41 verdier Exp verdier $";
//+=============================================================================
//
// file :        TemplateDevServClass.cpp
//
// description : C++ source for the TemplateDevServClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the TemplateDevServ once per process.
//
// project :     TANGO Device Server
//
// $Author: verdier $
//
// $Revision: $
//
// $Log: DevServClass.cpp,v $
//
// copyleft :   European Synchrotron Radiation Facility
//              BP 220, Grenoble 38043
//              FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//             (c) - Pascal Verdier - ESRF
//=============================================================================


#include <tango.h>

#include <TemplateDevServ.h>
#include <TemplateDevServClass.h>


namespace TemplateDevServ
{

TemplateBlock
//+----------------------------------------------------------------------------
//
// method : 		DevTemplateCmd::DevTemplateCmd()
// 
// description : 	constructor for the command of the TemplateDevServ.
//
// In : - name : The command name
//		- in : The input parameter type
//		- out : The output parameter type
//		- in_desc : The input parameter description
//		- out_desc : The output parameter description
//
//-----------------------------------------------------------------------------
DevTemplateCmd::DevTemplateCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out,
								const char		*in_desc,
				       			const char		*out_desc )
:Command(name,in,out,in_desc,out_desc)
{
}
//
//	Constructor without in/out parameters description
//
DevTemplateCmd::DevTemplateCmd(	const char		*name,
								Tango::CmdArgType in,
				       			Tango::CmdArgType out)
:Command(name,in,out)
{
}

TemplateBlock
//+----------------------------------------------------------------------------
//
// method : 		DevTemplateCmd::is_allowed()
// 
// description : 	method to test whether command is allowed or not in this
//			state. In this case, the command is allowed only if
//			the device is in ON state
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns :	boolean - true == is allowed , false == not allowed
//
//-----------------------------------------------------------------------------
bool DevTemplateCmd::is_allowed(Tango::DeviceImpl *device, const CORBA::Any &in_any)
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}

TemplateBlock
//+----------------------------------------------------------------------------
//
// method : 		DevTemplateCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevTemplateCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevTemplateCmd::execute(): arrived" << endl;

	extract(in_any, argin);

	return insert((static_cast<TemplateDevServ *>(device))->dev_template_cmd(argin));
}


TemplateBlock



//
//----------------------------------------------------------------
//	Initialize pointer for singleton pattern
//----------------------------------------------------------------
//
TemplateDevServClass *TemplateDevServClass::_instance = NULL;

//+----------------------------------------------------------------------------
//
// method : 		TemplateDevServClass::TemplateDevServClass(string &s)
// 
// description : 	constructor for the TemplateDevServClass
//
// in : - s : The class name
//
//-----------------------------------------------------------------------------
TemplateDevServClass::TemplateDevServClass(string &s):DeviceClass(s)
{

	cout2 << "Entering TemplateDevServClass constructor" << endl;
	
	cout2 << "Leaving TemplateDevServClass constructor" << endl;

}

//+----------------------------------------------------------------------------
//
// method : 		TemplateDevServClass::instance
// 
// description : 	Create the object if not already done. Otherwise, just
//			return a pointer to the object
//
// in : - name : The class name
//
//-----------------------------------------------------------------------------
TemplateDevServClass *TemplateDevServClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new TemplateDevServClass(s);
		}
		catch (bad_alloc)
		{
			throw;
		}		
	}		
	return _instance;
}

TemplateDevServClass *TemplateDevServClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}

//+----------------------------------------------------------------------------
//
// method : 		TemplateDevServClass::command_factory
// 
// description : 	Create the command object(s) and store them in the 
//			command list
//
//-----------------------------------------------------------------------------
void TemplateDevServClass::command_factory()
{
	command_list.push_back(new DevTemplateCmd("DevReadPosition",
						      Tango::DEV_LONG,
						      Tango::DEV_LONG,
						      "Motor number (0-7)",
						      "Motor position"));
}

//+----------------------------------------------------------------------------
//
// method : 		TemplateDevServClass::device_factory
// 
// description : 	Create the device object(s) and store them in the 
//			device list
//
// in :		Tango::DevVarStringArray *devlist_ptr : The device name list
//
//-----------------------------------------------------------------------------
void TemplateDevServClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{
	
	for (long i = 0;i < devlist_ptr->length();i++)
	{
		cout4 << "Device name : " << (*devlist_ptr)[i] << endl;
						
		// Create device and add it into the device list
		//----------------------------------------------------
		device_list.push_back(new TemplateDevServ(this, (*devlist_ptr)[i]));							 

		// Export device to the outside world
		//----------------------------------------------------
		export_device(device_list.back());
	}
}

}	//	namespace TemplateDevServ
