// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_SEQ_CONVERTER_H
#define OB_SEQ_CONVERTER_H

#include <OB/Basic.h>

namespace OB
{

//
// Copy from a CORBA sequence mapping to an OutputIterator
//
template<class Sequence, class OutputIterator>
void copy_from_seq(const Sequence& sequence, OutputIterator iterator)
{
    for(CORBA::ULong i = 0 ; i < sequence.length() ; i++, iterator++) 
    {
        *iterator = sequence[i];
    }
}

//
// Copy a range to a CORBA sequence mapping. The sequence must be large
// enough to hold all the elements in the range.
//
template<class InputIterator, class Sequence>
void copy_to_seq(InputIterator first, InputIterator last, Sequence& sequence)
{
    CORBA::ULong i = 0;

    while(first != last) 
    {
        sequence[i] = *first;
        first++;
        i++;
    }
}

//
// Remove an item from a sequence
//
template<class Seq>
void remove_seq_item(Seq& seq, CORBA::ULong n)
{
    CORBA::ULong i, j;

    for(i = 0, j = 0; i < seq.length(); i++, j++) {
        if(i == n)
	    j--;
        else if(i > n)
            seq[j] = seq[i];
    }

    seq.length(j);
}


} // End of namespace OB

#endif
