// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_VALUE_FACTORY_BASE_H
#define OB_VALUE_FACTORY_BASE_H

#include <OB/ValueFactoryBase_fwd.h>
#include <OB/ValueBase_fwd.h>

namespace CORBA
{

class ValueFactoryBase : public virtual OB::RefCount
{
    virtual ValueBase* create_for_unmarshal() = 0;
    friend class CORBA::ValueBase;

protected:

    ValueFactoryBase();

public:

    virtual ~ValueFactoryBase();
    virtual void _add_ref();
    virtual void _remove_ref();

    static ValueFactoryBase* _downcast(ValueFactoryBase*);

    struct BooleanValue
    {
        BooleanValue(Boolean b) : value(b) {}
        Boolean value;
    };

    struct CharValue
    {
        CharValue(Char c) : value(c) {}
        Char value;
    };

    struct OctetValue
    {
        OctetValue(Octet o) : value(o) {}
        Octet value;
    };

    struct WCharValue
    {
        WCharValue(WChar wc) : value(wc) {}
        WChar value;
    };
};

typedef ValueFactoryBase* ValueFactory;

} // End of namespace CORBA

#endif
