// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef TYPED_EVENT_SERVICE_H
#define TYPED_EVENT_SERVICE_H

#include <OB/OBTypedEventChannelFactory.h>

//
// Forward declarations
//
class TypedEventChannelFactory_impl;
class Reaper;
typedef JTCHandleT< Reaper > ReaperHandle;

namespace OB
{

//
// This class encapsulates the typed event service
// 
class TypedEventService
{
    //
    // No copy constructor/assignment operator.
    //
    TypedEventService(const TypedEventService&);
    void operator=(const TypedEventService&);

    //
    // My ORB
    //
    CORBA::ORB_var orb_;

    //
    // My POA
    //
    PortableServer::POA_var poa_;

    //
    // The typed event channel factory
    //
    TypedEventChannelFactory_impl* channelFactory_;

    //
    // My proxy reaper
    //
    ReaperHandle reaper_;

    //
    // Are we initialized?
    //
    bool initialized_;

public:

    TypedEventService(CORBA::ORB_ptr, PortableServer::POA_ptr);
    ~TypedEventService();

    //
    // Initialize the event service
    //
    void initialize();

    //
    // Get typed event channel factory
    //
    OBTypedEventChannelFactory::TypedEventChannelFactory_ptr
    typedEventChannelFactory();
};

} // End of namespace OB

#endif
