// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_TYPE_CODE_CONST_H
#define OB_TYPE_CODE_CONST_H

#include <OB/TypeCode_fwd.h>

namespace OB
{

class TypeCodeConst : public JTCMutex
{
    TypeCodeConst(const TypeCodeConst&);
    void operator=(const TypeCodeConst&);

    CORBA::TypeCode_var typeCode_;
    const char* str_;
    const char** arr_;

public:

    TypeCodeConst(const char* s) : str_(s), arr_(0) { }
    TypeCodeConst(const char** arr) : str_(0), arr_(arr) { }
    ~TypeCodeConst();

    operator CORBA::TypeCode_ptr();
    CORBA::TypeCode_ptr operator->()
    { return operator CORBA::TypeCode_ptr(); }
};

} // End of namespace OB

#endif
