// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_STUB_IMPL_H
#define OB_STUB_IMPL_H

#include <OB/TypeCodeConst.h>
#include <OB/Object_fwd.h>
#include <OB/StubImpl_fwd.h>
#include <OB/RefCounted_fwd.h>
#include <OB/IFR2_fwd.h>
#include <OB/OCIClient_fwd.h>

#include <OB/Except.h>

namespace OB
{

//
// The StubImplBase class
//
class StubImplBase : public RefCount
{
    //
    // Hide copy-constructor and assignment operator
    //
    StubImplBase(const StubImplBase&);
    void operator=(const StubImplBase&);
    
public:

    StubImplBase() { }
    virtual ~StubImplBase() { }

    static inline StubImplBase_ptr _duplicate(StubImplBase_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline StubImplBase_ptr _nil()
    { return 0; }

    virtual CORBA::InterfaceDef_ptr _get_interface() = 0;
    virtual CORBA::Boolean _is_a(const char*) = 0;
    virtual CORBA::Boolean _non_existent() = 0;
    virtual CORBA::Boolean _locate_request() = 0;

    virtual OCI::ConnectorInfo_ptr _get_oci_connector_info() = 0;
    virtual OCI::TransportInfo_ptr _get_oci_transport_info() = 0;
};

} // End of namespace OB

namespace CORBA
{

inline void
release(OB::StubImplBase_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(OB::StubImplBase_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
