// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_PRINCIPAL_H
#define OB_PRINCIPAL_H

#include <OB/Principal_fwd.h>

namespace CORBA
{

//
// The Principal class
//
class Principal : public OB::RefCount
{
    //
    // Hide copy-constructor and assignment operator
    //
    Principal(const Principal&);
    void operator=(const Principal&);

protected:

    Principal() { };

public:

    //
    // Standard IDL to C++ Mapping
    //
    static inline Principal_ptr _duplicate(Principal_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline Principal_ptr _nil()
    { return 0; }
};

inline void
release(Principal_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(Principal_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
