// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef __OB_POAServantActivator_skel_h__
#define __OB_POAServantActivator_skel_h__

#include <OB/POAServantActivator.h>

#include <OB/POAServantManager_skel.h>
#include <OB/POACommon_skel.h>
#include <OB/LocalObject.h>

namespace POA_PortableServer
{

//
// A delegation class so that _this() can work with non reference
// counted servants.
//
class ServantActivatorDelegate;
typedef ServantActivatorDelegate* ServantActivatorDelegate_ptr;

}

void OBDuplicate(POA_PortableServer::ServantActivatorDelegate_ptr);
void OBRelease(POA_PortableServer::ServantActivatorDelegate_ptr);

namespace POA_PortableServer
{

typedef OB::ObjVar<ServantActivatorDelegate> ServantActivatorDelegate_var;

}

namespace POA_PortableServer
{

class ServantActivator : virtual public PortableServer::ServantActivator,
		         virtual public PortableServer::ServantBase,
			 virtual public OBCORBA::LocalObjectBase
{
    ServantActivator(const ServantActivator&);
    void operator=(const ServantActivator&);

    ServantActivatorDelegate_var delegate_;

public:

    ServantActivator();
    ~ServantActivator();

    PortableServer::ServantActivator_ptr _this();

    //
    // ServantBase methods
    //
    virtual CORBA::RepositoryId
    _primary_interface(const PortableServer::ObjectId&,
		       PortableServer::POA_ptr);

    virtual void
    _OB_dispatch(OB::Upcall_ptr);
};

} // End of namespace POA_PortableServer

#endif
