// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_ORB_INIT_H
#define OB_ORB_INIT_H

#include <OB/OBORB_fwd.h>
#include <OB/Properties_fwd.h>
#include <OB/Logger_fwd.h>
#include <OB/Reactor_fwd.h>

namespace CORBA
{

//
// ORB initialization
//
ORB_ptr ORB_init(int&, char**, const char* = "", const char* = OB_VERSION);

typedef char* ORBid;

} // End of namespace CORBA

namespace OBCORBA
{

//
// Proprietary ORBacus ORB_init calls
//
OBCORBA::ORB_ptr
ORB_init(int&, char**, OB::Properties_ptr, OB::Logger_ptr,
	 OB::Reactor_ptr = 0, const char* = "", const char* = OB_VERSION);

OBCORBA::ORB_ptr
ORB_init(int&, char**, OB::Properties_ptr, const char* = "",
	 const char* = OB_VERSION);

} // End of namespace OBCORBA

namespace OB
{

//
// Consume command line arguments and populate the given property set
//
void
ParseArgs(int&, char**, Properties_ptr, Logger_ptr = 0);

} // End of namespace OB

#endif
