// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_OCI_INIT_H
#define OB_OCI_INIT_H

#include <OB/OCIClient_fwd.h>
#include <OB/OBORB_fwd.h>

namespace OCI
{

//
// Prototype for the OCI version check function
//
typedef void (*CHECK)(CORBA::ORB_ptr, const char*);

//
// Prototype for the OCI initialization function
//
typedef Plugin_ptr (*INIT)(CORBA::ORB_ptr, int&, char**);

//
// Register the initialization function for an OCI plugin with the
// given name (e.g., "iiop")
//
void register_plugin(const char*, INIT init);

//
// For internal use only
//
INIT lookup_plugin(const char*);

} // End of namespace OCI

#endif
