// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************
 
#ifndef NAMING_SERVICE_H
#define NAMING_SERVICE_H

#include <OB/OBNaming.h>
#include <OB/Hashtable.h>
#include <OB/ObjectIdHasher.h>

//
// Forward declarations
//
namespace CosNaming
{

class NamingDatabase;
typedef OB::SynchronizedHashtable< PortableServer::ObjectId,
		                   CosNaming::NamingContext_ptr,
    		                   OBPortableServer::ObjectIdHasher
		                 > NamingContextSet;

} // End of namespace CosNaming

namespace OB
{

//
// The structure contains the naming service options
//
struct NamingServiceOptions
{
    //
    // The naming service trace level
    //
    CORBA::ULong traceLevel;

    //
    // Disable automatic updates?
    //
    bool noUpdates;

    //
    // Timeout in seconds used for the ORBacus timeout policy
    //
    int callbackTimeout;

    //
    // Database file name used by a persistent server
    //
    // For a non-persistent server, this member must be left
    // uninitialized.
    //
    CORBA::String_var databaseName;

    //
    // Database modes for a persistent server
    //
    enum DatabaseMode
    {
	CreateNew,
	OpenExisting,
	OpenOrCreate
    };

    //
    // Database mode used by a persistent server
    //
    DatabaseMode databaseMode;

    //
    // Timeout in minutes in which a persistent server compacts
    // its database
    //
    int databaseTimeout;
};

//
// This class encapsulates the naming service
// 
class NamingService
{
    //
    // No copy constructor/assignment operator.
    //
    NamingService(const NamingService&);
    void operator=(const NamingService&);

    //
    // My ORB
    //
    CORBA::ORB_var orb_;

    //
    // My root context POA
    //
    PortableServer::POA_var rootContextPOA_;

    //
    // My context POA
    //
    PortableServer::POA_var contextPOA_;

    //
    // My set of naming contexts
    //
    CosNaming::NamingContextSet* ncs_;

    //
    // My naming service database
    //
    CosNaming::NamingDatabase* store_;

    //
    // My timeout policy
    //
    CORBA::PolicyList* timeoutPolicy_;

    //
    // My root naming context
    //
    CosNaming::NamingContext_var root_;

    //
    // The naming service options
    //
    NamingServiceOptions options_;

    //
    // Are we initialized?
    //
    bool initialized_;

public:

    NamingService(CORBA::ORB_ptr, PortableServer::POA_ptr,
    		  PortableServer::POA_ptr, const NamingServiceOptions&);
    ~NamingService();

    //
    // Get the default options
    //
    // Defaults:
    //  traceLevel      = 0
    //  noUpdate        = false
    //  callbackTimeout = 5
    //  databaseName    = null
    //  databaseMode    = OpenExisting
    //  databaseTimeout = 5
    //
    static NamingServiceOptions defaultOptions();

    //
    // Initialize the naming service
    //
    void initialize();

    //
    // Get the root naming context
    //
    CosNaming::NamingContext_ptr rootNamingContext();
};

} // End of namespace OB

#endif
