// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_INS_H
#define OB_INS_H

#include <OB/Any.h>
#include <OB/TypeCodeConst.h>
#include <OB/OCITypes.h>

namespace OB
{

//
// This class parses the fields of an CORBANAME stringified name. Pass
// as string or octet sequence to the constructor. The isValid()
// method determines if the path is a valid stringified name. The
// getContents() method returns a string sequence of {id, kind} pairs.
//
class CORBANameParser
{
    OCI::ObjectKey path_;
    CORBA::ULong curr_;
    char terminator_;

    OB::StrSeq< int > contents_;
    bool valid_;

    char* next();

    bool atEnd() const;

    char terminator() const;

    void parse();
    
public:

    CORBANameParser(const OCI::ObjectKey&);
    CORBANameParser(const char*);

    bool isValid() const;

    const OB::StrSeq< int >& getContents() const;
};

} // End namespace OB

#endif
