// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_CONTEXT_H
#define OB_CONTEXT_H

#include <OB/Context_fwd.h>
#include <OB/NamedValue_fwd.h>
#include <OB/AnyDeclaration.h>
#include <OB/Hashtable.h>

namespace OBCORBA
{

class ORB_impl; // For the friend declaration

} // End namespace OBCORBA

namespace CORBA
{

//
// The Context class
//
class Context : public OB::RefCount
{
    String_var name_;
    Context_var parent_;

    typedef OB::Hashtable<String_var, String_var, OB::StringHasher> ValueHash;
    ValueHash values_;

    // OB_STL::list<String_var> values_;
    // OB::SeqVar< OB::StrSeq< int > > values_;

    //
    // Hide copy-constructor and assignment operator
    //
    Context(const Context&);
    void operator=(const Context&);

protected:

    Context(const char*);
    Context(const char*, Context_ptr);
    friend class ::OBCORBA::ORB_impl; // ORB_impl creates Context
    
public:

    //
    // Standard IDL to C++ Mapping
    //
    static inline Context_ptr _duplicate(Context_ptr p)
    { if(p) p -> _OB_incRef(); return p; }
    static inline Context_ptr _nil()
    { return 0; }

    const char* context_name() const { return name_; }
    Context_ptr parent() const { return parent_; }

    void create_child(const char*, Context_out);

    void set_one_value(const char*, const Any&);
    void set_values(NVList_ptr);
    void delete_values(const char*);
    void get_values(const char*, Flags, const char*, NVList_out);

    //
    // ORBacus internal functions
    // Application programs must not use these functions directly
    //
    void _OB_getValues(const char*, Flags, const char*, OB::StrSeq< int >&);
    static Context* _OB_create(const OB::StrSeq< int >&);
};

inline void
release(Context_ptr p)
{
    if(p)
	p -> _OB_decRef();
}

inline Boolean
is_nil(Context_ptr p)
{
    return p == 0;
}

} // End of namespace CORBA

#endif
