// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_CODE_CONVERTERS_H
#define OB_CODE_CONVERTERS_H

namespace OB
{

//
// Declare CodeConverterBase
//
class CodeConverterBase;

//
// The CodeConverters struct
//
struct CodeConverters
{
    CodeConverterBase* inputCharConverter;
    CodeConverterBase* outputCharConverter;
    CodeConverterBase* inputWcharConverter;
    CodeConverterBase* outputWcharConverter;

    //
    // Equality check
    //
    bool equal(const CodeConverters& other) const
    {
        return inputCharConverter == other.inputCharConverter &&
	    outputCharConverter == other.outputCharConverter &&
	    inputWcharConverter == other.inputWcharConverter &&
	    outputWcharConverter == other.outputWcharConverter;
    }
};

} // End of namespace OB

#endif
