// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// *********************************************************************

#ifndef __OB_BalancerUtil_init_h__
#define __OB_BalancerUtil_init_h__

#include <OB/BalancerUtil.h>

//
// IDL:ooc.com/LoadBalancing:1.0
//
namespace LoadBalancing
{

//
// IDL:ooc.com/LoadBalancing/Util:1.0
//
namespace Util
{

//
// Initialize the LoadAlert, LoadUpdater, and LoadCalculator local
// objects.
//
// The following properties determine which local objects get created:
//
//   ooc.balancer.util.create_alert=true|false
//   ooc.balancer.util.create_updater=true|false
//   ooc.balancer.util.create_calculator=true|false
//
// The default value for the above properties is true.  Futhermore,
// the properties:
//
//   ooc.balancer.util.update_freq=MILLISECONDS
//   ooc.balancer.util.alert_expire=MILLISECONDS
//
// determine the defaults for the LoadUpdater update frequence and the
// LoadAlert alert expire time, respectively.  If not specified, then
// 1000 milliseconds (1 second) is used.
//
// Note: This function *must* be called before initializing the ORB.
// 	 Also, if both the LoadCalculator and LoadUpdater are created,
// 	 then it is not necessary to call set_load_calculator() on the
// 	 LoadUpdater object with the LoadCalculator object.
//
void LBUtil_init();

} // End of namespace Util

} // End of namespace LoadBalancing

#endif
