// **********************************************************************
//
// Copyright (c) 2002
// IONA Technologies, Inc.
// Waltham, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#ifndef OB_ABSTRACT_BASE_H
#define OB_ABSTRACT_BASE_H

#include <OB/Object_fwd.h>
#include <OB/AbstractBase_fwd.h>
#include <OB/ValueBase_fwd.h>

#include <OB/AnyDeclaration.h>

namespace OB
{

class AbstractBaseInfo : public ConstructedInfo
{
public:

    AbstractBaseInfo() { }
    virtual ~AbstractBaseInfo() { }

    //
    // void* memory handling
    //
    virtual void free(void*) const;
    virtual void* dup(const void*) const;

    //
    // CDR
    //
    virtual void marshal(const void*, OutputStreamImpl*) const;
    virtual void unmarshal(void*, InputStreamImpl*) const;
};

} // End of namespace OB

namespace CORBA
{

class AbstractBase
{
    //
    // Not implemented
    //
    void operator=(const AbstractBase&);

#ifdef __SUNPRO_CC
    //
    // COMPILERFIX: Dummy data member to get around Forte 6.0 bug with
    // virtual inheritance
    //
    int dummy_;
#endif

protected:

    AbstractBase();
    AbstractBase(const AbstractBase&);
    
    virtual ~AbstractBase() = 0;

public:

    static OB::AbstractBaseInfo _OB_abstractBaseInfo;

    static AbstractBase_ptr _duplicate(AbstractBase_ptr);
    static AbstractBase_ptr _narrow(AbstractBase_ptr);
    static AbstractBase_ptr _nil();

    virtual Object_ptr _to_object();
    virtual ValueBase* _to_value();
};

Boolean is_nil(AbstractBase_ptr);
void release(AbstractBase_ptr);

} // End of namespace CORBA

//
// Use Any::to_abstract_base for extraction
//

void operator<<=(CORBA::Any&, CORBA::AbstractBase_ptr*);
void operator<<=(CORBA::Any&, CORBA::AbstractBase_ptr);

inline void
operator<<=(CORBA::Any_var& any, CORBA::AbstractBase_ptr* val)
{
    any.inout() <<= val;
}

inline void
operator<<=(CORBA::Any_var& any, CORBA::AbstractBase_ptr val)
{
    any.inout() <<= val;
}

#endif
