/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import pogo.gene.PogoDefs;
import pogo.gene.PogoString;

public class TangoTypes
implements TangoConst,
PogoDefs {
    public int code;
    public String cpp_code_str;
    public String java_code_str;
    public String cpp;
    public String java;
    public String description;
    public boolean is_array;
    public boolean need_constr;
    public boolean need_2constr;

    public TangoTypes(String type, String desc) {
        if (type.indexOf("Tango_") >= 0) {
            type = this.to_cpp_code_str(type);
        }
        this.createType(type);
        if (desc != null) {
            this.description = new String(desc);
        }
    }

    public TangoTypes(String type) {
        if (type.indexOf("Tango_") >= 0) {
            type = this.to_cpp_code_str(type);
        }
        if (type.equals("Tango::DevVoid")) {
            this.createType("Tango::DEV_VOID");
        } else if (type.equals("Tango::DevBoolean") || type.equals("boolean")) {
            this.createType("Tango::DEV_BOOLEAN");
        } else if (type.equals("Tango::DevShort") || type.equals("short")) {
            this.createType("Tango::DEV_SHORT");
        } else if (type.equals("Tango::DevLong") || type.equals("long")) {
            this.createType("Tango::DEV_LONG");
        } else if (type.equals("Tango::DevUShort")) {
            this.createType("Tango::DEV_USHORT");
        } else if (type.equals("Tango::DevULong")) {
            this.createType("Tango::DEV_ULONG");
        } else if (type.equals("Tango::DevFloat") || type.equals("float")) {
            this.createType("Tango::DEV_FLOAT");
        } else if (type.equals("Tango::DevDouble") || type.equals("double")) {
            this.createType("Tango::DEV_DOUBLE");
        } else if (type.equals("Tango::DevVarCharArray") || type.equals("char[]")) {
            this.createType("Tango::DEVVAR_CHARARRAY");
        } else if (type.equals("Tango::DevVarShortArray") || type.equals("short[]")) {
            this.createType("Tango::DEVVAR_SHORTARRAY");
        } else if (type.equals("Tango::DevVarLongArray") || type.equals("long[]")) {
            this.createType("Tango::DEVVAR_LONGARRAY");
        } else if (type.equals("Tango::DevVarFloatArray") || type.equals("float[]")) {
            this.createType("Tango::DEVVAR_FLOATARRAY");
        } else if (type.equals("Tango::DevVarDoubleArray") || type.equals("double[]")) {
            this.createType("Tango::DEVVAR_DOUBLEARRAY");
        } else if (type.equals("Tango::DevVarULongArray")) {
            this.createType("Tango::DEVVAR_ULONGARRAY");
        } else if (type.equals("Tango::DevVarUShortArray")) {
            this.createType("Tango::DEVVAR_USHORTARRAY");
        } else if (type.equals("Tango::ConstDevString")) {
            this.createType("Tango::CONST_DEV_STRING");
        } else if (type.equals("Tango::DevString") || type.equals("string")) {
            this.createType("Tango::DEV_STRING");
        } else if (type.equals("Tango::DevVarStringArray") || type.equals("string[]")) {
            this.createType("Tango::DEVVAR_STRINGARRAY");
        } else if (type.equals("Tango::DevVarLongStringArray")) {
            this.createType("Tango::DEVVAR_LONGSTRINGARRAY");
        } else if (type.equals("Tango::DevVarDoubleStringArray")) {
            this.createType("Tango::DEVVAR_DOUBLESTRINGARRAY");
        } else {
            this.createType(type);
        }
    }

    private void createType(String type) {
        this.cpp_code_str = new String(type);
        this.java_code_str = this.to_java_code_str();
        if (type.equals("Tango::DEV_VOID")) {
            this.code = 0;
            this.cpp = new String("void");
            this.java = new String("void");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_BOOLEAN")) {
            this.code = 1;
            this.cpp = new String("Tango::DevBoolean");
            this.java = new String("boolean");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_SHORT")) {
            this.code = 2;
            this.cpp = new String("Tango::DevShort");
            this.java = new String("short");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_LONG")) {
            this.code = 3;
            this.cpp = new String("Tango::DevLong");
            this.java = new String("int");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_FLOAT")) {
            this.code = 4;
            this.cpp = new String("Tango::DevFloat");
            this.java = new String("float");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_DOUBLE")) {
            this.code = 5;
            this.cpp = new String("Tango::DevDouble");
            this.java = new String("double");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_USHORT")) {
            this.code = 6;
            this.cpp = new String("Tango::DevUShort");
            this.java = new String("int");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_ULONG")) {
            this.code = 7;
            this.cpp = new String("Tango::DevULong");
            this.java = new String("int");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_CHARARRAY")) {
            this.code = 9;
            this.cpp = new String("Tango::DevVarCharArray");
            this.java = new String("byte[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_SHORTARRAY")) {
            this.code = 10;
            this.cpp = new String("Tango::DevVarShortArray");
            this.java = new String("short[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_LONGARRAY")) {
            this.code = 11;
            this.cpp = new String("Tango::DevVarLongArray");
            this.java = new String("int[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_FLOATARRAY")) {
            this.code = 12;
            this.cpp = new String("Tango::DevVarFloatArray");
            this.java = new String("float[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_DOUBLEARRAY")) {
            this.code = 13;
            this.cpp = new String("Tango::DevVarDoubleArray");
            this.java = new String("double[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_USHORTARRAY")) {
            this.code = 14;
            this.cpp = new String("Tango::DevVarUShortArray");
            this.java = new String("short[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_ULONGARRAY")) {
            this.code = 15;
            this.cpp = new String("Tango::DevVarULongArray");
            this.java = new String("int[]");
            this.is_array = true;
            this.need_constr = true;
        } else if (type.equals("Tango::CONST_DEV_STRING")) {
            this.code = -2;
            this.cpp = new String("Tango::ConstDevString");
            this.java = new String("String");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEV_STRING")) {
            this.code = 8;
            this.cpp = new String("Tango::DevString");
            this.java = new String("String");
            this.is_array = false;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_STRINGARRAY")) {
            this.code = 16;
            this.cpp = new String("Tango::DevVarStringArray");
            this.java = new String("String[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Tango::DEVVAR_LONGSTRINGARRAY")) {
            this.code = 17;
            this.cpp = new String("Tango::DevVarLongStringArray");
            this.java = new String("DevVarLongStringArray");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = true;
        } else if (type.equals("Tango::DEVVAR_DOUBLESTRINGARRAY")) {
            this.code = 18;
            this.cpp = new String("Tango::DevVarDoubleStringArray");
            this.java = new String("DevVarDoubleStringArray");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = true;
        } else if (type.equals("Tango::DEV_STATE")) {
            this.code = 19;
            this.cpp = new String("Tango::DevState");
            this.java = new String("DevState");
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        } else if (type.equals("string") || type.equals("String")) {
            this.code = 8;
            this.cpp_code_str = new String("string");
            this.cpp = new String("string");
            this.java = new String("String");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of short") || type.equals("vector<short>") || type.equals("short[]")) {
            this.code = 10;
            this.cpp_code_str = new String("Array of short");
            this.cpp = new String("vector<short>");
            this.java = new String("short[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of long") || type.equals("vector<long>") || type.equals("long[]")) {
            this.code = 11;
            this.cpp_code_str = new String("Array of long");
            this.cpp = new String("vector<long>");
            this.java = new String("long[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of float") || type.equals("vector<float>") || type.equals("float[]")) {
            this.code = 12;
            this.cpp_code_str = new String("Array of float");
            this.cpp = new String("vector<float>");
            this.java = new String("float[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of double") || type.equals("vector<double>") || type.equals("double[]")) {
            this.code = 13;
            this.cpp_code_str = new String("Array of double");
            this.cpp = new String("vector<double>");
            this.java = new String("double[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = false;
        } else if (type.equals("Array of string") || type.equals("vector<string>") || type.equals("String[]")) {
            this.code = 16;
            this.cpp_code_str = new String("Array of string");
            this.cpp = new String("vector<string>");
            this.java = new String("String[]");
            this.is_array = true;
            this.need_constr = true;
            this.need_2constr = true;
        } else {
            System.out.println("WARNING: Tango type (" + type + ") Unknown !");
            this.code = -1;
            this.cpp = new String(type);
            this.java = new String(type);
            this.is_array = false;
            this.need_constr = false;
            this.need_2constr = false;
        }
    }

    public void setDescription(String str) {
        this.description = new String(str);
    }

    public String javaExtract() {
        String cpp_namespace = "::";
        int start = this.cpp.indexOf(cpp_namespace);
        String s = start > 0 ? this.cpp.substring(start + cpp_namespace.length()) : this.cpp;
        return new String("extract_" + s);
    }

    private String to_java_code_str() {
        if (this.cpp_code_str.indexOf(PogoDefs.cppNameSpace) < 0) {
            return this.cpp_code_str;
        }
        StringBuffer sb = new StringBuffer("Tango_");
        int start = this.cpp_code_str.indexOf(PogoDefs.cppNameSpace) + PogoDefs.cppNameSpace.length();
        sb.append(this.cpp_code_str.substring(start));
        return sb.toString();
    }

    private String to_cpp_code_str(String code_str) {
        String java_begin = "Tango_";
        if (code_str.indexOf(java_begin) < 0) {
            return code_str;
        }
        StringBuffer sb = new StringBuffer("Tango::");
        int start = code_str.indexOf(java_begin) + java_begin.length();
        sb.append(code_str.substring(start));
        return sb.toString();
    }

    public String extract_java_method() {
        StringBuffer sb = new StringBuffer("extract");
        String first = this.java.substring(0, 1).toUpperCase();
        sb.append(first);
        PogoString pg = new PogoString(this.java.substring(1));
        pg.replace("[]", "Array");
        sb.append(pg.str);
        sb.append("()");
        return sb.toString();
    }

    public String extract_method() {
        StringBuffer sb = new StringBuffer("extract");
        String target = "DevVar";
        int start = this.cpp.indexOf(target);
        if (start > 0) {
            sb.append(this.cpp.substring(start + target.length()));
        } else {
            target = "Dev";
            start = this.cpp.indexOf(target);
            if (start > 0) {
                sb.append(this.cpp.substring(start + target.length()));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.cpp_code_str + "\t" + this.cpp + "\t" + this.java + "\n");
        if (this.is_array) {
            sb.append("Is an Array and ");
        } else {
            sb.append("Is Not an Array and ");
        }
        if (this.need_constr) {
            sb.append("Needs Constructor");
        } else {
            sb.append("Doesn't Needs Constructor\n");
        }
        return sb.toString();
    }
}

