/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.Property;

public class Taco2Tango
implements PogoDefs {
    private PogoClass pogo;
    private String filename;
    private String tacoCodeBeginning = new String(")/sizeof(db_resource)");
    private String tacoAddCommands = new String("DevCommandListEntry");
    private String tacoAddDevProps = new String("res_object[]");
    private String tacoAddClassProps = new String("res_class[]");
    private String tacoAddStates = new String("static long state_handler");
    private static String[] typeStr = new String[]{"D_VOID_TYPE", "Tango::DEV_VOID", "D_BOOLEAN_TYPE", "Tango::DEV_BOOLEAN", "D_USHORT_TYPE", "Tango::DEV_USHORT", "D_SHORT_TYPE", "Tango::DEV_SHORT", "D_ULONG_TYPE", "Tango::DEV_ULONG", "D_LONG_TYPE", "Tango::DEV_LONG", "D_FLOAT_TYPE", "Tango::DEV_FLOAT", "D_DOUBLE_TYPE", "Tango::DEV_DOUBLE", "D_STRING_TYPE", "Tango::DEV_STRING", "D_VAR_CHARARR", "Tango::DEVVAR_CHARARRAY", "D_VAR_STRINGARR", "Tango::DEVVAR_STRINGARRAY", "D_VAR_USHORTARR", "Tango::DEVVAR_USHORTARRAY", "D_VAR_SHORTARR", "Tango::DEVVAR_SHORTARRAY", "D_VAR_ULONGARR", "Tango::DEVVAR_ULONGARRAY", "D_VAR_LONGARR", "Tango::DEVVAR_LONGARRAY", "D_VAR_FLOATARR", "Tango::DEVVAR_FLOATARRAY", "D_VAR_DOUBLEARR", "Tango::DEVVAR_DOUBLEARRAY"};
    private static String[] stateStr = new String[]{"DEVUNKNOWN", "DEVOFF", "DEVON", "DEVCLOSE", "DEVOPEN", "DEVLOW", "DEVHIGH", "DEVINSERTED", "DEVEXTRACTED", "DEVMOVING", "DEVWARMUP", "DEVINIT", "DEVSTANDBY", "DEVSERVICE", "DEVRUN", "DEVLOCAL", "DEVREMOTE", "DEVAUTOMATIC", "DEVRAMP", "DEVTRIPPED", "DEVHV_ENABLE", "DEVBEAM_ENABLE", "DEVBLOCKED", "DEVFAULT", "DEVSTARTING", "DEVSTOPPING", "DEVSTARTREQUESTED", "DEVSTOPREQUESTED", "DEVPOSITIVEENDSTOP", "DEVNEGATIVEENDSTOP", "DEVBAKEREQUESTED", "DEVBAKEING", "DEVSTOPBAKE", "DEVFORCEDOPEN", "DEVFORCEDCLOSE", "DEVOFFUNAUTHORISED", "DEVONNOTREGULAR", "DEVRESETTING", "DEVFORBIDDEN", "DEVOPENING", "DEVCLOSING", "DEVUNDEFINED", "DEVCOUNTING", "STOPPED", "RUNNING", "DEVALARM", "DEVDISABLED", "DEVSTANDBY_NOT_REACHED", "DEVON_NOT_REACHED"};

    public Taco2Tango(String filename) throws PogoException {
        this.filename = new String(filename);
        PogoString pgsName = new PogoString(filename);
        this.pogo = new PogoClass(pgsName.extractClassFromPath(), "", new Vector(), new Vector(), new Vector(), new Vector(), new Vector());
        System.out.println("Taco2Tango created");
    }

    public PogoClass getPogoClass() throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fid = new FileInputStream(this.filename);
        int nb = fid.available();
        byte[] inStr = new byte[nb];
        fid.read(inStr);
        PogoString pgs = new PogoString(new String(inStr));
        fid.close();
        this.extractCommands(pgs);
        this.extractStates(pgs);
        this.extractProperties(pgs, this.tacoAddDevProps);
        this.extractProperties(pgs, this.tacoAddClassProps);
        this.pogo.title = this.pogo.class_name;
        this.pogo.language = 2;
        return this.pogo;
    }

    private void extractStates(PogoString pgs) throws PogoException {
        int i = 0;
        while (i < stateStr.length) {
            if (pgs.str.indexOf(stateStr[i]) > 0) {
                String s1 = stateStr[i].substring(new String("DEV").length());
                int j = 0;
                while (j < PogoDefs.TangoStatesArray.length) {
                    String s2 = PogoDefs.TangoStatesArray[j].substring(new String("Tango::").length());
                    if (s1.equals(s2)) {
                        this.pogo.states.addElement(new DevState(PogoDefs.TangoStatesArray[j], ""));
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void extractCommands(PogoString pgs) throws PogoException {
        int start = pgs.str.indexOf(this.tacoAddCommands);
        if (start < 0) {
            throw new PogoException(this.tacoAddCommands + " not found in " + this.filename);
        }
        start = pgs.inMethod(start);
        PogoString cmdStruct = new PogoString(pgs.extractMethodCore(start));
        start = 0;
        int end = 0;
        while ((start = cmdStruct.inMethod(end)) >= 0) {
            end = cmdStruct.outMethod(start);
            PogoString line = new PogoString(cmdStruct.str.substring(start, end).trim());
            String[] fields = line.getFields();
            String tacoCmd = fields[0];
            String tacoArgin = this.getTangoType(fields[2]);
            String tacoArgout = this.getTangoType(fields[3]);
            if (tacoCmd.equals("DevState") || tacoCmd.equals("DevStatus")) continue;
            this.pogo.commands.addElement(new Cmd(tacoCmd, new String(tacoCmd + "Cmd"), tacoArgin, tacoArgout, "", "", ""));
        }
    }

    private void extractProperties(PogoString pgs, String propertyType) throws PogoException {
        int start = pgs.str.indexOf(propertyType);
        if (start < 0) {
            System.out.println(propertyType + " not found in " + this.filename);
            return;
        }
        start = pgs.inMethod(start);
        PogoString propStruct = new PogoString(pgs.extractMethodCore(start));
        start = 0;
        int end = 0;
        while ((start = propStruct.inMethod(end)) >= 0) {
            end = propStruct.outMethod(start);
            PogoString line = new PogoString(propStruct.str.substring(start, end));
            String[] fields = line.getFields();
            String propname = fields[0];
            String proptype = this.getTangoType(fields[1]);
            System.out.println(propname + ": " + proptype);
            if (propertyType == this.tacoAddDevProps) {
                this.pogo.dev_properties.addElement(new Property(propname, proptype, ""));
                continue;
            }
            if (propertyType != this.tacoAddClassProps) continue;
            this.pogo.class_properties.addElement(new Property(propname, proptype, ""));
        }
    }

    private String getTangoType(String tacoType) {
        int i = 0;
        while (i < typeStr.length) {
            if (typeStr[i].equals(tacoType)) {
                return typeStr[i + 1];
            }
            i += 2;
        }
        return tacoType;
    }

    public static void main(String[] args) {
        try {
            Taco2Tango t2t = new Taco2Tango("/segfs/tango/tools/pogo/generated/taco/ipc.c");
            PogoClass pogoClass = t2t.getPogoClass();
        }
        catch (Exception e) {
            System.out.println("POGO Startup Failed.");
            System.out.println(e);
        }
    }
}

