/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.Property;

public class PropertyTable
implements PogoDefs {
    public Vector vect = new Vector();

    public PropertyTable() {
        this.vect.addElement(new Property("DefaultValue", "Tango::DEV_SHORT", "A default value to initialize the device server"));
        this.vect.addElement(new Property("ServerPath", "Tango::DEV_STRING", "Path to find executable file for server"));
    }

    public PropertyTable(Vector v_in) {
        int i = 0;
        while (i < v_in.size()) {
            this.vect.addElement(v_in.elementAt(i));
            ++i;
        }
    }

    public PropertyTable(String filename, int source, int lang) throws FileNotFoundException, SecurityException, IOException, PogoException {
        int end;
        String endstr;
        String[] srcStr = new String[]{"Class", "Device"};
        FileInputStream fidin = new FileInputStream(filename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString code = new PogoString(inStr);
        fidin.close();
        String startstr = lang == 1 ? "\t//--------- Start of properties data members ----------" : "properties member data";
        int start = code.str.indexOf(startstr);
        if (start < 0) {
            System.out.println("No property found in " + filename);
            return;
        }
        if (source == 0) {
            endstr = lang == 1 ? "\t//--------- End of properties data members ----------" : "//\tMethod prototypes";
            start = code.nextCr(start) + 1;
            end = code.str.indexOf(endstr, start);
            end = code.previousCr(end) - 1;
        } else {
            String string = endstr = lang == 1 ? "\t//--------- End of properties data members ----------" : "//@}";
            if (lang == 1) {
                start = code.str.indexOf("/**", start);
                end = code.str.indexOf("\t//--------- End of properties data members ----------", start);
            } else {
                start = code.inMethod(start) + 2;
                end = code.str.indexOf("//@}", start);
            }
        }
        if (start > end || start < 0 || end < 0) {
            System.out.println("No property found in " + filename);
            return;
        }
        String core = new String(code.str.substring(start, end));
        end = 0;
        start = 0;
        while ((end = core.indexOf("*/", end)) > 0) {
            PogoString pgs = new PogoString(core.substring(start, end += 3));
            String desc = pgs.getDescription();
            start = end;
            end = core.indexOf(";", start);
            StringTokenizer st = new StringTokenizer(core.substring(start, end));
            String type = st.nextToken().toString();
            String name = st.nextToken().toString();
            if (name.charAt(0) >= 'a' || name.charAt(0) >= 'z') {
                char car = (char)(name.charAt(0) - 32);
                name = new String(car + name.substring(1));
            }
            this.vect.addElement(new Property(name, type, desc, lang));
        }
    }

    public void addElement(Property st) {
        this.vect.addElement(st);
    }

    public Property elementAt(int idx) {
        return (Property)this.vect.elementAt(idx);
    }

    public int size() {
        return this.vect.size();
    }

    protected String updateJavaMethod(String readcode, String target) throws PogoException {
        if (this.size() == 0) {
            return "";
        }
        PogoString core = new PogoString(readcode);
        int start = core.str.indexOf("Automatic code generation");
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!'Automatic code generation' Not found");
        }
        start = core.nextCr(start) + 1;
        start = core.nextCr(start) + 1;
        int end = core.str.indexOf("End of Automatic code generation", start);
        end = core.previousCr(end);
        StringBuffer sb = new StringBuffer(core.str.substring(0, start));
        sb.append("\t\tString[]\tpropnames = {\n");
        int i = 0;
        while (i < this.size()) {
            Property property = this.elementAt(i);
            sb.append("\t\t\t\t\"" + property + "\"");
            if (i < this.size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
            ++i;
        }
        sb.append("\t\t\t};\n");
        sb.append("\n");
        sb.append("\t\t//\tCall database and extract values\n");
        sb.append("\t\t//--------------------------------------------\n");
        sb.append("\t\tDbDatum[]\tdata = get_db_" + target + "().get_property(propnames);\n");
        int i2 = 0;
        while (i2 < this.size()) {
            Property property = this.elementAt(i2);
            sb.append("\t\tif (data[" + i2 + "].is_empty()==false)");
            sb.append("\t\t" + property.getVarName() + " = data[" + i2 + "]." + property.type.extract_java_method() + ";\n");
            ++i2;
        }
        sb.append("\n");
        sb.append(core.str.substring(end));
        return sb.toString();
    }

    protected String addJavaDataMembers(String readcode) throws PogoException {
        PogoString pg = new PogoString(readcode);
        int start = pg.str.indexOf("\t//--------- Start of properties data members ----------");
        if (start < 0) {
            throw new PogoException(new String("Input File Syntax error !\n\t//--------- Start of properties data members ----------\n Not found !"));
        }
        int end = pg.str.indexOf("\t//--------- End of properties data members ----------");
        if (end < 0) {
            throw new PogoException(new String("Input File Syntax error !\n\t//--------- End of properties data members ----------\n Not found !"));
        }
        String prev_declar = pg.str.substring(start, end);
        StringBuffer sb = new StringBuffer("\t//--------- Start of properties data members ----------");
        sb.append("\n\n");
        int i = 0;
        while (i < this.size()) {
            Property property = this.elementAt(i);
            sb.append(property.buildDefinition(1));
            ++i;
        }
        sb.append("\n");
        pg.replace(prev_declar, sb.toString());
        return pg.str;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.vect.size()) {
            Property prop = (Property)this.vect.elementAt(i);
            sb.append(prop.name + "\t");
            sb.append(prop.type.cpp_code_str + "\n");
            ++i;
        }
        return sb.toString();
    }
}

