/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.util.StringTokenizer;
import java.util.Vector;

public class PogoString {
    public String str;

    public PogoString(String str) {
        this.str = new String(str);
    }

    public PogoString(byte[] b) {
        this.str = new String(b);
    }

    public int previousCr(int start) {
        while (start >= 0 && this.str.charAt(start) != '\n') {
            --start;
        }
        return ++start;
    }

    public int nextCr(int start) {
        while (start < this.str.length() && this.str.charAt(start) != '\n') {
            ++start;
        }
        return start;
    }

    public int inTest(int start) {
        if ((start = this.str.indexOf("if", start)) < 0) {
            return start;
        }
        start = this.str.indexOf("(", start);
        return start;
    }

    public int outTest(int start) {
        ++start;
        int cnt = 1;
        while (cnt != 0) {
            switch (this.str.charAt(start)) {
                case '(': {
                    ++cnt;
                    break;
                }
                case ')': {
                    --cnt;
                }
            }
            ++start;
        }
        return start;
    }

    public int inMethod(int start) {
        while (start < this.str.length() && this.str.charAt(start) != '{') {
            ++start;
        }
        if (start < this.str.length()) {
            return start;
        }
        return -1;
    }

    public int outMethod(int start) {
        ++start;
        int cnt = 1;
        while (cnt != 0 && start < this.str.length()) {
            switch (this.str.charAt(start)) {
                case '{': {
                    ++cnt;
                    break;
                }
                case '}': {
                    --cnt;
                }
            }
            ++start;
        }
        if ((start = this.nextCr(start)) < this.str.length() - 1) {
            ++start;
        }
        return start;
    }

    public String extractMethodCore() {
        return this.extractMethodCore(0);
    }

    public String extractMethodCore(int start) {
        start = this.inMethod(start) + 1;
        int end = this.outMethod(start);
        while (end > start && this.str.charAt(end) != '}') {
            --end;
        }
        return this.str.substring(start, end);
    }

    public String[] getParams() {
        String[] params = this.getFields();
        return params;
    }

    public String trim(char c) {
        if (this.str.length() == 0) {
            return "";
        }
        int start = 0;
        int end = this.str.length() - 1;
        while (this.str.charAt(start) == c && start < end) {
            ++start;
        }
        while (this.str.charAt(end) == c && end > start) {
            --end;
        }
        if (start >= end) {
            return "";
        }
        return this.str.substring(start, end + 1);
    }

    public String[] getFields() {
        this.str = this.trim('\n');
        this.str = this.trim(';');
        this.str = this.trim(',');
        this.str = this.str.trim();
        this.str = this.trim('{');
        this.str = this.trim('}');
        while (this.str.indexOf(40) > 0) {
            this.replace("(", ",");
        }
        this.str = this.trim(')');
        StringTokenizer st = new StringTokenizer(this.str, ",");
        Vector<String> v = new Vector<String>();
        while (st.countTokens() > 0) {
            v.add(st.nextToken().toString().trim());
        }
        String[] fields = new String[v.size()];
        int i = 0;
        while (i < v.size()) {
            PogoString p = new PogoString((String)v.elementAt(i));
            fields[i] = p.trim('\"');
            ++i;
        }
        return fields;
    }

    public String setComments() {
        StringBuffer sb = new StringBuffer("");
        int start = 0;
        int end = 0;
        int n = 0;
        while ((end = this.nextCr(start)) < this.str.length()) {
            ++end;
            if (n++ > 0) {
                sb.append(" *\t");
            }
            sb.append(this.str.substring(start, end));
            start = end;
        }
        if (n++ > 0) {
            sb.append(" *\t");
        }
        sb.append(this.str.substring(start, end));
        return sb.toString();
    }

    public void insert(int idx, String s) {
        StringBuffer sb = new StringBuffer(this.str);
        sb.insert(idx, s);
        this.str = new String(sb.toString());
    }

    public void replace(String pattern, String newOne) {
        this.replace(0, pattern, newOne);
    }

    public void replace(int start, String pattern, String newOne) {
        StringBuffer sb = new StringBuffer(this.str);
        int start1 = this.str.indexOf(pattern, start);
        if (start1 < 0) {
            return;
        }
        int end = start1 + pattern.length();
        if (newOne == null) {
            sb.replace(start1, end, "");
        } else {
            sb.replace(start1, end, newOne);
        }
        this.str = new String(sb.toString());
    }

    public void append(String newStr) {
        StringBuffer sb = new StringBuffer(this.str);
        sb.append(newStr);
        this.str = new String(sb.toString());
    }

    public String noEdges() {
        return this.noEdges(0);
    }

    public String noEdges(int start) {
        int end = this.str.length() - 1;
        while (start < end && (this.str.charAt(start) < '.' || this.str.charAt(start) == '/')) {
            ++start;
        }
        while (start <= end && (this.str.charAt(end) < '.' || this.str.charAt(end) == '/')) {
            --end;
        }
        return this.str.substring(start, ++end);
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer("");
        int start = this.str.indexOf("/**");
        if (start < 0) {
            start = 0;
        }
        String s = this.noEdges(start);
        StringTokenizer st = new StringTokenizer(s);
        boolean newLine = false;
        int i = 0;
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            if (tmp.indexOf("@") >= 0) break;
            if (tmp.indexOf("*") >= 0) {
                newLine = true;
                sb.append("\n");
            } else {
                if (!newLine) {
                    sb.append(" ");
                }
                sb.append(tmp);
                newLine = false;
            }
            ++i;
        }
        this.str = sb.toString();
        this.str = this.noEdges();
        return this.str;
    }

    public String extractClassFromPath() {
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '.') {
            --end;
        }
        if (end == 0) {
            end = this.str.length() - 1;
        }
        int start = end;
        while (start > 0 && this.str.charAt(start) != '/' && this.str.charAt(start) != '\\') {
            --start;
        }
        if (this.str.charAt(start) == '/' || this.str.charAt(start) == '\\') {
            ++start;
        }
        return this.str.substring(start, end);
    }

    public String buildServerClassFromPath() {
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '.') {
            --end;
        }
        if (end == 0) {
            end = this.str.length() - 1;
        }
        String ext = this.str.substring(end, this.str.length());
        StringBuffer sb = new StringBuffer(this.str.substring(0, end));
        sb.append("Class" + ext);
        return sb.toString();
    }

    public String buildServerClassHFromPath() {
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '.') {
            --end;
        }
        if (end == 0) {
            end = this.str.length() - 1;
        }
        String ext = this.str.substring(end, this.str.length());
        StringBuffer sb = new StringBuffer(this.str.substring(0, end));
        sb.append("Class.h");
        return sb.toString();
    }

    public String buildDescClassFromPath(int lang) {
        if (lang == 1) {
            return this.str;
        }
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '.') {
            --end;
        }
        if (end == 0) {
            end = this.str.length() - 1;
        }
        return new String(this.str.substring(0, end) + ".h");
    }

    public String extractPathFromFullPath() {
        int end = this.str.length() - 1;
        while (end > 0 && this.str.charAt(end) != '/') {
            --end;
        }
        if (end == 0) {
            end = this.str.length() - 1;
            while (end > 0 && this.str.charAt(end) != '\\') {
                --end;
            }
        }
        return this.str.substring(0, end);
    }

    public String toLowerString() {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.str.length()) {
            if (this.str.charAt(i) >= 'A' && this.str.charAt(i) <= 'Z') {
                if (i > 0 && (this.str.charAt(i - 1) < 'A' || this.str.charAt(i - 1) > 'Z')) {
                    sb.append('_');
                }
                sb.append((char)(this.str.charAt(i) + 32));
            } else {
                sb.append(this.str.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return this.str;
    }
}

