/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.Cmd;
import pogo.gene.JavaServer;
import pogo.gene.JavaServerClass;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;

public class PogoGeneJava
extends PogoGene
implements PogoDefs,
TangoConst {
    public PogoGeneJava(PogoClass pogo) {
        super(pogo);
    }

    protected String AddExecuteMethod(Cmd cmd, PogoString pgs) throws PogoException {
        int start = pgs.str.indexOf(PogoDefs.classDescRes);
        if (start < 0) {
            throw new PogoException("Template Syntax error !\nClass Description\n Not found !");
        }
        int end = pgs.str.indexOf("*/", start);
        String oldMethod = pgs.str.substring(start, end);
        StringBuffer sb = new StringBuffer(PogoDefs.classDescRes + "\n *\t");
        if (cmd.description != null) {
            sb.append(new PogoString(cmd.description).setComments());
        }
        sb.append("\n");
        pgs.replace(oldMethod, sb.toString());
        String target = "public Any execute(DeviceImpl device,Any in_any)";
        start = pgs.str.indexOf(target);
        if (start < 0) {
            throw new PogoException(new String("Template Syntax error !\n" + target + "\n Not Found !"));
        }
        int tmp = start = pgs.inMethod(start);
        if ((start = pgs.str.indexOf("println", start)) < 0) {
            start = tmp;
        }
        start = pgs.nextCr(start) + 1;
        end = pgs.outMethod(start);
        oldMethod = pgs.str.substring(start, end);
        String newMethod = cmd.buildJavaExecuteMethodBlock(this.pogo.class_name);
        pgs.replace(start, oldMethod, newMethod);
        target = "public boolean is_allowed(DeviceImpl device, Any data_in)";
        start = pgs.str.indexOf(target);
        if (start < 0) {
            throw new PogoException(new String("Template Syntax error !\n" + target + "\n Not Found !"));
        }
        start = pgs.inMethod(start);
        end = pgs.outMethod(start);
        oldMethod = pgs.str.substring(start, end);
        newMethod = cmd.buildIsAllowedMethod(new PogoString(oldMethod), 1);
        pgs.replace(oldMethod, newMethod);
        return pgs.str;
    }

    protected void generateCommandClasses() throws IOException, PogoException {
        String template = new String(this.pogo.templates_dir + "/java/" + PogoDefs.templateFile + "Cmd.java");
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method) {
                PogoString pgs;
                byte[] inStr;
                int nb;
                FileInputStream fidin;
                String servercmd = new String(this.pogo.output_files + "/" + cmd.cmd_class + ".java");
                if (this.mustGenerate(servercmd)) {
                    System.out.println("Generating " + servercmd + "....");
                    fidin = new FileInputStream(template);
                    nb = fidin.available();
                    inStr = new byte[nb];
                    fidin.read(inStr);
                    pgs = new PogoString(inStr);
                    fidin.close();
                    while (pgs.str.indexOf(PogoDefs.templateClass) >= 0) {
                        pgs.replace(PogoDefs.templateClass, this.pogo.class_name);
                    }
                    while (pgs.str.indexOf(PogoDefs.templateClassCmd) >= 0) {
                        pgs.replace(PogoDefs.templateClassCmd, cmd.cmd_class);
                    }
                    this.sbTrace.append(servercmd + "        Created\n");
                } else {
                    fidin = new FileInputStream(servercmd);
                    nb = fidin.available();
                    inStr = new byte[nb];
                    fidin.read(inStr);
                    pgs = new PogoString(inStr);
                    fidin.close();
                    this.sbTrace.append(servercmd + "        Modified\n");
                }
                String newcode = this.AddExecuteMethod(cmd, pgs);
                FileOutputStream fidout = new FileOutputStream(servercmd);
                fidout.write(newcode.getBytes());
                fidout.close();
            }
            ++i;
        }
    }

    protected String addClassToMakefile(PogoString pgs) throws PogoException {
        String tag = "CL_LIST =\t$(CLASS).class";
        if (pgs.str.indexOf(tag) < 0) {
            throw new PogoException("Makefile Syntax error !");
        }
        StringBuffer fileslist = new StringBuffer(tag);
        fileslist.append("\\\n\t\t$(CLASS)Class.class");
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method) {
                fileslist.append("\t\\\n\t\t" + cmd.cmd_class + ".class");
            }
            ++i;
        }
        fileslist.append("\n");
        pgs.replace(tag, fileslist.toString());
        return pgs.str;
    }

    protected void generateMakefile(String filename) throws IOException, PogoException {
        System.out.println("Generating " + filename + "....");
        String template = this.pogo.templates_dir + "/java/Makefile";
        FileInputStream fidin = new FileInputStream(template);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        while (pgs.str.indexOf(PogoDefs.templateClass) >= 0) {
            pgs.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        String newcode = this.addClassToMakefile(pgs);
        FileOutputStream fidout = new FileOutputStream(filename);
        fidout.write(pgs.str.getBytes());
        fidout.close();
    }

    public void generate() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String makefile = new String(this.pogo.output_files + "/Makefile");
        String server = new String(this.pogo.output_files + "/" + this.pogo.class_name + ".java");
        String serverclass = new String(this.pogo.output_files + "/" + this.pogo.class_name + "Class.java");
        this.sbTrace = new StringBuffer("Java source code generation:\n\n");
        if (this.mustGenerate(makefile)) {
            this.generateMakefile(makefile);
            this.sbTrace.append(makefile + "        Created\n");
        }
        this.generateCommandClasses();
        JavaServer serv = new JavaServer(this.pogo);
        serv.generateSource(server);
        this.sbTrace.append(server + "        Writen\n");
        JavaServerClass sc = new JavaServerClass(this.pogo);
        sc.generateSource(serverclass);
        this.sbTrace.append(serverclass + "        Writen\n");
        this.buildReadMeFile(new String(this.pogo.templates_dir + "/java/README"), new String(this.pogo.output_files + "/" + "README"));
    }
}

