/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.TangoConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.DevState;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.Property;

public class PogoGeneDoc
extends PogoGene
implements PogoDefs,
TangoConst {
    private PogoClass pogo;
    private String outDoc;
    private String header;

    public PogoGeneDoc(PogoClass pogo) {
        super(pogo);
        this.pogo = pogo;
        this.outDoc = new String(pogo.output_files + "/doc_html");
        this.header = new String("\"" + pogo.class_name + " Device Server generated by POGO\"");
    }

    private String buildTableHeader(String title, int nb_col) {
        StringBuffer sb = new StringBuffer("<Table Border=2 Cellpadding=3 CELLSPACING=0 WIDTH=\"100%\">\n");
        sb.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
        sb.append("<Td COLSPAN=" + nb_col + "> <Font Size=+2>");
        sb.append("<Center>");
        sb.append("<b>" + title + "</b></td></Font></Center>\n");
        return sb.toString();
    }

    private String buildTableHeader(String title, String[] col_titles) {
        StringBuffer sb = new StringBuffer(this.buildTableHeader(title, col_titles.length));
        sb.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
        int i = 0;
        while (i < col_titles.length) {
            sb.append("<Td>");
            sb.append("<Center>");
            sb.append("<b>" + col_titles[i] + "</b></td></Center>\n");
            ++i;
        }
        return sb.toString();
    }

    private void makeDocDir() throws SecurityException {
        File f = new File(this.outDoc);
        if (!f.exists()) {
            f.mkdir();
        }
    }

    private String generateProgrammersGuide() throws FileNotFoundException, SecurityException, IOException, InterruptedException, PogoException {
        String[] cmd;
        this.makeDocDir();
        switch (this.pogo.language) {
            case 1: {
                cmd = this.buildCmdDocFromJava();
                break;
            }
            case 2: {
                cmd = this.buildCmdDocFromCpp();
                break;
            }
            default: {
                return "Languange not supported !";
            }
        }
        Process proc = Runtime.getRuntime().exec(cmd);
        return "";
    }

    private String[] buildCmdDocFromCpp() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String template = new String(this.pogo.templates_dir + "/html/Doxyfile");
        String doxyfile = new String(this.pogo.output_files + "/Doxyfile");
        FileInputStream fidin = new FileInputStream(template);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        fidin.close();
        PogoString code = new PogoString(inStr);
        code.replace("POGO_TITLE", "\"" + this.pogo.title + "\"");
        code.replace("POGO_SRC_FILES", this.pogo.output_files);
        code.replace("POGO_OUT_DOC", this.outDoc);
        FileOutputStream fidout = new FileOutputStream(doxyfile);
        fidout.write(code.str.getBytes());
        fidout.close();
        String[] cmd = new String[2];
        int n = 0;
        String docPath = System.getProperty("CPP_DOC_PATH");
        cmd[n++] = docPath != null ? new String(docPath + "/doxygen") : new String("doxygen");
        cmd[n++] = doxyfile;
        return cmd;
    }

    private String[] buildCmdDocFromJava() {
        String[] cmd = new String[this.pogo.commands.size() + 9];
        int n = 0;
        cmd[n++] = "javadoc";
        cmd[n++] = "-private";
        cmd[n++] = "-author";
        cmd[n++] = "-windowtitle";
        cmd[n++] = this.header;
        cmd[n++] = "-header";
        cmd[n++] = this.header;
        cmd[n++] = "-d";
        cmd[n++] = this.outDoc + "/html";
        cmd[n++] = new String(this.pogo.output_files + "/" + this.pogo.class_name + PogoDefs.javaExtention);
        cmd[n++] = new String(this.pogo.output_files + "/" + this.pogo.class_name + "Class" + PogoDefs.javaExtention);
        int i = 2;
        while (i < this.pogo.commands.size()) {
            Cmd c = this.pogo.commands.cmdIdx(i);
            cmd[n++] = new String(this.pogo.output_files + "/" + c.cmd_class + PogoDefs.javaExtention);
            ++i;
        }
        return cmd;
    }

    protected void generateIndexFile() throws IOException, PogoException {
        String f_in = new String(this.pogo.templates_dir + "/html/index.html");
        String f_out = new String(this.outDoc + "/index.html");
        this.makeDocDir();
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.classDescRes, this.pogo.class_desc);
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.close();
    }

    protected void generateDescriptionFile() throws IOException, PogoException {
        String f_in = new String(this.pogo.templates_dir + "/html/page.html");
        String f_out = new String(this.outDoc + "/Description.html");
        if (new File(f_out).exists()) {
            return;
        }
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Center>\n").getBytes());
        fidout.write(new String("<Br>\n<Br>\n<Br>\n<Br>\n<Br>\n<Br>\n").getBytes());
        fidout.write(new String("This Page Must Be Filled by <Br>\n").getBytes());
        fidout.write(new String("The Programmer\n").getBytes());
        fidout.write(new String("</Center>\n").getBytes());
        fidout.close();
    }

    protected void generateStateDescriptionFile() throws IOException, PogoException {
        String f_in = new String(this.pogo.templates_dir + "/html/page.html");
        String f_out = new String(this.outDoc + "/TangoDevStates.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device States Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Center>\n").getBytes());
        fidout.write(new String("<Br> <Br> <Br> \n").getBytes());
        String[] titles = new String[]{"Names", "Descriptions"};
        fidout.write(new String(this.buildTableHeader("States", titles)).getBytes());
        int i = 0;
        while (i < this.pogo.states.size()) {
            DevState state = this.pogo.states.elementAt(i);
            fidout.write(new String("<Tr><Td>" + state.name + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + state.description + "</Td></Tr>\n\n").getBytes());
            ++i;
        }
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("</Table>\n").getBytes());
        fidout.write(new String("</Center>\n").getBytes());
        fidout.close();
    }

    protected void generatePropertyDescriptionFile() throws IOException, PogoException {
        String f_in = new String(this.pogo.templates_dir + "/html/page.html");
        String f_out = new String(this.outDoc + "/Properties.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Properties Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Br> <Br> <Br> \n").getBytes());
        fidout.write(new String("<Center>\n").getBytes());
        String[] titles = new String[]{"Property name", "Property type", "Description"};
        fidout.write(new String(this.buildTableHeader("Class Properties", titles)).getBytes());
        fidout.write(new String("\n").getBytes());
        int i = 0;
        while (i < this.pogo.class_properties.size()) {
            Property property = this.pogo.class_properties.elementAt(i);
            fidout.write(new String("<Tr><Td>" + property.name + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + property.type.cpp_code_str + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + property.description + "</Td></Tr>\n\n").getBytes());
            ++i;
        }
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("</Table>\n").getBytes());
        fidout.write(new String("</Center>\n").getBytes());
        fidout.write(new String("<Center>\n").getBytes());
        fidout.write(new String("<Br> <Br> <Br> \n").getBytes());
        fidout.write(new String(this.buildTableHeader("Device Properties", titles)).getBytes());
        int i2 = 0;
        while (i2 < this.pogo.dev_properties.size()) {
            Property property = this.pogo.dev_properties.elementAt(i2);
            fidout.write(new String("<Tr><Td>" + property.name + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + property.type.cpp_code_str + "</Td>\n").getBytes());
            fidout.write(new String("<Td>" + property.description + "</Td></Tr>\n\n").getBytes());
            ++i2;
        }
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("\n").getBytes());
        fidout.write(new String("</Table>\n").getBytes());
        fidout.write(new String("</Center>\n").getBytes());
        fidout.close();
    }

    protected void generateAttributesFile() throws IOException, PogoException {
        Attrib attr;
        int i;
        String[] titles;
        String f_in = new String(this.pogo.templates_dir + "/html/page.html");
        String f_out = new String(this.outDoc + "/Attributes.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Attributes Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        pgs.append("<Br><Br><Br><Br><Br>\n");
        boolean assAttr = false;
        boolean scalar = false;
        boolean spectrum = false;
        boolean image = false;
        int i2 = 0;
        while (i2 < this.pogo.attributes.size()) {
            Attrib attr2 = this.pogo.attributes.elementAt(i2);
            if (attr2.attrType == 0) {
                scalar = true;
                if (attr2.rwType == 3) {
                    assAttr = true;
                }
            } else if (attr2.attrType == 1) {
                spectrum = true;
            } else if (attr2.attrType == 2) {
                image = true;
            }
            ++i2;
        }
        if (scalar) {
            titles = new String[3 + (assAttr ? 1 : 0)];
            titles[0] = "Attribute name";
            titles[1] = "Data Type";
            titles[2] = "R/W Type";
            if (assAttr) {
                titles[3] = "Associated Attribute";
            }
            pgs.append(this.buildTableHeader("Scalar Attributs", titles));
            i = 0;
            while (i < this.pogo.attributes.size()) {
                attr = this.pogo.attributes.elementAt(i);
                if (attr.attrType == 0) {
                    pgs.append("<Tr><Td><Center>" + attr.name + "</Center></Td>\n");
                    pgs.append("<Td><Center>" + attr.dataType.cpp_code_str + "</Center></Td>");
                    pgs.append("<Td><Center>" + PogoDefs.cppNameSpace + PogoDefs.AttrRWtypeArray[attr.rwType] + "</Center></Td>");
                    if (attr.rwType == 3) {
                        pgs.append("<Td><Center>" + attr.assAttr + "</Center></Td>");
                    } else if (assAttr) {
                        pgs.append("<Td><Center> - </Center></Td>");
                    }
                    pgs.append("</Tr>\n\n");
                }
                ++i;
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
            pgs.append("<Br><Br><Br><Br><Br>\n");
        }
        if (spectrum) {
            titles = new String[]{"Attribute name", "Data Type", "X Data Length"};
            pgs.append(this.buildTableHeader("Spectrum Attributs", titles));
            i = 0;
            while (i < this.pogo.attributes.size()) {
                attr = this.pogo.attributes.elementAt(i);
                if (attr.attrType == 1) {
                    pgs.append("<Tr><Td><Center>" + attr.name + "</Center></Td>\n");
                    pgs.append("<Td><Center>" + attr.dataType.cpp_code_str + "</Center></Td>");
                    pgs.append("<Td><Center>" + attr.xSize + "</Center></Td>");
                    pgs.append("</Tr>\n\n");
                }
                ++i;
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
            pgs.append("<Br><Br><Br><Br><Br>\n");
        }
        if (image) {
            titles = new String[]{"Attribute name", "Data Type", "X Data Length", "Y Data Length"};
            pgs.append(this.buildTableHeader("Image Attributs", titles));
            i = 0;
            while (i < this.pogo.attributes.size()) {
                attr = this.pogo.attributes.elementAt(i);
                if (attr.attrType == 2) {
                    pgs.append("<Tr><Td><Center>" + attr.name + "</Center></Td>\n");
                    pgs.append("<Td><Center>" + attr.dataType.cpp_code_str + "</Center></Td>");
                    pgs.append("<Td><Center>" + attr.xSize + "</Center></Td>");
                    pgs.append("<Td><Center>" + attr.ySize + "</Center></Td>");
                    pgs.append("</Tr>\n\n");
                }
                ++i;
            }
            pgs.append("</Table>\n");
            pgs.append("</Center>\n");
        }
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.close();
    }

    protected void generateCmdListFile() throws IOException, PogoException {
        String f_in = new String(this.pogo.templates_dir + "/html/page.html");
        String f_out = new String(this.outDoc + "/DevCommandsList.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device Commands Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(new String("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n").getBytes());
        fidout.write(new String("<HTML><HEAD>\n").getBytes());
        fidout.write(new String("<TITLE>Commands\n</TITLE></HEAD>\n").getBytes());
        fidout.write(new String("<BODY BGCOLOR=\"white\">\n").getBytes());
        fidout.write(new String("<FONT size=\"+1\" ID=\"FrameHeadingFont\">\n").getBytes());
        fidout.write(new String("<B>Commands</B></FONT>\n").getBytes());
        fidout.write(new String("<Br>\n<Br>\n<Br>\n").getBytes());
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            fidout.write(new String("<A Href=\"DevCommands.html#" + cmd.command + "\" TARGET=\"DevCommands\"> " + cmd.command + "</a><Br>\n").getBytes());
            ++i;
        }
        fidout.write(new String("<Br>\n<Br>\n<A Href=\"DevCommandsTable.html\" TARGET=\"DevCommands\"> Abstract </a><Br>\n").getBytes());
        fidout.close();
        this.copyFile(new String(this.pogo.templates_dir + "/html/frame.html"), new String(this.outDoc + "/DevCommandsFrame.html"));
    }

    protected void generateCmdListDescriptionFile() throws IOException, PogoException {
        String f_in = new String(this.pogo.templates_dir + "/html/page.html");
        String f_out = new String(this.outDoc + "/DevCommands.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device Commands Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.write(new String("<Br>\n<Br>\n<Br>\n").getBytes());
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            fidout.write(new String("<A NAME=\"" + cmd.command + "\"><!-- --></A>\n").getBytes());
            fidout.write(new String("<h2>" + (i + 1) + " - " + cmd.command).getBytes());
            if (cmd.level == DispLevel.EXPERT) {
                fidout.write(new String(" (for expert only)").getBytes());
            }
            fidout.write(new String("</h2>\n<ul>\n").getBytes());
            fidout.write(new String("<Li><Strong>Description: </Strong> ").getBytes());
            if (cmd.description != null) {
                fidout.write(new String(cmd.description).getBytes());
            }
            fidout.write(new String("<Br>&nbsp\n").getBytes());
            fidout.write(new String("<Li><Strong>Argin:<Br>" + cmd.argin.cpp_code_str + "</Strong>\n").getBytes());
            if (cmd.argin.description != null) {
                fidout.write(new String(" : " + cmd.argin.description).getBytes());
            }
            fidout.write(new String("<Br>&nbsp\n").getBytes());
            fidout.write(new String("<Li><Strong>Argout:<Br>" + cmd.argout.cpp_code_str + "</Strong>\n").getBytes());
            if (cmd.argout.description != null) {
                fidout.write(new String(" : " + cmd.argout.description).getBytes());
            }
            if (cmd.notAllowedFor != null) {
                fidout.write(new String("<Br>&nbsp\n").getBytes());
                fidout.write(new String("<Li><Strong>Command allowed for: </Strong><Ul>\n").getBytes());
                int idx = 0;
                while (idx < this.pogo.states.size()) {
                    DevState st = this.pogo.states.elementAt(idx);
                    boolean found = false;
                    int alIdx = 0;
                    while (alIdx < cmd.notAllowedFor.size()) {
                        DevState st1 = cmd.notAllowedFor.elementAt(alIdx);
                        if (st1.name.equals(st.name)) {
                            found = true;
                        }
                        ++alIdx;
                    }
                    if (!found) {
                        fidout.write(new String("<Li>" + st.name).getBytes());
                    }
                    ++idx;
                }
                fidout.write(new String("</Ul>\n").getBytes());
            } else {
                fidout.write(new String("<Li><Strong>Command allowed for all device states.</Strong><Br>\n").getBytes());
            }
            fidout.write(new String("<Br>&nbsp\n").getBytes());
            if (cmd.polled_period > 0) {
                fidout.write(new String("<Li><Strong>Polled every " + cmd.polled_period + " ms</Strong><Br>\n").getBytes());
            }
            fidout.write(new String("</ul><Br>\n<Br>\n").getBytes());
            ++i;
        }
        fidout.close();
    }

    protected void generateCmdTableFile() throws IOException, PogoException {
        String f_in = new String(this.pogo.templates_dir + "/html/page.html");
        String f_out = new String(this.outDoc + "/DevCommandsTable.html");
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString pgs = new PogoString(inStr);
        fidin.close();
        pgs.replace(PogoDefs.projectTitleRes, this.pogo.title);
        pgs.replace(PogoDefs.pageTitleRes, "Device Commands Description");
        pgs.replace("1.0", this.pogo.revision);
        pgs.replace("Verdier", this.pogo.author);
        String[] titles = new String[]{"Command name", "Argument In", "Argument Out"};
        pgs.append("<Br> <Br> <Br> \n");
        pgs.append("<Center>\n");
        pgs.append(this.buildTableHeader("Device Commands for Operator Level", titles));
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            if (cmd.level == DispLevel.OPERATOR) {
                pgs.append(new String("<Tr><Td>" + cmd.command + "</Td>\n"));
                pgs.append(new String("<Td>" + cmd.argin.cpp_code_str + "</Td>\n"));
                pgs.append(new String("<Td>" + cmd.argout.cpp_code_str + "</Td>\n"));
            }
            ++i;
        }
        pgs.append("\n\n\n</Table></Center>\n");
        pgs.append("<Br> <Br> <Br> \n");
        pgs.append("<Center>\n");
        pgs.append(this.buildTableHeader("Device Commands for Expert Level Only", titles));
        int i2 = 0;
        while (i2 < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i2);
            if (cmd.level == DispLevel.EXPERT) {
                pgs.append(new String("<Tr><Td>" + cmd.command + "</Td>\n"));
                pgs.append(new String("<Td>" + cmd.argin.cpp_code_str + "</Td>\n"));
                pgs.append(new String("<Td>" + cmd.argout.cpp_code_str + "</Td>\n"));
            }
            ++i2;
        }
        pgs.append("\n\n\n</Table></Center>\n");
        FileOutputStream fidout = new FileOutputStream(f_out);
        fidout.write(pgs.str.getBytes());
        fidout.close();
    }

    public String generate() throws FileNotFoundException, SecurityException, IOException, InterruptedException, PogoException {
        System.out.println("Generating HTML Doc files...");
        this.generateIndexFile();
        this.generateDescriptionFile();
        this.generateStateDescriptionFile();
        this.generatePropertyDescriptionFile();
        this.generateCmdListDescriptionFile();
        this.generateCmdListFile();
        this.generateCmdTableFile();
        this.generateAttributesFile();
        this.generateProgrammersGuide();
        return "";
    }
}

