/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileNotFoundException;
import java.io.IOException;
import pogo.gene.CppServer;
import pogo.gene.CppServerClass;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;

public class PogoGeneCpp
extends PogoGene
implements PogoDefs,
TangoConst {
    public PogoGeneCpp(PogoClass pogo) {
        super(pogo);
    }

    public void generate() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String makefile = new String(this.pogo.output_files + "/Makefile");
        String main = new String(this.pogo.output_files + "/main.cpp");
        String cfactory = new String(this.pogo.output_files + "/ClassFactory.cpp");
        String server = new String(this.pogo.output_files + "/" + this.pogo.class_name + ".cpp");
        String server_h = new String(this.pogo.output_files + "/" + this.pogo.class_name + ".h");
        String serverclass = new String(this.pogo.output_files + "/" + this.pogo.class_name + "Class.cpp");
        String serverclass_h = new String(this.pogo.output_files + "/" + this.pogo.class_name + "Class.h");
        this.sbTrace = new StringBuffer("C++ source code generation:\n\n");
        if (this.mustGenerate(makefile)) {
            System.out.println("Generating " + makefile + " for C++....");
            this.replacePatternFile(new String(this.pogo.templates_dir + "/cpp/Makefile"), makefile, PogoDefs.templateClass, this.pogo.class_name);
            this.sbTrace.append(makefile + " for C++     Created\n");
        }
        if (this.mustGenerate(main)) {
            System.out.println("Generating " + main + "....");
            this.sbTrace.append(main + "     Created\n");
            this.copyFile(new String(this.pogo.templates_dir + "/cpp/main.cpp"), main);
        }
        if (this.mustGenerate(cfactory)) {
            System.out.println("Generating " + cfactory + "....");
            this.replacePatternFile(new String(this.pogo.templates_dir + "/cpp/ClassFactory.cpp"), cfactory, PogoDefs.templateClass, this.pogo.class_name);
            this.sbTrace.append(cfactory + "      Created\n");
        }
        CppServerClass sc = new CppServerClass(this.pogo);
        sc.generateHeader(serverclass_h);
        this.sbTrace.append(serverclass_h + "      written\n");
        sc.generateSource(serverclass);
        this.sbTrace.append(serverclass + "      Written\n");
        CppServer serv = new CppServer(this.pogo);
        serv.generateHeader(server_h);
        this.sbTrace.append(server_h + "      written\n");
        serv.generateSource(server);
        this.sbTrace.append(server + "       written\n");
        this.buildReadMeFile(new String(this.pogo.templates_dir + "/cpp/README"), new String(this.pogo.output_files + "/" + "README"));
    }
}

