/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.Attrib;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;

public class PogoGene
implements PogoDefs,
TangoConst {
    PogoClass pogo;
    protected StringBuffer sbTrace;

    public PogoGene(PogoClass pogo) {
        this.pogo = pogo;
    }

    public String getTrace() {
        return this.sbTrace.toString();
    }

    protected boolean mustGenerate(String filename) throws FileNotFoundException, IOException {
        return !this.already_exists(filename);
    }

    protected boolean already_exists(String filename) throws FileNotFoundException, IOException {
        return new File(filename).exists();
    }

    protected String setMethodInComments(PogoString pgs, int startline) {
        int end_bl = pgs.inMethod(startline);
        end_bl = pgs.outMethod(end_bl);
        PogoString pgs1 = new PogoString(pgs.str.substring(startline, end_bl));
        StringBuffer sb = new StringBuffer("//");
        int i = 0;
        while (i < pgs1.str.length()) {
            sb.append(pgs1.str.charAt(i));
            if (pgs1.str.charAt(i) == '\n') {
                sb.append("//");
            }
            ++i;
        }
        return sb.toString();
    }

    protected void copyFile(String f_in, String f_out) throws FileNotFoundException, IOException {
        FileInputStream fidin = new FileInputStream(f_in);
        FileOutputStream fidout = new FileOutputStream(f_out);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        fidout.write(inStr);
        fidin.close();
        fidout.close();
    }

    protected void replacePatternFile(String f_in, String f_out, String to_find, String target) throws IOException {
        String s;
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        String str = new String(inStr);
        fidin.close();
        FileOutputStream fidout = new FileOutputStream(f_out);
        int end = 0;
        int start = 0;
        while ((end = str.indexOf(to_find, start)) > 0) {
            s = str.substring(start, end);
            fidout.write(s.getBytes());
            fidout.write(target.getBytes());
            start = end + to_find.length();
        }
        s = str.substring(start);
        fidout.write(s.getBytes());
        fidout.close();
    }

    protected String addCommentsCmdMethod() {
        StringBuffer sb = new StringBuffer("\n\n");
        sb.append("//===================================================================\n");
        sb.append("//\n");
        sb.append("//\tThe folowing table gives the correspondance\n");
        sb.append("//\tbetween commands and method's name.\n");
        sb.append("//\n");
        sb.append("//\tCommand's name\t|\tMethod's name\n");
        sb.append("//\t----------------------------------------\n");
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            sb.append("//\t" + cmd.command + "\t|\t" + cmd.exec_method + "()\n");
            ++i;
        }
        sb.append("//\n");
        sb.append("//===================================================================\n");
        return sb.toString();
    }

    protected String changeExeMethodArgs(Cmd cmd, String str, int idx, int lang) {
        StringBuffer sb = new StringBuffer(str);
        boolean in_method = false;
        int cnt = 0;
        sb.insert(idx, "//");
        while (!in_method || cnt > 0) {
            char c;
            if ((c = sb.charAt(idx++)) == '\n') {
                sb.insert(idx, "//");
            }
            if (c == '{') {
                ++cnt;
                in_method = true;
                continue;
            }
            if (c != '}') continue;
            --cnt;
        }
        switch (lang) {
            case 1: {
                String description = cmd.buildJavaExecCmdMethodComments();
                sb.insert(idx, description);
                sb.insert(idx += description.length(), cmd.buildJavaExecCmdMethod());
                break;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String checkForExecMethodModif(PogoString readcode, int lang) throws PogoException {
        if (lang == 2) {
            int i = 0;
            while (i < this.pogo.commands.size()) {
                Cmd cmd = this.pogo.commands.cmdIdx(i);
                if (!cmd.virtual_method) {
                    cmd.updateCppExecCmdMethodComments(readcode, this.pogo.class_name);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method) {
                int startmethod;
                boolean generate = true;
                String pattern = lang == 2 ? new String(this.pogo.class_name + "::" + cmd.exec_method + "(") : new String(cmd.exec_method + "(");
                int endline = 0;
                boolean done = false;
                while (!done && (startmethod = readcode.str.indexOf(pattern, endline)) >= 0) {
                    int sl;
                    void var7_8;
                    int startline = readcode.previousCr((int)var7_8);
                    String line = readcode.str.substring(startline, endline = readcode.nextCr(startline));
                    int el = line.indexOf(")", sl = line.indexOf("("));
                    if (el < 0) {
                        el = sl + 1;
                    }
                    line = line.substring(0, el);
                    System.out.println(readcode.str.substring((int)var7_8, endline) + " is exec : " + cmd.isExecMethod(readcode.str.substring((int)var7_8, endline)));
                    if (!cmd.isExecMethod(readcode.str.substring((int)var7_8, endline)) || line.indexOf("//") >= 0 || line.indexOf("\"") >= 0 || line.indexOf("<<") >= 0 || line.indexOf("println") >= 0) continue;
                    if (cmd.execMethodArgsChanged(line, lang)) {
                        System.out.println("args of " + cmd.exec_method + " have been modified !\n\t-> Re-Generate....");
                        String s = this.changeExeMethodArgs(cmd, readcode.str, startline, lang);
                        readcode = new PogoString(s);
                    }
                    done = true;
                }
            }
            ++i;
        }
        return readcode.str;
    }

    protected String setProjectTitle(String header) {
        int start = header.indexOf(PogoDefs.projectTitleRes);
        if (start < 0) {
            return header;
        }
        int end = header.indexOf("\n", start += PogoDefs.projectTitleRes.length());
        StringBuffer sb = new StringBuffer(header.substring(0, start));
        sb.append("\t" + this.pogo.title);
        sb.append(header.substring(end));
        return sb.toString();
    }

    protected String readAttributeTemplate(String f_in, int part) throws FileNotFoundException, SecurityException, IOException, PogoException {
        FileInputStream fidin = new FileInputStream(f_in);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString rw = new PogoString(inStr);
        fidin.close();
        while (rw.str.indexOf(PogoDefs.templateClass) >= 0) {
            rw.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        int end = rw.str.indexOf("WRITE ATTRIBUTE");
        if (end < 0) {
            throw new PogoException("'WRITE ATTRIBUTE' method not found");
        }
        end = rw.previousCr(end);
        PogoString pgs = null;
        switch (part) {
            case 0: {
                pgs = new PogoString(rw.str.substring(0, end));
                break;
            }
            case 1: {
                int start = rw.nextCr(end) + 1;
                pgs = new PogoString(rw.str.substring(start));
            }
        }
        return pgs.toString();
    }

    protected String buildAttributesMethods(PogoString pgs, int lang) throws PogoException, IOException, FileNotFoundException {
        int ptr;
        int end;
        int start;
        String tab;
        String string = tab = lang == 1 ? "\t\t" : "\t";
        if (lang == 1) {
            start = pgs.str.indexOf("\t//--------- Start of attributes data members ----------");
            if (start < 0) {
                throw new PogoException(new String("Input File Syntax error !\n\t//--------- Start of attributes data members ----------\nNot Found !"));
            }
            end = pgs.str.indexOf("\t//--------- End of attributes data members ----------");
            if (end < 0) {
                throw new PogoException(new String("Input File Syntax error !\n\t//--------- End of attributes data members ----------\n Not found !"));
            }
            String prev_declar = pgs.str.substring(start, end);
            StringBuffer sb = new StringBuffer("\t//--------- Start of attributes data members ----------");
            sb.append("\n\n");
            int i = 0;
            while (i < this.pogo.attributes.size()) {
                Attrib attr = this.pogo.attributes.elementAt(i);
                sb.append(attr.javaMemberData());
                ++i;
            }
            sb.append("\n");
            pgs.replace(prev_declar, sb.toString());
        }
        String rwAttr = lang == 1 ? new String(this.pogo.templates_dir + "/java/ReadWriteAttr.java") : new String(this.pogo.templates_dir + "/cpp/ReadWriteAttr.cpp");
        String read = this.readAttributeTemplate(rwAttr, 0);
        String write = this.readAttributeTemplate(rwAttr, 1);
        String pattern = lang == 1 ? "public void read_attr_hardware" : "::read_attr_hardware";
        start = pgs.str.indexOf(pattern);
        if (start < 0) {
            pattern = lang == 1 ? "always_executed_hook()" : "::always_executed_hook";
            ptr = pgs.str.indexOf(pattern);
            if (ptr < 0) {
                throw new PogoException("'" + pattern + "()' method not found");
            }
            ptr = pgs.inMethod(ptr) + 1;
            ptr = pgs.outMethod(ptr) + 1;
            pgs.insert(ptr, read);
        }
        boolean writable = false;
        int i = 0;
        while (i < this.pogo.attributes.size()) {
            Attrib attr = this.pogo.attributes.elementAt(i);
            if (attr.getWritable()) {
                writable = true;
            }
            ++i;
        }
        pattern = lang == 1 ? "public void write_attr_hardware" : "::write_attr_hardware";
        if (writable && (start = pgs.str.indexOf(pattern)) < 0) {
            pattern = lang == 1 ? "public void always_executed_hook()" : "::always_executed_hook()";
            ptr = pgs.str.indexOf(pattern);
            ptr = pgs.inMethod(ptr) + 1;
            ptr = pgs.outMethod(ptr) + 1;
            pgs.insert(ptr, write);
        }
        if ((start = pgs.str.indexOf(pattern = lang == 1 ? "public void read_attr(" : "::read_attr(")) < 0) {
            throw new PogoException("'" + pattern + ")' method not found");
        }
        start = pgs.inMethod(start) + 1;
        end = pgs.outMethod(start) - 2;
        PogoString method = new PogoString(pgs.str.substring(start, end));
        String oldmethod = new String(method.toString());
        ptr = method.str.indexOf("Switch on attribute name");
        if (ptr < 0) {
            System.out.println(method);
            throw new PogoException("'Switch on attribute name' not found");
        }
        ptr = method.nextCr(ptr) + 1;
        ptr = method.nextCr(ptr) + 1;
        int i2 = 0;
        while (i2 < this.pogo.attributes.size()) {
            Attrib attr = this.pogo.attributes.elementAt(i2);
            String target = new String("\"" + attr.name + "\"");
            if (method.str.indexOf(target, ptr) < 0) {
                StringBuffer sb = new StringBuffer();
                if (i2 != 0) {
                    sb.append(tab + "else\n");
                }
                sb.append(tab + "if (attr_name == " + target + ")\n");
                sb.append(tab + "{\n");
                sb.append(tab + "\t//\tAdd your own code here\n");
                sb.append(tab + "}\n");
                int here = i2 != 0 ? method.str.lastIndexOf("}", method.str.length()) + "}\n".length() : ptr;
                method.insert(here, sb.toString());
            }
            ++i2;
        }
        pgs.replace(oldmethod, method.str);
        if (writable) {
            pattern = lang == 1 ? "public void write_attr_hardware(" : "::write_attr_hardware";
            start = pgs.str.indexOf(pattern);
            if (start < 0) {
                throw new PogoException("'" + pattern + "' method not found");
            }
            start = pgs.inMethod(start) + 1;
            end = pgs.outMethod(start) - 2;
            method = new PogoString(pgs.str.substring(start, end));
            oldmethod = new String(method.str);
            ptr = method.str.indexOf("Switch on attribute name");
            if (ptr < 0) {
                throw new PogoException("'Switch on attribute name' not found");
            }
            ptr = method.nextCr(ptr) + 1;
            ptr = method.nextCr(ptr) + 1;
            int i3 = 0;
            int n = 0;
            while (i3 < this.pogo.attributes.size()) {
                Attrib attr = this.pogo.attributes.elementAt(i3);
                String string2 = tab = lang == 1 ? "\t\t\t" : "\t\t";
                if (attr.getWritable()) {
                    String target = new String("\"" + attr.name + "\"");
                    if (method.str.indexOf(target, ptr) < 0) {
                        int here;
                        StringBuffer sb = new StringBuffer();
                        if (n != 0) {
                            sb.append(tab + "else\n");
                        }
                        sb.append(tab + "if (attr_name == " + target + ")\n");
                        sb.append(tab + "{\n");
                        sb.append(tab + "\t//\tAdd your own code here\n");
                        sb.append(tab + "}\n");
                        if (n != 0) {
                            here = method.str.lastIndexOf("}", method.str.length());
                            here = method.str.lastIndexOf("}", here - 1) + "}\n".length();
                        } else {
                            here = ptr;
                        }
                        method.insert(here, sb.toString());
                    }
                    ++n;
                }
                ++i3;
            }
            pgs.replace(oldmethod, method.str);
        }
        return pgs.toString();
    }

    protected void buildReadMeFile(String f_in, String f_out) {
        try {
            FileInputStream fidin = new FileInputStream(f_in);
            FileOutputStream fidout = new FileOutputStream(f_out);
            int nb = fidin.available();
            byte[] inStr = new byte[nb];
            fidin.read(inStr);
            fidin.close();
            PogoString pgs = new PogoString(new String(inStr));
            while (pgs.str.indexOf(PogoDefs.templateClass) > 0) {
                pgs.replace(PogoDefs.templateClass, this.pogo.class_name);
            }
            fidout.write(pgs.str.getBytes());
            if (this.pogo.language == 1) {
                int i = 0;
                while (i < this.pogo.commands.size()) {
                    Cmd cmd = this.pogo.commands.cmdIdx(i);
                    if (!cmd.virtual_method) {
                        String str = new String(cmd.command + "Cmd" + PogoDefs.javaExtention + ":\n\t" + "Java source code for the command " + cmd.command + "\n\t" + cmd.description + "\n\n");
                        fidout.write(str.getBytes());
                    }
                    ++i;
                }
            }
            fidout.close();
        }
        catch (Exception ex) {
            System.out.println("README Cannot be generated\n" + ex.toString());
        }
    }

    private String buildProxyMethods() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            sb.append(cmd.buildJavaExecCmdMethodComments());
            sb.append(cmd.buildJavaExecCmdMethodSignature(1));
            ++i;
        }
        sb.append("\n\n");
        return sb.toString();
    }

    protected void buildClientProxyFile(String template, String proxyfile, String proxyclass) throws PogoException, IOException, FileNotFoundException {
        PogoString pgs;
        byte[] inStr;
        int nb;
        FileInputStream fidin;
        if (this.mustGenerate(proxyfile)) {
            System.out.println("Generating " + proxyfile);
            fidin = new FileInputStream(template);
            nb = fidin.available();
            inStr = new byte[nb];
            fidin.read(inStr);
            fidin.close();
            pgs = new PogoString(new String(inStr));
            while (pgs.str.indexOf("TangoclassProxy") >= 0) {
                pgs.replace("TangoclassProxy", proxyclass);
            }
            FileOutputStream fidout = new FileOutputStream(proxyfile);
            fidout.write(pgs.str.getBytes());
            fidout.close();
        }
        fidin = new FileInputStream(proxyfile);
        nb = fidin.available();
        inStr = new byte[nb];
        fidin.read(inStr);
        fidin.close();
        pgs = new PogoString(inStr);
        String constructor = "public " + proxyclass + "(String devname) throws DevFailed";
        int end = pgs.str.indexOf(constructor);
        end = pgs.inMethod(end);
        end = pgs.outMethod(end) + 1;
        constructor = pgs.str.substring(0, end);
        int start = pgs.str.indexOf("\tpublic static void main(String[] argv)");
        start = pgs.str.lastIndexOf("/**", start);
        start = pgs.str.lastIndexOf("//==========", start);
        String main = pgs.str.substring(start);
        FileOutputStream fidout = new FileOutputStream(proxyfile);
        fidout.write(constructor.getBytes());
        fidout.write(this.buildProxyMethods().getBytes());
        fidout.write(main.getBytes());
        fidout.close();
    }
}

