/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PropertyTable;

public class JavaServerClass
extends PogoGene
implements PogoDefs,
TangoConst {
    private String serverclass;
    private PropertyTable properties;

    public JavaServerClass(PogoClass pogo) {
        super(pogo);
        this.serverclass = new String(pogo.output_files + "/" + pogo.class_name + "Class.java");
        this.properties = pogo.class_properties;
    }

    public void generateSource(String serverclass) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String get_property;
        System.out.println("Generating " + serverclass + "....");
        String templname = new String(this.pogo.templates_dir + "/java/" + PogoDefs.templateFile + "Class.java");
        FileInputStream fidin = new FileInputStream(templname);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString templcode = new PogoString(inStr);
        fidin.close();
        while (templcode.str.indexOf(PogoDefs.templateClass) >= 0) {
            templcode.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        String factories = "";
        String class_constructor = null;
        if (this.already_exists(serverclass)) {
            fidin = new FileInputStream(serverclass);
            nb = fidin.available();
            inStr = new byte[nb];
            fidin.read(inStr);
            PogoString code = new PogoString(inStr);
            fidin.close();
            class_constructor = this.getClassConstructor(code);
            get_property = this.getGetPropertyMethod(code);
        } else {
            get_property = this.getGetPropertyMethod(null);
        }
        factories = this.buildFactories(templcode);
        if (class_constructor != null) {
            PogoString tmp = new PogoString(factories);
            String s = this.getClassConstructor(tmp);
            tmp.replace(s, class_constructor);
            factories = tmp.str;
        }
        if ((get_property = this.properties.updateJavaMethod(get_property, "class")).length() > 0) {
            factories = this.addPutGetPropertyCall(factories, "get");
            factories = this.properties.addJavaDataMembers(factories);
        }
        factories = this.addPutGetPropertyCall(factories, "write");
        String put_property = this.buildPutPropertyMethod();
        FileOutputStream fidout = new FileOutputStream(serverclass);
        fidout.write(factories.getBytes());
        fidout.write("\n".getBytes());
        fidout.write(get_property.getBytes());
        fidout.write(put_property.getBytes());
        fidout.write(new String("\n}\n").getBytes());
        fidout.close();
    }

    protected String addPutGetPropertyCall(String readcode, String putget) throws PogoException {
        String method_call = new String(putget + "_class_property();");
        String s = this.getClassConstructor(new PogoString(readcode));
        PogoString method_core = new PogoString(s);
        if (s.indexOf(method_call) > 0) {
            return readcode;
        }
        int start = method_core.str.indexOf("Util.out2.println");
        if (start < 0) {
            return readcode;
        }
        start = method_core.nextCr(start) + 1;
        method_core.insert(start, new String("\t\t" + method_call + "\n"));
        PogoString newcode = new PogoString(readcode);
        newcode.replace(s, method_core.str);
        return newcode.str;
    }

    protected String buildFactories(PogoString templcode) throws PogoException {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int end = templcode.str.indexOf("command_factory");
        if (end < 0) {
            throw new PogoException("command_factory() method not found !");
        }
        end = templcode.inMethod(end);
        sb.append(templcode.str.substring(start, end));
        sb.append(this.pogo.commands.buildCommandFactoryMethod(1));
        start = templcode.outMethod(end + 1);
        start = templcode.nextCr(start);
        end = templcode.str.indexOf("device_factory");
        if (end < 0) {
            throw new PogoException("device_factory() method not found !");
        }
        end = templcode.inMethod(end);
        end = templcode.outMethod(end + 1);
        end = templcode.nextCr(end);
        sb.append(templcode.str.substring(start, end));
        if (this.pogo.attributes.size() > 0) {
            sb.append("\n//=============================================================================\n");
            sb.append("//\n//\tMethod:\tattribute_factory(Vector att_list)\n//\n");
            sb.append("//=============================================================================\n");
            sb.append("\tpublic void attribute_factory(Vector att_list) throws DevFailed\n");
            sb.append(this.pogo.attributes.buildFactory(1));
        }
        return sb.toString();
    }

    protected String getClassConstructor(PogoString readcode) throws PogoException {
        String constr_sign = new String("protected " + this.pogo.class_name + "Class(String name) throws DevFailed");
        int end = readcode.str.indexOf(constr_sign);
        if (end < 0) {
            throw new PogoException(new String("Input File Syntax error !\n" + constr_sign + "\n Not found !"));
        }
        end = readcode.inMethod(end + 1);
        end = readcode.outMethod(end);
        return readcode.str.substring(0, end);
    }

    protected String getGetPropertyMethod(PogoString readcode) throws FileNotFoundException, SecurityException, IOException {
        int start;
        String get_property_signature = new String("public void get_class_property()");
        if (readcode == null || (start = readcode.str.indexOf(get_property_signature)) < 0) {
            String templname = new String(this.pogo.templates_dir + "/java/" + "readPropMethodName.java");
            FileInputStream fidin = new FileInputStream(templname);
            int nb = fidin.available();
            byte[] inStr = new byte[nb];
            fidin.read(inStr);
            PogoString templcode = new PogoString(inStr);
            fidin.close();
            while (templcode.str.indexOf(PogoDefs.templateClass) >= 0) {
                templcode.replace(PogoDefs.templateClass, new String(this.pogo.class_name + "Class"));
            }
            while (templcode.str.indexOf("target") >= 0) {
                templcode.replace("target", "class");
            }
            return templcode.str;
        }
        int end = readcode.inMethod(start);
        end = readcode.outMethod(end + 1);
        while (readcode.str.charAt(start) != '}') {
            --start;
        }
        return readcode.str.substring(start += 2, end);
    }

    protected String buildPutPropertyMethod() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String templname = new String(this.pogo.templates_dir + "/java/write_property.java");
        FileInputStream fidin = new FileInputStream(templname);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString readcode = new PogoString(inStr);
        fidin.close();
        while (readcode.str.indexOf(PogoDefs.templateClass) >= 0) {
            readcode.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        String tag = "PogoProjectTitle";
        String pattern = new String("\"" + this.pogo.title + "\"");
        while (readcode.str.indexOf(tag) >= 0) {
            readcode.replace(tag, pattern);
        }
        tag = "PogoClassDescription";
        PogoString desc = new PogoString(this.pogo.class_desc);
        pattern = "\\n";
        while (desc.str.indexOf("\n") >= 0) {
            desc.replace("\n", pattern);
        }
        String tmp = desc.str;
        if (tmp.length() > 255) {
            tmp = tmp.substring(0, 255);
        }
        pattern = new String("\"" + tmp + "\"");
        while (readcode.str.indexOf(tag) >= 0) {
            readcode.replace(tag, pattern);
        }
        return readcode.str;
    }
}

