/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.PropertyTable;

public class JavaServer
extends PogoGene
implements PogoDefs,
TangoConst {
    private String server;
    private PropertyTable properties;
    private static String readprop_method_name = "get_device_property";
    private String readprop_method_signature;
    private String init_signature;

    public JavaServer(PogoClass pogo) {
        super(pogo);
        this.server = new String(pogo.output_files + "/" + pogo.class_name + ".java");
        this.properties = pogo.dev_properties;
        this.init_signature = new String("\tpublic void init_device()");
        this.readprop_method_signature = new String("public void " + readprop_method_name + "()");
    }

    public void generateSource(String server) throws FileNotFoundException, SecurityException, IOException, PogoException {
        System.out.println("Generating " + server + "....");
        boolean src_exist = this.already_exists(server);
        String filename = src_exist ? server : new String(this.pogo.templates_dir + "/java/" + PogoDefs.templateFile + ".java");
        FileInputStream fidin = new FileInputStream(filename);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString readcode = new PogoString(inStr);
        fidin.close();
        if (!src_exist) {
            while (readcode.str.indexOf(PogoDefs.templateClass) >= 0) {
                readcode.replace(PogoDefs.templateClass, this.pogo.class_name);
            }
        }
        String newcode = readcode.str;
        if (src_exist) {
            newcode = this.checkForExecMethodModif(new PogoString(newcode), 1);
        }
        newcode = this.addMethodsToExecuteCmd(newcode);
        newcode = this.addClassDescription(newcode);
        newcode = this.addStatesDescriptions(newcode);
        if (this.pogo.attributes.size() > 0) {
            newcode = this.buildAttributesMethods(new PogoString(newcode), 1);
        }
        if (this.properties.size() > 0) {
            newcode = this.properties.addJavaDataMembers(newcode);
            newcode = this.addReadPropMethod(new PogoString(newcode));
        }
        FileOutputStream fidout = new FileOutputStream(server);
        fidout.write(newcode.getBytes());
        fidout.close();
    }

    protected String addMethodsToExecuteCmd(String readcode) throws PogoException {
        PogoString newcode = new PogoString(readcode);
        int start = 0;
        if ((start = readcode.indexOf("\tpublic static void main(String[] argv)", start)) < 0) {
            throw new PogoException(new String("Input File Syntax error !\n\tpublic static void main(String[] argv)\nNot Found !"));
        }
        start = readcode.lastIndexOf("}", start);
        start += 2;
        StringBuffer method = new StringBuffer();
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method || cmd.virtual_method && cmd.override_method != 0) {
                boolean generate = true;
                String signature = cmd.buildJavaExecCmdMethodSignature(0);
                int sig_pos = readcode.indexOf(signature);
                if (sig_pos > 0) {
                    generate = false;
                }
                if (generate) {
                    method.append(cmd.buildJavaExecCmdMethodComments());
                    method.append(cmd.buildJavaExecCmdMethod());
                } else {
                    int start_comments = readcode.lastIndexOf("}", sig_pos) + 3;
                    String old_comments = readcode.substring(start_comments, sig_pos);
                    newcode.replace(old_comments, cmd.buildJavaExecCmdMethodComments());
                }
            }
            ++i;
        }
        newcode.insert(start, method.toString());
        return newcode.toString();
    }

    private String addReadPropMethod(PogoString readcode) throws FileNotFoundException, SecurityException, IOException, PogoException {
        if (this.properties.size() == 0) {
            return readcode.str;
        }
        String templatefile = new String(this.pogo.templates_dir + "/java/readPropMethodName.java");
        FileInputStream fidin = new FileInputStream(templatefile);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString method = new PogoString(inStr);
        fidin.close();
        while (method.str.indexOf(PogoDefs.templateClass) >= 0) {
            method.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        while (method.str.indexOf("target") >= 0) {
            method.replace("target", "device");
        }
        String template_method = new String(method.str);
        int start = readcode.str.indexOf(this.readprop_method_signature);
        if (start < 0) {
            start = readcode.str.indexOf(this.init_signature);
            if (start < 0) {
                throw new PogoException(new String("Syntax error in input file\n" + this.init_signature + "\n Not Found !"));
            }
            start = readcode.inMethod(start);
            start = readcode.outMethod(start) + 1;
            readcode.insert(start, template_method);
        }
        readcode.str = this.properties.updateJavaMethod(readcode.str, "device");
        this.addReadPropMethodCall(readcode);
        return readcode.str;
    }

    private void addReadPropMethodCall(PogoString readcode) throws PogoException {
        int end;
        int start = readcode.str.indexOf(this.init_signature);
        if (start < 0) {
            throw new PogoException(new String("Syntax error in input file\n" + this.init_signature + "\n Not Found !"));
        }
        String meth_core = readcode.str.substring(start = readcode.inMethod(start), end = readcode.outMethod(start));
        if (meth_core.indexOf(readprop_method_name) >= 0) {
            return;
        }
        start = readcode.str.indexOf("Initialise variables to default values", start);
        start = readcode.nextCr(start) + 1;
        start = readcode.nextCr(start) + 1;
        readcode.insert(start, new String("\t\t" + readprop_method_name + "();\n"));
    }

    protected String addStatesDescriptions(String readcode) throws PogoException {
        PogoString pg = new PogoString(readcode);
        int start = pg.str.indexOf("//--------- Start of States Description ----------");
        if (start < 0) {
            throw new PogoException(new String("Input File Syntax error !\n//--------- Start of States Description ----------\n Not found !"));
        }
        int end = pg.str.indexOf("//--------- End of States Description ----------");
        if (end < 0) {
            throw new PogoException(new String("Input File Syntax error !\n//--------- End of States Description ----------\n Not found !"));
        }
        String prev_code = pg.str.substring(start, end);
        StringBuffer sb = new StringBuffer("//--------- Start of States Description ----------");
        sb.append("\n/*\n");
        sb.append(this.pogo.states.toStringComments(1));
        sb.append(" */\n");
        pg.replace(prev_code, sb.toString());
        return pg.str;
    }

    protected String addClassDescription(String readcode) throws PogoException {
        PogoString pg = new PogoString(readcode);
        String startComments = " *\tClass Description:";
        int start = pg.str.indexOf(startComments);
        if (start < 0) {
            throw new PogoException(new String("Input File Syntax error !\n" + startComments + "\n Not found !"));
        }
        String author = " * @author\t$Author:";
        int end = pg.str.indexOf(author);
        if (end < 0) {
            throw new PogoException(new String("Input File Syntax error !\n" + author + "\n Not found !"));
        }
        String prev_code = pg.str.substring(start, end);
        StringBuffer sb = new StringBuffer(startComments);
        sb.append("\n *\t");
        PogoString desc = new PogoString(this.pogo.class_desc);
        sb.append(desc.setComments());
        sb.append("\n *\n");
        pg.replace(prev_code, sb.toString());
        return pg.str;
    }
}

