/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.Cmd;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.Property;
import pogo.gene.PropertyTable;

public class CppServerClass
extends PogoGene
implements PogoDefs,
TangoConst {
    private String serverclass;
    private PropertyTable properties;

    public CppServerClass(PogoClass pogo) {
        super(pogo);
        this.serverclass = new String(pogo.output_files + "/" + pogo.class_name + "Class.cpp");
        this.properties = pogo.class_properties;
    }

    protected String addCmdClassDefs(PogoString code) throws PogoException {
        StringBuffer sb = new StringBuffer();
        int start = code.str.indexOf(PogoDefs.templateCmd);
        if (start < 0) {
            throw new PogoException("Input File Syntax error !");
        }
        start = code.previousCr(start);
        int end = code.inMethod(start);
        end = code.outMethod(end);
        String block = code.str.substring(start, end);
        code = new PogoString(code.str.substring(end));
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method) {
                code.insert(0, cmd.buildCppCmdClassDefs(block));
            }
            ++i;
        }
        if (this.pogo.attributes.size() > 0 && code.str.indexOf("attribute_factory") < 0 && (start = code.str.indexOf("command_factory")) > 0) {
            start = code.nextCr(start) + 1;
            code.insert(start, "\tvoid attribute_factory(vector<Tango::Attr *> &);\n");
        }
        if (this.properties.size() > 0) {
            sb = new StringBuffer("//\tproperties member data\n");
            int i2 = 0;
            while (i2 < this.properties.size()) {
                Property property = this.properties.elementAt(i2);
                sb.append(property.buildDefinition(2));
                ++i2;
            }
            start = code.str.indexOf(": public Tango::DeviceClass");
            if (start < 0) {
                throw new PogoException("Input File Syntax error !");
            }
            if ((start = code.str.indexOf("public:", start)) < 0) {
                throw new PogoException("Input File Syntax error !");
            }
            start = code.nextCr(start) + 1;
            code.insert(start, sb.toString());
            start = code.str.indexOf("command_factory", start);
            if (start < 0) {
                throw new PogoException("Input File Syntax error !");
            }
            start = code.nextCr(start) + 1;
            code.insert(start, "\tvoid get_class_property();\n");
        }
        return code.toString();
    }

    public void generateHeader(String serverclass_h) throws FileNotFoundException, SecurityException, IOException, PogoException {
        int start;
        System.out.println("Generating " + serverclass_h + "....");
        String head_of_file = null;
        String data_members = "";
        if (this.already_exists(serverclass_h)) {
            FileInputStream fidin = new FileInputStream(serverclass_h);
            int nb = fidin.available();
            byte[] inStr = new byte[nb];
            fidin.read(inStr);
            PogoString pgs = new PogoString(inStr);
            fidin.close();
            int end = pgs.str.indexOf("Define classes for commands");
            if (end < 0) {
                throw new PogoException("Syntax error in reading " + serverclass_h);
            }
            end = pgs.nextCr(end) + 1;
            end = pgs.nextCr(end) + 1;
            head_of_file = pgs.str.substring(0, end);
            start = pgs.str.indexOf("//\tadd your own data members here");
            if (start > 0) {
                end = pgs.str.indexOf("public:", start);
                data_members = pgs.str.substring(start, end);
            }
        }
        String templname = new String(this.pogo.templates_dir + "/cpp/" + PogoDefs.templateFile + "Class.h");
        FileInputStream fidin = new FileInputStream(templname);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString templcode = new PogoString(inStr);
        fidin.close();
        while (templcode.str.indexOf(PogoDefs.templateClass.toUpperCase()) >= 0) {
            templcode.replace(PogoDefs.templateClass.toUpperCase(), this.pogo.class_name.toUpperCase());
        }
        while (templcode.str.indexOf(PogoDefs.templateClass) >= 0) {
            templcode.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        start = templcode.str.indexOf("Define classes for commands");
        if (start < 0) {
            throw new PogoException("Syntax error in reading " + serverclass_h);
        }
        start = templcode.nextCr(start) + 1;
        start = templcode.nextCr(start) + 1;
        if (head_of_file == null) {
            head_of_file = templcode.str.substring(0, start);
        }
        templcode = new PogoString(templcode.str.substring(start));
        PogoString new_code = new PogoString(this.addCmdClassDefs(templcode));
        if (data_members.length() > 0 && (start = new_code.str.indexOf("//\tadd your own data members here")) > 0) {
            int end = new_code.str.indexOf("public:", start);
            String tmp = new_code.str.substring(start, end);
            new_code.replace(tmp, data_members);
        }
        FileOutputStream fidout = new FileOutputStream(serverclass_h);
        fidout.write(head_of_file.getBytes());
        fidout.write(new_code.str.getBytes());
        fidout.close();
    }

    public void generateSource(String serverclass) throws FileNotFoundException, SecurityException, IOException, PogoException {
        String get_property;
        System.out.println("Generating " + serverclass + "....");
        String templname = new String(this.pogo.templates_dir + "/cpp/" + PogoDefs.templateFile + "Class.cpp");
        FileInputStream fidin = new FileInputStream(templname);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString templcode = new PogoString(inStr);
        fidin.close();
        while (templcode.str.indexOf(PogoDefs.templateClass) >= 0) {
            templcode.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        String classes = "";
        String factories = "";
        String class_constructor = null;
        if (this.already_exists(serverclass)) {
            fidin = new FileInputStream(serverclass);
            nb = fidin.available();
            inStr = new byte[nb];
            fidin.read(inStr);
            PogoString code = new PogoString(inStr);
            fidin.close();
            classes = this.updateCmdClass(code, templcode);
            class_constructor = this.getClassConstructor(code);
            get_property = this.getGetPropertyMethod(code);
        } else {
            classes = this.createCmdClass(templcode);
            get_property = this.getGetPropertyMethod(null);
        }
        classes = this.updateIsAllowedMethods(classes);
        factories = this.buildFactories(templcode);
        if (class_constructor != null) {
            PogoString tmp = new PogoString(factories);
            String s = this.getClassConstructor(tmp);
            tmp.replace(s, class_constructor);
            factories = tmp.str;
        }
        if ((get_property = this.updatePropertyMethod(get_property)).length() > 0) {
            factories = this.addPutGetPropertyCall(factories, "get");
        }
        factories = this.addPutGetPropertyCall(factories, "write");
        String put_property = this.buildPutPropertyMethod();
        FileOutputStream fidout = new FileOutputStream(serverclass);
        fidout.write(classes.getBytes());
        fidout.write(factories.getBytes());
        fidout.write(get_property.getBytes());
        fidout.write(put_property.getBytes());
        fidout.write(new String("\n}\t// namespace\n").getBytes());
        fidout.close();
    }

    protected String addPutGetPropertyCall(String readcode, String putget) throws PogoException {
        String method_call = new String(putget + "_class_property();");
        String s = this.getClassConstructor(new PogoString(readcode));
        PogoString method_core = new PogoString(s);
        if (s.indexOf(method_call) > 0) {
            return readcode;
        }
        int start = method_core.str.indexOf("cout");
        if (start < 0) {
            return readcode;
        }
        start = method_core.nextCr(start) + 1;
        method_core.insert(start, new String("\t" + method_call + "\n"));
        PogoString newcode = new PogoString(readcode);
        newcode.replace(s, method_core.str);
        return newcode.str;
    }

    protected String updateCmdClass(PogoString readcode, PogoString templcode) throws PogoException {
        int start = templcode.str.indexOf(PogoDefs.templateBlock);
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!");
        }
        int b = 0;
        String construct_templ = this.getCmdBlockFromTemplate(templcode.str, b++);
        String allowed_templ = this.getCmdBlockFromTemplate(templcode.str, b++);
        String exec_templ = this.getCmdBlockFromTemplate(templcode.str, b++);
        int end = start;
        int i = 0;
        while (i < b) {
            end = templcode.str.indexOf(PogoDefs.templateBlock, end + 1);
            ++i;
        }
        end = templcode.nextCr(end) + 1;
        end = readcode.str.indexOf("Initialize pointer for singleton pattern");
        if (end < 0) {
            throw new PogoException("singleton not found in source file");
        }
        end = readcode.previousCr(end);
        end -= 2;
        end = readcode.previousCr(end);
        end -= 2;
        end = readcode.previousCr(end);
        PogoString pgs = new PogoString(readcode.str.substring(0, end));
        int i2 = 0;
        while (i2 < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i2);
            if (!cmd.virtual_method) {
                String method = new String(cmd.cmd_class + "::execute(Tango::DeviceImpl ");
                System.out.println("Checking for " + method);
                int start_meth = pgs.str.indexOf(method);
                if (start_meth < 0) {
                    System.out.println("\t-> creating...");
                    pgs.str = this.insertNewCmdClass(cmd, pgs, templcode.str);
                } else {
                    start_meth = pgs.inMethod(start_meth);
                    int end_meth = pgs.outMethod(start_meth + 1);
                    String oldCore = pgs.str.substring(start_meth, end_meth);
                    PogoString templ = new PogoString(this.getCmdBlockFromTemplate(templcode.str, 2));
                    start_meth = templ.inMethod(0);
                    end_meth = templ.outMethod(start_meth + 1);
                    String newCore = cmd.buildCppCmdClassBlock(templ.str.substring(start_meth, end_meth), this.pogo.class_name);
                    pgs.replace(oldCore, newCore);
                    String oldsig = cmd.constructorSignature(pgs.str);
                    String newSig = cmd.constructorSignature(construct_templ);
                    pgs.replace(oldsig, newSig);
                }
            }
            ++i2;
        }
        return pgs.str;
    }

    protected String createCmdClass(PogoString templcode) throws PogoException {
        int start = templcode.str.indexOf(PogoDefs.templateBlock);
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!");
        }
        String head = templcode.str.substring(0, start);
        int b = 0;
        String construct_templ = this.getCmdBlockFromTemplate(templcode.str, b++);
        String allowed_templ = this.getCmdBlockFromTemplate(templcode.str, b++);
        String exec_templ = this.getCmdBlockFromTemplate(templcode.str, b++);
        int end = start;
        int i = 0;
        while (i < b) {
            end = templcode.str.indexOf(PogoDefs.templateBlock, end + 1);
            ++i;
        }
        end = templcode.nextCr(end) + 1;
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i2);
            if (!cmd.virtual_method) {
                sb.append(cmd.buildCppCmdClassDefs(construct_templ));
                sb.append(cmd.buildCppCmdClassDefs(allowed_templ));
                String s = cmd.buildCppCmdClassDefs(exec_templ);
                sb.append(cmd.buildCppCmdClassBlock(s, this.pogo.class_name));
            }
            ++i2;
        }
        sb.append("\n\n");
        String exec_methods = new String(sb.toString());
        return new String(head + exec_methods);
    }

    protected String buildFactories(PogoString templcode) throws PogoException {
        StringBuffer sb = new StringBuffer();
        int start = templcode.str.indexOf("Initialize pointer for singleton pattern");
        if (start < 0) {
            throw new PogoException("singleton not found in source file");
        }
        start = templcode.previousCr(start);
        start -= 2;
        start = templcode.previousCr(start);
        start -= 2;
        start = templcode.previousCr(start);
        int end = templcode.str.indexOf("command_factory");
        if (end < 0) {
            throw new PogoException("command_factory() method not found !");
        }
        end = templcode.inMethod(end);
        sb.append(templcode.str.substring(start, end));
        sb.append(this.pogo.commands.buildCommandFactoryMethod(2));
        start = templcode.outMethod(end + 1);
        start = templcode.nextCr(start);
        end = templcode.str.indexOf("device_factory");
        if (end < 0) {
            throw new PogoException("device_factory() method not found !");
        }
        end = templcode.inMethod(end);
        end = templcode.outMethod(end + 1);
        end = templcode.nextCr(end);
        sb.append(templcode.str.substring(start, end));
        if (this.pogo.attributes.size() > 0) {
            sb.append("//+----------------------------------------------------------------------------\n");
            sb.append("//\tMethod: " + this.pogo.class_name + "Class::attribute_factory(vector<Tango::Attr *> &att_list)\n");
            sb.append("//-----------------------------------------------------------------------------\n");
            sb.append("void " + this.pogo.class_name + "Class::attribute_factory(vector<Tango::Attr *> &att_list)\n");
            sb.append(this.pogo.attributes.buildFactory(2));
        }
        return sb.toString();
    }

    protected String insertNewCmdClass(Cmd cmd, PogoString pgs, String templcode) throws PogoException {
        int b = 0;
        String construct_templ = this.getCmdBlockFromTemplate(templcode, b++);
        String allowed_templ = this.getCmdBlockFromTemplate(templcode, b++);
        String exec_templ = this.getCmdBlockFromTemplate(templcode, b++);
        int idx = 0;
        idx = pgs.str.indexOf(new String("namespace " + this.pogo.class_name));
        if (idx < 0) {
            int i = 0;
            while ((i = pgs.str.indexOf("#include", i)) >= 0) {
                idx = i++;
            }
        }
        idx = pgs.nextCr(idx) + 2;
        StringBuffer new_cmd = new StringBuffer("");
        new_cmd.append(cmd.buildCppCmdClassDefs(construct_templ));
        new_cmd.append(cmd.buildCppCmdClassDefs(allowed_templ));
        String s = cmd.buildCppCmdClassDefs(exec_templ);
        new_cmd.append(cmd.buildCppCmdClassBlock(s, this.pogo.class_name));
        StringBuffer sb = new StringBuffer(pgs.str);
        sb.insert(idx, (Object)new_cmd);
        return sb.toString();
    }

    protected String getCmdBlockFromTemplate(String templcode, int num) throws PogoException {
        int start = 0;
        int i = 0;
        while (i <= num) {
            if ((start = templcode.indexOf(PogoDefs.templateBlock, start + 1)) < 0) {
                throw new PogoException("Input File Syntax error 1!" + PogoDefs.templateBlock + "Not found");
            }
            ++i;
        }
        start = templcode.indexOf("\n", start);
        int end = templcode.indexOf(PogoDefs.templateBlock, start);
        return templcode.substring(start, end);
    }

    protected String updateIsAllowedMethods(String readcode) throws PogoException {
        PogoString pgs = new PogoString(readcode);
        int i = 0;
        while (i < this.pogo.commands.size()) {
            Cmd cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method) {
                String pattern = new String("bool " + cmd.cmd_class + "::is_allowed");
                int start = pgs.str.indexOf(pattern);
                if (start < 0) {
                    throw new PogoException("\"" + pattern + "\" Not Found in source file !");
                }
                start = pgs.previousCr(start);
                int end = pgs.nextCr(start) + 1;
                String line = pgs.str.substring(start, end);
                start = pgs.inMethod(start);
                end = pgs.outMethod(start);
                String method = pgs.str.substring(start, end);
                String newMethod = cmd.buildIsAllowedMethod(new PogoString(method), 2);
                pgs.replace(new String(line + method), new String(line + newMethod));
            }
            ++i;
        }
        return pgs.str;
    }

    protected String getClassConstructor(PogoString readcode) throws PogoException {
        int start = readcode.str.indexOf("::_instance = NULL;");
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!'::_instance = NULL;' Not found");
        }
        int end = start = readcode.nextCr(start) + 1;
        while (readcode.str.charAt(end) != '{') {
            ++end;
        }
        end = readcode.outMethod(end);
        end = readcode.inMethod(end + 1);
        end = readcode.outMethod(end);
        return readcode.str.substring(start, end);
    }

    protected String getGetPropertyMethod(PogoString readcode) throws FileNotFoundException, SecurityException, IOException {
        int start;
        String get_property_signature = new String("void " + this.pogo.class_name + "Class::get_class_property()");
        if (readcode == null || (start = readcode.str.indexOf(get_property_signature)) < 0) {
            String templname = new String(this.pogo.templates_dir + "/cpp/" + "readPropMethodName.cpp");
            FileInputStream fidin = new FileInputStream(templname);
            int nb = fidin.available();
            byte[] inStr = new byte[nb];
            fidin.read(inStr);
            PogoString templcode = new PogoString(inStr);
            fidin.close();
            while (templcode.str.indexOf(PogoDefs.templateClass) >= 0) {
                templcode.replace(PogoDefs.templateClass, new String(this.pogo.class_name + "Class"));
            }
            while (templcode.str.indexOf("target") >= 0) {
                templcode.replace("target", "class");
            }
            return templcode.str;
        }
        int end = readcode.inMethod(start);
        end = readcode.outMethod(end + 1);
        while (readcode.str.charAt(start) != '}') {
            --start;
        }
        return readcode.str.substring(start += 2, end);
    }

    protected String updatePropertyMethod(String readcode) throws PogoException {
        if (this.properties.size() == 0) {
            return "";
        }
        PogoString core = new PogoString(readcode);
        int start = core.str.indexOf("Automatic code generation");
        if (start < 0) {
            throw new PogoException("Input File Syntax error 1!'Automatic code generation' Not found");
        }
        start = core.nextCr(start) + 1;
        start = core.nextCr(start) + 1;
        int end = core.str.indexOf("End of Automatic code generation", start);
        end = core.previousCr(end);
        StringBuffer sb = new StringBuffer(core.str.substring(0, start));
        sb.append("\tTango::DbData\tdata;\n");
        int i = 0;
        while (i < this.properties.size()) {
            Property property = this.properties.elementAt(i);
            sb.append("\tdata.push_back(Tango::DbDatum(\"" + property.name + "\"));\n");
            ++i;
        }
        sb.append("\n");
        sb.append("\t//\tCall database and extract values\n");
        sb.append("\t//--------------------------------------------\n");
        sb.append("\tget_db_class()->get_property(data);\n");
        int i2 = 0;
        while (i2 < this.properties.size()) {
            Property property = this.properties.elementAt(i2);
            sb.append("\tif (data[" + i2 + "].is_empty()==false)");
            sb.append("\tdata[" + i2 + "]  >>  " + property.getVarName() + ";\n");
            ++i2;
        }
        sb.append("\n");
        sb.append(core.str.substring(end));
        return sb.toString();
    }

    protected String buildPutPropertyMethod() throws FileNotFoundException, SecurityException, IOException, PogoException {
        String templname = new String(this.pogo.templates_dir + "/cpp/write_property.cpp");
        FileInputStream fidin = new FileInputStream(templname);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString readcode = new PogoString(inStr);
        fidin.close();
        while (readcode.str.indexOf(PogoDefs.templateClass) >= 0) {
            readcode.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        String tag = "PogoProjectTitle";
        String pattern = new String("\"" + this.pogo.title + "\"");
        while (readcode.str.indexOf(tag) >= 0) {
            readcode.replace(tag, pattern);
        }
        tag = "PogoClassDescription";
        int start = 0;
        PogoString desc = new PogoString(this.pogo.class_desc);
        pattern = "\\n\\";
        while ((start = desc.str.indexOf(10, start)) >= 0) {
            desc.insert(start, pattern);
            start += pattern.length() + 1;
        }
        String tmp = desc.str;
        if (tmp.length() > 255) {
            tmp = tmp.substring(0, 255);
        }
        pattern = new String("\"" + tmp + "\"");
        while (readcode.str.indexOf(tag) >= 0) {
            readcode.replace(tag, pattern);
        }
        return readcode.str;
    }
}

