/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.TangoDs.TangoConst;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import pogo.gene.PogoClass;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoGene;
import pogo.gene.PogoString;
import pogo.gene.Property;
import pogo.gene.PropertyTable;

public class CppServer
extends PogoGene
implements PogoDefs,
TangoConst {
    private String server;
    private PropertyTable properties;
    private static String readprop_method_name = "get_device_property";
    private String readprop_method_signature;
    private String init_signature;

    public CppServer(PogoClass pogo) {
        super(pogo);
        this.server = new String(pogo.output_files + "/" + pogo.class_name + "Class.cpp");
        this.properties = pogo.dev_properties;
        this.init_signature = new String("void " + pogo.class_name + "::" + "init_device");
        this.readprop_method_signature = new String("void " + pogo.class_name + "::" + readprop_method_name + "()");
    }

    private String addPropertyDataMembers(PogoString readcode) throws PogoException {
        String tagStr = "Device properties member data.";
        int start = readcode.str.indexOf(tagStr);
        if (start < 0) {
            start = readcode.str.indexOf("Attributs member data.");
            if (start < 0) {
                throw new PogoException("Tags not found in header file");
            }
            start = readcode.inMethod(start) + 1;
            start = readcode.outMethod(start) + 1;
            StringBuffer sb = new StringBuffer("/**\n");
            sb.append(" * @name Device properties\n");
            sb.append(" * " + tagStr + "\n */\n");
            sb.append("//@{\n//@}\n\n");
            readcode.insert(start, sb.toString());
        }
        start = readcode.inMethod(start) + 2;
        int end = readcode.str.indexOf("//@}", start);
        String old = readcode.str.substring(start, end);
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.properties.size()) {
            Property property = this.properties.elementAt(i);
            sb.append("/**\n");
            sb.append(" *\t" + new PogoString(property.description).setComments() + "\n");
            sb.append(" */\n");
            String type = property.type.cpp;
            if (type.equals("Tango::DevString")) {
                type = "string";
            }
            sb.append("\t" + type + "\t" + property.getVarName() + ";\n");
            ++i;
        }
        if (old.length() > 0) {
            readcode.replace(start, old, sb.toString());
        } else {
            readcode.insert(start, sb.toString());
        }
        if (readcode.str.indexOf(readprop_method_name) < 0) {
            start = readcode.str.indexOf("Here is the end of the automatic");
            while (readcode.str.charAt(start) != '}') {
                --start;
            }
            start = readcode.previousCr(start);
            sb = new StringBuffer("");
            sb.append("/**\n");
            sb.append(" *\tRead the device properties from database\n");
            sb.append(" */\n");
            sb.append("\t void " + readprop_method_name + "();\n");
            readcode.insert(start, sb.toString());
        }
        return readcode.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected String addPrototypes(PogoString readcode) throws PogoException {
        newcode = new StringBuffer();
        start = readcode.str.indexOf("public Tango::Device_2Impl");
        if (start >= 0) ** GOTO lbl6
        throw new PogoException("Input File Syntax error !", "\"public Tango::Device_2Impl\" NOT FOUND");
lbl-1000:
        // 1 sources

        {
            --start;
lbl6:
            // 2 sources

            ** while (start > 0 && readcode.str.charAt((int)start) != '\n')
        }
lbl7:
        // 1 sources

        header = this.setProjectTitle(readcode.str.substring(0, start));
        end = header.indexOf(PogoDefs.classDescRes);
        if (end > 0) {
            end = header.indexOf(" * ", end) + 3;
            newcode.append(header.substring(0, end));
        } else {
            newcode.append(header);
            newcode.append("\n/**\n * " + PogoDefs.classDescRes + "\n * ");
        }
        if (this.pogo.class_desc != null) {
            newcode.append(new PogoString(this.pogo.class_desc).setComments());
        }
        newcode.append("\n */\n");
        newcode.append("\n/*\n");
        newcode.append(this.pogo.states.toStringComments(2));
        newcode.append(" */\n\n");
        end = readcode.str.indexOf("//@{");
        if (end >= 0) ** GOTO lbl33
        throw new PogoException("Input File Syntax error !", "tag:  \"//@{\"   NOT FOUND");
lbl-1000:
        // 1 sources

        {
            ++end;
lbl33:
            // 2 sources

            ** while (readcode.str.charAt((int)end) != '\n')
        }
lbl34:
        // 1 sources

        newcode.append(readcode.str.substring(start, ++end));
        i = 0;
        while (i < this.pogo.attributes.size()) {
            attr = this.pogo.attributes.elementAt(i);
            newcode.append(attr.cppMemberData());
            ++i;
        }
        start = readcode.str.indexOf("//@}", end);
        end = readcode.str.indexOf("always_executed_hook");
        if (end < 0) {
            throw new PogoException("Input File Syntax error !", "\"always_executed_hook\" NOT FOUND");
        }
        end = readcode.str.indexOf("\n", end) + 1;
        newcode.append(readcode.str.substring(start, end));
        newcode.append("\n//@}\n\n");
        newcode.append("/**\n * @name " + this.pogo.class_name + " methods prototypes\n */\n\n//@{\n");
        if (this.pogo.attributes.size() > 0) {
            newcode.append(PogoDefs.readAttrProto2);
            newcode.append(PogoDefs.readAttrProto3);
            writable = false;
            i = 0;
            while (i < this.pogo.attributes.size()) {
                attr = this.pogo.attributes.elementAt(i);
                if (attr.getWritable()) {
                    writable = true;
                }
                ++i;
            }
            if (writable) {
                newcode.append(PogoDefs.writeAttrProto);
            }
        }
        i = 0;
        while (i < this.pogo.commands.size()) {
            cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method || cmd.virtual_method && cmd.override_method != 0) {
                newcode.append(cmd.buildCppCmdProtypes());
            }
            ++i;
        }
        newcode.append("\n//@}\n");
        start = readcode.str.indexOf("Here is the end of the automatic");
        while (start > 0 && readcode.str.charAt(start) != '\n') {
            --start;
        }
        if (start < 0) {
            throw new PogoException("Input File Syntax error !\n\"//@}\" tag NOT FOUND");
        }
        newcode.append(readcode.str.substring(start));
        return newcode.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void generateHeader(String server_h) throws FileNotFoundException, SecurityException, IOException, PogoException {
        block3: {
            System.out.println("Generating " + server_h + "....");
            filename = this.already_exists(server_h) != false ? server_h : new String(this.pogo.templates_dir + "/cpp/" + PogoDefs.templateFile + ".h");
            fidin = new FileInputStream(filename);
            nb = fidin.available();
            inStr = new byte[nb];
            fidin.read(inStr);
            readcode = new PogoString(inStr);
            fidin.close();
            if (this.already_exists(server_h)) ** GOTO lbl20
            while (readcode.str.indexOf(PogoDefs.templateClass.toUpperCase()) >= 0) {
                readcode.replace(PogoDefs.templateClass.toUpperCase(), this.pogo.class_name.toUpperCase());
            }
            while (readcode.str.indexOf(PogoDefs.templateClass) >= 0) {
                readcode.replace(PogoDefs.templateClass, this.pogo.class_name);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                System.out.println("Replacing DeviceImpl by Device_2Impl");
                readcode.replace("DeviceImpl", "Device_2Impl");
lbl20:
                // 2 sources

                ** while (readcode.str.indexOf((String)"DeviceImpl") >= 0)
            }
        }
        newcode = this.addPrototypes(readcode);
        newcode = this.addPropertyDataMembers(new PogoString(newcode));
        fidout = new FileOutputStream(server_h);
        fidout.write(newcode.getBytes());
        fidout.close();
    }

    /*
     * Unable to fully structure code
     */
    public void generateSource(String server) throws FileNotFoundException, SecurityException, IOException, PogoException {
        block5: {
            System.out.println("Generating " + server + "....");
            src_exist = this.already_exists(server);
            filename = src_exist != false ? server : new String(this.pogo.templates_dir + "/cpp/" + PogoDefs.templateFile + ".cpp");
            fidin = new FileInputStream(filename);
            nb = fidin.available();
            inStr = new byte[nb];
            fidin.read(inStr);
            readcode = new PogoString(inStr);
            fidin.close();
            if (src_exist) ** GOTO lbl18
            while (readcode.str.indexOf(PogoDefs.templateClass) >= 0) {
                readcode.replace(PogoDefs.templateClass, this.pogo.class_name);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                System.out.println("Replacing DeviceImpl by Device_2Impl");
                readcode.replace("DeviceImpl(cl", "Device_2Impl(cl");
lbl18:
                // 2 sources

                ** while (readcode.str.indexOf((String)"DeviceImpl(cl") >= 0)
            }
        }
        newcode = this.addMethodsToExecuteCmd(readcode.str);
        if (src_exist) {
            newcode = this.checkForExecMethodModif(new PogoString(newcode), 2);
        }
        if (this.pogo.attributes.size() > 0) {
            newcode = this.buildAttributesMethods(new PogoString(newcode), 2);
        }
        if (this.properties.size() > 0) {
            newcode = this.addReadPropMethod(new PogoString(newcode));
        }
        fidout = new FileOutputStream(server);
        fidout.write(newcode.getBytes());
        fidout.close();
    }

    /*
     * Unable to fully structure code
     */
    protected String addMethodsToExecuteCmd(String readcode) throws PogoException {
        newcode = new StringBuffer();
        start = 0;
        end = readcode.indexOf("//==========================", start);
        if (end >= 0) ** GOTO lbl7
        throw new PogoException("Input File Syntax error !");
lbl-1000:
        // 1 sources

        {
            ++end;
lbl7:
            // 2 sources

            ** while (readcode.charAt((int)end) != '\n')
        }
lbl8:
        // 1 sources

        newcode.append(readcode.substring(start, ++end));
        newcode.append(this.addCommentsCmdMethod());
        start = readcode.indexOf("#include", start);
        if (start < 0) {
            throw new PogoException("Input File Syntax error !");
        }
        start = readcode.lastIndexOf("//", start);
        start = readcode.indexOf("\n", start) + 1;
        namespace = new String("namespace " + this.pogo.class_name);
        if (readcode.indexOf(namespace) < 0) {
            newcode.append(readcode.substring(start));
            namespace_exist = false;
        } else {
            end = readcode.length() - 1;
            while (readcode.charAt(end) != '}') {
                --end;
            }
            while (readcode.charAt(end) != '\n') {
                --end;
            }
            newcode.append(readcode.substring(start, end));
            namespace_exist = true;
        }
        i = 0;
        while (i < this.pogo.commands.size()) {
            cmd = this.pogo.commands.cmdIdx(i);
            if (!cmd.virtual_method || cmd.override_method == 1) {
                line = cmd.buildCppExecCmdMethodSignature(this.pogo.class_name);
                System.out.println(line);
                sl = line.indexOf("(");
                el = line.indexOf(" ", sl);
                if (el < 0) {
                    el = sl + 1;
                }
                if (readcode.indexOf(line = line.substring(0, el)) < 0) {
                    newcode.append(new String("\n"));
                    newcode.append(cmd.buildCppExecCmdMethodComments(this.pogo.class_name));
                    newcode.append(cmd.buildCppExecCmdMethod(this.pogo.class_name));
                    if (cmd.virtual_method) {
                        cmd.override_method = 2;
                    }
                } else {
                    System.out.println("\t" + cmd.exec_method + "() already exists  --> Do not overwrite");
                }
            }
            ++i;
        }
        if (namespace_exist) {
            newcode.append(new String("\n}\t//\tnamespace\n"));
        }
        return newcode.toString();
    }

    private String addReadPropMethod(PogoString readcode) throws FileNotFoundException, SecurityException, IOException, PogoException {
        if (this.properties.size() == 0) {
            return readcode.str;
        }
        String templatefile = new String(this.pogo.templates_dir + "/cpp/readPropMethodName.cpp");
        FileInputStream fidin = new FileInputStream(templatefile);
        int nb = fidin.available();
        byte[] inStr = new byte[nb];
        fidin.read(inStr);
        PogoString method = new PogoString(inStr);
        fidin.close();
        while (method.str.indexOf(PogoDefs.templateClass) >= 0) {
            method.replace(PogoDefs.templateClass, this.pogo.class_name);
        }
        while (method.str.indexOf("target") >= 0) {
            method.replace("target", "device");
        }
        String template_method = new String(method.str);
        int start = readcode.str.indexOf(this.readprop_method_signature);
        if (start < 0) {
            start = readcode.str.indexOf(this.init_signature);
            if (start < 0) {
                throw new PogoException("Syntax error in existing Source file", new String(this.init_signature + " not found "));
            }
            start = readcode.inMethod(start);
            start = readcode.outMethod(start) + 1;
            readcode.insert(start, template_method);
        }
        int start0 = start;
        if ((start = readcode.str.indexOf("Automatic code generation", start)) <= 0) {
            throw new PogoException("Syntax error in existing Source file", "\"Automatic readcode generation\"  Not Found");
        }
        start = readcode.nextCr(start) + 1;
        int end = readcode.str.indexOf("Automatic code generation", start = readcode.nextCr(start) + 1);
        if (end < 0) {
            throw new PogoException("Syntax error in existing Source file", "\"Automatic readcode generation\"  Not Found");
        }
        end = readcode.previousCr(end) - 1;
        String oldCode = readcode.str.substring(start, end);
        StringBuffer sb = new StringBuffer("\tTango::DbData\tdata;\n");
        int i = 0;
        while (i < this.properties.size()) {
            Property property = this.properties.elementAt(i);
            sb.append("\tdata.push_back(Tango::DbDatum(\"" + property.name + "\"));\n");
            ++i;
        }
        sb.append("\n");
        sb.append("\t//\tCall database and extract values\n");
        sb.append("\t//--------------------------------------------\n");
        sb.append("\tget_db_device()->get_property(data);\n");
        int i2 = 0;
        while (i2 < this.properties.size()) {
            Property property = this.properties.elementAt(i2);
            sb.append("\tif (data[" + i2 + "].is_empty()==false)");
            sb.append("\tdata[" + i2 + "]  >>  " + property.getVarName() + ";\n");
            ++i2;
        }
        sb.append("\n");
        readcode.replace(start, oldCode, sb.toString());
        this.addReadPropMethodCall(readcode);
        return readcode.str;
    }

    private void addReadPropMethodCall(PogoString readcode) throws PogoException {
        int end;
        int start = readcode.str.indexOf(this.init_signature);
        if (start < 0) {
            throw new PogoException("Syntax error in existing Source file");
        }
        String meth_core = readcode.str.substring(start = readcode.inMethod(start), end = readcode.outMethod(start));
        if (meth_core.indexOf(readprop_method_name) >= 0) {
            return;
        }
        start = readcode.str.indexOf("Initialise variables to default values", start);
        start = readcode.nextCr(start) + 1;
        start = readcode.nextCr(start) + 1;
        readcode.insert(start, new String("\t" + readprop_method_name + "();\n"));
    }
}

