/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.TangoConst;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoDefs;
import pogo.gene.PogoException;
import pogo.gene.PogoString;
import pogo.gene.TangoTypes;

public class Cmd
implements TangoConst,
PogoDefs {
    public String command;
    public String description;
    public String exec_method;
    public String cmd_class;
    public TangoTypes argin;
    public TangoTypes argout;
    public DispLevel level = DispLevel.OPERATOR;
    public DevStateTable notAllowedFor;
    public boolean virtual_method;
    public int override_method;
    public int polled_period;

    private void cmdFactory(String name, String cc, String in_type, String out_type, String in_desc, String out_desc, String desc) {
        this.command = new String(name);
        this.cmd_class = new String(cc);
        this.exec_method = this.buildExecCmdMethodName();
        this.argin = new TangoTypes(in_type, in_desc);
        this.argout = new TangoTypes(out_type, out_desc);
        this.notAllowedFor = new DevStateTable();
        if (desc != null) {
            this.description = new String(desc);
        }
        this.virtual_method = false;
        this.override_method = 0;
    }

    public Cmd(String name, String cc, String in_type, String out_type, String in_desc, String out_desc, String desc) {
        this.cmdFactory(name, cc, in_type, out_type, in_desc, out_desc, desc);
    }

    public Cmd(String name, String cc, String in_type, String out_type, String in_desc, String out_desc, String desc, DispLevel level) {
        this.cmdFactory(name, cc, in_type, out_type, in_desc, out_desc, desc);
        this.level = level;
    }

    public Cmd(String cmdLine) throws PogoException {
        String[] fields = new PogoString(cmdLine).getFields();
        this.cmdFactory(fields[1], fields[0], fields[2], fields[3], fields[4], fields[5], "");
        if (fields.length >= 7 && fields[6].equals("Tango::EXPERT")) {
            this.level = DispLevel.EXPERT;
        }
    }

    public void setDescription(String str) {
        this.description = new String(str);
    }

    private String buildExecCmdMethodName() {
        if (this.command.equals("State")) {
            return "dev_state";
        }
        if (this.command.equals("Status")) {
            return "dev_status";
        }
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < this.command.length()) {
            if (this.command.charAt(i) >= 'A' && this.command.charAt(i) <= 'Z') {
                if (i > 0 && (this.command.charAt(i - 1) < 'A' || this.command.charAt(i - 1) > 'Z')) {
                    sb.append('_');
                }
                sb.append((char)(this.command.charAt(i) + 32));
            } else {
                sb.append(this.command.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public void setPolledPerriod(String cmd_factory) {
        String target = new String("if (command_list[i]->get_name()==\"" + this.command + "\")\n" + "\t\t\tcommand_list[i]->set_polling_period(");
        int start = cmd_factory.indexOf(target);
        if (start > 0) {
            int end = cmd_factory.indexOf(")", start += target.length());
            try {
                this.polled_period = Integer.parseInt(cmd_factory.substring(start, end));
            }
            catch (NumberFormatException e) {
                this.polled_period = 0;
            }
        }
    }

    public boolean isExecMethod(String line) {
        if (line.indexOf(59) >= 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(line);
        while (st.countTokens() > 0) {
            int end;
            String s = st.nextToken().toString();
            int start = s.indexOf("::");
            if (start > 0) {
                s = s.substring(start + "::".length());
            }
            if ((end = s.indexOf("(")) > 0) {
                s = s.substring(0, end);
            }
            if (!s.equals(this.exec_method)) continue;
            return true;
        }
        return false;
    }

    public void checkCppExecCmdMethodName(String filename) throws PogoException {
        try {
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            fid.read(inStr);
            String str = new String(inStr);
            fid.close();
            String pattern = new String(this.cmd_class + "::execute");
            int start = str.indexOf(pattern);
            if (start < 0) {
                System.out.println(pattern + "\nClass not found -> does'nt change name !");
                return;
            }
            if ((start = str.indexOf("static_cast", start)) < 0) {
                System.out.println("insert not found -> does'nt change name !");
                return;
            }
            int end = str.indexOf(";", start);
            String line = str.substring(start, end);
            String name = line.substring(start = line.indexOf("->") + 2, end = line.indexOf("(", start)).trim();
            if (!this.exec_method.equals(name)) {
                System.out.println(name + ": Not conventionnal name !");
                System.out.println("It should be :   " + this.exec_method + "()...");
                this.exec_method = new String(name);
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("File Not Found Do not change exec method name");
        }
        catch (SecurityException ex) {
            System.out.println("File Not Found Do not change exec method name");
        }
        catch (IOException ex) {
            System.out.println("File Not Found Do not change exec method name");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkJavaExecCmdMethodName(String filename) throws PogoException {
        try {
            int start;
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            fid.read(inStr);
            String str = new String(inStr);
            fid.close();
            String pattern = new String(")(device)).");
            int end = 0;
            while ((start = str.indexOf(pattern, end)) > 0) {
                void var6_11;
                start = var6_11 + pattern.length();
                String name = str.substring(start, end = str.indexOf("(", start)).trim();
                if (this.exec_method.equals(name)) continue;
                System.out.println("\"" + this.exec_method + "\"");
                this.exec_method = new String(name);
                System.out.println(this.exec_method + ": Not conventionnal name !\n");
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("File Not Found Do not change exec method name");
        }
        catch (SecurityException ex) {
            System.out.println("File Not Found Do not change exec method name");
        }
        catch (IOException ex) {
            System.out.println("File Not Found Do not change exec method name");
        }
    }

    public String constructorSignature(String code) {
        PogoString pgs = new PogoString(code);
        String defaultname = "DevTemplateCmd::DevTemplateCmd";
        String name = this.cmd_class + "::" + this.cmd_class;
        while (pgs.str.indexOf(defaultname) >= 0) {
            pgs.replace(defaultname, name);
        }
        int start = pgs.str.indexOf(name);
        start = pgs.str.indexOf(name, start + 1);
        int end = pgs.str.indexOf("{", start);
        code = pgs.str.substring(start, end);
        return code;
    }

    public String AddCmdPollingLine(int lang) {
        StringBuffer sb = new StringBuffer();
        if (lang != 1 && this.polled_period > 0) {
            sb.append("\t\tif (command_list[i]->get_name()==\"" + this.command + "\")\n");
            sb.append("\t\t\tcommand_list[i]->set_polling_period(" + this.polled_period + ");\n");
        }
        return sb.toString();
    }

    public String AddCmdFactoryLine(int lang) {
        String add_list_str = lang == 1 ? PogoDefs.javaAddCommands : PogoDefs.cppAddCommands;
        String tab0 = lang == 1 ? "\t\t" : "\t";
        String tab = lang == 1 ? "\t\t\t" : "\t\t";
        StringBuffer sb = new StringBuffer(tab0 + add_list_str + "(new ");
        sb.append(this.cmd_class + "(\"" + this.command + "\",\n" + tab);
        if (lang == 1) {
            sb.append(this.argin.java_code_str);
        } else {
            sb.append(this.argin.cpp_code_str);
        }
        sb.append(", ");
        if (lang == 1) {
            sb.append(this.argout.java_code_str);
        } else {
            sb.append(this.argout.cpp_code_str);
        }
        sb.append(",\n" + tab);
        if (this.argin.description == null) {
            sb.append("\"\",\n" + tab);
        } else {
            sb.append("\"" + this.argin.description + "\",\n" + tab);
        }
        if (this.argout.description == null) {
            sb.append("\"\"));\n");
        } else {
            sb.append("\"" + this.argout.description + "\"");
        }
        if (lang == 1) {
            sb.append("));\n");
        } else if (this.level == DispLevel.EXPERT) {
            sb.append(",\n" + tab + "Tango::EXPERT));\n");
        } else {
            sb.append(",\n" + tab + "Tango::OPERATOR));\n");
        }
        return sb.toString();
    }

    public boolean execMethodArgsChanged(String line, int lang) {
        String argin;
        String s1;
        StringTokenizer st1;
        StringTokenizer st = new StringTokenizer(line);
        String s = st.nextToken().toString();
        String argout = lang == 1 ? st.nextToken().toString() : s;
        int start = line.indexOf("(") + 1;
        int end = line.indexOf(")");
        if (end < 0) {
            end = line.length();
        }
        if ((st1 = new StringTokenizer(s1 = line.substring(start, end))).countTokens() > 0) {
            argin = st1.nextToken().toString();
            if (argin.equals("const")) {
                argin = st1.nextToken().toString();
            }
        } else {
            argin = new String("void");
        }
        switch (lang) {
            case 1: {
                return !this.argin.java.equals(argin) || !this.argout.java.equals(argout);
            }
            case 2: {
                if (!this.argin.cpp.equals(argin)) {
                    System.out.println("ARGIN CHANGED " + argin + " - " + this.argin.cpp);
                }
                if (!this.argout.cpp.equals(argout)) {
                    System.out.println("ARGOUT CHANGED " + argout + " - " + this.argout.cpp);
                }
                return !this.argin.cpp.equals(argin) || !this.argout.cpp.equals(argout);
            }
        }
        return false;
    }

    public String buildJavaExecuteMethodBlock(String class_name) {
        StringBuffer sb = new StringBuffer("");
        String indent = new String("\t\t");
        if (this.argin.code != 0) {
            sb.append(indent + this.argin.java + " argin = " + this.argin.javaExtract() + "(in_any);\n");
        }
        if (!this.argout.java.equals("void")) {
            sb.append(indent + "return insert(");
        } else {
            sb.append(indent);
        }
        sb.append("((" + class_name + ")(device))." + this.exec_method + "(");
        if (!this.argin.java.equals("void")) {
            sb.append("argin");
        }
        if (!this.argout.java.equals("void")) {
            sb.append("));\n");
        } else {
            sb.append(");\n" + indent + "return insert();\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    public String buildJavaExecCmdMethodComments() {
        StringBuffer sb = new StringBuffer("\n\n");
        sb.append("//=========================================================\n");
        sb.append("/**\n");
        sb.append(" *\tExecute command \"" + this.command + "\" on device.\n");
        if (this.description != null && this.description.length() > 0) {
            sb.append(" *\t" + new PogoString(this.description).setComments() + "\n");
        }
        sb.append(" *\n");
        if (!this.argin.java.equals("void")) {
            sb.append(" * @param\targin\t" + this.argin.description + "\n");
        }
        if (!this.argout.java.equals("void")) {
            sb.append(" * @return\t" + this.argout.description + "\n");
        }
        sb.append(" */\n");
        sb.append("//=========================================================\n");
        return sb.toString();
    }

    public String buildJavaExecCmdMethodSignature(int out) {
        StringBuffer sb = new StringBuffer("\tpublic ");
        sb.append(this.argout.java + " ");
        if (out == 0) {
            sb.append(this.exec_method);
        } else {
            sb.append(this.command);
        }
        sb.append("(");
        if (this.argin.code != 0) {
            sb.append(this.argin.java + " argin");
        }
        sb.append(") throws DevFailed");
        return sb.toString();
    }

    public String buildJavaExecCmdMethod() {
        StringBuffer sb = new StringBuffer(this.buildJavaExecCmdMethodSignature(0) + "\n\t{\n");
        if (this.argout.code != 0) {
            sb.append("\t\t" + this.argout.java + "\targout = ");
            if (this.command.equals("State")) {
                sb.append(" super.dev_state();\n\n");
            } else if (this.command.equals("Status")) {
                sb.append(" super.dev_status();\n\n");
            } else if (this.argout.is_array && !this.argout.need_2constr) {
                sb.append("new " + this.argout.java);
                sb.insert(sb.length() - 1, '5');
                sb.append(";\n\n");
            } else if (this.argout.need_constr) {
                sb.append("new " + this.argout.java + "();\n\n");
            } else {
                sb.append(" (" + this.argout.java + ")0;\n\n");
            }
        }
        sb.append("\t\tUtil.out2.println(\"Entering " + this.exec_method + "()\");\n");
        sb.append("\n\t\t// ---Add your Own code to control device here ---\n\n");
        sb.append("\t\tUtil.out2.println(\"Exiting " + this.exec_method + "()\");\n");
        if (this.argout.code != 0) {
            sb.append("\t\treturn argout;\n");
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    public String buildJavaProxyMethod() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\t{\n");
        if (this.command.equals("State")) {
            sb.append("\t\treturn state();\n");
        } else if (this.command.equals("Status")) {
            sb.append("\t\treturn status();\n");
        } else {
            if (this.argin.code != 0) {
                sb.append("\t\tdata_in.insert(argin);\n");
                sb.append("\t\tdata_out = command_inout(\"" + this.command + "\", data_in);\n");
            } else {
                sb.append("\t\tdata_out = command_inout(\"" + this.command + "\");\n");
            }
            if (this.argout.code != 0) {
                sb.append("\t\treturn data_out." + this.argout.extract_method() + "();\n");
            }
        }
        sb.append("\t}\n");
        return sb.toString();
    }

    public String buildCppCmdProtypesLine() {
        StringBuffer sb = new StringBuffer("");
        if (this.virtual_method) {
            sb.append("virtual ");
        }
        sb.append(this.argout.cpp + "\t");
        if (this.argout.code != 8 && (this.argout.need_constr || this.argout.is_array)) {
            sb.append("*");
        }
        sb.append(this.exec_method + "(");
        if (this.argin.code != 0) {
            if (this.argin.is_array) {
                sb.append("const ");
            }
            sb.append(this.argin.cpp);
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                sb.append(" *");
            }
        }
        sb.append(");\n");
        return sb.toString();
    }

    public String buildCppCmdProtypes() {
        StringBuffer sb = new StringBuffer("/**\n * ");
        if (this.description != null) {
            sb.append(new PogoString(this.description).setComments());
        }
        if (this.argin.code != 0) {
            sb.append("\n *\t@param\targin\t");
            if (this.argin.description != null) {
                sb.append(new PogoString(this.argin.description).setComments());
            }
        }
        if (this.argout.code != 0) {
            sb.append("\n *\t@return\t");
            if (this.argout.description != null) {
                sb.append(new PogoString(this.argout.description).setComments());
            }
        }
        sb.append("\n *\t@exception DevFailed");
        sb.append("\n */\n");
        sb.append("\t");
        sb.append(this.buildCppCmdProtypesLine());
        return sb.toString();
    }

    public String buildCppCmdClassDefs(String str) {
        PogoString pgs = new PogoString(str);
        while (pgs.str.indexOf(PogoDefs.templateCmd) >= 0) {
            pgs.replace(PogoDefs.templateCmd, this.cmd_class);
        }
        pgs.append("\n\n");
        return pgs.str;
    }

    /*
     * Unable to fully structure code
     */
    public String buildCppCmdClassBlock(String str, String class_name) throws PogoException {
        end = str.indexOf("extract");
        if (end >= 0) ** GOTO lbl5
        throw new PogoException("Input File Syntax error 1!");
lbl-1000:
        // 1 sources

        {
            --end;
lbl5:
            // 2 sources

            ** while (str.charAt((int)end) != '\n')
        }
lbl6:
        // 1 sources

        sb = new StringBuffer(str.substring(0, ++end));
        if (this.argin.code != 0) {
            sb.append("\t");
            if (this.argin.is_array) {
                sb.append("const ");
            }
            sb.append(this.argin.cpp + "\t");
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                sb.append("*");
            }
            sb.append("argin;\n");
            sb.append("\textract(in_any, argin);\n\n");
        }
        sb.append("\t");
        if (this.argout.code != 0) {
            sb.append("return insert");
        }
        sb.append("((static_cast<" + class_name + " *>(device))->" + this.exec_method + "(");
        if (this.argin.code != 0) {
            sb.append("argin");
        }
        sb.append("));\n");
        if (this.argout.code == 0) {
            sb.append("\treturn new CORBA::Any();\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public String buildCppExecCmdMethodComments(String class_name) {
        StringBuffer sb = new StringBuffer("");
        sb.append("//+------------------------------------------------------------------\n");
        sb.append("/**\n");
        sb.append(" *\tmethod:\t" + class_name + "::" + this.exec_method + "\n");
        sb.append(" *\n");
        sb.append(" *\tdescription:\tmethod to execute \"" + this.command + "\"\n");
        if (this.description != null && this.description.length() > 0) {
            sb.append(" *\t" + new PogoString(this.description).setComments() + "\n");
        }
        sb.append(" *\n");
        if (this.argin.code != 0) {
            sb.append(" * @param\targin\t" + this.argin.description + "\n");
        }
        if (this.argout.code != 0) {
            sb.append(" * @return\t" + this.argout.description + "\n");
        }
        sb.append(" *\n");
        sb.append(" */\n");
        sb.append("//+------------------------------------------------------------------\n");
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void updateCppExecCmdMethodComments(PogoString codeStr, String class_name) throws PogoException {
        int startMethod;
        boolean methodExists = false;
        int endLine = 0;
        String line = this.buildCppExecCmdMethodSignature(class_name);
        System.out.println(line);
        int sl = line.indexOf("(");
        int el = line.indexOf(" ", sl);
        if (el < 0) {
            el = sl + 1;
        }
        line = line.substring(0, el);
        while ((startMethod = codeStr.str.indexOf(line, endLine)) >= 0) {
            String s;
            void var4_8;
            startMethod = codeStr.previousCr((int)var4_8);
            if (startMethod > (endLine = codeStr.nextCr(startMethod))) {
                System.out.println("\n1:\n" + startMethod + " - " + endLine);
                System.out.println(line + "\n\n");
            }
            if ((s = codeStr.str.substring(startMethod, endLine)).indexOf("//") >= 0 || s.indexOf("\"") >= 0 || s.indexOf("<<") >= 0) continue;
            methodExists = true;
            break;
        }
        String newHeader = this.buildCppExecCmdMethodComments(class_name);
        if (methodExists) {
            int startHeader = startMethod;
            while (startHeader > 0 && codeStr.str.charAt(startHeader) != '}') {
                --startHeader;
            }
            if ((startHeader = codeStr.str.indexOf("//", startHeader)) < 0) {
                startHeader = startMethod;
            }
            String oldHeader = codeStr.str.substring(startHeader, startMethod);
            codeStr.replace(startHeader, oldHeader, newHeader);
        } else {
            codeStr.append(newHeader);
        }
    }

    public String buildCppExecCmdMethodSignature(String class_name) {
        StringBuffer sb = new StringBuffer(this.argout.cpp + " ");
        if (this.argout.code != 8 && this.argout.is_array) {
            sb.append("*");
        }
        sb.append(class_name + "::" + this.exec_method + "(");
        if (this.argin.code != 0) {
            if (this.argin.is_array) {
                sb.append("const ");
            }
            sb.append(this.argin.cpp + " ");
            if ((this.argin.need_constr || this.argin.is_array) && this.argin.code != 8) {
                sb.append("*");
            }
            sb.append("argin");
        }
        sb.append(")");
        return sb.toString();
    }

    public String buildCppExecCmdMethod(String class_name) {
        StringBuffer sb = new StringBuffer(this.buildCppExecCmdMethodSignature(class_name) + "\n{\n");
        if (this.argout.code != 0) {
            if (this.argout.need_constr || this.argout.is_array) {
                sb.append("\t//\tPOGO has generated a method core with argout allocation.\n");
                sb.append("\t//\tIf you would like to use a static reference without copying,\n");
                sb.append("\t//\tSee \"TANGO Device Server Programmer's Manual\"\n");
                sb.append("\t//\t\t(chapter : Writing a TANGO DS / Exchanging data)\n");
                sb.append("\t//------------------------------------------------------------\n");
            }
            sb.append("\t" + this.argout.cpp + "\t");
            if (this.argout.code != 8 && this.argout.need_constr || this.argout.is_array) {
                sb.append("*");
            }
            sb.append("argout ");
            if (this.command.equals("State")) {
                sb.append("= DeviceImpl::dev_state()");
            } else if (this.command.equals("Status")) {
                sb.append("= DeviceImpl::dev_status()");
            } else if (this.argout.need_constr) {
                sb.append(" = new ");
                if (this.argout.code == 8) {
                    sb.append("char[6];\n\tstrcpy(argout, \"dummy\")");
                } else {
                    sb.append(this.argout.cpp + "()");
                }
            }
            sb.append(";\n");
            if (this.argout.code == -2) {
                sb.append("\targout = \"Hello World\";\n");
            }
            if (!this.argout.need_2constr) {
                if (this.argout.is_array) {
                    if (this.argout.code == 16) {
                        sb.append("\targout->length(1);\n");
                        sb.append("\t(*argout)[0] = ");
                        sb.append("CORBA::string_dup(\"dummy\");\n");
                    } else {
                        sb.append("\targout->length(1);\n");
                        sb.append("\t(*argout)[0] = 0");
                        if (this.argout.code == 12 || this.argout.code == 13) {
                            sb.append(".0");
                        }
                        sb.append(";\n");
                    }
                }
            } else {
                if (this.argout.code == 18) {
                    sb.append("\targout->dvalue.length(1);\n");
                    sb.append("\targout->dvalue[0] = 0.0;\n");
                } else {
                    sb.append("\targout->lvalue.length(1);\n");
                    sb.append("\targout->lvalue[0] = 0;\n");
                }
                sb.append("\targout->svalue.length(1);\n");
                sb.append("\targout->svalue[0] = CORBA::string_dup(\"dummy\");\n");
            }
        }
        sb.append("\tcout2 << \"" + class_name + "::" + this.exec_method + "(): entering... !\" << endl;\n");
        sb.append("\n\t//\tAdd your own code to control device here\n\n");
        if (this.argout.code != 0) {
            sb.append("\treturn argout;\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public void getExecMethodDescription(String str, int lang) {
        int start;
        boolean isComments = true;
        PogoString pgs = new PogoString(str);
        int end = 0;
        while (end >= 0 && isComments) {
            String target = lang == 1 ? this.buildJavaExecCmdMethodSignature(0) : this.buildCppCmdProtypesLine();
            System.out.println(target);
            end = pgs.str.indexOf(target, end);
            if (end < 0 && (end = pgs.str.indexOf(target = new String(this.argout.cpp + "\t" + this.exec_method + "("), end)) < 0) {
                System.out.println(this.exec_method + " method Not found !");
                return;
            }
            start = pgs.previousCr(end);
            if (pgs.str.substring(start, end).indexOf("//") < 0) {
                isComments = false;
            }
            ++end;
        }
        if (end < 0) {
            System.out.println(this.exec_method + " Not found !");
            return;
        }
        start = end = pgs.previousCr(end);
        switch (lang) {
            case 2: {
                while (start > 0 && pgs.str.charAt(start) != ';' && pgs.str.charAt(start) != '{') {
                    --start;
                }
                ++start;
                break;
            }
            case 1: {
                int start1;
                while (start > 0 && pgs.str.charAt(start) != '}') {
                    --start;
                }
                if ((start1 = pgs.str.indexOf("Execute command", ++start)) >= 0) {
                    start = pgs.nextCr(start1);
                }
                end = pgs.str.indexOf("*/", start);
            }
        }
        PogoString comments = new PogoString(pgs.str.substring(start, end));
        this.description = comments.getDescription();
    }

    public void setNotAllowedFor(String str, int lang) {
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        } else {
            this.notAllowedFor.clear();
        }
        PogoString pgs = new PogoString(str);
        String pattern = lang == 1 ? new String("public boolean is_allowed(DeviceImpl device, Any data_in)") : new String(this.cmd_class + "::is_allowed");
        int start = pgs.str.indexOf(pattern);
        if (start < 0) {
            System.out.println("WARNING: " + pattern + " Not Found !");
            return;
        }
        start = pgs.inMethod(start);
        int end = pgs.outMethod(start + 1);
        PogoString method = new PogoString(pgs.str.substring(start, end));
        if ((start = method.inTest(0)) < 0) {
            return;
        }
        end = method.outTest(start);
        if (end < 0) {
            return;
        }
        StringTokenizer stk = new StringTokenizer(method.str.substring(start + 1, end - 1));
        int i = 0;
        while (stk.hasMoreTokens()) {
            String s = stk.nextToken();
            switch (lang) {
                case 2: {
                    if (s.indexOf("Tango::") != 0) break;
                    this.notAllowedFor.addElement(new DevState(s, ""));
                    break;
                }
                case 1: {
                    if (s.indexOf("DevState.") != 0) break;
                    this.notAllowedFor.addElement(new DevState(s, ""));
                }
            }
            ++i;
        }
    }

    public void setNotAllowedFor(DevStateTable stTable) {
        if (this.notAllowedFor == null) {
            this.notAllowedFor = new DevStateTable();
        } else {
            this.notAllowedFor.clear();
        }
        int i = 0;
        while (i < stTable.size()) {
            this.notAllowedFor.addElement(stTable.elementAt(i));
            ++i;
        }
    }

    public void addNotAllowedFor(DevState state) {
        this.notAllowedFor.addElement(state);
    }

    public void removeNotAllowedFor(DevState state) {
        this.notAllowedFor.remove(state);
    }

    public String buildIsAllowedMethod(PogoString method, int lang) throws PogoException {
        int start = method.str.indexOf(PogoDefs.endGeneTag);
        if (start < 0) {
            throw new PogoException("\"" + PogoDefs.endGeneTag + "\" Not Found !");
        }
        int end = method.str.indexOf(PogoDefs.startGeneTag);
        if (end < 0) {
            throw new PogoException("\"" + PogoDefs.startGeneTag + "\" Not Found !");
        }
        start = method.previousCr(start);
        end = method.nextCr(end) + 1;
        String nonAuto = method.str.substring(start, end);
        if (this.notAllowedFor == null || this.notAllowedFor.size() == 0) {
            StringBuffer sb = new StringBuffer("{\n" + nonAuto + "\t\treturn true;\n");
            if (lang == 1) {
                sb.append("\t");
            }
            sb.append("}\n");
            return sb.toString();
        }
        StringBuffer head = new StringBuffer("{\n\t");
        if (lang == 1) {
            head.append("\t");
        }
        head.append("if (");
        int i = 0;
        while (i < this.notAllowedFor.size()) {
            DevState state = this.notAllowedFor.elementAt(i);
            if (lang == 1) {
                head.append("device.get_state() == " + state.javaName());
            } else {
                head.append("device->get_state() == " + state.name);
            }
            if (i < this.notAllowedFor.size() - 1) {
                head.append("  ||\n\t\t");
                if (lang == 1) {
                    head.append("\t");
                }
            }
            ++i;
        }
        if (lang == 1) {
            head.append(")\n\t\t{\n");
        } else {
            head.append(")\n\t{\n");
        }
        StringBuffer foot = new StringBuffer("");
        if (lang == 1) {
            foot.append("\t");
        }
        foot.append("\t\treturn false;\n");
        if (lang == 1) {
            foot.append("\t");
        }
        foot.append("\t}\n");
        if (lang == 1) {
            foot.append("\t");
        }
        foot.append("\treturn true;\n");
        if (lang == 1) {
            foot.append("\t");
        }
        foot.append("}\n");
        return new String(head.toString() + nonAuto + foot.toString());
    }

    public String toString() {
        return this.command;
    }
}

